/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.general.nparam.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.dependencies.DependsListener;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.dbobj.general.law.Param;
import com.dassault.cecilia.dbobj.general.law.TypeParam;
import com.dassault.cecilia.dbobj.general.law.gui.ParamValueCtrl;
import com.dassault.cecilia.dbobj.general.nparam.DBParam;
import com.dassault.cecilia.dbobj.wrap.DBWrapThreadSave;
import com.dassault.cecilia.dbobj.wrap.gui.DBWrapFrameEdit;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Logger;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;

public class DBParamFrameEdit
extends DBWrapFrameEdit {
    private static final Logger _LOG = Logger.getLogger(DBParamFrameEdit.class.getPackage().getName());
    JComboBox<TypeParam> _ctrlParamType;
    ParamValueCtrl _ctrlParamValue;

    @Override
    protected String getDBLabel() {
        return ResMsgVoc.getString("VOC_PARAMETER");
    }

    @Override
    public DBParam getDBWrap() {
        return (DBParam)super.getDBWrap();
    }

    public DBParamFrameEdit(DBParam dbParam, CeciliaAppl appl) {
        super(dbParam.getCopy(), appl);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(this.createCenterPanel(), "Center");
        this.getContentPane().add(this.createAndPlugLogsButtonAt(this.createSaveAndClosePanel()), "South");
        this.pack();
        this.refreshControl();
        this.setModified(false);
    }

    @Override
    public boolean isModified() {
        if (super.isModified()) {
            return true;
        }
        return this._ctrlParamValue.isModified();
    }

    @Override
    public boolean verifyData() {
        TypeParam type = (TypeParam)((Object)this._ctrlParamType.getSelectedItem());
        if (!this._ctrlParamValue.validCtrl(type)) {
            return false;
        }
        if (!this.verifyDescription()) {
            return false;
        }
        return super.verifyData();
    }

    @Override
    public boolean save() {
        if (this.isReadOnly()) {
            return false;
        }
        return this.doSave();
    }

    @Override
    protected boolean doSave() {
        TypeParam type = (TypeParam)((Object)this._ctrlParamType.getSelectedItem());
        final Param param = this._ctrlParamValue.getParam(type);
        if (param == null) {
            _LOG.severe("La valeur du parametre a sauver est null.");
        }
        if (type != null && param != null) {
            this.getDBWrap().setType(type);
            this.getDBWrap().setValue(param);
            DBWrapThreadSave thSave = new DBWrapThreadSave(this.getDBWrap(), this.getDescription(), this.getApplication(), this._ctrlSave){

                @Override
                protected void setModif(boolean value) {
                    DBParamFrameEdit.this.setModified(value);
                    if (!value) {
                        DBParamFrameEdit.this._ctrlParamValue.setParamValue(param);
                    }
                }
            };
            return this.doSave(thSave);
        }
        return false;
    }

    @Override
    protected void refreshControl() {
        super.refreshControl();
        this._ctrlParamType.setEnabled(true);
        this._ctrlParamType.setSelectedItem((Object)this.getDBWrap().getType());
        this._ctrlParamValue.setParamValue(this.getDBWrap().getValue());
    }

    private Component createCenterPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        result.add(this.createPathCtrl(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        result.add(this.createTitlePanel(this.createDescriptionCtrl(), ResMsgVoc.getString("VOC_DESCRIPTION")), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.5, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        result.add(this.createTitlePanel(this.createParamCtrl(), ResMsgVoc.getString("VOC_PARAMETER")), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        return result;
    }

    private Collection<DBRelation> getWorkingRelation() {
        HashSet<DBRelation> relations = new HashSet<DBRelation>();
        this._ctrlParamValue.addRelation(this.getDBFolder(), "WORKING", relations);
        return relations;
    }

    private Component createParamCtrl() {
        this._ctrlParamType = new JComboBox();
        for (TypeParam type : TypeParam.values()) {
            this._ctrlParamType.addItem(type);
        }
        this._ctrlParamType.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelect, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelect, cellHasFocus);
                TypeParam type = (TypeParam)((Object)value);
                StringBuilder sb = new StringBuilder();
                sb.append(type.getLabel());
                if (type.withSymbol()) {
                    sb.append(" (");
                    sb.append(type.getSymbol());
                    sb.append(')');
                }
                this.setText(sb.toString());
                return this;
            }
        });
        this._ctrlParamType.addActionListener(new DBWrapFrameEdit.ModifyListener(this));
        this._ctrlParamValue = new ParamValueCtrl(this.getApplication(), false, true, true);
        this._ctrlParamValue.addDependsListener(new DependsListener(){

            @Override
            public void changeDepends() {
                DBParamFrameEdit.this.getDBWrap().updateDependTimeUpdt(DBParamFrameEdit.this.getApplication().getDAOFactory(), DBParamFrameEdit.this.getWorkingRelation());
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(ResMsgVoc.getString("VOC_TYPE")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 10), 0, 0));
        panel.add(this._ctrlParamType, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 10, 5, 0), 0, 0));
        panel.add((Component)this._ctrlParamValue, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 13, 1, new Insets(5, 0, 5, 0), 0, 0));
        return panel;
    }
}

