/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.component.gui;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.export.ExpBook;
import com.dassault.cecilia.core.cecilia.pref.Preferencies;
import com.dassault.cecilia.core.plugin.IModel;
import com.dassault.cecilia.dbobj.folder.DBFolderThreadClose;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.mbsa.GenerateAltaricaCode;
import com.dassault.cecilia.dbobj.mbsa.ResIcoOcas;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.UtilOcas;
import com.dassault.cecilia.dbobj.mbsa.component.AltaComponent;
import com.dassault.cecilia.dbobj.mbsa.component.gui.AltaEditPanel;
import com.dassault.cecilia.dbobj.mbsa.component.gui.AltaEventPanel;
import com.dassault.cecilia.dbobj.mbsa.component.gui.AltaFlowPanel;
import com.dassault.cecilia.dbobj.mbsa.component.gui.AltaGeneralPanel;
import com.dassault.cecilia.dbobj.mbsa.component.gui.AltaIconPanel;
import com.dassault.cecilia.dbobj.mbsa.component.gui.AltaStatePanel;
import com.dassault.cecilia.dbobj.mbsa.export.XPortCfgComponent;
import com.dassault.cecilia.dbobj.mbsa.node.AltaEvent;
import com.dassault.cecilia.dbobj.mbsa.node.AltaFlow;
import com.dassault.cecilia.dbobj.mbsa.node.AltaState;
import com.dassault.cecilia.dbobj.mbsa.node.gui.AltaCodeFrame;
import com.dassault.cecilia.dbobj.mbsa.node.gui.AltaEditor;
import com.dassault.cecilia.dbobj.mbsa.node.gui.HelperLabel;
import com.dassault.cecilia.dbobj.mbsa.type.DBRecord;
import com.dassault.cecilia.dbobj.mbsa.type.DBRecordField;
import com.dassault.cecilia.dbobj.mbsa.type.DBType;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AltaComponentFrame
extends AltaCodeFrame {
    Component _oldTabSelected = null;
    AltaGeneralPanel _generalPanel;
    AltaFlowPanel _flowPanel;
    AltaStatePanel _statePanel;
    AltaEventPanel _eventPanel;
    AltaIconPanel _iconPanel;

    public AltaComponentFrame(CeciliaAppl appl, AltaComponent dbComponent) {
        super(dbComponent.getCopy(), appl);
        this.makePanel();
        this.editComponent(this.getAltaNode());
        this.setModified(false);
    }

    @Override
    protected AltaComponent getAltaNode() {
        return (AltaComponent)super.getAltaNode();
    }

    public void focusTreatment() {
        this.requestFocus();
        if (this._tabPane != null) {
            switch (this._tabPane.getSelectedIndex()) {
                case 0: {
                    this._generalPanel.focusTreatment();
                    break;
                }
                case 1: {
                    this._flowPanel.focusTreatment();
                    break;
                }
                case 2: {
                    this._statePanel.focusTreatment();
                    break;
                }
                case 3: {
                    this._eventPanel.focusTreatment();
                    break;
                }
                case 4: {
                    this._iconPanel.requestFocus();
                    break;
                }
                case 5: {
                    this._codeEditor.getEditorComponent().requestFocus();
                }
            }
        }
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.focusTreatment();
    }

    private void makePanel() {
        this._generalPanel = new AltaGeneralPanel(this.getApplication());
        this._tabPane.addTab(ResMsgVoc.getString("VOC_GENERAL"), this._generalPanel);
        this._flowPanel = new AltaFlowPanel(this.getApplication());
        this._tabPane.addTab(ResMsgOcas.getString("MODEL_EDIT_INOUT"), ResIcoCore.getImageIcon("MBSA_FLOW"), this._flowPanel);
        this._statePanel = new AltaStatePanel(this.getApplication());
        this._tabPane.addTab(ResMsgVoc.getString("VOC_STATES"), ResIcoCore.getImageIcon("MBSA_STATE"), this._statePanel);
        this._eventPanel = new AltaEventPanel(this.getApplication());
        this._tabPane.addTab(ResMsgVoc.getString("VOC_EVENTS"), ResIcoCore.getImageIcon("MBSA_EVENT"), this._eventPanel);
        this._iconPanel = new AltaIconPanel(this.getApplication());
        this._tabPane.addTab(ResMsgVoc.getString("VOC_ICONS"), ResIcoOcas.getImageIcon("ICONE_PI"), this._iconPanel);
        this._tabPane.addTab(ResMsgOcas.getString("MODEL_EDIT_ALTARICA_CODE"), ResIcoOcas.getImageIcon("CODE_PI"), this.createAltaEditor());
        JPanel content = new JPanel(new BorderLayout());
        this.getContentPane().add(content);
        this._tabPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
        content.add((Component)this._tabPane, "Center");
        content.add(this.createAndPlugLogsButtonAt(this.createCodeAndClosePanel()), "South");
        this.defineActions();
        this.setSize(700, 500);
    }

    @Override
    protected int getTabIndex(AltaCodeFrame.CodeTabType tabType) {
        switch (tabType) {
            case GENERAL: {
                return 0;
            }
            case FLOW: {
                return 1;
            }
            case STATE: {
                return 2;
            }
            case EVENT: {
                return 3;
            }
            case ICON: {
                return 4;
            }
            case CODE: {
                return 5;
            }
        }
        return -1;
    }

    @Override
    public void changePreferencies(Preferencies prefs) {
        super.changePreferencies(prefs);
        this._generalPanel.changePreferencies(prefs);
    }

    @Override
    public String getHelpRoots(Vector list) {
        AltaComponent model = this.getAltaNode();
        for (AltaFlow port : model.getFlows()) {
            if (port.getOrientation() == AltaFlow.Orientation.IN) {
                UtilOcas.addInAlphabeticOrder(list, new HelperLabel(port.getName(), (Icon)ResIcoCore.getImageIcon("MBSA_FLOW_INPUT"), port.getType()));
                continue;
            }
            UtilOcas.addInAlphabeticOrder(list, new HelperLabel(port.getName(), (Icon)ResIcoCore.getImageIcon("MBSA_FLOW_OUTPUT"), port.getType()));
        }
        for (AltaState state : model.getStates()) {
            UtilOcas.addInAlphabeticOrder(list, new HelperLabel(state.getName(), (Icon)ResIcoCore.getImageIcon("MBSA_STATE"), state.getType()));
        }
        for (AltaEvent event : model.getEvents()) {
            UtilOcas.addInAlphabeticOrder(list, new HelperLabel(event.getName(), (Icon)ResIcoCore.getImageIcon("MBSA_EVENT"), ""));
        }
        if (model.getSimuls().size() > 0) {
            UtilOcas.addInAlphabeticOrder(list, new HelperLabel("icone", (Icon)ResIcoOcas.getImageIcon("ICONE_PI"), ""));
        }
        return model.getDBFolder().getRefPath();
    }

    @Override
    public String analyseString(String str, char car, Vector list) {
        String resultString = "";
        switch (car) {
            case '^': 
            case '_': {
                AltaFlow flow = this.getAltaNode().getFlow(str);
                if (flow == null || !(flow.getType() instanceof DBRecord)) break;
                DBRecord dbRecord = (DBRecord)flow.getType();
                for (int i = dbRecord.getValueCount() - 1; i >= 0; --i) {
                    DBRecordField field = dbRecord.getFieldAt(i);
                    UtilOcas.addInAlphabeticOrder(list, new HelperLabel(field.getName(), (Icon)ResIcoCore.getImageIcon("MBSA_FIELD"), field.getType()));
                }
                resultString = ((DBType)flow.getType()).getDBFolder().getRefPath();
                break;
            }
        }
        return resultString;
    }

    private void defineActions() {
        this._tabPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (AltaComponentFrame.this._oldTabSelected instanceof AltaEditPanel) {
                    ((AltaEditPanel)AltaComponentFrame.this._oldTabSelected).toDoWhenDeActivated();
                } else if (AltaComponentFrame.this._oldTabSelected == AltaComponentFrame.this._editorTabPane) {
                    AltaComponentFrame.this.getAltaNode().setCode(AltaComponentFrame.this._codeEditor.getText());
                }
                Component tabSelected = AltaComponentFrame.this._tabPane.getSelectedComponent();
                if (tabSelected == AltaComponentFrame.this._editorTabPane) {
                    AltaComponentFrame.this._editorTabPane.setSelectedIndex(0);
                    try {
                        AltaComponentFrame.this._codeEditor.setHeader(AltaComponentFrame.this.getAltaNode().getHeader(true));
                    }
                    catch (IOException ioe) {
                        AltaComponentFrame.this._codeEditor.setHeader("/*Exception: " + ioe.getMessage() + "*/");
                    }
                    try {
                        AltaComponentFrame.this._codeEditor.setBottom(AltaComponentFrame.this.getAltaNode().getFooter());
                    }
                    catch (IOException ioe) {
                        AltaComponentFrame.this._codeEditor.setBottom("/*Exception: " + ioe.getMessage() + "*/");
                    }
                }
                AltaComponentFrame.this.focusTreatment();
                AltaComponentFrame.this._oldTabSelected = tabSelected;
                if (AltaComponentFrame.this._oldTabSelected instanceof AltaEditPanel) {
                    ((AltaEditPanel)AltaComponentFrame.this._oldTabSelected).toDoWhenActivated();
                }
            }
        });
    }

    private void editComponent(AltaComponent node) {
        this._generalPanel.setComponent(node);
        this._flowPanel.setComponent(node);
        this._statePanel.setComponent(node);
        this._eventPanel.setComponent(node);
        this._iconPanel.setComponent(node);
        this.editNode(node);
    }

    @Override
    public void updateLangage() {
        this._generalPanel.updateLangage();
        this._flowPanel.updateLangage();
        this._statePanel.updateLangage();
        this._eventPanel.updateLangage();
        this._iconPanel.updateLangage();
        super.updateLangage();
    }

    @Override
    protected String getDescription() {
        return this._generalPanel.getPropertiesPanel().getComment();
    }

    @Override
    public boolean save() {
        if (this.isReadOnly()) {
            return false;
        }
        this.updateSelectedOperator();
        this.getAltaNode().setCode(this._codeEditor.getText());
        if (!this.doSave()) {
            return false;
        }
        this._generalPanel.getCtrlName().setText(this.getDBFolder().getParent().getName());
        this._generalPanel.getPropertiesPanel().updateDBFolder(this.getDBFolder());
        return true;
    }

    public boolean saveAsModel() {
        return false;
    }

    @Override
    public boolean isModified() {
        if (super.isModified()) {
            return true;
        }
        return this._generalPanel.isModified();
    }

    @Override
    public void setModified(boolean modified) {
        super.setModified(modified);
        this._generalPanel.setModified(modified);
    }

    @Override
    protected String getDBLabel() {
        return ResMsgVoc.getString("VOC_COMPONENT");
    }

    @Override
    public boolean toDoWhenClosing() {
        if (!super.toDoWhenClosing()) {
            return false;
        }
        if (!this.verifyClose()) {
            return false;
        }
        new DBFolderThreadClose(this.getDBFolder(), this.getApplication(), this._ctrlClose){

            @Override
            protected void firstDo() {
                super.firstDo();
                AltaComponentFrame.this._editorHelper.hideWindow();
            }
        }.realiseDo();
        return true;
    }

    @Override
    public void toDoWhenDeActivated() {
        if (this._tabPane.getSelectedComponent() instanceof AltaEditPanel) {
            ((AltaEditPanel)this._tabPane.getSelectedComponent()).toDoWhenDeActivated();
        }
        if (this._editorHelper != null) {
            this._editorHelper.hideWindow();
        }
        super.toDoWhenDeActivated();
    }

    @Override
    public void toDoWhenActivated() {
        super.toDoWhenActivated();
        if (this._tabPane.getSelectedComponent() instanceof AltaEditPanel) {
            ((AltaEditPanel)this._tabPane.getSelectedComponent()).toDoWhenActivated();
        }
        this.focusTreatment();
    }

    @Override
    public boolean isEditable() {
        return !this.isReadOnly();
    }

    @Override
    public void setEditable(boolean etat) {
        super.setEditable(etat);
        this._statePanel.forReadOnly(this.isReadOnly());
        this._operatorPanel.forReadOnly(this.isReadOnly());
    }

    public AltaEditor getLawEditor() {
        return this._codeEditor;
    }

    @Override
    protected GenerateAltaricaCode generateCode() {
        this.updateSelectedOperator();
        this.getAltaNode().setCode(this._codeEditor.getText());
        return super.generateCode();
    }

    @Override
    public IModel getModel(String key) {
        if (key.equals("docbook.file") || key.equals("word.file")) {
            return this.getModel(key, "Component_");
        }
        return super.getModel(key);
    }

    @Override
    protected void configBook(ExpBook book) {
        XPortCfgComponent xPortCfg = new XPortCfgComponent();
        xPortCfg.configBook(book, this.getAltaNode());
    }

    @Override
    protected void updateEdit() {
        DBLogs.DBLevel oldLevel = this.getLogs().getMaxLevel();
        int oldNbr = this.getLogs().getNbrLogs();
        DBLogs.DefaultManager logMng = new DBLogs.DefaultManager(this.getApplication().getDBUser().getLogin(), this.getAltaNode().getLogs());
        this.getAltaNode().update(this.getApplication().getDAOFactory(), logMng);
        this._flowPanel.refreshTable();
        this._statePanel.refreshTable();
        this._eventPanel.refreshTable();
        this._iconPanel.refreshTable();
        this._generalPanel.fireRefresh(false);
        this.getAltaNode().prepareDependTimeUpdt(this.getApplication().getDAOFactory(), this.getAltaNode().getUseRelations());
        this.updateLogs(this.getAltaNode().getUseRelations(), oldLevel, oldNbr);
    }
}

