/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.graph;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.mbsa.component.pref.AltaContentDisplayPreferencies;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaContext;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGraph;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaSheet;
import com.dassault.cecilia.lib.util.CopyUtility;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class AlgaContent {
    int _width;
    int _height;
    List<AlgaSheet> _lstSheet = new ArrayList<AlgaSheet>();
    AlgaSheet _currentSheet;
    int _sheetIconWidth;
    int _sheetIconHeight;

    public AlgaContent() {
        String name = ResMsgVoc.getString("VOC_LAYER") + " " + 1;
        this._currentSheet = new AlgaSheet(1, name, 1, true, true);
        this._lstSheet.add(this._currentSheet);
    }

    public List<AlgaSheet> getSheets() {
        return this._lstSheet;
    }

    public void setSheets(List<AlgaSheet> sheets) {
        this._lstSheet = sheets;
        this._currentSheet = null;
        for (AlgaSheet algaSheet : sheets) {
            if (!algaSheet.isSelected()) continue;
            this._currentSheet = algaSheet;
            break;
        }
        if (this._currentSheet == null && sheets.size() > 0) {
            this._currentSheet = sheets.get(0);
        }
    }

    public AlgaSheet getCurrentSheet() {
        return this._currentSheet;
    }

    public void setCurrentSheet(AlgaSheet sheet) {
        this._currentSheet = sheet;
    }

    public int getWidth() {
        return this._width;
    }

    public int getHeight() {
        return this._height;
    }

    public void computeSize(Graphics g) {
        this._width = 0;
        this._height = 0;
        for (int i = 0; i < this._lstSheet.size(); ++i) {
            AlgaSheet sheet = this._lstSheet.get(i);
            sheet.computeSize(g);
            this._width = Math.max(this._width, sheet.getW());
            this._height = Math.max(this._height, sheet.getH());
        }
        if (this._width < 400) {
            this._width = 480;
        }
        if (this._height < 200) {
            this._height = 200;
        }
    }

    public void paint(Graphics2D g, AlgaContext context) {
        g.scale(context.getZoom(), context.getZoom());
        for (int i = this._lstSheet.size() - 1; i >= 0; --i) {
            AlgaSheet sheet = this._lstSheet.get(i);
            if (!sheet.isVisible()) continue;
            sheet.paint(g, context);
        }
        if (!context.isPrinting()) {
            g.scale(1.0 / context.getZoom(), 1.0 / context.getZoom());
            this.paintSheetsIcon(g, context);
        }
    }

    public int getSheetIconWidth() {
        return this._sheetIconWidth;
    }

    public int getSheetIconHeight() {
        return this._sheetIconHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintSheetsIcon(Graphics2D g, AlgaContext context) {
        Rectangle r = context.getRectView();
        int xSheet = 2 + r.x;
        int ySheet = 2 + r.y;
        Font font = new Font("Courier", 0, 12);
        FontMetrics fmetrics = g.getFontMetrics(font);
        int width = fmetrics.stringWidth(" ") + 8;
        int height = fmetrics.getHeight() + 2;
        Font oldFont = g.getFont();
        Color oldColor = g.getColor();
        try {
            g.setFont(font);
            AlgaSheet selectedSheet = null;
            for (int i = 0; i < this._lstSheet.size(); ++i) {
                AlgaSheet sheet = this._lstSheet.get(i);
                if (!sheet.isVisible()) continue;
                if (sheet._selected) {
                    selectedSheet = sheet;
                }
                g.setColor(Color.black);
                g.drawRect(xSheet, ySheet, width, height);
                if (sheet == this._currentSheet) {
                    g.fillRect(xSheet, ySheet, width, height);
                    g.setColor(Color.white);
                }
                String txt = Integer.toString(sheet.getNumber());
                if (sheet.getNumber() > 9) {
                    txt = "" + (char)(65 + sheet.getNumber() - 10);
                }
                g.drawString(txt, xSheet + 2, ySheet + height - 4);
                xSheet += width;
            }
            this._sheetIconWidth = xSheet;
            this._sheetIconHeight = ySheet + height;
            g.setColor(Color.black);
            g.drawString(" " + selectedSheet.getName(), xSheet + 3, ySheet + height - 4);
        }
        finally {
            g.setFont(oldFont);
            g.setColor(oldColor);
        }
    }

    public AlgaGraph getGraphAtPoint(int x, int y, AltaContentDisplayPreferencies.LinkDisplay linkDispl) {
        AlgaGraph result = null;
        for (int i = 0; result == null && i < this._lstSheet.size(); ++i) {
            AlgaSheet sheet = this._lstSheet.get(i);
            result = sheet.getGraphAtPoint(x, y, linkDispl);
        }
        return result;
    }

    public void changeSelectGraphs(Rectangle rect, boolean addSelect) {
        for (int i = 0; i < this._lstSheet.size(); ++i) {
            AlgaSheet sheet = this._lstSheet.get(i);
            if (!sheet.isVisible()) continue;
            for (AlgaGraph graph : sheet.getGraphs()) {
                boolean include = false;
                if (rect != null) {
                    include = rect.contains(graph.getSelectBounds());
                }
                if (include) {
                    graph.setSelected(true);
                    continue;
                }
                if (addSelect) continue;
                graph.setSelected(false);
            }
        }
    }

    public AlgaGraph getSelectedGraph() {
        AlgaGraph selected = null;
        for (int i = 0; i < this._lstSheet.size(); ++i) {
            AlgaSheet sheet = this._lstSheet.get(i);
            if (!sheet.isVisible()) continue;
            for (AlgaGraph graph : sheet.getGraphs()) {
                if (!graph.isSelected()) continue;
                if (selected == null) {
                    selected = graph;
                    continue;
                }
                return null;
            }
        }
        return selected;
    }

    public List<AlgaGraph> getSelectedGraphs() {
        ArrayList<AlgaGraph> list = new ArrayList<AlgaGraph>();
        for (int i = 0; i < this._lstSheet.size(); ++i) {
            AlgaSheet sheet = this._lstSheet.get(i);
            if (!sheet.isVisible()) continue;
            for (AlgaGraph graph : sheet.getGraphs()) {
                if (!graph.isSelected()) continue;
                list.add(graph);
            }
        }
        return list;
    }

    public AlgaContent getCopy(CopyUtility util) {
        AlgaContent copy = new AlgaContent();
        copy._lstSheet.clear();
        for (int i = 0; i < this._lstSheet.size(); ++i) {
            AlgaSheet sheet = this._lstSheet.get(i);
            if (!util.selectForCopy((Object)sheet)) continue;
            AlgaSheet copySheet = sheet.getCopy(true, util);
            copy._lstSheet.add(copySheet);
            if (sheet != this._currentSheet) continue;
            copy._currentSheet = copySheet;
        }
        return copy;
    }

    public AlgaSheet findSheetForGraphic(AlgaGraph grf) {
        for (int i = 0; i < this._lstSheet.size(); ++i) {
            AlgaSheet sheet = this._lstSheet.get(i);
            if (!sheet.getGraphs().contains(grf)) continue;
            return sheet;
        }
        return null;
    }

    public void addRelation(DBFolder dbSrcFolder, String typeSrcRelation, Set<DBRelation> relations) {
        for (AlgaSheet algaSheet : this.getSheets()) {
            algaSheet.addRelation(dbSrcFolder, typeSrcRelation, relations);
        }
    }

    public boolean update(CECFactory daoFactory, DBLogs.DBLogsManager logMng) {
        boolean result = true;
        for (int i = this._lstSheet.size() - 1; i >= 0; --i) {
            AlgaSheet sheet = this._lstSheet.get(i);
            if (sheet.update(daoFactory, logMng)) continue;
            result = false;
        }
        return result;
    }

    public Rectangle getClipArea() {
        List<AlgaGraph> selectedObjs = this.getSelectedGraphs();
        if (selectedObjs == null || selectedObjs.isEmpty()) {
            return null;
        }
        int xMin = Integer.MAX_VALUE;
        int yMin = Integer.MAX_VALUE;
        int xMax = Integer.MIN_VALUE;
        int yMax = Integer.MIN_VALUE;
        for (AlgaGraph graph : selectedObjs) {
            xMin = Math.min(xMin, graph.getX());
            yMin = Math.min(yMin, graph.getY());
            xMax = Math.max(xMax, graph.getX() + graph.getWUser());
            yMax = Math.max(yMax, graph.getY() + graph.getHUser());
        }
        return new Rectangle(xMin, yMin, xMax - xMin, yMax - yMin);
    }
}

