/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.graph;

import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.general.icon.DBIcon;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaEquipment;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaContext;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaForm;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGraph;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.lib.util.CopyUtility;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;

public class AlgaImage
extends AlgaForm {
    DBIcon _dbIcon;

    public AlgaImage() {
        super(AlgaForm.Type.IMAGE);
    }

    public DBIcon getDBIcon() {
        return this._dbIcon;
    }

    public AlgaImage setDBIcon(DBIcon dbIcon) {
        this._dbIcon = dbIcon;
        ImageIcon icon = this._dbIcon.getImage();
        this.setW(icon.getIconWidth());
        this.setH(icon.getIconHeight());
        return this;
    }

    @Override
    public AlgaImage getCopy(boolean withDepth, CopyUtility util) {
        AlgaImage result = new AlgaImage();
        result.copy(this, withDepth, util);
        return result;
    }

    @Override
    protected void copy(AlgaGraph grfsrc, boolean withDepth, CopyUtility util) {
        super.copy(grfsrc, withDepth, util);
        if (grfsrc instanceof AlgaImage) {
            AlgaImage src = (AlgaImage)grfsrc;
            this._dbIcon = src._dbIcon;
        }
    }

    @Override
    public String getTooltip(AltaEquipment owner, int x, int y) {
        return "[Icon]:" + this._dbIcon.getRefPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics2D g, AlgaContext context) {
        if (this._dbIcon == null) {
            return;
        }
        AffineTransform oldTransform = g.getTransform();
        try {
            g.translate(this.getCX() - this.getW() / 2, this.getCY() - this.getH() / 2);
            this._transform.prepareGraphics(g, this.getW() / 2, this.getH() / 2);
            this.paintImage(g, context);
            if (this.isSelected() && context.isDisplay()) {
                this.paintSelectionCorner(g, context, 0, 0, this.getW(), this.getH());
            }
        }
        finally {
            g.setTransform(oldTransform);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintImage(Graphics2D g, AlgaContext context) {
        Graphics g2D = null;
        try {
            ImageIcon icon = this._dbIcon.getImage();
            BufferedImage image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
            g2D = image.createGraphics();
            g2D.drawImage(icon.getImage(), 0, 0, icon.getIconWidth(), icon.getIconHeight(), null);
            g.drawImage(image, 0, 0, this.getW(), this.getH(), null);
        }
        finally {
            if (g2D != null) {
                g2D.dispose();
            }
        }
    }

    @Override
    public boolean update(CECFactory daoFactory, DBLogs.DBLogsManager logMng) {
        this._dbIcon = (DBIcon)DBWrap.createOrFind(daoFactory, this._dbIcon.getDBFolder(), logMng, DBIcon.class);
        if (this._dbIcon == null) {
            return false;
        }
        return super.update(daoFactory, logMng);
    }
}

