/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.gui;

import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaContent;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaContext;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGraph;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaSheet;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.mouse.DelegateMouseRect;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.mouse.DelegateMouseSelect;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class AltaContentView
extends JComponent {
    AlgaContent _content = null;
    AlgaContext _context;
    double _zoom = 1.0;
    CtrlMouse _ctrlMouse;
    int _mouseAction = -10;
    AlgaGraph _graphAction;
    DelegateMouse _delegateMouse;
    ArrayList<AltaHitGraphListener> _hitGraphLs = new ArrayList();
    ArrayList<AltaChangeSelectListener> _changeSelectLs = new ArrayList();
    JTextField _message;
    boolean _bFirstPaint = false;

    public void addAltaHitGraphListener(AltaHitGraphListener listener) {
        if (!this._hitGraphLs.contains(listener)) {
            this._hitGraphLs.add(listener);
        }
    }

    public void removeAltaHitGraphListener(AltaHitGraphListener listener) {
        this._hitGraphLs.remove(listener);
    }

    public void addAltaChangeSelectListener(AltaChangeSelectListener listener) {
        if (!this._changeSelectLs.contains(listener)) {
            this._changeSelectLs.add(listener);
        }
    }

    public void removeAltaChangeSelectListener(AltaChangeSelectListener listener) {
        this._changeSelectLs.remove(listener);
    }

    public void fireChangeSelect() {
        for (int i = this._changeSelectLs.size() - 1; i >= 0; --i) {
            this._changeSelectLs.get(i).changeSelect();
        }
    }

    public void setMessageField(JTextField message) {
        this._message = message;
    }

    public AltaContentView(AlgaContext context) {
        this._context = context;
        this.setOpaque(true);
        this._ctrlMouse = new CtrlMouse();
        this.setAutoscrolls(true);
        this.addMouseListener(this._ctrlMouse);
        this.addMouseMotionListener(this._ctrlMouse);
    }

    @Override
    public void setComponentPopupMenu(JPopupMenu popup) {
        super.setComponentPopupMenu(popup);
        popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                AltaContentView.this._delegateMouse = null;
            }
        });
    }

    public AlgaContent getContent() {
        return this._content;
    }

    public void setContent(AlgaContent content) {
        this._content = content;
    }

    public AlgaContext getContext() {
        return this._context;
    }

    public double getZoom() {
        return this._zoom;
    }

    public void setZoom(double zoom) {
        this._zoom = zoom;
        this.revalidate();
    }

    @Override
    public Dimension getPreferredSize() {
        int h;
        int w;
        if (this._zoom == 1.0) {
            w = this._content.getWidth();
            h = this._content.getHeight();
        } else {
            w = (int)((double)this._content.getWidth() * this._zoom) + 1;
            h = (int)((double)this._content.getHeight() * this._zoom) + 1;
        }
        return new Dimension(w + 20, h + 20);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this._bFirstPaint) {
            this._bFirstPaint = true;
            this._content.computeSize(g);
            this.revalidate();
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(Color.white);
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        JViewport vp = (JViewport)SwingUtilities.getAncestorOfClass(JViewport.class, this);
        Rectangle r = vp == null ? new Rectangle() : vp.getViewRect();
        this._context.setRectView(r);
        this._context.setZoom(this._zoom);
        this._content.paint(g2, this._context);
    }

    class CtrlMouse
    implements MouseListener,
    MouseMotionListener {
        int _originX;
        int _originY;
        int _currentX;
        int _currentY;
        AlgaGraph _graphHitGraph = null;

        CtrlMouse() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!AltaContentView.this.hasFocus()) {
                AltaContentView.this.requestFocus();
            }
            this._currentX = this._originX = e.getX();
            this._currentY = this._originY = e.getY();
            int x = (int)((double)this._originX / AltaContentView.this._zoom);
            int y = (int)((double)this._originY / AltaContentView.this._zoom);
            AltaContentView.this._graphAction = AltaContentView.this._content.getGraphAtPoint(x, y, AltaContentView.this._context.getLinkDisplay());
            if (AltaContentView.this._graphAction != null) {
                AltaContentView.this._delegateMouse = AltaContentView.this._graphAction.getCtrlMouse(x, y, AltaContentView.this);
                if (AltaContentView.this._delegateMouse == null) {
                    AltaContentView.this._delegateMouse = new DelegateMouseSelect(AltaContentView.this._graphAction);
                }
            } else if (SwingUtilities.isLeftMouseButton(e)) {
                AltaContentView.this._mouseAction = -9;
                AltaContentView.this._delegateMouse = new DelegateMouseRect();
            } else {
                AltaContentView.this._mouseAction = -10;
            }
            if (AltaContentView.this._delegateMouse != null && !AltaContentView.this._delegateMouse.mousePressed(e, AltaContentView.this)) {
                AltaContentView.this._delegateMouse = null;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (AltaContentView.this._delegateMouse != null) {
                AltaContentView.this._delegateMouse.mouseReleased(e, AltaContentView.this);
                AltaContentView.this._delegateMouse = null;
            }
            AltaContentView.this._mouseAction = -10;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (AltaContentView.this._delegateMouse != null) {
                AltaContentView.this._delegateMouse.mouseDragged(e, AltaContentView.this);
            }
            AltaContentView.this.scrollRectToVisible(new Rectangle(e.getX(), e.getY(), 1, 1));
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (e.getX() < AltaContentView.this._content.getSheetIconWidth() && e.getY() < AltaContentView.this._content.getSheetIconHeight()) {
                List<AlgaSheet> sheets = AltaContentView.this._content.getSheets();
                int sheetNumber = 0;
                for (AlgaSheet sheet : sheets) {
                    if (!sheet.isVisible()) continue;
                    ++sheetNumber;
                }
                int sheetWidth = Math.round(AltaContentView.this._content.getSheetIconWidth() / sheetNumber);
                int sheetIdx = 0;
                for (AlgaSheet sheet : sheets) {
                    if (!sheet.isVisible()) continue;
                    if (e.getX() > sheetIdx * sheetWidth && e.getX() < (sheetIdx + 1) * sheetWidth) {
                        AltaContentView.this._message.setText(sheet.getName());
                        return;
                    }
                    ++sheetIdx;
                }
            } else {
                AlgaGraph grf;
                int x = (int)((double)e.getX() / AltaContentView.this._zoom);
                int y = (int)((double)e.getY() / AltaContentView.this._zoom);
                this._graphHitGraph = grf = AltaContentView.this._content.getGraphAtPoint(x, y, AltaContentView.this._context.getLinkDisplay());
                for (int i = AltaContentView.this._hitGraphLs.size() - 1; i >= 0; --i) {
                    AltaContentView.this._hitGraphLs.get(i).changeHitGraph(this._graphHitGraph, x, y);
                }
            }
        }
    }

    public static interface AltaChangeSelectListener {
        public void changeSelect();
    }

    public static interface AltaHitGraphListener {
        public void changeHitGraph(AlgaGraph var1, int var2, int var3);
    }

    public static interface DelegateMouse {
        public boolean mousePressed(MouseEvent var1, AltaContentView var2);

        public void mouseDragged(MouseEvent var1, AltaContentView var2);

        public void mouseReleased(MouseEvent var1, AltaContentView var2);
    }
}

