/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions;

import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.general.icon.DBIcon;
import com.dassault.cecilia.dbobj.general.icon.gui.IconDlgChooser;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaForm;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGraph;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaImage;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaLine;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaPolygone;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaSheet;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaText;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.Pt;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentEditPanel;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCCmd;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.Color;
import java.awt.Window;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public class OCmdFormCreate
extends OCCmd {
    AlgaForm.Type _type;
    int _x;
    int _y;
    AlgaGraph _graphic;
    AlgaSheet _sheet;
    private static IconDlgChooser _dlgIcon = null;
    private static Object _lockerDlgIcon = new Object();

    public OCmdFormCreate(CeciliaAppl appl, AltaContentEditPanel c, AlgaForm.Type type, int x, int y) {
        super(appl, c);
        this._type = type;
        this._x = x;
        this._y = y;
    }

    @Override
    protected boolean prepareDo() {
        switch (this._type) {
            case OVALE: 
            case RECTANGLE: 
            case ROUND_RECTANGLE: {
                this._graphic = new AlgaForm(this._type).setW(100).setH(100).setCX(this._x).setCY(this._y);
                break;
            }
            case ARROW_SIMPLE: 
            case ARROW_DOUBLE: {
                this._graphic = new AlgaForm(this._type).setW(150).setH(75).setCX(this._x).setCY(this._y);
                break;
            }
            case ARROW_R_DOUBLE: 
            case ARROW_R_SIMPLE: {
                this._graphic = new AlgaForm(this._type).setW(125).setH(125).setCX(this._x).setCY(this._y);
                break;
            }
            case ARROW_TRIPLE: {
                this._graphic = new AlgaForm(this._type).setW(125).setH(75).setCX(this._x).setCY(this._y);
                break;
            }
            case LINE: {
                int x = this._x - 50;
                if (x < 10) {
                    x = 10;
                }
                ArrayList<Pt> points = new ArrayList<Pt>();
                points.add(new Pt(x, this._y));
                points.add(new Pt(x + 100, this._y));
                this._graphic = new AlgaLine().setPoints(points);
                break;
            }
            case POLYGONE: {
                int y;
                int x = this._x - 50;
                if (x < 10) {
                    x = 10;
                }
                if ((y = this._y - 50) < 10) {
                    y = 10;
                }
                ArrayList<Pt> points = new ArrayList<Pt>();
                points.add(new Pt(x + 50, y));
                points.add(new Pt(x + 100, y));
                points.add(new Pt(x + 50, y + 50));
                points.add(new Pt(x + 100, y + 50));
                points.add(new Pt(x + 100, y + 100));
                points.add(new Pt(x, y + 100));
                points.add(new Pt(x, y + 50));
                this._graphic = new AlgaPolygone().setPoints(points);
                break;
            }
            case IMAGE: {
                DBIcon dbIcon = this.selectIcon();
                if (dbIcon == null) {
                    return false;
                }
                this._graphic = new AlgaImage().setDBIcon(dbIcon).setCX(this._x).setCY(this._y);
                break;
            }
            case TEXT: {
                this._graphic = new AlgaText().setText(ResMsgOcas.getString("DRAW_EDIT_DEFAULT_TEXT")).setW(100).setH(30).setCX(this._x).setCY(this._y);
                this._graphic.setOpaque(false).setBackground(Color.white).setForeground(Color.black);
                break;
            }
            default: {
                return false;
            }
        }
        this._graphic.computeControlPoints();
        this._sheet = this.getNode().getContent().getCurrentSheet();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IconDlgChooser createIconDlgChooser() {
        if (_dlgIcon == null) {
            Object object = _lockerDlgIcon;
            synchronized (object) {
                IconDlgChooser dlg = null;
                if (_dlgIcon == null) {
                    Window win = SwingUtilities.getWindowAncestor(this.getView());
                    dlg = new IconDlgChooser(win, this.getAppl());
                }
                if (dlg != null && _dlgIcon == null) {
                    _dlgIcon = dlg;
                }
            }
        }
        return _dlgIcon;
    }

    private DBIcon selectIcon() {
        IconDlgChooser dlg = this.createIconDlgChooser();
        dlg.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(this.getSource()));
        dlg.setVisible(true);
        if (!dlg.getResult()) {
            return null;
        }
        DBFolder dbFolder = dlg.getSelectFolder();
        if (dbFolder == null) {
            return null;
        }
        DBWrap dbWrap = this.getAppl().getDAOFactory().findOrCreateWrap(dbFolder);
        if (dbWrap == null) {
            return null;
        }
        return (DBIcon)dbWrap;
    }

    @Override
    protected void firstDo() {
        if (this._graphic == null) {
            return;
        }
        this.redo();
        this.getPanel().addHisto(this);
    }

    @Override
    public void redo() {
        this._sheet.add(this._graphic, Integer.MAX_VALUE);
        this.getContent().changeSelectGraphs(null, false);
        this._graphic.setSelected(true);
        this.refreshAll();
    }

    @Override
    public void undo() {
        this._sheet.remove(this._graphic);
        this.refreshAll();
    }
}

