/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions;

import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGraph;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaSheet;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentEditPanel;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCmdGraphMove;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.util.List;

public class OCmdGraphAlign
extends OCmdGraphMove {
    protected int _pivotX = -1;
    protected int _pivotY = -1;

    public OCmdGraphAlign(CeciliaAppl appl, AltaContentEditPanel c, OCmdGraphMove.Move align) {
        super(appl, c, align);
    }

    @Override
    protected boolean prepareDo() {
        int i;
        int nbrPivot = 0;
        List<AlgaSheet> sheets = this.getSheets();
        for (i = sheets.size() - 1; i >= 0; --i) {
            AlgaSheet sheet = sheets.get(i);
            if (!sheet.isVisible()) continue;
            for (AlgaGraph graph : sheet.getGraphs()) {
                if (!graph.isSelected()) continue;
                if (graph.isLocked()) {
                    this.updatePivot(graph);
                    ++nbrPivot;
                    continue;
                }
                this._graphs.add(graph);
            }
        }
        if (this._graphs.isEmpty()) {
            return false;
        }
        if (this._graphs.size() == 1 && nbrPivot == 0) {
            return false;
        }
        this.updateOldLocations();
        if (nbrPivot == 0) {
            for (i = this._graphs.size() - 1; i >= 0; --i) {
                AlgaGraph graph = (AlgaGraph)this._graphs.get(i);
                this.updatePivot(graph);
                ++nbrPivot;
            }
        }
        if (nbrPivot > 0) {
            this.updatePivot(nbrPivot);
        }
        return true;
    }

    private void updatePivot(AlgaGraph graph) {
        int val = -1;
        switch (this._align) {
            case LEFT: {
                val = graph.getX();
                break;
            }
            case RIGHT: {
                val = graph.getX() + graph.getWUser();
                break;
            }
            case VERTICAL: {
                val = graph.getX() + graph.getWUser() / 2;
                break;
            }
            case TOP: {
                val = graph.getY();
                break;
            }
            case BOTTOM: {
                val = graph.getY() + graph.getHUser();
                break;
            }
            case HORIZONTAL: {
                val = graph.getY() + graph.getHUser() / 2;
            }
        }
        if (this._pivotX == -1 && this._pivotY == -1) {
            switch (this._align) {
                case LEFT: 
                case RIGHT: 
                case VERTICAL: {
                    this._pivotX = val;
                    break;
                }
                case TOP: 
                case BOTTOM: 
                case HORIZONTAL: {
                    this._pivotY = val;
                    break;
                }
                case CENTER: {
                    this._pivotX = graph.getX() + graph.getWUser() / 2;
                    this._pivotY = graph.getY() + graph.getHUser() / 2;
                }
            }
        } else {
            switch (this._align) {
                case LEFT: {
                    this._pivotX = Math.min(this._pivotX, val);
                    break;
                }
                case RIGHT: {
                    this._pivotX = Math.max(this._pivotX, val);
                    break;
                }
                case VERTICAL: {
                    this._pivotX += val;
                    break;
                }
                case TOP: {
                    this._pivotY = Math.min(this._pivotY, val);
                    break;
                }
                case BOTTOM: {
                    this._pivotY = Math.max(this._pivotY, val);
                    break;
                }
                case HORIZONTAL: {
                    this._pivotY += val;
                    break;
                }
                case CENTER: {
                    this._pivotX += graph.getX() + graph.getWUser() / 2;
                    this._pivotY += graph.getY() + graph.getHUser() / 2;
                }
            }
        }
    }

    private void updatePivot(int nbrPivot) {
        switch (this._align) {
            case VERTICAL: {
                this._pivotX /= nbrPivot;
                break;
            }
            case HORIZONTAL: {
                this._pivotY /= nbrPivot;
                break;
            }
            case CENTER: {
                this._pivotX /= nbrPivot;
                this._pivotY /= nbrPivot;
            }
        }
    }

    @Override
    protected void actionDo() {
        AlgaGraph graph;
        int i;
        for (i = this._graphs.size() - 1; i >= 0; --i) {
            graph = (AlgaGraph)this._graphs.get(i);
            if (OCmdGraphMove.Move.VERTICAL.equals((Object)this._align) && this._pivotX - graph.getWUser() / 2 < 0) {
                this._pivotX += graph.getWUser() / 2 - this._pivotX + 1;
            }
            if (!OCmdGraphMove.Move.HORIZONTAL.equals((Object)this._align) || this._pivotY - graph.getHUser() / 2 >= 0) continue;
            this._pivotY += graph.getHUser() / 2 - this._pivotY + 1;
        }
        for (i = this._graphs.size() - 1; i >= 0; --i) {
            graph = (AlgaGraph)this._graphs.get(i);
            switch (this._align) {
                case LEFT: {
                    this.moveGraphToNewPos(OCmdGraphMove.Move.HORIZONTAL, this._pivotX, graph);
                    break;
                }
                case RIGHT: {
                    this.moveGraphToNewPos(OCmdGraphMove.Move.HORIZONTAL, this._pivotX - graph.getWUser(), graph);
                    break;
                }
                case VERTICAL: {
                    this.moveGraphToNewPos(OCmdGraphMove.Move.HORIZONTAL, this._pivotX - graph.getWUser() / 2, graph);
                    break;
                }
                case TOP: {
                    this.moveGraphToNewPos(OCmdGraphMove.Move.VERTICAL, this._pivotY, graph);
                    break;
                }
                case BOTTOM: {
                    this.moveGraphToNewPos(OCmdGraphMove.Move.VERTICAL, this._pivotY - graph.getHUser(), graph);
                    break;
                }
                case HORIZONTAL: {
                    this.moveGraphToNewPos(OCmdGraphMove.Move.VERTICAL, this._pivotY - graph.getHUser() / 2, graph);
                    break;
                }
                case CENTER: {
                    this.moveGraphToNewPos(OCmdGraphMove.Move.HORIZONTAL, this._pivotX - graph.getWUser() / 2, graph);
                    this.moveGraphToNewPos(OCmdGraphMove.Move.VERTICAL, this._pivotY - graph.getHUser() / 2, graph);
                }
            }
            graph.computeControlPoints();
        }
    }

    @Override
    public void redo() {
        this.actionDo();
        this.refreshAll();
    }
}

