/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.UtilOcas;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaSub;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGraph;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaLink;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaNode;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaSheet;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentEditPanel;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCCmd;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;

public class OCmdRename
extends OCCmd {
    String _oldName;
    String _newName;
    AltaSub _subLogical;
    AlgaNode _subGraphical;
    List<AlgaLink> _links;

    public OCmdRename(CeciliaAppl appl, AltaContentEditPanel c, AlgaNode node) {
        super(appl, c);
        this._subGraphical = node;
        this._subLogical = node.getLogical();
        this._oldName = this._subLogical.getName();
        this._links = new ArrayList<AlgaLink>(32);
    }

    @Override
    protected boolean prepareDo() {
        String newName = this._oldName;
        boolean valide = false;
        while ((newName = (String)JOptionPane.showInputDialog(JOptionCecilia.getTopContainerOf(this.getSource()), ResMsgOcas.getString("INFO_NEW_NAME"), ResMsgVoc.getString("VOC_RENAME"), 3, null, null, newName)) != null && !newName.isEmpty() && !newName.equals(this._oldName)) {
            String msgErr = UtilOcas.validateNameAltaRica(newName, this.getNode());
            if (msgErr != null) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this.getSource()), msgErr, ResMsgVoc.getString("VOC_ERROR"), 0);
                continue;
            }
            valide = true;
            break;
        }
        if (!valide) {
            return false;
        }
        List<AlgaSheet> sheets = this.getContent().getSheets();
        for (int i = sheets.size() - 1; i >= 0; --i) {
            AlgaSheet sheet = sheets.get(i);
            for (AlgaGraph grf : sheet.getGraphs()) {
                AlgaLink gLink;
                if (!(grf instanceof AlgaLink) || (gLink = (AlgaLink)grf).getLogical().getFromGraphic() != this._subGraphical && gLink.getLogical().getToGraphic() != this._subGraphical) continue;
                this._links.add(gLink);
            }
        }
        this._newName = newName;
        return true;
    }

    @Override
    protected void firstDo() {
        this.redo();
        this.getPanel().addHisto(this);
    }

    private void rename(String name) {
        this.getNode().delSub(this._subLogical);
        this._subLogical.setName(name);
        this.getNode().addSub(this._subLogical);
        for (int i = this._links.size() - 1; i >= 0; --i) {
            AlgaLink link = this._links.get(i);
            link.computeControlPoints();
        }
    }

    @Override
    public void redo() {
        this.rename(this._newName);
        this.refreshAll();
        this.getNode().setChangeInternalStructure(true);
    }

    @Override
    public void undo() {
        this.rename(this._oldName);
        this.refreshAll();
        this.getNode().setChangeInternalStructure(true);
    }
}

