/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.other.PartialCheckBox;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.general.icon.DBIcon;
import com.dassault.cecilia.dbobj.general.icon.gui.IconDlgChooser;
import com.dassault.cecilia.dbobj.general.icon.gui.IconPanelPreview;
import com.dassault.cecilia.dbobj.mbsa.ResIcoOcas;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;

public class VisioPropsDlg
extends JDialogCecilia {
    private static final String ICON_KEEP_PROPORTION_KEY = VisioPropsDlg.class.getPackage().getName() + "." + VisioPropsDlg.class.getName() + ".KeyKeepProportion";
    DBIcon _dbIcon;
    private CeciliaAppl _application;
    JPanel _panelLocation;
    JPanel _panelSize;
    JPanel _panelColor;
    JPanel _panelArrows;
    JPanel _panelFont;
    JPanel _panelText;
    JPanel _panelIcon;
    JTextField _ctrlX;
    JTextField _ctrlY;
    JTextField _ctrlW;
    JTextField _ctrlH;
    JCheckBox _keepProportion;
    PartialCheckBox _ctrlColorBackOpak;
    JButton _ctrlColorFore;
    JButton _ctrlColorBack;
    PartialCheckBox _ctrlArrowBeg;
    PartialCheckBox _ctrlArrowEnd;
    PartialCheckBox _ctrlFontBold;
    PartialCheckBox _ctrlFontItalic;
    JComboBox _ctrlFontSize;
    JTextArea _ctrlText;
    JToggleButton _ctrlAlignTop;
    JToggleButton _ctrlAlignMiddle;
    JToggleButton _ctrlAlignBottom;
    JToggleButton _ctrlAlignLeft;
    JToggleButton _ctrlAlignCenter;
    JToggleButton _ctrlAlignRight;
    IconPanelPreview _ctrlIconPreview;
    JButton _ctrlIconChange;
    JButton _ctrlIconResize;
    JSplitPane _ctrlSplit;
    private static final Insets INSETS_NONE = new Insets(0, 0, 0, 0);
    private static final Insets INSETS_STD = new Insets(5, 5, 5, 5);
    String _oldValueForFocusWidth;
    String _oldValueForFocusHeight;
    private static final Integer[] __FONT_SIZE = new Integer[]{8, 9, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 36, 40, 44};
    private static IconDlgChooser _dlgIcon = null;
    private static Object _lockerDlgIcon = new Object();
    private String _previousText;

    public VisioPropsDlg(Window owner, CeciliaAppl appl) throws HeadlessException {
        super(owner, ResMsgOcas.getString("DRAW_EDIT_PROPERTIES"), true);
        this._application = appl;
        this._dbIcon = null;
        this.make();
    }

    private void make() {
        JPanel center = new JPanel(new GridBagLayout());
        JPanel left = new JPanel(new GridBagLayout());
        int y = 0;
        this._panelLocation = this.createPanelLocation();
        left.add((Component)this._panelLocation, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 18, 2, INSETS_NONE, 0, 0));
        this._panelSize = this.createPanelSize();
        left.add((Component)this._panelSize, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 18, 2, INSETS_NONE, 0, 0));
        this._panelColor = this.createPanelColor();
        left.add((Component)this._panelColor, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 18, 2, INSETS_NONE, 0, 0));
        this._panelArrows = this.createPanelArrows();
        left.add((Component)this._panelArrows, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 18, 2, INSETS_NONE, 0, 0));
        this._panelFont = this.createPanelFont();
        left.add((Component)this._panelFont, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 18, 2, INSETS_NONE, 0, 0));
        center.add((Component)left, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, INSETS_NONE, 0, 0));
        this._panelText = this.createPanelText();
        this._panelIcon = this.createPanelIcon();
        this._ctrlSplit = new JSplitPane(1, this._panelText, this._panelIcon);
        center.add((Component)this._ctrlSplit, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 1, INSETS_NONE, 0, 0));
        center.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)center, "Center");
        this.getContentPane().add((Component)this.createButPanel(), "South");
    }

    private void setTitleBorder(JComponent component, String title) {
        component.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5), BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), title)));
    }

    private JPanel createPanelLocation() {
        JPanel result = new JPanel(new GridBagLayout());
        this._ctrlX = new JTextField(5);
        this._ctrlY = new JTextField(5);
        result.add((Component)new JLabel(ResMsgVoc.getString("VOC_HORIZONTAL")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, INSETS_STD, 0, 0));
        result.add((Component)this._ctrlX, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, INSETS_STD, 0, 0));
        result.add((Component)new JLabel(ResMsgVoc.getString("VOC_VERTICAL")), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, INSETS_STD, 0, 0));
        result.add((Component)this._ctrlY, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 2, INSETS_STD, 0, 0));
        this.setTitleBorder(result, ResMsgOcas.getString("MENU_LOCATE"));
        return result;
    }

    private JPanel createPanelSize() {
        JPanel result = new JPanel(new GridBagLayout());
        this._keepProportion = new JCheckBox(ResMsgOcas.getString("ICON_KEEP_PROPRTION"));
        this._ctrlW = new JTextField(5);
        this._ctrlW.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                VisioPropsDlg.this._oldValueForFocusWidth = VisioPropsDlg.this._ctrlW.getText().trim();
                super.focusGained(e);
            }

            @Override
            public void focusLost(FocusEvent e) {
                VisioPropsDlg.this.doFocusLostWidth();
                super.focusLost(e);
            }
        });
        this._ctrlH = new JTextField(5);
        this._ctrlH.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                VisioPropsDlg.this._oldValueForFocusHeight = VisioPropsDlg.this._ctrlH.getText().trim();
                super.focusGained(e);
            }

            @Override
            public void focusLost(FocusEvent e) {
                VisioPropsDlg.this.doFocusLostHeight();
                super.focusLost(e);
            }
        });
        result.add((Component)this._keepProportion, new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 0, INSETS_STD, 0, 0));
        result.add((Component)new JLabel(ResMsgVoc.getString("VOC_WIDTH")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, INSETS_STD, 0, 0));
        result.add((Component)this._ctrlW, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, INSETS_STD, 0, 0));
        result.add((Component)new JLabel(ResMsgVoc.getString("VOC_HEIGHT")), new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, INSETS_STD, 0, 0));
        result.add((Component)this._ctrlH, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 17, 2, INSETS_STD, 0, 0));
        this.setTitleBorder(result, ResMsgVoc.getString("VOC_SIZE"));
        this._keepProportion.setSelected(Boolean.parseBoolean(this._application.getPlugable().getOption(ICON_KEEP_PROPORTION_KEY)));
        return result;
    }

    protected void doFocusLostWidth() {
        if (this._keepProportion.isEnabled() && this._keepProportion.isSelected()) {
            try {
                String curValue = this._ctrlW.getText().trim();
                int old1 = Integer.parseInt(this._oldValueForFocusWidth);
                int cur1 = Integer.parseInt(curValue);
                if (old1 == cur1) {
                    return;
                }
                double coef = (double)old1 / (double)cur1;
                int old2 = Integer.parseInt(this._ctrlH.getText().trim());
                int cur2 = (int)((double)old2 / coef);
                this._ctrlH.setText(Integer.toString(cur2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    protected void doFocusLostHeight() {
        if (this._keepProportion.isEnabled() && this._keepProportion.isSelected()) {
            try {
                String curValue = this._ctrlH.getText().trim();
                int old1 = Integer.parseInt(this._oldValueForFocusHeight);
                int cur1 = Integer.parseInt(curValue);
                if (old1 == cur1) {
                    return;
                }
                double coef = (double)old1 / (double)cur1;
                int old2 = Integer.parseInt(this._ctrlW.getText().trim());
                int cur2 = (int)((double)old2 / coef);
                this._ctrlW.setText(Integer.toString(cur2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private JPanel createPanelColor() {
        JPanel result = new JPanel(new GridBagLayout());
        this._ctrlColorFore = new JButton("...");
        this._ctrlColorFore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = JColorChooser.showDialog(VisioPropsDlg.this._ctrlColorFore, ResMsgVoc.getString("VOC_LINE"), VisioPropsDlg.this._ctrlColorFore.getBackground());
                if (color != null) {
                    VisioPropsDlg.this._ctrlColorFore.setBackground(color);
                    VisioPropsDlg.this._ctrlColorFore.repaint();
                }
            }
        });
        this._ctrlColorFore.setPreferredSize(new Dimension(60, 24));
        this._ctrlColorFore.setContentAreaFilled(false);
        this._ctrlColorFore.setOpaque(true);
        this._ctrlColorFore.setBackground(null);
        this._ctrlColorFore.setBorder(BorderFactory.createEtchedBorder());
        this._ctrlColorBackOpak = new PartialCheckBox(ResMsgVoc.getString("VOC_FILLING")).setAsymetricChangeValue(true);
        this._ctrlColorBackOpak.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VisioPropsDlg.this._ctrlColorBack.setEnabled(VisioPropsDlg.this._ctrlColorBackOpak.isEnabled() && VisioPropsDlg.this._ctrlColorBackOpak.getState() == PartialCheckBox.State.TRUE);
            }
        });
        this._ctrlColorBack = new JButton("...");
        this._ctrlColorBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = JColorChooser.showDialog(VisioPropsDlg.this._ctrlColorBack, ResMsgVoc.getString("VOC_FILLING"), VisioPropsDlg.this._ctrlColorBack.getBackground());
                if (color != null) {
                    VisioPropsDlg.this._ctrlColorBack.setBackground(color);
                    VisioPropsDlg.this._ctrlColorBack.repaint();
                }
            }
        });
        this._ctrlColorBack.setPreferredSize(new Dimension(60, 24));
        this._ctrlColorBack.setContentAreaFilled(false);
        this._ctrlColorBack.setOpaque(true);
        this._ctrlColorBack.setBackground(null);
        this._ctrlColorBack.setBorder(BorderFactory.createEtchedBorder());
        result.add((Component)new JLabel(ResMsgVoc.getString("VOC_LINE")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, INSETS_STD, 0, 0));
        result.add((Component)this._ctrlColorFore, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, INSETS_STD, 0, 0));
        result.add((Component)this._ctrlColorBackOpak, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 25, 5, 0), 0, 0));
        result.add((Component)this._ctrlColorBack, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 2, INSETS_STD, 0, 0));
        this.setTitleBorder(result, ResMsgVoc.getString("VOC_COLORS"));
        return result;
    }

    private JPanel createPanelArrows() {
        JPanel result = new JPanel(new GridBagLayout());
        this._ctrlArrowBeg = new PartialCheckBox(ResMsgOcas.getString("DRAW_EDIT_ARROW_START")).setAsymetricChangeValue(true);
        this._ctrlArrowEnd = new PartialCheckBox(ResMsgOcas.getString("DRAW_EDIT_ARROW_END")).setAsymetricChangeValue(true);
        result.add((Component)this._ctrlArrowBeg, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, INSETS_STD, 0, 0));
        result.add((Component)this._ctrlArrowEnd, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, INSETS_STD, 0, 0));
        this.setTitleBorder(result, ResMsgVoc.getString("VOC_ARROWS"));
        return result;
    }

    private JPanel createPanelFont() {
        JPanel result = new JPanel(new GridBagLayout());
        this._ctrlFontSize = new JComboBox<Integer>(__FONT_SIZE);
        this._ctrlFontBold = new PartialCheckBox(ResMsgVoc.getString("VOC_BOLD")).setAsymetricChangeValue(true);
        this._ctrlFontItalic = new PartialCheckBox(ResMsgVoc.getString("VOC_ITALIC")).setAsymetricChangeValue(true);
        result.add((Component)new JLabel(ResMsgVoc.getString("VOC_SIZE")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, INSETS_STD, 0, 0));
        result.add((Component)this._ctrlFontSize, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, INSETS_STD, 0, 0));
        result.add((Component)this._ctrlFontBold, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, INSETS_STD, 0, 0));
        result.add((Component)this._ctrlFontItalic, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, INSETS_STD, 0, 0));
        this.setTitleBorder(result, ResMsgVoc.getString("VOC_FONT"));
        return result;
    }

    private JPanel createPanelText() {
        JPanel result = new JPanel(new GridBagLayout());
        this._ctrlText = new JTextArea(8, 20);
        result.add((Component)this._ctrlText, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, INSETS_STD, 0, 0));
        this._ctrlAlignLeft = new JToggleButton(ResIcoOcas.getImageIcon("TEXT_LEFT_ALIGN"));
        this._ctrlAlignCenter = new JToggleButton(ResIcoOcas.getImageIcon("TEXT_CENTER_ALIGN"));
        this._ctrlAlignRight = new JToggleButton(ResIcoOcas.getImageIcon("TEXT_RIGHT_ALIGN"));
        this._ctrlAlignLeft.setMargin(INSETS_NONE);
        this._ctrlAlignCenter.setMargin(INSETS_NONE);
        this._ctrlAlignRight.setMargin(INSETS_NONE);
        ButtonGroup group = new ButtonGroup();
        group.add(this._ctrlAlignLeft);
        group.add(this._ctrlAlignCenter);
        group.add(this._ctrlAlignRight);
        JPanel panel = new JPanel(new GridLayout(1, 3, 5, 10));
        panel.add(this._ctrlAlignLeft);
        panel.add(this._ctrlAlignCenter);
        panel.add(this._ctrlAlignRight);
        result.add((Component)panel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, INSETS_STD, 0, 0));
        this._ctrlAlignTop = new JToggleButton(ResIcoOcas.getImageIcon("TEXT_TOP_ALIGN"));
        this._ctrlAlignMiddle = new JToggleButton(ResIcoOcas.getImageIcon("TEXT_MIDDLE_ALIGN"));
        this._ctrlAlignBottom = new JToggleButton(ResIcoOcas.getImageIcon("TEXT_BOTTOM_ALIGN"));
        this._ctrlAlignTop.setMargin(INSETS_NONE);
        this._ctrlAlignMiddle.setMargin(INSETS_NONE);
        this._ctrlAlignBottom.setMargin(INSETS_NONE);
        group = new ButtonGroup();
        group.add(this._ctrlAlignTop);
        group.add(this._ctrlAlignMiddle);
        group.add(this._ctrlAlignBottom);
        panel = new JPanel(new GridLayout(3, 1, 10, 5));
        panel.add(this._ctrlAlignTop);
        panel.add(this._ctrlAlignMiddle);
        panel.add(this._ctrlAlignBottom);
        result.add((Component)panel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, INSETS_STD, 0, 0));
        this.setTitleBorder(result, ResMsgOcas.getString("MENU_TEXT"));
        return result;
    }

    private JPanel createPanelIcon() {
        JPanel result = new JPanel(new GridBagLayout());
        this._ctrlIconPreview = new IconPanelPreview();
        this._ctrlIconPreview.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this._ctrlIconPreview.setPreferredSize(new Dimension(200, 150));
        this._ctrlIconPreview.setMinimumSize(new Dimension(100, 75));
        this._ctrlIconChange = new JButton(ResMsgVoc.getString("VOC_CHANGE"));
        this._ctrlIconChange.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IconDlgChooser dlg = VisioPropsDlg.this.createIconDlgChooser();
                DBIcon dbIcon = VisioPropsDlg.this._dbIcon;
                if (dbIcon != null) {
                    dlg.setSelectFolder(dbIcon.getDBFolder());
                }
                dlg.setVisible(true);
                if (!dlg.getResult()) {
                    return;
                }
                DBFolder dbFolder = dlg.getSelectFolder();
                if (dbFolder == null) {
                    return;
                }
                DBWrap dbWrap = VisioPropsDlg.this._application.getDAOFactory().findOrCreateWrap(dbFolder);
                if (dbWrap == null) {
                    return;
                }
                VisioPropsDlg.this._dbIcon = dbIcon = (DBIcon)dbWrap;
                VisioPropsDlg.this._ctrlIconPreview.setImageIcon(dbIcon == null ? null : dbIcon.getImage());
                VisioPropsDlg.this._ctrlIconPreview.repaint();
            }
        });
        this._ctrlIconResize = new JButton(ResMsgVoc.getString("VOC_RESIZE"));
        this._ctrlIconResize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageIcon imag = VisioPropsDlg.this._dbIcon.getImage();
                VisioPropsDlg.this._ctrlW.setText(Integer.toString(imag.getIconWidth()));
                VisioPropsDlg.this._ctrlH.setText(Integer.toString(imag.getIconHeight()));
            }
        });
        JPanel panel = new JPanel(new GridLayout(1, 2, 5, 5));
        panel.add(this._ctrlIconChange);
        panel.add(this._ctrlIconResize);
        result.add((Component)this._ctrlIconPreview, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, INSETS_STD, 0, 0));
        result.add((Component)panel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, INSETS_STD, 0, 0));
        this.setTitleBorder(result, ResMsgVoc.getString("VOC_ICON"));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IconDlgChooser createIconDlgChooser() {
        if (_dlgIcon == null) {
            Object object = _lockerDlgIcon;
            synchronized (object) {
                IconDlgChooser dlg = null;
                if (_dlgIcon == null) {
                    Window win = SwingUtilities.getWindowAncestor(this);
                    dlg = new IconDlgChooser(win, this._application);
                }
                if (dlg != null && _dlgIcon == null) {
                    _dlgIcon = dlg;
                }
            }
        }
        return _dlgIcon;
    }

    public void setVisibleLocation(boolean enabled, int x, int y) {
        this._panelLocation.setVisible(enabled);
        this._ctrlX.setText(x < 0 ? "" : Integer.toString(x));
        this._ctrlY.setText(y < 0 ? "" : Integer.toString(y));
    }

    public void setVisibleSize(boolean enabled, int w, int h) {
        this._panelSize.setVisible(enabled);
        this._keepProportion.setEnabled(w >= 0 && h >= 0);
        this._ctrlW.setText(w < 0 ? "" : Integer.toString(w));
        this._ctrlH.setText(h < 0 ? "" : Integer.toString(h));
    }

    public void setVisibleColor(boolean enabledFore, int ctrlfore, int fore, boolean enabledBack, int ctrlback, int back) {
        this._panelColor.setVisible(enabledFore || enabledBack);
        this._ctrlColorFore.setEnabled(enabledFore);
        this._ctrlColorFore.setBackground(ctrlfore == 0 ? new Color(fore) : null);
        this._ctrlColorBackOpak.setEnabled(enabledBack);
        if (enabledBack) {
            switch (ctrlback) {
                case -2: {
                    this._ctrlColorBackOpak.setState(PartialCheckBox.State.PARTIAL);
                    break;
                }
                case 0: {
                    this._ctrlColorBackOpak.setState(PartialCheckBox.State.FALSE);
                    break;
                }
                default: {
                    this._ctrlColorBackOpak.setState(PartialCheckBox.State.TRUE);
                    break;
                }
            }
        } else {
            this._ctrlColorBackOpak.setState(PartialCheckBox.State.FALSE);
        }
        this._ctrlColorBack.setEnabled(enabledBack && this._ctrlColorBackOpak.getState() != PartialCheckBox.State.FALSE);
        this._ctrlColorBack.setBackground(ctrlback != 0 ? new Color(back) : null);
    }

    public void setVisibleArrows(boolean enabled, int ab, int ae) {
        this._panelArrows.setVisible(enabled);
        this._ctrlArrowBeg.setState(ab < 0 ? PartialCheckBox.State.PARTIAL : (ab != 0 ? PartialCheckBox.State.TRUE : PartialCheckBox.State.FALSE));
        this._ctrlArrowEnd.setState(ae < 0 ? PartialCheckBox.State.PARTIAL : (ae != 0 ? PartialCheckBox.State.TRUE : PartialCheckBox.State.FALSE));
    }

    public void setVisibleText(boolean enabled, String t, int fs, int fb, int fi, int ah, int av) {
        this._panelText.setVisible(enabled);
        this._ctrlSplit.setVisible(this._panelText.isVisible() || this._panelIcon.isVisible());
        this._previousText = t;
        this._ctrlText.setText(t == null ? "" : t);
        switch (ah) {
            case 0: {
                this._ctrlAlignLeft.setSelected(true);
                break;
            }
            case 1: {
                this._ctrlAlignCenter.setSelected(true);
                break;
            }
            case 2: {
                this._ctrlAlignRight.setSelected(true);
                break;
            }
            default: {
                this._ctrlAlignLeft.setSelected(false);
                this._ctrlAlignCenter.setSelected(false);
                this._ctrlAlignRight.setSelected(false);
            }
        }
        switch (av) {
            case 0: {
                this._ctrlAlignTop.setSelected(true);
                break;
            }
            case 1: {
                this._ctrlAlignMiddle.setSelected(true);
                break;
            }
            case 2: {
                this._ctrlAlignBottom.setSelected(true);
                break;
            }
            default: {
                this._ctrlAlignTop.setSelected(false);
                this._ctrlAlignMiddle.setSelected(false);
                this._ctrlAlignBottom.setSelected(false);
            }
        }
        this._panelFont.setVisible(enabled);
        this._ctrlFontSize.setSelectedItem(fs < 0 ? null : Integer.valueOf(fs));
        this._ctrlFontBold.setState(fb < 0 ? PartialCheckBox.State.PARTIAL : (fb != 0 ? PartialCheckBox.State.TRUE : PartialCheckBox.State.FALSE));
        this._ctrlFontItalic.setState(fi < 0 ? PartialCheckBox.State.PARTIAL : (fi != 0 ? PartialCheckBox.State.TRUE : PartialCheckBox.State.FALSE));
    }

    public void setVisibleIcon(boolean enabled, DBIcon dbIcon) {
        this._panelIcon.setVisible(enabled);
        this._ctrlSplit.setVisible(this._panelText.isVisible() || this._panelIcon.isVisible());
        this._dbIcon = dbIcon;
        this._ctrlIconResize.setEnabled(this._dbIcon != null);
        this._ctrlIconPreview.setImageIcon(dbIcon == null ? null : dbIcon.getImage());
        this._ctrlSplit.setVisible(this._panelText.isVisible() || this._panelIcon.isVisible());
    }

    private boolean helpVerify(JComponent comp) {
        comp.requestFocus();
        return false;
    }

    @Override
    protected boolean verifyParameters() {
        if (this.isValidX()) {
            try {
                if (this.getValueX() < 0) {
                    return this.helpVerify(this._ctrlX);
                }
            }
            catch (NumberFormatException e) {
                return this.helpVerify(this._ctrlX);
            }
        }
        if (this.isValidY()) {
            try {
                if (this.getValueY() < 0) {
                    return this.helpVerify(this._ctrlY);
                }
            }
            catch (NumberFormatException e) {
                return this.helpVerify(this._ctrlY);
            }
        }
        if (this.isValidW()) {
            try {
                if (this.getValueW() < 0) {
                    return this.helpVerify(this._ctrlW);
                }
            }
            catch (NumberFormatException e) {
                return this.helpVerify(this._ctrlW);
            }
        }
        if (this.isValidH()) {
            try {
                if (this.getValueH() < 0) {
                    return this.helpVerify(this._ctrlH);
                }
            }
            catch (NumberFormatException e) {
                return this.helpVerify(this._ctrlH);
            }
        }
        if (this.isValidFontSize()) {
            try {
                if (this.getFontSize() < 0) {
                    return this.helpVerify(this._ctrlFontSize);
                }
            }
            catch (NumberFormatException e) {
                return this.helpVerify(this._ctrlFontSize);
            }
        }
        return true;
    }

    public boolean isValidX() {
        return this._panelLocation.isVisible() && !this._ctrlX.getText().trim().isEmpty();
    }

    public int getValueX() {
        return Integer.parseInt(this._ctrlX.getText().trim());
    }

    public boolean isValidY() {
        return this._panelLocation.isVisible() && !this._ctrlY.getText().trim().isEmpty();
    }

    public int getValueY() {
        return Integer.parseInt(this._ctrlY.getText().trim());
    }

    public boolean isValidW() {
        return this._panelSize.isVisible() && !this._ctrlW.getText().trim().isEmpty();
    }

    public int getValueW() {
        return Integer.parseInt(this._ctrlW.getText().trim());
    }

    public boolean isValidH() {
        return this._panelSize.isVisible() && !this._ctrlH.getText().trim().isEmpty();
    }

    public int getValueH() {
        return Integer.parseInt(this._ctrlH.getText().trim());
    }

    public boolean isValidFore() {
        return this._panelColor.isVisible() && this._ctrlColorFore.getBackground() != null;
    }

    public Color getColorFore() {
        return this._ctrlColorFore.getBackground();
    }

    public boolean isValidBackOpaque() {
        return this._panelColor.isVisible() && this._ctrlColorBackOpak.isEnabled();
    }

    public PartialCheckBox.State getBackOpaque() {
        return this._ctrlColorBackOpak.getState();
    }

    public boolean isValidBack() {
        return this.isValidBackOpaque() && this.getBackOpaque() != PartialCheckBox.State.FALSE;
    }

    public Color getColorBack() {
        return this._ctrlColorBack.getBackground();
    }

    public boolean isValidArrowBeg() {
        return this._panelArrows.isVisible() && this._ctrlArrowBeg.getState() != PartialCheckBox.State.PARTIAL;
    }

    public boolean withArrowBeg() {
        return this._ctrlArrowBeg.getState() == PartialCheckBox.State.TRUE;
    }

    public boolean isValidArrowEnd() {
        return this._panelArrows.isVisible() && this._ctrlArrowEnd.getState() != PartialCheckBox.State.PARTIAL;
    }

    public boolean withArrowEnd() {
        return this._ctrlArrowEnd.getState() == PartialCheckBox.State.TRUE;
    }

    public boolean isValidFontSize() {
        return this._panelFont.isVisible() && this._ctrlFontSize.getSelectedItem() != null;
    }

    public int getFontSize() {
        return Integer.parseInt(this._ctrlFontSize.getSelectedItem().toString().trim());
    }

    public boolean isValidFontBold() {
        return this._panelFont.isVisible() && this._ctrlFontBold.getState() != PartialCheckBox.State.PARTIAL;
    }

    public boolean withFontBold() {
        return this._ctrlFontBold.getState() == PartialCheckBox.State.TRUE;
    }

    public boolean isValidFontItalic() {
        return this._panelFont.isVisible() && this._ctrlFontItalic.getState() != PartialCheckBox.State.PARTIAL;
    }

    public boolean withFontItalic() {
        return this._ctrlFontItalic.getState() == PartialCheckBox.State.TRUE;
    }

    public boolean isValidText() {
        return this._panelText.isVisible() && this._ctrlText.getText() != null;
    }

    public String getValueText() {
        String currentText = this._ctrlText.getText();
        if (this._previousText == null && currentText.length() == 0) {
            return null;
        }
        return currentText;
    }

    public boolean isValidAlignH() {
        return this._panelText.isVisible() && (this._ctrlAlignLeft.isSelected() || this._ctrlAlignCenter.isSelected() || this._ctrlAlignRight.isSelected());
    }

    public int getValueAlignH() {
        if (this._ctrlAlignLeft.isSelected()) {
            return 0;
        }
        if (this._ctrlAlignCenter.isSelected()) {
            return 1;
        }
        if (this._ctrlAlignRight.isSelected()) {
            return 2;
        }
        return -1;
    }

    public boolean isValidAlignV() {
        return this._panelText.isVisible() && (this._ctrlAlignTop.isSelected() || this._ctrlAlignMiddle.isSelected() || this._ctrlAlignBottom.isSelected());
    }

    public int getValueAlignV() {
        if (this._ctrlAlignTop.isSelected()) {
            return 0;
        }
        if (this._ctrlAlignMiddle.isSelected()) {
            return 1;
        }
        if (this._ctrlAlignBottom.isSelected()) {
            return 2;
        }
        return -1;
    }

    public boolean isValidIcon() {
        return this._panelIcon.isVisible() && this._dbIcon != null;
    }

    public DBIcon getValueIcon() {
        return this._dbIcon;
    }

    @Override
    protected void validDialog() {
        if (this._ctrlW.hasFocus()) {
            this.doFocusLostWidth();
        } else if (this._ctrlH.hasFocus()) {
            this.doFocusLostHeight();
        }
        super.validDialog();
        if (this.getResult()) {
            this._application.getPlugable().setOption(ICON_KEEP_PROPORTION_KEY, Boolean.toString(this._keepProportion.isSelected()));
        }
    }
}

