/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.export;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.export.ExpBook;
import com.dassault.cecilia.core.cecilia.export.ExpContainer;
import com.dassault.cecilia.core.cecilia.export.ExpDBFolderHeader;
import com.dassault.cecilia.core.cecilia.export.ExpGeneral;
import com.dassault.cecilia.core.cecilia.export.ExpObjectInfo;
import com.dassault.cecilia.core.cecilia.export.ExpPara;
import com.dassault.cecilia.core.cecilia.export.ExpSection;
import com.dassault.cecilia.core.cecilia.export.ExpTable;
import com.dassault.cecilia.core.cecilia.export.ExpTableWithEntry;
import com.dassault.cecilia.core.cecilia.export.XPortConfig;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.export.XPortCfgNode;
import com.dassault.cecilia.dbobj.mbsa.node.AltaFlow;
import com.dassault.cecilia.dbobj.mbsa.node.AltaNode;
import com.dassault.cecilia.dbobj.mbsa.operator.AltaOperator;
import com.dassault.cecilia.dbobj.mbsa.type.AltaType;
import com.dassault.cecilia.dbobj.mbsa.type.DBType;

public class XPortCfgOperator
extends XPortCfgNode
implements XPortConfig<AltaOperator> {
    @Override
    public void configBook(ExpBook expBook, AltaOperator item) {
        expBook.setInfo(new ExpObjectInfo(item.getDBFolder()));
        this.addInternal(expBook, item);
        this.addDependencies(expBook, item);
    }

    @Override
    public void addInto(ExpContainer expContainer, AltaOperator item) {
        ExpDBFolderHeader header = new ExpDBFolderHeader(item.getDBFolder(), ResMsgOcas.getString("EXPORT_DBK_MODEL_OF_OPERATOR"));
        this.addInternal(header, item);
        expContainer.add(header);
    }

    private void addInternal(ExpContainer header, AltaOperator item) {
        header.add(new ExpGeneral(item.getDBFolder()));
        ExpSection sectionDef = new ExpSection(){

            @Override
            public String getTitle() {
                return ResMsgOcas.getString("OPERATOR_EDIT_OPERANDE");
            }
        };
        if (item.getFlows().isEmpty()) {
            sectionDef.add(new ExpPara(ResMsgVoc.getString("VOC_NONE")));
        } else {
            sectionDef.add(new ExpOperandes(item));
        }
        header.add(sectionDef);
        this.addSectionCode(header, item);
        this.addSectionOperators(header, item);
    }

    @Override
    protected String getAltaRicaCode(AltaNode node) {
        AltaOperator item = (AltaOperator)node;
        StringBuilder out = new StringBuilder(1024);
        out.append(item.getHeader(false, false));
        out.append(item.getCode().trim()).append("\n");
        out.append(item.getBottom(false)).append("\n");
        return out.toString();
    }

    static class ExpOperandes
    extends ExpTableWithEntry<AltaFlow> {
        AltaOperator _node;
        AltaFlow _flowNode;

        public ExpOperandes(AltaOperator node) {
            this._node = node;
            this._flowNode = new AltaFlow(node.getName(), node.getType());
        }

        @Override
        protected int getColumnCount() {
            return 2;
        }

        @Override
        protected String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return ResMsgVoc.getString("VOC_NAME");
                }
                case 1: {
                    return ResMsgVoc.getString("VOC_TYPE");
                }
            }
            return "<Error>";
        }

        @Override
        protected int getRowCount() {
            return this._node.getFlows().size() + 1;
        }

        @Override
        protected AltaFlow getObject(int row) {
            if (row == 0) {
                return this._flowNode;
            }
            return this._node.getFlows().get(row - 1);
        }

        @Override
        protected String getEntryAt(int col, AltaFlow field) {
            switch (col) {
                case 0: {
                    return field.getName();
                }
                case 1: {
                    AltaType type = field.getType();
                    if (type instanceof DBType && ((DBType)type).getDBFolder() != null) {
                        return ((DBType)type).getDBFolder().getRefPath();
                    }
                    return type.getValue();
                }
            }
            return "";
        }

        @Override
        protected ExpTable.ExpAlign getColumnAlign(int col) {
            return ExpTable.ExpAlign.LEFT;
        }

        @Override
        protected int getColumnWidth(int col) {
            return 15;
        }
    }
}

