/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.export;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.export.DBKOutput;
import com.dassault.cecilia.core.cecilia.export.ExpBook;
import com.dassault.cecilia.core.cecilia.export.ExpContainer;
import com.dassault.cecilia.core.cecilia.export.ExpDBFolderHeader;
import com.dassault.cecilia.core.cecilia.export.ExpGeneral;
import com.dassault.cecilia.core.cecilia.export.ExpObjectInfo;
import com.dassault.cecilia.core.cecilia.export.ExpPara;
import com.dassault.cecilia.core.cecilia.export.ExpSection;
import com.dassault.cecilia.core.cecilia.export.ExpTable;
import com.dassault.cecilia.core.cecilia.export.ExpTableWithEntry;
import com.dassault.cecilia.core.cecilia.export.XPortConfig;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaEquipment;
import com.dassault.cecilia.dbobj.mbsa.export.ExpAlgaContent;
import com.dassault.cecilia.dbobj.mbsa.export.XPortCfgNode;
import com.dassault.cecilia.dbobj.mbsa.node.AltaNode;
import com.dassault.cecilia.dbobj.mbsa.system.AltaConfig;
import com.dassault.cecilia.dbobj.mbsa.system.AltaSystem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

public class XPortCfgSystem
extends XPortCfgNode
implements XPortConfig<AltaSystem> {
    @Override
    public void configBook(ExpBook expBook, AltaSystem item) {
        expBook.setInfo(new ExpObjectInfo(item.getDBFolder()));
        final String refPath = item.getDBFolder().getRefPath();
        ExpSection main = new ExpSection(){

            @Override
            public String getTitle() {
                return ResMsgVoc.getString("VOC_MODEL") + " " + refPath;
            }
        };
        expBook.add(main);
        this.addInternal(main, item);
        this.addDependencies(expBook, item);
    }

    @Override
    public void addInto(ExpContainer expContainer, AltaSystem item) {
        ExpDBFolderHeader header = new ExpDBFolderHeader(item.getDBFolder());
        this.addInternal(header, item);
        expContainer.add(header);
    }

    private void addInternal(ExpContainer main, AltaSystem item) {
        main.add(new ExpGeneral(item.getDBFolder()));
        this.addSectionSubs(main, item);
        main.add(new ExpAlgaContent(item));
        this.addSectionSyncs(main, item);
        this.addSectionCode(main, item);
        this.addSectionOperators(main, item);
        this.addSectionConfigs(main, item);
        this.addSectionEvents(main, item, ResMsgOcas.getString("VOC_MODIFIED_EVENTS"));
    }

    @Override
    protected String getAltaRicaCode(AltaNode node) {
        AltaEquipment item = (AltaEquipment)node;
        StringBuilder out = new StringBuilder(1024);
        out.append(item.getCode().trim()).append("\n");
        return out.toString();
    }

    protected void addSectionConfigs(ExpContainer expContainer, AltaSystem item) {
        if (!item.getConfigs().isEmpty()) {
            ExpSection sectionDef = new ExpSection(){

                @Override
                public String getTitle() {
                    return ResMsgOcas.getString("VOC_INITIAL_CONFIGS");
                }
            };
            sectionDef.add(new ExpMBSAConfigs(item));
            expContainer.add(sectionDef);
        }
    }

    static class ExpMBSAConfigs
    extends ExpTableWithEntry<AltaConfig> {
        AltaSystem _node;

        public ExpMBSAConfigs(AltaSystem node) {
            this._node = node;
        }

        @Override
        protected int getColumnCount() {
            return 3;
        }

        @Override
        protected String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return ResMsgVoc.getString("VOC_NAME");
                }
                case 1: {
                    return ResMsgVoc.getString("VOC_COMMENT");
                }
                case 2: {
                    return ResMsgOcas.getString("OCAS_INIT_STATES");
                }
            }
            return "<Error>";
        }

        @Override
        protected int getRowCount() {
            return this._node.getConfigs().size();
        }

        @Override
        protected AltaConfig getObject(int row) {
            return this._node.getConfigs().get(row);
        }

        @Override
        protected void writeDocbookEntryAt(DBKOutput output, int col, int row) throws IOException {
            AltaConfig item = this._node.getConfigs().get(row);
            if (col == 2) {
                ArrayList<String> inits = new ArrayList<String>(5);
                for (Map.Entry<String, String> init : item.getStates().entrySet()) {
                    inits.add(init.getKey() + " := " + init.getValue());
                }
                ExpPara.writeDocbookListSimple(output, inits);
            } else {
                output.write(this.getEntryAt(col, item), true);
            }
        }

        @Override
        protected String getEntryAt(int col, AltaConfig item) {
            switch (col) {
                case 0: {
                    return item.getName();
                }
                case 1: {
                    return item.getLabel();
                }
            }
            return "";
        }

        @Override
        protected ExpTable.ExpAlign getColumnAlign(int col) {
            return ExpTable.ExpAlign.LEFT;
        }

        @Override
        protected int getColumnWidth(int col) {
            if (col == 0) {
                return 8;
            }
            if (col == 1) {
                return 20;
            }
            return 10;
        }
    }
}

