/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.node.io;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.general.DBObjectXmlConstant;
import com.dassault.cecilia.dbobj.general.DBObjectXmlUtility;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.node.io.DBAltaDefaultHandlerXml;
import com.dassault.cecilia.dbobj.mbsa.type.AltaType;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeBool;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeParser;
import com.dassault.cecilia.dbobj.mbsa.type.DBType;
import java.io.IOException;
import java.util.Map;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class DBAltaTypeHandlerXml
extends DBAltaDefaultHandlerXml
implements DBObjectXmlConstant {
    protected CECFactory _cecFactory;

    protected DBAltaTypeHandlerXml(DBLogs.DBLogsManager manager, Locator locator, CECFactory cecFactory) {
        super(manager, locator);
        this._cecFactory = cecFactory;
    }

    protected AltaType readType(String key, Map<String, String> attrs) throws SAXException {
        String type = attrs.get("type");
        String refPath = attrs.get("refPath");
        String refID = attrs.get("refID");
        if (type == null || type.isEmpty()) {
            if (refID == null || refID.isEmpty()) {
                this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_PARSER_NOR_ATTRS", key, "type", "refID"), this.getLocator()));
            }
            if (refPath == null || refPath.isEmpty()) {
                this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_PARSER_NOR_ATTRS", key, "type", "refPath"), this.getLocator()));
            }
        } else if (refID != null || refPath != null) {
            this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_PARSER_XOR_ATTRS", key, "type", "refID"), this.getLocator()));
        }
        AltaType typeField = null;
        if (type == null || type.isEmpty()) {
            type = null;
            long id = Long.parseLong(refID);
            typeField = AltaTypeParser.getDBType(refPath, id, this._cecFactory);
        } else {
            typeField = AltaTypeParser.getType(type);
        }
        if (typeField == null) {
            this.warning(new SAXParseException(ResMsgOcas.msgFormat("MSG_XML_TYPE_READ", type == null ? refPath : type), this.getLocator()));
            typeField = AltaTypeBool.getInstance();
        }
        return typeField;
    }

    public static void writeType(AltaType type, Appendable outData) throws IOException {
        if (!(type instanceof DBType) || ((DBType)type).getDBFolder() == null) {
            DBObjectXmlUtility.appendXML(outData.append(" ").append("type").append("='"), type.getValue()).append("'");
        } else {
            DBFolder dbFolder = ((DBType)type).getDBFolder();
            DBObjectXmlUtility.writeDBFolder(outData, dbFolder, null);
        }
    }
}

