/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.operator;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.mbsa.GenerateAltaricaCode;
import com.dassault.cecilia.dbobj.mbsa.node.AltaFlow;
import com.dassault.cecilia.dbobj.mbsa.node.AltaNode;
import com.dassault.cecilia.dbobj.mbsa.node.io.DBAltaTypeHandlerXml;
import com.dassault.cecilia.dbobj.mbsa.node.io.DBNodeHandlerXml;
import com.dassault.cecilia.dbobj.mbsa.node.io.DBNodeReaderRaw;
import com.dassault.cecilia.dbobj.mbsa.operator.io.DBOperHandlerXml;
import com.dassault.cecilia.dbobj.mbsa.operator.io.DBOperReaderRaw;
import com.dassault.cecilia.dbobj.mbsa.type.AltaType;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeBool;
import com.dassault.cecilia.dbobj.mbsa.type.DBType;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.dbobj.wrap.compareConflict.CompareResult;
import com.dassault.cecilia.dbobj.wrap.compareConflict.CompareResultString;
import com.dassault.cecilia.lib.util.CopyUtility;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AltaOperator
extends AltaNode {
    private static Logger _LOG = Logger.getLogger(AltaOperator.class.getPackage().getName());
    AltaType _type = AltaTypeBool.getInstance();

    @Override
    protected Logger getJavaLog() {
        return _LOG;
    }

    public AltaOperator(DBFolder dbFolder) {
        super(dbFolder);
        this._code = new StringBuilder(64).append(this.getName()).append(" = true;\n").toString();
    }

    @Override
    public DBFolder.Family getFamily() {
        return DBFolder.Family.OPERATOR;
    }

    @Override
    protected String getNature() {
        return "operator";
    }

    @Override
    protected String getRelation() {
        return "OA_OPER";
    }

    @Override
    protected Set<DBRelation> createRelations(String typeSrc) {
        DBFolder dbType;
        Set<DBRelation> relations = super.createRelations(typeSrc);
        if (this._type instanceof DBType && (dbType = ((DBType)this._type).getDBFolder()) != null) {
            relations.add(new DBRelation(this._dbFolder, typeSrc, dbType, "OA_TYPE"));
        }
        return relations;
    }

    @Override
    public void toXML(Appendable out, String indent) throws IOException {
        out.append(indent).append("<").append("cec.operator");
        DBAltaTypeHandlerXml.writeType(this._type, out);
        out.append(">\n");
        super.toXML(out, indent);
        out.append(indent).append("</").append("cec.operator").append(">\n");
    }

    @Override
    public AltaOperator getCopy() {
        AltaOperator dest = new AltaOperator(this._dbFolder);
        dest.setType(this._type.getCopy());
        dest.copy(this, (CopyUtility)new CopyUtility.Default());
        return dest;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.getDBFolder().getParent().getName();
    }

    public AltaType getType() {
        return this._type;
    }

    public void setType(AltaType type) {
        this._type = type;
    }

    @Override
    public String getAltaRicaName() {
        return this.getName();
    }

    public String getHeader(boolean likeModel, boolean expandLink) {
        StringBuilder header = new StringBuilder(512);
        if (likeModel) {
            header.append("node ");
        } else {
            header.append("func ");
        }
        header.append(this.getName()).append("\n");
        header.append(" flow\n");
        try {
            this._type.writeAltaRicaFlow(header, this.getName(), AltaFlow.Orientation.OUT, expandLink);
            for (AltaFlow altaOperande : this._lstFlow) {
                altaOperande.getType().writeAltaRicaFlow(header, altaOperande.getName(), altaOperande.getOrientation(), expandLink);
            }
        }
        catch (IOException e) {
            _LOG.log(Level.INFO, "Il y a eu un soucis lors de l'ecriture des types de flux", e);
        }
        header.append(" assert\n");
        return header.toString();
    }

    public String getBottom(boolean likeModel) {
        if (likeModel) {
            return "edon";
        }
        return "cnuf";
    }

    @Override
    protected void doGenerateCode(File file, GenerateAltaricaCode generator) {
        generator.generateOperator(this, file);
    }

    @Override
    protected DBNodeHandlerXml createHandlerXml(CECFactory cecFactory, DBLogs.DBLogsManager logMng) {
        return new DBOperHandlerXml(logMng, null, cecFactory);
    }

    @Override
    protected void copyFromHandlerXml(DBNodeHandlerXml saxHandler, DBLogs.DBLogsManager logMng) {
        this._type = ((DBOperHandlerXml)saxHandler).getType();
        super.copyFromHandlerXml(saxHandler, logMng);
    }

    @Override
    protected DBNodeReaderRaw createReaderRaw(DBFolder dbFolder, DBLogs.DBLogsManager logMng) {
        return new DBOperReaderRaw(this._dbFolder, logMng);
    }

    @Override
    protected void copyFromReaderRaw(DBNodeReaderRaw readerRaw, CECFactory cecFactory, DBLogs.DBLogsManager logMng) {
        this._type = ((DBOperReaderRaw)readerRaw).getType();
        super.copyFromReaderRaw(readerRaw, cecFactory, logMng);
    }

    @Override
    public List<Function<DBWrap, CompareResult>> getFieldsToCompare(DAOFactory factoryWrap, boolean forImport) {
        List<Function<DBWrap, CompareResult>> list = super.getFieldsToCompare(factoryWrap, forImport);
        list.add(new Function<DBWrap, CompareResult>(){

            @Override
            public CompareResult apply(DBWrap wrap) {
                AltaType type1 = AltaOperator.this.getType();
                AltaType type2 = ((AltaOperator)wrap).getType();
                return new CompareResultString(ResMsgVoc.getString("VOC_TYPE"), type1 != null ? type1.toLabel() : null, type2 != null ? type2.toLabel() : null);
            }
        });
        return list;
    }
}

