/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.simul;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.action.CThread;
import com.dassault.cecilia.core.cecilia.stepper.SimStepper;
import com.dassault.cecilia.core.cecilia.stepper.ViewTransition;
import com.dassault.cecilia.core.cecilia.stepper.ViewVariable;
import com.dassault.cecilia.dbobj.mbsa.simul.AltaSimulFrame;
import com.dassault.cecilia.dbobj.mbsa.simul.CentralizedStepper;
import com.dassault.cecilia.dbobj.mbsa.system.AltaSystem;
import com.dassault.cecilia.dbobj.mbsa.system.gui.AltaSystemFrame;
import com.dassault.cecilia.lib.mbsa.Stepper;
import com.dassault.cecilia.lib.mbsa.StepperException;
import com.dassault.cecilia.lib.mbsa.StepperInstantaneousLoopException;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import com.dassault.cecilia.main.cecilia.OpenFolder;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JInternalFrame;

public class AltaSimStepper
extends SimStepper {
    AltaSystem _model;
    CeciliaAppl _appl;
    CentralizedStepper _centralized;
    AltaSystemFrame _editMasterFrame;
    AltaSimulFrame _simulMasterFrame;
    Map<String, String> _initStates;
    boolean _bSimulationStoping = false;

    AltaSimStepper(CeciliaAppl appl, CentralizedStepper central, AltaSystem model) {
        this._model = model;
        this._centralized = central;
        this._appl = appl;
    }

    public Map<String, String> getInitStates() {
        return this._initStates;
    }

    public void startSimulation() {
        StartSimulationThread thread = new StartSimulationThread(this._appl.getTopWindow());
        thread.realiseDo();
    }

    public boolean isSimulationStoping() {
        return this._bSimulationStoping;
    }

    public void stopSimulation() {
        this._bSimulationStoping = true;
        SimulationThread thread = new SimulationThread(this._appl.getTopWindow()){

            @Override
            protected void firstDo() {
                this.doStopSimulation();
                AltaSimStepper.this._bSimulationStoping = false;
            }
        };
        thread.realiseDo();
    }

    @Override
    public boolean changeOption() {
        return this._connect.setSimulOptions(this._centralized.getSimulOptions());
    }

    @Override
    public boolean goForward(ViewTransition tr) {
        ForwardSimulationThread thread = new ForwardSimulationThread(this._appl.getTopWindow(), tr);
        thread.realiseDo();
        return thread._result;
    }

    @Override
    public boolean goBackward(int nbrTrans) {
        BackwardSimulationThread thread = new BackwardSimulationThread(this._appl.getTopWindow(), nbrTrans);
        thread.realiseDo();
        return thread._result;
    }

    @Override
    public boolean goInitialState() {
        InitialStateSimulationThread thread = new InitialStateSimulationThread(this._appl.getTopWindow());
        thread.realiseDo();
        return thread._result;
    }

    @Override
    public boolean setValueOfState(ViewVariable state, String value) {
        ChangeValueOfStateSimulationThread thread = new ChangeValueOfStateSimulationThread(this._appl.getTopWindow(), state, value);
        thread.realiseDo();
        return thread._result;
    }

    class ChangeValueOfStateSimulationThread
    extends SimulationThread {
        boolean _result;
        ViewVariable _state;
        String _value;

        public ChangeValueOfStateSimulationThread(Component c, ViewVariable state, String value) {
            super(c);
            this._result = false;
            this._state = state;
            this._value = value;
        }

        @Override
        protected void firstDo() {
            block4: {
                try {
                    this._result = AltaSimStepper.this.doSetValueOfState(this._state, this._value);
                    if (!this._result) {
                        String mess = ResMsgCore.msgFormat("SIM_ERR_SETVALUE", this._state.getName(), this._value);
                        AltaSimStepper.this.displayException(mess);
                    } else {
                        this.refreshFrames();
                    }
                }
                catch (StepperException ex) {
                    if (!this.displayException(ex, true)) break block4;
                    this.doStopSimulation();
                }
            }
        }
    }

    class InitialStateSimulationThread
    extends SimulationThread {
        boolean _result;

        public InitialStateSimulationThread(Component c) {
            super(c);
            this._result = false;
        }

        @Override
        protected void firstDo() {
            block3: {
                try {
                    this._result = AltaSimStepper.this.doGoInitialState();
                    if (this._result) {
                        this.refreshFrames();
                    }
                }
                catch (StepperException ex) {
                    if (!this.displayException(ex, true)) break block3;
                    this.doStopSimulation();
                }
            }
        }
    }

    class BackwardSimulationThread
    extends SimulationThread {
        boolean _result;
        int _nbrTrans;

        public BackwardSimulationThread(Component c, int nbrTrans) {
            super(c);
            this._nbrTrans = nbrTrans;
            this._result = false;
        }

        @Override
        protected void firstDo() {
            block3: {
                try {
                    this._result = AltaSimStepper.this.doGoBackward(this._nbrTrans);
                    if (this._result) {
                        this.refreshFrames();
                    }
                }
                catch (StepperException ex) {
                    if (!this.displayException(ex, false)) break block3;
                    this.doStopSimulation();
                }
            }
        }
    }

    class ForwardSimulationThread
    extends SimulationThread {
        boolean _result;
        ViewTransition _tr;

        public ForwardSimulationThread(Component c, ViewTransition tr) {
            super(c);
            this._tr = tr;
            this._result = false;
        }

        @Override
        protected void firstDo() {
            block3: {
                try {
                    this._result = AltaSimStepper.this.doGoForward(this._tr);
                    if (this._result) {
                        this.refreshFrames();
                    }
                }
                catch (StepperException ex) {
                    if (!this.displayException(ex, false)) break block3;
                    this.doStopSimulation();
                }
            }
        }
    }

    abstract class SimulationThread
    extends CThread {
        public SimulationThread(Component c) {
            super(c);
            AltaSimStepper.this.setParentComponent(c);
        }

        protected void doStopSimulation() {
            OpenFolder openFolder = AltaSimStepper.this._appl.getOpenFolders().getOpenFolder(AltaSimStepper.this._model.getDBFolder());
            for (JInternalFrame frame : openFolder.getFrames()) {
                if (!(frame instanceof AltaSimulFrame)) continue;
                frame.doDefaultCloseAction();
            }
            openFolder.setMasterFrame(AltaSimStepper.this._editMasterFrame);
            AltaSimStepper.this._editMasterFrame.setVisible(true);
            AltaSimStepper.this._centralized.stopSimulation();
            AltaSimStepper.this._model = null;
            for (JInternalFrame frame : new ArrayList<JInternalFrame>(openFolder.getFrames())) {
                if (!(frame instanceof AltaSimulFrame)) continue;
                openFolder.removeFrame(frame);
            }
        }

        protected boolean displayException(Throwable result, boolean stopTemporalExcept) {
            if (result != null) {
                if (result instanceof StepperInstantaneousLoopException) {
                    AltaSimStepper.this.displayStepperException((StepperException)result);
                    return stopTemporalExcept;
                }
                if (result instanceof StepperException) {
                    AltaSimStepper.this.displayStepperException((StepperException)result);
                    return true;
                }
                AltaSimStepper.this.displayException(result.getMessage());
                return true;
            }
            return false;
        }

        protected void refreshFrames() {
            OpenFolder openFolder = AltaSimStepper.this._appl.getOpenFolders().getOpenFolder(AltaSimStepper.this._model.getDBFolder());
            for (JInternalFrame frame : openFolder.getFrames()) {
                if (!(frame instanceof AltaSimulFrame)) continue;
                frame.repaint();
            }
        }
    }

    class StartSimulationThread
    extends CThread {
        public StartSimulationThread(Component c) {
            super(c);
            AltaSimStepper.this.setParentComponent(c);
        }

        @Override
        protected void firstDo() {
            Stepper stepper = AltaSimStepper.this._centralized.createStepper();
            if (stepper == null) {
                return;
            }
            AltaSimStepper.this._initStates = null;
            try {
                AltaSimStepper.this.open(stepper);
                AltaSimStepper.this._initStates = AltaSimStepper.this.getCurrentStates();
            }
            catch (StepperException exc) {
                AltaSimStepper.this.displayStepperException(exc);
            }
            catch (Throwable th) {
                AltaSimStepper.this.displayException(th.getMessage());
            }
            if (AltaSimStepper.this._initStates == null) {
                AltaSimStepper.this.close();
                return;
            }
            AltaSimStepper.this._simulMasterFrame = new AltaSimulFrame(AltaSimStepper.this._appl, AltaSimStepper.this._model, AltaSimStepper.this);
            OpenFolder openFolder = AltaSimStepper.this._appl.getOpenFolders().getOpenFolder(AltaSimStepper.this._model.getDBFolder());
            openFolder.addFrame(AltaSimStepper.this._simulMasterFrame);
            AltaSimStepper.this._editMasterFrame = (AltaSystemFrame)openFolder.getAccess().getMasterFrame();
            AltaSimStepper.this._simulMasterFrame.getSimulPanel().getView().setZoom(AltaSimStepper.this._editMasterFrame.getEditPanel().getView().getZoom());
            openFolder.setMasterFrame(AltaSimStepper.this._simulMasterFrame);
            AltaSimStepper.this._simulMasterFrame.setLocation(AltaSimStepper.this._editMasterFrame.getLocation());
            AltaSimStepper.this._simulMasterFrame.setSize(AltaSimStepper.this._editMasterFrame.getSize());
            AltaSimStepper.this._simulMasterFrame.showView(AltaSimStepper.this._appl.getTopWindow().getDesktop());
            AltaSimStepper.this._editMasterFrame.setVisible(false);
        }
    }
}

