/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.system;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.error.GeneralError;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBFactory;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.general.DBObjectXmlUtility;
import com.dassault.cecilia.dbobj.general.ObjectWithName;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaEquipment;
import com.dassault.cecilia.dbobj.mbsa.node.AltaState;
import com.dassault.cecilia.dbobj.mbsa.node.gui.AltaReservedWord;
import com.dassault.cecilia.dbobj.mbsa.system.AltaSystem;
import com.dassault.cecilia.dbobj.wrap.compareConflict.CompareUtils;
import com.dassault.cecilia.lib.util.CopyUtility;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

public class AltaConfig
implements ObjectWithName {
    public static final String DEFAULT = "Default";
    public static final String OPTION_CONFIG_ALWAYS_SELECT = AltaConfig.class.getName() + "$AlwaysDisplayConfig";
    public static final boolean OPTION_CONFIG_ALWAYS_SELECT_DEF = false;
    String _name = "default";
    String _label = "";
    Map<String, String> _states = new LinkedHashMap<String, String>();
    boolean _bWithError;
    int _nbrHeight = 1;

    public static String verifyName(String name, JComponent owner) {
        if (AltaReservedWord.isReservedWord(name)) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(owner), ResMsgOcas.msgFormat("MODEL_EDIT_RESERVED_WORD", name), ResMsgVoc.getString("VOC_ERROR"), 0);
        } else {
            int character = DBFactory.verifyName(name);
            if (character != 0) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(owner), ResMsgOcas.msgFormat("INFO_INVALID_CHARACTERE", Character.valueOf((char)character)), ResMsgVoc.getString("VOC_ERROR"), 0);
            } else {
                return name;
            }
        }
        return null;
    }

    public AltaConfig getCopy(CopyUtility util) {
        AltaConfig result = new AltaConfig();
        result.copy(this, util);
        util.setRef((Object)this, (Object)result);
        return result;
    }

    private void copy(AltaConfig src, CopyUtility util) {
        this._name = src.getName();
        this._label = src.getLabel();
        this._states = new LinkedHashMap<String, String>(src.getStates());
        this._bWithError = src._bWithError;
        this._nbrHeight = src._nbrHeight;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public AltaConfig setName(String name) {
        this._name = name;
        return this;
    }

    public String getLabel() {
        return this._label;
    }

    public AltaConfig setLabel(String label) {
        this._label = label;
        this.computeHeight();
        return this;
    }

    public Map<String, String> getStates() {
        return this._states;
    }

    public AltaConfig setStates(Map<String, String> states) {
        this._states = new TreeMap<String, String>(states);
        this.computeHeight();
        return this;
    }

    private void computeHeight() {
        int countCR = this._label.length();
        if (countCR > 0) {
            countCR -= this._label.replace("\n", "").length();
        }
        this._nbrHeight = this._states.size();
        if (this._nbrHeight <= countCR) {
            this._nbrHeight = countCR + 1;
        }
        if (this._nbrHeight > 6) {
            this._nbrHeight = 6;
        }
    }

    public int getHeigth() {
        return this._nbrHeight;
    }

    public boolean withError() {
        return this._bWithError;
    }

    public void verify(List<GeneralError<String>> appendError, AltaEquipment system) {
        boolean bWithError = false;
        this._bWithError = true;
        for (Map.Entry<String, String> init : this._states.entrySet()) {
            ObjectWithName obj = system.findFieldFromPath(init.getKey());
            if (obj == null || !(obj instanceof AltaState)) {
                if (appendError != null) {
                    appendError.add(new GeneralError<String>(init.getKey(), ResMsgOcas.getString("MSG_ERR_CONFIG_VARIABLE")));
                }
                bWithError = true;
                continue;
            }
            if (((AltaState)obj).isCompatibleValue(init.getValue())) continue;
            if (appendError != null) {
                appendError.add(new GeneralError<String>(init.getKey(), ResMsgOcas.msgFormat("MSG_ERR_CONFIG_VALUE", init.getValue())));
            }
            bWithError = true;
        }
        this._bWithError = bWithError;
    }

    public void toXML(Appendable out, String indent0) throws IOException {
        out.append(indent0).append("<").append("alta.config");
        DBObjectXmlUtility.appendXML(out.append(" ").append("name").append("='"), this._name).append("'");
        if (this._states.size() == 0 && (this._label == null || this._label.isEmpty())) {
            out.append("/>\n");
        } else {
            out.append(">\n");
            if (this._label != null && !this._label.isEmpty()) {
                out.append(indent0).append("  <").append("label").append(">");
                DBObjectXmlUtility.appendXML(out, this._label);
                out.append("</").append("label").append(">\n");
            }
            for (Map.Entry<String, String> init : this._states.entrySet()) {
                out.append(indent0).append("  <").append("alta.init");
                DBObjectXmlUtility.appendXML(out.append(" ").append("name").append("='"), init.getKey()).append("'");
                DBObjectXmlUtility.appendXML(out.append(" ").append("value").append("='"), init.getValue()).append("'");
                out.append("/>\n");
            }
            out.append(indent0).append("</").append("alta.config").append(">\n");
        }
    }

    public String getCode() {
        if (this._states.size() == 0) {
            return "";
        }
        StringBuilder out = new StringBuilder();
        out.append(" init\n");
        for (Map.Entry<String, String> init : this._states.entrySet()) {
            out.append("  ").append(init.getKey()).append(" := ").append(init.getValue()).append(";\n");
        }
        return out.toString();
    }

    public boolean update(CECFactory daoFactory, DBLogs.DBLogsManager logMng, AltaSystem syst) {
        ArrayList<GeneralError<String>> errors = new ArrayList<GeneralError<String>>();
        this.verify(errors, syst);
        return errors.isEmpty();
    }

    @Override
    public String getAbstract() {
        StringBuilder sb = new StringBuilder();
        sb.append(CompareUtils.getTextForCompare(ResMsgVoc.getString("VOC_DESCRIPTION"), this._label));
        if (this.getStates() != null) {
            sb.append(ResMsgVoc.getString("VOC_STATES")).append(" : \n");
            ArrayList<String> list = new ArrayList<String>();
            for (Map.Entry<String, String> entry : this._states.entrySet()) {
                StringBuilder tmp = new StringBuilder();
                tmp.append('-');
                tmp.append(entry.getKey());
                tmp.append(" := ");
                tmp.append(entry.getValue());
                list.add(tmp.toString());
            }
            list.sort(new Comparator<String>(){

                @Override
                public int compare(String str1, String str2) {
                    return str1.compareToIgnoreCase(str2);
                }
            });
            for (String value : list) {
                sb.append(value).append('\n');
            }
        }
        return sb.toString();
    }

    @Override
    public AltaConfig getCopy() {
        AltaConfig config = new AltaConfig();
        config.setName(this.getName());
        config.setLabel(this.getLabel());
        config.setStates(this.getStates());
        config._bWithError = this._bWithError;
        config._nbrHeight = this._nbrHeight;
        return config;
    }
}

