/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.system.gui;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.swing.CeciliaAction;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.component.AltaComponent;
import com.dassault.cecilia.dbobj.mbsa.component.gui.AltaEditPanel;
import com.dassault.cecilia.dbobj.mbsa.system.AltaColor;
import com.dassault.cecilia.dbobj.mbsa.system.AltaSystem;
import com.dassault.cecilia.dbobj.mbsa.system.gui.ColorChooser;
import com.dassault.cecilia.dbobj.mbsa.type.AltaType;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeBool;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeBound;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeEnum;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeParser;
import com.dassault.cecilia.dbobj.mbsa.type.DBType;
import com.dassault.cecilia.dbobj.mbsa.type.gui.TypeDlgChooser;
import com.dassault.cecilia.lib.util.ResIcoAbstract;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Stroke;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class AltaColorPanel
extends AltaEditPanel {
    private static TypeDlgChooser _typeChooser = null;
    private static Object _LockerDlgChooser = new Object();
    private CeciliaAppl _appl;
    protected JTree _colorTree;
    protected ColorTreeModel _colorModel;
    protected CeciliaAction _ctrlAdd;
    protected CeciliaAction _ctrlDel;
    protected CeciliaAction _ctrlColor;
    protected PreviewColorPanel _previewPanel = new PreviewColorPanel(true);
    protected ColorChooser _basicColorChooser = new ColorChooser();
    JSplitPane _splitColor;
    JComboBox _typeSelector = new JComboBox();
    JPanel _predefinePanel = new JPanel();
    JTextField _predefineType = new JTextField("");
    JButton _selectPredefineType = new JButton("...");
    protected JTextField _valueEnumTypeField = new JTextField("");
    protected JPanel _intervalPanel = new JPanel();
    protected JLabel _minLabel = new JLabel("Min");
    protected JLabel _maxLabel = new JLabel("Max");
    protected JTextField _minValue = new JTextField("");
    protected JTextField _maxValue = new JTextField("");
    private DlgColor _colorDlg = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TypeDlgChooser getDlgChooser(Window win, CeciliaAppl appl) {
        if (_typeChooser == null) {
            TypeDlgChooser dlg = null;
            Object object = _LockerDlgChooser;
            synchronized (object) {
                if (_typeChooser == null) {
                    dlg = new TypeDlgChooser(win, appl);
                }
                if (_typeChooser == null) {
                    _typeChooser = dlg;
                }
                _typeChooser.setOnlyEnum(true);
            }
        }
        return _typeChooser;
    }

    public AltaColorPanel(CeciliaAppl appl) {
        this._appl = appl;
        this.makeTypeTree();
        this.createActions();
        this.makePanel();
        this.refreshCtrl();
    }

    @Override
    public AltaSystem getAltaComponent() {
        return (AltaSystem)super.getAltaComponent();
    }

    AltaColor getColors() {
        return this.getAltaComponent().getColors();
    }

    @Override
    public void setComponent(AltaComponent currentComponent) {
        super.setComponent(currentComponent);
        this._colorModel = new ColorTreeModel(new ColorTreeNode(this.getColors()));
        this._colorTree.setModel(this._colorModel);
        this._basicColorChooser.setEnabled(false);
        for (int i = this.getColors().getNbrTypes() - 1; i >= 0; --i) {
            this._colorTree.expandRow(i);
        }
    }

    protected void makePanel() {
        JToolBar buttonPanel = new JToolBar();
        buttonPanel.setFloatable(false);
        buttonPanel.add(Box.createGlue());
        buttonPanel.add(this._ctrlAdd.createButton(CeciliaAction.BorderStyle.LIGHT));
        buttonPanel.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        buttonPanel.add(this._ctrlDel.createButton(CeciliaAction.BorderStyle.LIGHT));
        buttonPanel.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        buttonPanel.add(this._ctrlColor.createButton(CeciliaAction.BorderStyle.LIGHT));
        buttonPanel.add(Box.createGlue());
        JPanel typePanel = new JPanel(new GridBagLayout());
        typePanel.setBorder(BorderFactory.createEtchedBorder());
        typePanel.add((Component)this._typeSelector, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        typePanel.add((Component)this._valueEnumTypeField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        typePanel.add((Component)this._predefinePanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        typePanel.add((Component)this._intervalPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this._predefinePanel.setLayout(new GridBagLayout());
        this._predefinePanel.add((Component)this._predefineType, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 2), 0, 0));
        this._predefinePanel.add((Component)this._selectPredefineType, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 5), 0, 0));
        this._intervalPanel.setLayout(new GridBagLayout());
        this._intervalPanel.add((Component)this._minLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this._intervalPanel.add((Component)this._minValue, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        this._intervalPanel.add((Component)this._maxLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this._intervalPanel.add((Component)this._maxValue, new GridBagConstraints(3, 0, 1, 1, 0.5, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        this._minLabel.setForeground(Color.black);
        this._maxLabel.setForeground(Color.black);
        this._typeSelector.addItem("enum");
        this._typeSelector.addItem(ResMsgVoc.getString("VOC_INTERVAL"));
        this._typeSelector.addItem(ResMsgOcas.getString("OCAS_PREDEFINE"));
        this._valueEnumTypeField.setVisible(true);
        this._intervalPanel.setVisible(false);
        this._predefinePanel.setVisible(false);
        this._colorTree.setCellRenderer(new AltaTreeColorCellRenderer());
        this._colorTree.expandRow(0);
        this._colorTree.setRootVisible(false);
        this._colorTree.setBackground(Color.white);
        this._colorTree.setRowHeight(ResIcoAbstract.getIconSize());
        this._previewPanel.setColor(Color.white);
        JPanel colorPanel = new JPanel(new GridBagLayout());
        colorPanel.add((Component)this._basicColorChooser, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(2, 2, 2, 2), 0, 0));
        colorPanel.add((Component)this._previewPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 20, 2, 20), 0, 0));
        this._splitColor = new JSplitPane(1, new JScrollPane(this._colorTree), colorPanel);
        this.setLayout(new GridBagLayout());
        this.add((Component)this._splitColor, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 5, 2, 5), 0, 0));
        this.add((Component)buttonPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 2, 5), 0, 0));
        this.add((Component)typePanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 5, 2, 5), 0, 0));
    }

    protected void makeTypeTree() {
        ColorTreeModel model = new ColorTreeModel(new ColorTreeNode());
        this._colorTree = new JTree(model);
    }

    protected void createActions() {
        this._selectPredefineType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TypeDlgChooser dlg = AltaColorPanel.getDlgChooser(SwingUtilities.getWindowAncestor(AltaColorPanel.this._selectPredefineType), AltaColorPanel.this._appl);
                DAOFolder daoFolder = AltaColorPanel.this._appl.getDAOFactory().createFolderDAO();
                DBFolder dbFolder = daoFolder.findFolder("TYPE_FAMILIES", AltaColorPanel.this._predefineType.getText());
                if (dbFolder != null) {
                    dlg.setSelectFolder(dbFolder);
                }
                dlg.setVisible(true);
                if (dlg.getResult() && (dbFolder = dlg.getSelectFolder()) != null) {
                    AltaColorPanel.this._predefineType.setText(dbFolder.getRefPath());
                }
            }
        });
        this._typeSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                switch (AltaColorPanel.this._typeSelector.getSelectedIndex()) {
                    case 0: {
                        AltaColorPanel.this._valueEnumTypeField.setVisible(true);
                        AltaColorPanel.this._intervalPanel.setVisible(false);
                        AltaColorPanel.this._predefinePanel.setVisible(false);
                        break;
                    }
                    case 1: {
                        AltaColorPanel.this._valueEnumTypeField.setVisible(false);
                        AltaColorPanel.this._intervalPanel.setVisible(true);
                        AltaColorPanel.this._predefinePanel.setVisible(false);
                        break;
                    }
                    case 2: {
                        AltaColorPanel.this._valueEnumTypeField.setVisible(false);
                        AltaColorPanel.this._intervalPanel.setVisible(false);
                        AltaColorPanel.this._predefinePanel.setVisible(true);
                    }
                }
            }
        });
        this._colorTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                AltaColorPanel.this.refreshCtrl();
            }
        });
        this._basicColorChooser.addColorListener(new ColorChooser.ColorListener(){

            @Override
            public void change(Color color) {
                TreePath[] treePath = AltaColorPanel.this._colorTree.getSelectionPaths();
                if (treePath == null || treePath.length == 0) {
                    return;
                }
                boolean change = false;
                for (int i = 0; i < treePath.length; ++i) {
                    ColorTreeNode node = (ColorTreeNode)treePath[i].getLastPathComponent();
                    if (node.getLevel() != 2) continue;
                    ((AltaColor.ColorMap.Item)node.getObject()).setColor(color);
                    change = true;
                }
                if (change) {
                    AltaColorPanel.this._colorTree.repaint();
                    AltaColorPanel.this._previewPanel.setColor(color);
                    AltaColorPanel.this.getAltaComponent().setModified(true);
                }
            }
        });
        this._ctrlAdd = new CeciliaAction(ResIcoCore.getImageIcon("BUT_ADD"), ResMsgVoc.getString("VOC_ADD"), ResMsgOcas.getString("COLOR_EDIT_ADD_TYPE")){

            @Override
            public void actionPerformed(ActionEvent e) {
                AltaType type = AltaColorPanel.this.getValidateType();
                if (type == null) {
                    return;
                }
                AltaColor.ColorMap colorMap = AltaColorPanel.this.getColors().findOrCreateColorMap(type);
                if (colorMap == null) {
                    return;
                }
                AltaColorPanel.this._colorModel.insert(colorMap);
                AltaColorPanel.this.getAltaComponent().setModified(true);
                if (type instanceof DBType) {
                    AltaColorPanel.this.getAltaComponent().updateDependTimeUpdt(AltaColorPanel.this._appl.getDAOFactory(), AltaColorPanel.this.getAltaComponent().getWorkingRelations());
                }
            }
        };
        this._ctrlDel = new CeciliaAction(ResIcoCore.getImageIcon("BUT_DEL"), ResMsgVoc.getString("VOC_DELETE"), ResMsgOcas.getString("KEY_0756")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePath[] treePath = AltaColorPanel.this._colorTree.getSelectionPaths();
                ArrayList<ColorTreeNode> nodesToRemove = new ArrayList<ColorTreeNode>();
                if (treePath != null) {
                    for (int i = 0; i < treePath.length; ++i) {
                        AltaColor.ColorMap colorMap;
                        ColorTreeNode node = (ColorTreeNode)treePath[i].getLastPathComponent();
                        if (node.getLevel() != 1 || (colorMap = (AltaColor.ColorMap)node.getObject()).getType() instanceof AltaTypeBool) continue;
                        nodesToRemove.add(node);
                    }
                }
                if (nodesToRemove.size() > 0) {
                    boolean withDBType = false;
                    for (int i = 0; i < nodesToRemove.size(); ++i) {
                        ColorTreeNode node = (ColorTreeNode)nodesToRemove.get(i);
                        AltaColor.ColorMap colorMap = (AltaColor.ColorMap)node.getObject();
                        if (colorMap.getType() instanceof DBType) {
                            withDBType = true;
                        }
                        AltaColorPanel.this.getColors().removeColorMap(colorMap.getType());
                        AltaColorPanel.this._colorModel.remove(node);
                    }
                    AltaColorPanel.this.getAltaComponent().setModified(true);
                    if (withDBType) {
                        AltaColorPanel.this.getAltaComponent().updateDependTimeUpdt(AltaColorPanel.this._appl.getDAOFactory(), AltaColorPanel.this.getAltaComponent().getWorkingRelations());
                    }
                }
            }
        };
        this._ctrlColor = new CeciliaAction(ResIcoCore.getImageIcon("PALETTE"), ResMsgVoc.getString("VOC_COLORS"), ResMsgOcas.getString("COLOR_EDIT_AFFECT")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePath[] treePath = AltaColorPanel.this._colorTree.getSelectionPaths();
                if (treePath == null) {
                    return;
                }
                Color firstColor = null;
                for (int i = 0; i < treePath.length; ++i) {
                    ColorTreeNode node = (ColorTreeNode)treePath[i].getLastPathComponent();
                    if (node.getLevel() != 2) continue;
                    firstColor = ((AltaColor.ColorMap.Item)node.getObject()).getColor();
                }
                if (firstColor != null) {
                    DlgColor dlg = AltaColorPanel.this.createColorDlg();
                    dlg.getChooser().setColor(firstColor);
                    dlg.setVisible(true);
                    if (dlg.getResult()) {
                        firstColor = dlg.getChooser().getColor();
                        for (int i = 0; i < treePath.length; ++i) {
                            ColorTreeNode node = (ColorTreeNode)treePath[i].getLastPathComponent();
                            if (node.getLevel() != 2) continue;
                            ((AltaColor.ColorMap.Item)node.getObject()).setColor(firstColor);
                        }
                        AltaColorPanel.this._colorTree.repaint();
                        AltaColorPanel.this._basicColorChooser.setColor(firstColor);
                        AltaColorPanel.this._previewPanel.setColor(firstColor);
                        AltaColorPanel.this.getAltaComponent().setModified(true);
                    }
                }
            }
        };
    }

    protected void refreshCtrl() {
        TreePath[] treePath = this._colorTree.getSelectionPaths();
        if (treePath != null) {
            boolean onlyType = true;
            boolean onlyColor = true;
            Color selectColor = null;
            boolean firstColor = false;
            for (int i = 0; (onlyType || onlyColor) && i < treePath.length; ++i) {
                ColorTreeNode node = (ColorTreeNode)treePath[i].getLastPathComponent();
                if (onlyColor) {
                    if (node.getLevel() == 2) {
                        if (!firstColor) {
                            firstColor = true;
                            selectColor = ((AltaColor.ColorMap.Item)node.getObject()).getColor();
                        } else {
                            Color currentColor = ((AltaColor.ColorMap.Item)node.getObject()).getColor();
                            if (selectColor != null && !selectColor.equals(currentColor)) {
                                selectColor = null;
                            }
                        }
                    } else {
                        onlyColor = false;
                    }
                }
                if (!onlyType || node.getLevel() == 1) continue;
                onlyType = false;
            }
            this._ctrlColor.setEnabled(onlyColor);
            this._ctrlDel.setEnabled(onlyType);
            if (selectColor != null) {
                this._previewPanel.setColor(selectColor);
            } else {
                this._previewPanel.setColor(Color.white);
            }
            this._basicColorChooser.setColor(selectColor);
            this._basicColorChooser.setEnabled(onlyColor);
        } else {
            this._ctrlColor.setEnabled(false);
            this._ctrlDel.setEnabled(false);
            this._previewPanel.setColor(Color.white);
            this._basicColorChooser.setEnabled(false);
        }
    }

    private AltaType getValidateType() {
        AltaType defaultType = null;
        String msgError = null;
        switch (this._typeSelector.getSelectedIndex()) {
            case 0: {
                if (this._valueEnumTypeField.getText().equals("")) {
                    msgError = ResMsgOcas.getString("MODEL_EDIT_ERROR_NO_ENUM");
                    break;
                }
                if (this._valueEnumTypeField.getText().indexOf(" ") != -1) {
                    msgError = ResMsgOcas.getString("MODEL_EDIT_ERROR_SPACE");
                    break;
                }
                String convertEnumType = AltaTypeEnum.convertInEnumType(this._valueEnumTypeField.getText());
                if (convertEnumType == null) {
                    msgError = ResMsgOcas.getString("TYPE_SPECIFY_ERROR");
                    break;
                }
                defaultType = new AltaTypeEnum("{" + convertEnumType + "}");
                break;
            }
            case 1: {
                int minValue = Integer.MIN_VALUE;
                int maxValue = Integer.MIN_VALUE;
                try {
                    minValue = Integer.parseInt(this._minValue.getText());
                    maxValue = Integer.parseInt(this._maxValue.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (minValue < 0) {
                    msgError = ResMsgOcas.getString("MODEL_EDIT_ERROR_MIN");
                    break;
                }
                if (maxValue < 0) {
                    msgError = ResMsgOcas.getString("MODEL_EDIT_ERROR_MAX");
                    break;
                }
                if (minValue >= maxValue) {
                    msgError = ResMsgOcas.getString("MODEL_EDIT_ERROR_MAXMIN_2");
                    break;
                }
                defaultType = new AltaTypeBound(minValue, maxValue);
                break;
            }
            case 2: {
                defaultType = AltaTypeParser.getType(this._predefineType.getText(), this._appl.getDAOFactory());
                if (defaultType != null) break;
                msgError = ResMsgOcas.getString("TYPE_SPECIFY_DOES_NOT_EXIST");
            }
        }
        if (msgError == null) {
            if (this.getColors().getColorMap(defaultType) != null) {
                msgError = ResMsgOcas.getString("TYPE_EXIST");
            } else if (!this.getColors().isValidType(defaultType)) {
                msgError = ResMsgOcas.getString("TYPE_STRUCT_NO_DEFINE_COLOR");
            } else {
                return defaultType;
            }
        }
        if (msgError != null) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), msgError, ResMsgVoc.getString("VOC_ERROR"), 0);
        }
        return null;
    }

    private synchronized DlgColor createColorDlg() {
        if (this._colorDlg == null) {
            final JColorChooser chooser = new JColorChooser();
            final PreviewColorPanel previewChooser = new PreviewColorPanel(false);
            AbstractColorChooserPanel[] tabColorPanel = chooser.getChooserPanels();
            chooser.removeChooserPanel(tabColorPanel[2]);
            chooser.removeChooserPanel(tabColorPanel[1]);
            chooser.setPreviewPanel(previewChooser);
            chooser.getSelectionModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    previewChooser.setColor(chooser.getColor());
                }
            });
            this._colorDlg = new DlgColor(SwingUtilities.getWindowAncestor(this), chooser);
            this._colorDlg.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(this));
        }
        return this._colorDlg;
    }

    public void updateLangage() {
        int type = this._typeSelector.getSelectedIndex();
        this._typeSelector.removeAllItems();
        this._typeSelector.addItem("enum");
        this._typeSelector.addItem(ResMsgVoc.getString("VOC_INTERVAL"));
        this._typeSelector.addItem(ResMsgOcas.getString("OCAS_PREDEFINE"));
        this._typeSelector.setSelectedIndex(type);
    }

    @Override
    public void focusTreatment() {
        this.requestFocus();
        if (this._splitColor.getDividerLocation() < 150) {
            this._splitColor.setDividerLocation(0.25);
        }
    }

    public static class DlgColor
    extends JDialogCecilia {
        JColorChooser _colorChooser;

        public DlgColor(Window win, JColorChooser colorChooser) {
            super(win, true);
            this.setTitle(ResMsgOcas.getString("TITLE_COLOR_TYPE"));
            ImageIcon icon = ResIcoCore.getImageIcon("PALETTE");
            this.setIconImage(icon.getImage());
            this._colorChooser = colorChooser;
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)colorChooser, "Center");
            this.getContentPane().add((Component)this.createButPanel(), "South");
            this.init();
            this.pack();
        }

        @Override
        protected boolean verifyParameters() {
            return true;
        }

        public JColorChooser getChooser() {
            return this._colorChooser;
        }
    }

    public class AltaTreeColorCellRenderer
    extends DefaultTreeCellRenderer {
        public AltaTreeColorCellRenderer() {
            this.setTextSelectionColor(Color.white);
            this.setTextNonSelectionColor(Color.black);
            this.setBackground(Color.white);
            this.setBackgroundNonSelectionColor(Color.white);
            this.setBackgroundSelectionColor(new Color(0, 0, 128));
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean focus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, focus);
            ColorTreeNode node = (ColorTreeNode)value;
            if (node.getLevel() == 0) {
                this.setClosedIcon(ResIcoCore.getImageIcon("FOLDER_DEFAULT_C"));
                this.setOpenIcon(ResIcoCore.getImageIcon("FOLDER_DEFAULT_O"));
                this.setText("root");
            } else {
                if (node.getLevel() == 1) {
                    AltaColor.ColorMap colorMap = (AltaColor.ColorMap)node.getObject();
                    AltaType type = colorMap.getType();
                    this.setText(type.toLabel());
                    this.setClosedIcon(ResIcoCore.getImageIcon("FOLDER_ENUM_"));
                    this.setOpenIcon(ResIcoCore.getImageIcon("FOLDER_ENUM_"));
                    return this;
                }
                if (node.getLevel() == 2) {
                    AltaColor.ColorMap.Item item = (AltaColor.ColorMap.Item)node.getObject();
                    this.setText(item.getValue());
                    this.setLeafIcon(ResIcoCore.getImageIcon("PALETTE"));
                    JPanel panel = new JPanel(new GridBagLayout());
                    panel.setBackground(Color.white);
                    JPanel emptyPanel = new JPanel();
                    emptyPanel.setBackground(Color.white);
                    panel.add((Component)this, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 2), 0, 0));
                    panel.add((Component)new AltaLineColorPanel(item.getColor(), sel), new GridBagConstraints(1, 0, 1, 1, 0.3, 0.0, 17, 2, new Insets(0, 2, 0, 0), 0, 0));
                    panel.add((Component)emptyPanel, new GridBagConstraints(2, 0, 1, 1, 0.1, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
                    return panel;
                }
            }
            return this;
        }
    }

    public class ColorTreeModel
    extends DefaultTreeModel {
        public ColorTreeModel(TreeNode troort) {
            super(troort);
        }

        public void remove(ColorTreeNode typeNode) {
            if (typeNode.getLevel() != 1) {
                return;
            }
            ColorTreeNode parent = typeNode.getParent();
            int idx = parent.getIndex(typeNode);
            parent._children.remove(idx);
            this.nodesWereRemoved(parent, new int[]{idx}, new Object[]{typeNode});
        }

        public void insert(AltaColor.ColorMap colorMap) {
            Comparator<? super AltaType> comparator = AltaColor.getComparator();
            ColorTreeNode colorRoot = (ColorTreeNode)this.getRoot();
            ColorTreeNode addNode = new ColorTreeNode(colorMap, colorRoot);
            boolean insert = false;
            for (int i = 0; !insert && i < colorRoot.getChildCount(); ++i) {
                ColorTreeNode currentNode = (ColorTreeNode)colorRoot.getChildAt(i);
                AltaType currentType = ((AltaColor.ColorMap)currentNode.getObject()).getType();
                int cmp = comparator.compare(colorMap.getType(), currentType);
                if (cmp > 0) continue;
                colorRoot._children.insertElementAt(addNode, i);
                insert = true;
            }
            if (!insert) {
                colorRoot._children.add(addNode);
            }
            int idx = colorRoot.getIndex(addNode);
            this.nodesWereInserted(colorRoot, new int[]{idx});
        }
    }

    protected class ColorTreeNode
    implements TreeNode {
        short _level = (short)-1;
        Object _userObj = null;
        ColorTreeNode _parent;
        Vector<ColorTreeNode> _children;

        ColorTreeNode(AltaColor root) {
            this._level = 0;
            this._userObj = root;
            this._parent = null;
            this._children = null;
        }

        ColorTreeNode() {
            this._level = 0;
            this._userObj = null;
            this._parent = null;
            this._children = new Vector();
        }

        short getLevel() {
            return this._level;
        }

        Object getObject() {
            return this._userObj;
        }

        public ColorTreeNode(AltaColor.ColorMap colorMap, ColorTreeNode parent) {
            this._level = 1;
            this._userObj = colorMap;
            this._parent = parent;
            this._children = null;
        }

        public ColorTreeNode(AltaColor.ColorMap.Item item, ColorTreeNode parent) {
            this._level = (short)2;
            this._userObj = item;
            this._parent = parent;
            this._children = new Vector(1);
        }

        private synchronized void constructChildren() {
            if (this._children != null) {
                return;
            }
            switch (this._level) {
                case 0: {
                    AltaColor colors = (AltaColor)this._userObj;
                    this._children = new Vector(colors.getNbrTypes());
                    Iterator<AltaColor.ColorMap> iColorMap = colors.iteratorColors();
                    while (iColorMap.hasNext()) {
                        this._children.add(new ColorTreeNode(iColorMap.next(), this));
                    }
                    break;
                }
                case 1: {
                    AltaColor.ColorMap map = (AltaColor.ColorMap)this._userObj;
                    List<AltaColor.ColorMap.Item> items = map.getItems();
                    int nbr = items.size();
                    this._children = new Vector(nbr);
                    for (int i = 0; i < nbr; ++i) {
                        this._children.add(new ColorTreeNode(items.get(i), this));
                    }
                    break;
                }
                case 2: {
                    break;
                }
            }
        }

        @Override
        public int getChildCount() {
            if (this._children == null) {
                this.constructChildren();
            }
            return this._children.size();
        }

        @Override
        public TreeNode getChildAt(int childIndex) {
            return this._children.get(childIndex);
        }

        @Override
        public ColorTreeNode getParent() {
            return this._parent;
        }

        @Override
        public int getIndex(TreeNode node) {
            if (this._children == null) {
                this.constructChildren();
            }
            if (node == null) {
                throw new NullPointerException();
            }
            for (int i = this._children.size() - 1; i >= 0; --i) {
                if (!node.equals(this._children.get(i))) continue;
                return i;
            }
            return -1;
        }

        @Override
        public boolean getAllowsChildren() {
            return !this.isLeaf();
        }

        @Override
        public boolean isLeaf() {
            return this._level != 0 && this._level != 1;
        }

        public Enumeration children() {
            return this._children.elements();
        }
    }

    public static class PreviewColorPanel
    extends JPanel {
        protected AltaLineColorPanel _colorPanel;

        public PreviewColorPanel(boolean title) {
            this.setLayout(new GridBagLayout());
            JPanel panel = new JPanel(new GridBagLayout());
            if (title) {
                panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResMsgVoc.getString("VOC_PREVIEW")));
            } else {
                panel.setBorder(BorderFactory.createEtchedBorder());
            }
            this.add((Component)panel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this._colorPanel = new AltaLineColorPanel(Color.black, false);
            this._colorPanel.setDrawOnAllWidth(false);
            panel.add((Component)this._colorPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(10, 10, 10, 10), 0, 0));
        }

        public void setColor(Color color) {
            if (color.equals(this._colorPanel._color)) {
                return;
            }
            this._colorPanel.setColor(color);
            this._colorPanel.repaint();
        }
    }

    protected static class AltaLineColorPanel
    extends JPanel {
        private Color _color;
        private BasicStroke _stroke;
        private boolean _drawOnAllWidth = true;
        private boolean _drawSelected = false;

        public AltaLineColorPanel(Color color, boolean selected) {
            this._color = color;
            float[] dashPattern = new float[]{5.0f, 5.0f, 5.0f, 5.0f};
            this._stroke = new BasicStroke(1.0f, 1, 1, 10.0f, dashPattern, 0.0f);
            this._drawSelected = selected;
        }

        public void setDrawOnAllWidth(boolean draw) {
            this._drawOnAllWidth = draw;
        }

        public void setDrawSelected(boolean select) {
            this._drawSelected = select;
        }

        public void setColor(Color color) {
            this._color = color;
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor(Color.white);
            g2.fillRect(0, 0, this.getSize().width, this.getSize().height);
            if (this._drawSelected) {
                Stroke oldStroke = g2.getStroke();
                g2.setColor(Color.blue);
                g2.setStroke(this._stroke);
                g2.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
                g2.setStroke(oldStroke);
            }
            g2.setColor(this._color);
            if (this._drawOnAllWidth) {
                g2.drawLine(2, this.getSize().height / 2, this.getSize().width - 3, this.getSize().height / 2);
            } else {
                g2.drawLine(this.getSize().width / 4, this.getSize().height / 2, this.getSize().width - this.getSize().width / 4, this.getSize().height / 2);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(100, 20);
        }
    }
}

