/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.system.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.type.AltaType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AltaInitEditDlg
extends JDialogCecilia {
    String _path;
    AltaType _type;
    String _value;
    JTextField _ctrlName;
    JTextField _ctrlType;
    JComboBox _ctrlValue;

    public AltaInitEditDlg(Window owner) {
        super(owner);
        this.make();
    }

    protected void make() {
        this.init();
        JPanel north = new JPanel(new GridBagLayout());
        JLabel lblName = new JLabel(ResMsgVoc.getString("VOC_NAME"));
        this._ctrlName = new JTextField();
        this._ctrlName.setEditable(false);
        this._ctrlName.setEnabled(false);
        JLabel lblType = new JLabel(ResMsgVoc.getString("VOC_TYPE"));
        this._ctrlType = new JTextField();
        this._ctrlType.setEditable(false);
        this._ctrlType.setEnabled(false);
        JLabel lblValue = new JLabel(ResMsgVoc.getString("VOC_VALUE"));
        this._ctrlValue = new JComboBox();
        this._ctrlValue.setEditable(false);
        north.add((Component)lblName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        north.add((Component)this._ctrlName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        north.add((Component)lblType, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        north.add((Component)this._ctrlType, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        north.add((Component)lblValue, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        north.add((Component)this._ctrlValue, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        north.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)north, "Center");
        this.getContentPane().add((Component)this.createButPanel(), "South");
        this.setTitle(ResMsgOcas.getString("VOC_INITIAL_CONFIG"));
        this.setModal(true);
        this.pack();
        this.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(this));
    }

    public void setInit(String path, AltaType type, String value) {
        this._path = path;
        this._type = type;
        this._value = value;
        this._ctrlName.setText(path);
        this._ctrlType.setText(type.toLabel());
        this._ctrlValue.removeAllItems();
        int len = type.getValueCount();
        this._ctrlValue.setEditable(len > 0);
        for (int i = 0; i < len; ++i) {
            this._ctrlValue.addItem(type.getValueAt(i));
        }
        this._ctrlValue.setSelectedItem(value);
        this._ctrlValue.requestFocus();
    }

    @Override
    protected boolean verifyParameters() {
        String value = null;
        Object selectedItem = this._ctrlValue.getSelectedItem();
        value = selectedItem != null ? selectedItem.toString() : this._ctrlValue.getEditor().getItem().toString();
        if (value.isEmpty()) {
            String title = ResMsgVoc.getString("VOC_VALUE");
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlValue), ResMsgCore.msgFormat("MSG_ERR_FIELD_EMPTY", title), this.getTitle(), 0);
            this._ctrlValue.requestFocus();
            return false;
        }
        if (!this._type.valueExist(value)) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlValue), ResMsgOcas.msgFormat("MSG_ERR_CONFIG_VALUE", this._path), this.getTitle(), 0);
            this._ctrlValue.requestFocus();
            return false;
        }
        this._value = value;
        return true;
    }

    public String getValue() {
        return this._value;
    }
}

