/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.system.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.table.ArrayTableModel;
import com.dassault.cecilia.dbobj.general.ObjectWithName;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaEquipment;
import com.dassault.cecilia.dbobj.mbsa.node.AltaState;
import com.dassault.cecilia.dbobj.mbsa.system.gui.AltaInit;
import com.dassault.cecilia.dbobj.mbsa.type.AltaType;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

class AltaInitTableModel
extends ArrayTableModel<AltaInit> {
    JComponent _owner;

    public AltaInitTableModel(ArrayList<AltaInit> array, JComponent owner) {
        super(array);
        this._owner = owner;
    }

    public void populateWith(Map<String, String> configs, AltaEquipment owner) {
        this.getData().clear();
        TreeMap<String, String> states = new TreeMap<String, String>(configs);
        for (Map.Entry entry : states.entrySet()) {
            String path = (String)entry.getKey();
            AltaType type = null;
            ObjectWithName obj = owner.findFieldFromPath((String)entry.getKey());
            if (obj != null && obj instanceof AltaState) {
                type = ((AltaState)obj).getType();
            }
            this.getData().add(new AltaInit(path, type, (String)entry.getValue()));
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return ResMsgVoc.getString("VOC_STATE");
            }
            case 1: {
                return ResMsgVoc.getString("VOC_TYPE");
            }
            case 2: {
                return ResMsgVoc.getString("VOC_VALUE");
            }
        }
        return "Error";
    }

    @Override
    public Class<?> getColumnClass(int column) {
        switch (column) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (column != 2) {
            return false;
        }
        AltaInit init = (AltaInit)this.getItemAt(row);
        return init.getType() != null;
    }

    @Override
    public Object getValueAt(int row, int column) {
        AltaInit init = (AltaInit)this.getItemAt(row);
        switch (column) {
            case 0: {
                return init.getPath();
            }
            case 1: {
                AltaType type = init.getType();
                if (type == null) {
                    return "";
                }
                return type.toLabel();
            }
            case 2: {
                return init.getValue();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        AltaInit init = (AltaInit)this.getItemAt(row);
        switch (column) {
            case 0: {
                if (!(aValue instanceof String)) break;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                if (!(aValue instanceof String) || init.getType() == null) break;
                String val = (String)aValue;
                if (init.getType().valueExist(val)) {
                    boolean oldError = init.withError();
                    init.setValue(val);
                    if (!oldError) break;
                    this.fireTableCellUpdated(row, 0);
                    break;
                }
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._owner), ResMsgOcas.msgFormat("MSG_ERR_CONFIG_VALUE", init.getPath()), ResMsgOcas.getString("VOC_INITIAL_CONFIG"), 0);
            }
        }
    }
}

