/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.project.gui;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PlugableUtility;
import com.dassault.cecilia.core.swing.CeciliaAction;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.other.ToggleBorderLayout;
import com.dassault.cecilia.core.swing.table.CeciliaTable;
import com.dassault.cecilia.core.swing.table.TableDecoredModel;
import com.dassault.cecilia.core.swing.table.TableDecoredPanel;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObject;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.general.DBObjectXmlUtility;
import com.dassault.cecilia.dbobj.general.attrib.Attr;
import com.dassault.cecilia.dbobj.general.attrib.AttrCriterion;
import com.dassault.cecilia.dbobj.general.attrib.AttrType;
import com.dassault.cecilia.dbobj.general.attrib.DBAttrib;
import com.dassault.cecilia.dbobj.general.attrib.gui.AttributeCriterionPanel;
import com.dassault.cecilia.dbobj.general.attrib.gui.AttributeDlgChooser;
import com.dassault.cecilia.dbobj.general.law.Param;
import com.dassault.cecilia.dbobj.general.law.ParamRef;
import com.dassault.cecilia.dbobj.general.law.TypeParam;
import com.dassault.cecilia.dbobj.general.law.gui.ParamRefPanel;
import com.dassault.cecilia.dbobj.project.AverageAttributeCriterion;
import com.dassault.cecilia.dbobj.project.AverageAttributeDriver;
import com.dassault.cecilia.dbobj.project.DBProject;
import com.dassault.cecilia.dbobj.project.gui.AADPanelHandlerXml;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.lib.util.xmlparser.SAXExtendedHandler;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Locator;
import org.xml.sax.helpers.DefaultHandler;

public class AttributeAverageDriverPanel
extends JPanel {
    private static Logger _LOG = Logger.getLogger(AttributeAverageDriverPanel.class.getPackage().getName());
    DBProject _dbProject;
    CECFactory _cecFactory;
    CeciliaAppl _application;
    boolean _isAdmin;
    ArrayList<AverageAttributeDriver> _attributeDrivers = new ArrayList();
    AverageAttributeDriver _currentAttributeDriver = null;
    List<DBAttrib> _undeclaredAttributeVersions = new ArrayList<DBAttrib>();
    AttributeDlgChooser _dlgSelectAttribute;
    JLabel _ctrlLblAttribute;
    JTextField _ctrlTxtAttribute;
    CeciliaAction _ctrlAttrEdit;
    CeciliaAction _ctrlAttrSave;
    CeciliaAction _ctrlAttrLoad;
    JLabel _ctrlLblVersions;
    JComboBox _ctrlComboVersions;
    JComboBox _ctrlComboUndeclaredVersions;
    CeciliaAction _ctrlVersionAdd;
    CeciliaAction _ctrlVersionDel;
    RiskMatrixPanel _ctrlPanelMatrix;
    RiskMatrixModel _ctrlModelMatrix;
    JCheckBox _ctrlCheckDrive;
    DlgSelectCriterion _dlgSelectCriterion;
    DlgSelectParameter _dlgSelectParam;
    JFileChooser _dlgFile;

    public AttributeAverageDriverPanel(CeciliaAppl application) {
        this._application = application;
        this._cecFactory = application.getDAOFactory();
        this.build();
    }

    public void init(DBProject dbProject, boolean isAdmin) {
        List<AverageAttributeDriver> drivers;
        this._dbProject = dbProject;
        this._isAdmin = isAdmin;
        if (this._dbProject != null && (drivers = this._dbProject.getAttributeDrivers()) != null && drivers.size() > 0) {
            this._attributeDrivers = new ArrayList<AverageAttributeDriver>(drivers);
            this._currentAttributeDriver = this._attributeDrivers.get(this._attributeDrivers.size() - 1);
            this.defineUndeclaredAttributeVersion();
        }
        if (this._attributeDrivers.size() > 0) {
            this._ctrlCheckDrive.setSelected(true);
        } else {
            this.refreshCheckDrive();
        }
    }

    public void save() {
        if (!this._isAdmin) {
            return;
        }
        if (this._dbProject == null) {
            return;
        }
        if (this._dbProject.getDBFolder() == null) {
            return;
        }
        DBObject dbObj = this._dbProject.getDBFolder().getObject();
        if (dbObj == null) {
            return;
        }
        if (this._ctrlCheckDrive.isSelected()) {
            this._dbProject.setAttributeDrivers(this._attributeDrivers);
        } else {
            this._dbProject.setAttributeDrivers(new ArrayList<AverageAttributeDriver>());
        }
    }

    void defineAttributeToDrive(DBAttrib attribute) {
        this._currentAttributeDriver = new AverageAttributeDriver(attribute);
        this._attributeDrivers.clear();
        this._attributeDrivers.add(this._currentAttributeDriver);
        this.defineUndeclaredAttributeVersion();
    }

    void defineUndeclaredAttributeVersion() {
        this._undeclaredAttributeVersions.clear();
        DBFolder defFolder = null;
        ArrayList<Long> IDs = new ArrayList<Long>(this._attributeDrivers.size() + 1);
        for (AverageAttributeDriver select : this._attributeDrivers) {
            DBFolder dbFolder = select.getAttribute().getDBFolder();
            IDs.add(dbFolder.getID());
            if (defFolder != null) continue;
            defFolder = dbFolder;
        }
        List<DBFolder> dbSubFolder = defFolder.getParent().getChildren();
        if (dbSubFolder == null) {
            dbSubFolder = this._application.getDAOFactory().createFolderDAO().findChildren(defFolder.getParent());
        }
        for (DBFolder dbFolder : dbSubFolder) {
            if (IDs.contains(dbFolder.getID())) continue;
            DBWrap dbWrap = this._cecFactory.findOrCreateWrap(dbFolder);
            if (dbWrap == null || !(dbWrap instanceof DBAttrib)) {
                _LOG.log(Level.WARNING, "Impossible de lire l'attribut: " + dbFolder.getRefPath());
                continue;
            }
            this._undeclaredAttributeVersions.add((DBAttrib)dbWrap);
        }
    }

    void setAttributeToDrive(DBAttrib attribute) {
        if (this._currentAttributeDriver == null) {
            this.defineAttributeToDrive(attribute);
        } else {
            DBAttrib currentAttribute = this._currentAttributeDriver.getAttribute();
            if (!currentAttribute.equals(attribute)) {
                long attributeParentID = attribute.getDBFolder().getParent().getID();
                if (currentAttribute.getDBFolder().getParent().getID() == attributeParentID) {
                    boolean find = false;
                    for (int i = 0; i < this._attributeDrivers.size() && !find; ++i) {
                        AverageAttributeDriver attrDriver = this._attributeDrivers.get(i);
                        if (attrDriver.getAttribute().getDBFolder().getParent().getID() != attributeParentID) {
                            find = true;
                            continue;
                        }
                        if (attrDriver.getAttribute().equals(attribute)) {
                            find = true;
                            continue;
                        }
                        if (attrDriver.getAttribute().getDBFolder().getName().compareTo(attribute.getDBFolder().getName()) <= 0) continue;
                        this._currentAttributeDriver = new AverageAttributeDriver(attribute);
                        this._attributeDrivers.add(i, this._currentAttributeDriver);
                        this._undeclaredAttributeVersions.remove(attribute);
                        this._dbProject.setModified(true);
                        find = true;
                    }
                    if (!find) {
                        this._currentAttributeDriver = new AverageAttributeDriver(attribute);
                        this._attributeDrivers.add(this._currentAttributeDriver);
                        this._undeclaredAttributeVersions.remove(attribute);
                        this._dbProject.setModified(true);
                    }
                } else {
                    this.defineAttributeToDrive(attribute);
                    this._dbProject.setModified(true);
                }
            }
        }
    }

    Component buildAttributePanel() {
        this._ctrlLblAttribute = new JLabel(ResMsgVoc.getString("VOC_ATTRIBUTE"));
        this._ctrlTxtAttribute = new JTextField(80);
        this._ctrlTxtAttribute.setEditable(false);
        this._ctrlAttrEdit = new CeciliaAction(ResIcoCore.getImageIcon("BUT_EDIT"), ResMsgVoc.getString("VOC_EDIT"), ResMsgObj.getString("DLG_ATTRIBUTEDRIVEAVG_ATTRIBUTESEL")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AttributeAverageDriverPanel.this._dlgSelectAttribute == null) {
                    AttributeAverageDriverPanel.this._dlgSelectAttribute = new AttributeDlgChooser(SwingUtilities.getWindowAncestor(AttributeAverageDriverPanel.this), ResMsgObj.getString("DLG_ATTRIBUTEDRIVEAVG_ATTRIBUTESEL"), AttributeAverageDriverPanel.this._application, false);
                }
                if (AttributeAverageDriverPanel.this._currentAttributeDriver != null) {
                    AttributeAverageDriverPanel.this._dlgSelectAttribute.setSelectFolder(AttributeAverageDriverPanel.this._currentAttributeDriver.getAttribute().getDBFolder());
                }
                AttributeAverageDriverPanel.this._dlgSelectAttribute.setVisible(true);
                if (AttributeAverageDriverPanel.this._dlgSelectAttribute.getResult()) {
                    DBFolder dbSelectFolder = AttributeAverageDriverPanel.this._dlgSelectAttribute.getSelectFolder();
                    DBAttrib selectedAttribute = (DBAttrib)AttributeAverageDriverPanel.this._cecFactory.findOrCreateWrap(dbSelectFolder);
                    AttributeAverageDriverPanel.this.setAttributeToDrive(selectedAttribute);
                    AttributeAverageDriverPanel.this.refreshAttributeToDrive(true);
                }
            }
        };
        this._ctrlAttrSave = new CeciliaAction(ResIcoCore.getImageIcon("BUT_SAVE"), ResMsgVoc.getString("VOC_SAVE"), ResMsgObj.getString("DLG_ATTRIBUTEDRIVEAVG_ATTRIBUTESAVE")){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                File exportFile = AttributeAverageDriverPanel.this.displayDlgFile(true, AttributeAverageDriverPanel.this._application.getPlugable());
                if (exportFile == null) {
                    return;
                }
                Writer writer = null;
                try {
                    writer = new BufferedWriter(new FileWriter(exportFile));
                    AttributeAverageDriverPanel.this.saveToXML(AttributeAverageDriverPanel.this._attributeDrivers, writer);
                }
                catch (IOException ioe) {
                    _LOG.log(Level.INFO, "IOException during save file : " + exportFile, ioe);
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(AttributeAverageDriverPanel.this), ResMsgCore.msgFormat("FILE_ERROR_DURING_WRITE", exportFile.getPath()), ResMsgObj.getString("DLG_ATTRIBUTEDRIVEAVG_SELECT"), 0);
                }
                finally {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException ioe) {
                            _LOG.log(Level.INFO, "IOException during close file : " + exportFile, ioe);
                        }
                    }
                }
            }
        };
        this._ctrlAttrLoad = new CeciliaAction(ResIcoCore.getImageIcon("BUT_LOAD"), ResMsgVoc.getString("VOC_LOAD"), ResMsgObj.getString("DLG_ATTRIBUTEDRIVEAVG_ATTRIBUTELOAD")){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                File importFile = AttributeAverageDriverPanel.this.displayDlgFile(false, AttributeAverageDriverPanel.this._application.getPlugable());
                if (importFile == null) {
                    return;
                }
                FileInputStream inputStream = null;
                try {
                    inputStream = new FileInputStream(importFile);
                    AADPanelHandlerXml saxHanlder = new AADPanelHandlerXml(AttributeAverageDriverPanel.this._cecFactory, null);
                    AttributeAverageDriverPanel.this.readXml(inputStream, saxHanlder);
                    AttributeAverageDriverPanel.this._attributeDrivers = new ArrayList<AverageAttributeDriver>(saxHanlder.getAAD());
                    if (AttributeAverageDriverPanel.this._attributeDrivers.size() > 0) {
                        AttributeAverageDriverPanel.this._currentAttributeDriver = AttributeAverageDriverPanel.this._attributeDrivers.get(AttributeAverageDriverPanel.this._attributeDrivers.size() - 1);
                        AttributeAverageDriverPanel.this.defineUndeclaredAttributeVersion();
                    } else {
                        AttributeAverageDriverPanel.this._currentAttributeDriver = null;
                    }
                    AttributeAverageDriverPanel.this.refreshAttributeToDrive(true);
                    AttributeAverageDriverPanel.this._dbProject.setModified(true);
                }
                catch (Exception exc) {
                    _LOG.log(Level.INFO, "Exception during load file : " + importFile, exc);
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(AttributeAverageDriverPanel.this), ResMsgCore.msgFormat("FILE_ERROR_DURING_READ", importFile.getPath()), ResMsgObj.getString("DLG_ATTRIBUTEDRIVEAVG_SELECT"), 0);
                }
                finally {
                    if (inputStream != null) {
                        try {
                            ((InputStream)inputStream).close();
                        }
                        catch (IOException ioe) {
                            _LOG.log(Level.INFO, "IOException during close file : " + importFile, ioe);
                        }
                    }
                }
            }
        };
        JToolBar toolbar = new JToolBar();
        toolbar.setBorder(CeciliaAction.LINE_BORDER);
        toolbar.setFloatable(false);
        toolbar.add(this._ctrlLblAttribute);
        toolbar.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        toolbar.add(this._ctrlTxtAttribute);
        toolbar.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        toolbar.add(this._ctrlAttrEdit.createButton(CeciliaAction.BorderStyle.LIGHT));
        toolbar.add(Box.createGlue());
        toolbar.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        toolbar.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        toolbar.add(this._ctrlAttrSave.createButton(CeciliaAction.BorderStyle.LIGHT));
        toolbar.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        toolbar.add(this._ctrlAttrLoad.createButton(CeciliaAction.BorderStyle.LIGHT));
        return toolbar;
    }

    void buildVersionsPanel(Container toolbar) {
        this._ctrlLblVersions = new JLabel(ResMsgVoc.getString("VOC_VERSION"));
        this._ctrlComboVersions = new JComboBox<Object>(new Object[]{"1"});
        this._ctrlComboVersions.setEditable(false);
        this._ctrlComboVersions.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component result = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value != null && value instanceof AverageAttributeDriver) {
                    AverageAttributeDriver attrDriver = (AverageAttributeDriver)value;
                    this.setText(attrDriver.getAttribute().getDBFolder().getName());
                }
                return result;
            }
        });
        this._ctrlComboVersions.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AttributeAverageDriverPanel.this._currentAttributeDriver = (AverageAttributeDriver)AttributeAverageDriverPanel.this._ctrlComboVersions.getSelectedItem();
                AttributeAverageDriverPanel.this.refreshVersionAttribute(AttributeAverageDriverPanel.this._ctrlCheckDrive.isSelected());
            }
        });
        this._ctrlComboUndeclaredVersions = new JComboBox();
        this._ctrlComboUndeclaredVersions = new JComboBox<Object>(new Object[]{"1"});
        this._ctrlComboUndeclaredVersions.setEditable(false);
        this._ctrlComboUndeclaredVersions.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component result = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value != null && value instanceof DBAttrib) {
                    DBAttrib attr = (DBAttrib)value;
                    this.setText(attr.getDBFolder().getName());
                }
                return result;
            }
        });
        this._ctrlVersionAdd = new CeciliaAction(ResIcoCore.getImageIcon("BUT_ADD"), ResMsgVoc.getString("VOC_ADD"), ResMsgObj.getString("DLG_ATTRIBUTEDRIVEAVG_VERSIONADD")){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttributeAverageDriverPanel.this._ctrlComboUndeclaredVersions.setModel(new DefaultComboBoxModel<Object>(AttributeAverageDriverPanel.this._undeclaredAttributeVersions.toArray()));
                Object[] options = new String[]{"OK", "Cancel"};
                int selection = JOptionPane.showOptionDialog(JOptionCecilia.getTopContainerOf(AttributeAverageDriverPanel.this), AttributeAverageDriverPanel.this._ctrlComboUndeclaredVersions, ResMsgObj.getString("DLG_ATTRIBUTEDRIVEAVG_VERSIONADD_TITLE"), -1, -1, null, options, options[0]);
                if (selection == 0) {
                    DBAttrib attr = (DBAttrib)AttributeAverageDriverPanel.this._ctrlComboUndeclaredVersions.getSelectedItem();
                    AttributeAverageDriverPanel.this.setAttributeToDrive(attr);
                    AttributeAverageDriverPanel.this.refreshAttributeToDrive(true);
                }
            }
        };
        this._ctrlVersionDel = new CeciliaAction(ResIcoCore.getImageIcon("BUT_DEL"), ResMsgVoc.getString("VOC_DELETE"), ResMsgObj.getString("DLG_ATTRIBUTEDRIVEAVG_VERSIONDEL")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AttributeAverageDriverPanel.this._attributeDrivers.size() < 2) {
                    return;
                }
                AverageAttributeDriver attrDriver = (AverageAttributeDriver)AttributeAverageDriverPanel.this._ctrlComboVersions.getSelectedItem();
                if (attrDriver == null || attrDriver != AttributeAverageDriverPanel.this._currentAttributeDriver) {
                    return;
                }
                AttributeAverageDriverPanel.this._ctrlComboVersions.removeItem(attrDriver);
                AttributeAverageDriverPanel.this._attributeDrivers.remove(attrDriver);
                AttributeAverageDriverPanel.this._currentAttributeDriver = AttributeAverageDriverPanel.this._attributeDrivers.get(AttributeAverageDriverPanel.this._attributeDrivers.size() - 1);
                AttributeAverageDriverPanel.this._undeclaredAttributeVersions.add(attrDriver.getAttribute());
                AttributeAverageDriverPanel.this._dbProject.setModified(true);
                AttributeAverageDriverPanel.this.refreshAttributeToDrive(true);
            }
        };
        toolbar.add(this._ctrlLblVersions);
        toolbar.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        toolbar.add(this._ctrlComboVersions);
        toolbar.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        toolbar.add(this._ctrlVersionAdd.createButton(CeciliaAction.BorderStyle.LIGHT));
        toolbar.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        toolbar.add(this._ctrlVersionDel.createButton(CeciliaAction.BorderStyle.LIGHT));
    }

    JPanel buildRiskMatrixPanel() {
        this._ctrlModelMatrix = new RiskMatrixModel(new AverageAttributeCriterion());
        this._ctrlPanelMatrix = new RiskMatrixPanel(this._ctrlModelMatrix);
        return this._ctrlPanelMatrix;
    }

    private void build() {
        this.setLayout(new BorderLayout());
        this._ctrlCheckDrive = new JCheckBox(ResMsgObj.getString("DLG_ATTRIBUTEDRIVEAVG_SELECT"));
        this._ctrlCheckDrive.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AttributeAverageDriverPanel.this.refreshCheckDrive();
            }
        });
        this._ctrlCheckDrive.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttributeAverageDriverPanel.this._dbProject.setModified(true);
            }
        });
        JPanel sonPanel = new JPanel(new GridBagLayout());
        sonPanel.add(this.buildAttributePanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(2, 12, 2, 12), 0, 0));
        sonPanel.add((Component)this.buildRiskMatrixPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 10, 10, 10), 0, 0));
        this.add((Component)ToggleBorderLayout.simulate(this._ctrlCheckDrive, sonPanel), "Center");
    }

    void refreshCheckDrive() {
        boolean checkDrive = this._ctrlCheckDrive.isSelected();
        this._ctrlTxtAttribute.setEnabled(checkDrive && this._isAdmin);
        this._ctrlAttrEdit.setEnabled(checkDrive && this._isAdmin);
        this._ctrlAttrLoad.setEnabled(checkDrive && this._isAdmin);
        this.refreshAttributeToDrive(checkDrive);
    }

    void refreshAttributeToDrive(boolean checkDrive) {
        DBAttrib selectedAttribute = null;
        if (this._currentAttributeDriver != null) {
            selectedAttribute = this._currentAttributeDriver.getAttribute();
        }
        AverageAttributeDriver oldSelection = this._currentAttributeDriver;
        this._ctrlComboVersions.removeAllItems();
        if (selectedAttribute != null) {
            this._ctrlTxtAttribute.setText(selectedAttribute.getDBFolder().getParent().getPathUntilSystem(new StringBuilder()).deleteCharAt(0).toString());
            for (int i = 0; i < this._attributeDrivers.size(); ++i) {
                AverageAttributeDriver attrDriver = this._attributeDrivers.get(i);
                this._ctrlComboVersions.addItem(attrDriver);
            }
            this._ctrlComboVersions.setSelectedItem(oldSelection);
        } else {
            this._ctrlTxtAttribute.setText("");
        }
        this._ctrlComboVersions.setEnabled(checkDrive && selectedAttribute != null && this._isAdmin);
        this._ctrlVersionAdd.setEnabled(checkDrive && selectedAttribute != null && this._isAdmin && this._undeclaredAttributeVersions.size() > 0);
        this._ctrlVersionDel.setEnabled(checkDrive && selectedAttribute != null && this._isAdmin && this._attributeDrivers.size() > 1);
        this._ctrlAttrSave.setEnabled(checkDrive && selectedAttribute != null && this._isAdmin && this._attributeDrivers.size() > 0);
        this.refreshVersionAttribute(checkDrive);
    }

    void refreshVersionAttribute(boolean checkDrive) {
        if (this._currentAttributeDriver != null) {
            this._ctrlModelMatrix.setDatum(this._currentAttributeDriver.getCriterions(false));
        } else {
            this._ctrlModelMatrix.setDatum(new ArrayList());
        }
        int nbrItem = this._ctrlComboVersions.getItemCount();
        this._ctrlPanelMatrix.setEnabled(checkDrive && nbrItem > 0 && this._isAdmin);
    }

    private void editCriterion(int row) {
        AttrCriterion criterion = ((AverageAttributeCriterion)this._ctrlModelMatrix.getData(row)).getCriterion();
        criterion = criterion.getCopy();
        if (this._dlgSelectCriterion == null) {
            this._dlgSelectCriterion = new DlgSelectCriterion(SwingUtilities.getWindowAncestor(this._ctrlPanelMatrix));
        }
        DBAttrib attr = this._currentAttributeDriver.getAttribute();
        TreeSet<String> values = new TreeSet<String>();
        if (attr.getType() == AttrType.ENUM) {
            values.addAll(attr.getEnums());
        }
        this._dlgSelectCriterion._ctrlPanel.setAttributes(Collections.singletonMap(attr, values));
        this._dlgSelectCriterion._ctrlPanel.setCurrentAttributeCriterion(criterion);
        this._dlgSelectCriterion.setVisible(true);
        if (this._dlgSelectCriterion.getResult()) {
            criterion = this._dlgSelectCriterion._ctrlPanel.getCurrentAttributeCriterion();
            ((AverageAttributeCriterion)this._ctrlModelMatrix.getData(row)).setValueAt(criterion, 0);
            this._dbProject.setModified(true);
        }
    }

    private void editParameter(int row) {
        if (((AverageAttributeCriterion)this._ctrlModelMatrix.getData(row)).getChoice() == AverageAttributeCriterion.ProbabilityChoice.DEF) {
            return;
        }
        if (this._dlgSelectParam == null) {
            this._dlgSelectParam = new DlgSelectParameter(SwingUtilities.getWindowAncestor(this._ctrlPanelMatrix), this._application);
        }
        if (this._dlgSelectParam._ctrlPanel.getCtrlTree().getModel().getRoot().getChildCount() == 0) {
            return;
        }
        Param param = ((AverageAttributeCriterion)this._ctrlModelMatrix.getData(row)).getDefaultParameter();
        DBFolder dbFolder = null;
        if (param != null && param instanceof ParamRef) {
            dbFolder = ((ParamRef)param).getValue();
        }
        this._dlgSelectParam._ctrlPanel.setSelectFolder(dbFolder);
        this._dlgSelectParam.setVisible(true);
        if (this._dlgSelectParam.getResult()) {
            param = null;
            dbFolder = this._dlgSelectParam._ctrlPanel.getSelectFolder(true);
            if (dbFolder != null) {
                param = new ParamRef(TypeParam.DELAY, dbFolder);
            }
            ((AverageAttributeCriterion)this._ctrlModelMatrix.getData(row)).setValueAt(param, 2);
            this._dbProject.setModified(true);
        }
    }

    protected void createDlgFile() {
        if (this._dlgFile == null) {
            this._dlgFile = new JFileChooser();
            this._dlgFile.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    String fname = f.getName().toLowerCase();
                    return fname.endsWith(".xml") || f.isDirectory();
                }

                @Override
                public String getDescription() {
                    return ResMsgCore.getString("FILE_TYPE_XML");
                }
            });
            this._dlgFile.setFileSelectionMode(0);
        }
    }

    protected File displayDlgFile(boolean save, Plugable plugable) {
        int result;
        this.createDlgFile();
        this._dlgFile.setCurrentDirectory(new File(PlugableUtility.getStrOpt(plugable, "plugable.option.path", ".")));
        int n = result = save ? this._dlgFile.showSaveDialog(this) : this._dlgFile.showOpenDialog(this);
        if (result == 1) {
            return null;
        }
        File file = this._dlgFile.getSelectedFile();
        plugable.setOption("plugable.option.path", file.getParent());
        if (save) {
            String name = file.getName();
            int pos = name.lastIndexOf(46);
            if (pos == -1) {
                file = new File(file.getAbsolutePath() + ".xml");
            }
            if (file.exists() && 0 != JOptionPane.showConfirmDialog(JOptionCecilia.getTopContainerOf(this), ResMsgCore.msgFormat("FILE_MSG_EXIST_FRM", file))) {
                return null;
            }
        }
        return file;
    }

    private void saveToXML(ArrayList<AverageAttributeDriver> drivers, Writer out) throws IOException {
        DBObjectXmlUtility.appendXMLHeader(out);
        out.append("<").append("cec.params.averages").append(">\n");
        String indent1 = "  ";
        for (AverageAttributeDriver averageAttributeDriver : drivers) {
            averageAttributeDriver.toXML(out, indent1, false);
        }
        out.append("</").append("cec.params.averages").append(">\n");
    }

    protected void readXml(InputStream input, SAXExtendedHandler handler) throws IOException {
        try {
            SAXParserFactory fabrique = SAXParserFactory.newInstance();
            SAXParser parseur = fabrique.newSAXParser();
            parseur.parse(input, (DefaultHandler)handler);
        }
        catch (IOException e) {
            _LOG.log(Level.INFO, "le parseur XML a eu un probleme", e);
            throw e;
        }
        catch (Exception e) {
            StringBuffer sb = new StringBuffer();
            sb.append(ResMsgCore.getString("MSG_ERR_DBMOD_XML_GENERIC")).append("\n");
            Locator loc = handler.getLocator();
            if (loc != null) {
                sb.append("in [line = ");
                sb.append(loc.getLineNumber());
                sb.append("] [col = ");
                sb.append(loc.getColumnNumber());
                sb.append("]\n");
            }
            sb.append(e.getMessage());
            _LOG.log(Level.INFO, sb.toString(), e);
            throw new IOException(sb.toString());
        }
    }

    static class DlgSelectParameter
    extends JDialogCecilia {
        ParamRefPanel _ctrlPanel;

        DlgSelectParameter(Window win, CeciliaAppl appl) {
            super(win, ResMsgObj.getString("DLG_ATTRIBUTEDRIVEAVG_PARAM"), true);
            this._ctrlPanel = new ParamRefPanel(appl);
            this._ctrlPanel.setTypeFilter(TypeParam.DELAY);
            this._ctrlPanel.getCtrlTree().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() != 2) {
                        return;
                    }
                    if (!SwingUtilities.isLeftMouseButton(e)) {
                        return;
                    }
                    DBFolder dbFolder = _ctrlPanel.getSelectFolder(false);
                    if (dbFolder == null) {
                        return;
                    }
                    this.validDialog();
                }
            });
            this.setLayout(new BorderLayout());
            this.add((Component)this._ctrlPanel, "Center");
            this.add((Component)this.createButPanel(true), "South");
            this.init();
            this.pack();
            this.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(this));
        }

        @Override
        protected boolean verifyParameters() {
            return true;
        }
    }

    static class DlgSelectCriterion
    extends JDialogCecilia {
        AttributeCriterionPanel _ctrlPanel = new AttributeCriterionPanel(null);

        DlgSelectCriterion(Window win) {
            super(win, ResMsgObj.getString("DLG_ATTRIBUTEDRIVEAVG_ATTRIBUTESEL"), true);
            this.setLayout(new BorderLayout());
            this.add((Component)this._ctrlPanel, "Center");
            this.add((Component)this.createButPanel(true), "South");
            this.init();
            this.pack();
            this.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(this));
        }

        @Override
        protected boolean verifyParameters() {
            return this._ctrlPanel.verifyParameters();
        }
    }

    class RiskMatrixModel
    extends TableDecoredModel<AverageAttributeCriterion> {
        public RiskMatrixModel(AverageAttributeCriterion defTgt) {
            super(defTgt);
        }

        @Override
        protected AverageAttributeCriterion createTarget(AverageAttributeCriterion obj) {
            if (obj != null) {
                return obj;
            }
            DBAttrib attr = AttributeAverageDriverPanel.this._currentAttributeDriver.getAttribute();
            Attr.DefaultKey keyAttr = new Attr.DefaultKey(attr.getType(), attr.getName());
            String data = null;
            switch (attr.getType()) {
                case NUMBER: {
                    data = "0";
                    break;
                }
                case STRING: {
                    data = "";
                    break;
                }
                case ENUM: {
                    ArrayList<String> undeclaredValues = new ArrayList<String>(attr.getEnums());
                    data = (String)undeclaredValues.get(0);
                    for (int i = 0; i < this.getRowCount() && undeclaredValues.size() > 0; ++i) {
                        AverageAttributeCriterion attrCriterion = (AverageAttributeCriterion)this.getData(i);
                        AttrCriterion criterion = attrCriterion.getCriterion();
                        if (!criterion.getKey().equals(keyAttr) || criterion.getOperator() != AttrCriterion.Operator.EQ) continue;
                        undeclaredValues.remove(criterion.getData());
                    }
                    if (undeclaredValues.size() <= 0) break;
                    data = (String)undeclaredValues.get(0);
                }
            }
            AttrCriterion criterion = new AttrCriterion(keyAttr, AttrCriterion.Operator.EQ, data);
            return new AverageAttributeCriterion(criterion, AverageAttributeCriterion.ProbabilityChoice.AVG, null);
        }

        @Override
        public void addData(AverageAttributeCriterion obj) {
            super.addData(obj);
            AttributeAverageDriverPanel.this._dbProject.setModified(true);
        }

        @Override
        public void removeData(int idx) {
            super.removeData(idx);
            AttributeAverageDriverPanel.this._dbProject.setModified(true);
        }

        @Override
        public void changeData(AverageAttributeCriterion obj) {
            super.changeData(obj);
            AttributeAverageDriverPanel.this._dbProject.setModified(true);
        }

        @Override
        public void up(int idx) {
            super.up(idx);
            AttributeAverageDriverPanel.this._dbProject.setModified(true);
        }

        @Override
        public void down(int idx) {
            super.down(idx);
            AttributeAverageDriverPanel.this._dbProject.setModified(true);
        }
    }

    class RiskMatrixPanel
    extends TableDecoredPanel<AverageAttributeCriterion> {
        public RiskMatrixPanel(TableDecoredModel<AverageAttributeCriterion> model) {
            super(model);
            this._ctrlTable.setDefaultRenderer(AttrCriterion.class, new DefaultTableCellRenderer(){

                @Override
                protected void setValue(Object value) {
                    if (value == null || !(value instanceof AttrCriterion)) {
                        this.setText("");
                    } else {
                        AttrCriterion criterion = (AttrCriterion)value;
                        StringBuffer sb = new StringBuffer();
                        sb.append("[ ");
                        sb.append(criterion.getOperator().getLabel());
                        sb.append(" ").append(criterion.getData());
                        sb.append(" ]");
                        this.setText(sb.toString());
                    }
                }
            });
            this._ctrlTable.setDefaultRenderer(AverageAttributeCriterion.ProbabilityChoice.class, new DefaultTableCellRenderer(){

                @Override
                protected void setValue(Object value) {
                    if (value == null || !(value instanceof AverageAttributeCriterion.ProbabilityChoice)) {
                        this.setText("");
                    } else {
                        this.setText(((AverageAttributeCriterion.ProbabilityChoice)((Object)value)).getLabel());
                    }
                }
            });
        }

        @Override
        protected CeciliaTable createTable(TableModel model) {
            return new CeciliaTable(model){

                @Override
                protected void doubleClickLeft(MouseEvent e) {
                    if (!RiskMatrixPanel.this.isEnabled()) {
                        return;
                    }
                    Point p = e.getPoint();
                    int row = RiskMatrixPanel.this._ctrlTable.rowAtPoint(p);
                    int column = RiskMatrixPanel.this._ctrlTable.convertColumnIndexToModel(RiskMatrixPanel.this._ctrlTable.columnAtPoint(p));
                    if (row >= 0) {
                        if (column == 0) {
                            AttributeAverageDriverPanel.this.editCriterion(row);
                        } else if (column == 2) {
                            AttributeAverageDriverPanel.this.editParameter(row);
                        }
                    }
                }
            };
        }

        @Override
        protected void createBoxActions(Container toolbar) {
            AttributeAverageDriverPanel.this.buildVersionsPanel(toolbar);
            super.createBoxActions(toolbar);
        }
    }
}

