/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.project.gui;

import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTreeModel;
import com.dassault.cecilia.core.cecilia.folder.DBFolderVirtualTreeModel;
import com.dassault.cecilia.core.cecilia.folder.DBFolderVirtualTreeRenderer;
import com.dassault.cecilia.core.cecilia.folder.gui.DBFolderPanelSelect;
import com.dassault.cecilia.core.cecilia.folder.gui.DBFolderPanelSelectFilterFlags;
import com.dassault.cecilia.core.plugin.PlugableAppl;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.dao.DAOFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.SwingUtilities;

public abstract class DBObjectProjectDlgChooser
extends JDialogCecilia {
    CAppl _application;
    private boolean _multiSelection;
    Collection<DBFolder> _excludeFolders;
    protected DBFolderPanelSelectFilterFlags _ctrlSelect;

    public DBObjectProjectDlgChooser(Window owner, CAppl appl, String title) {
        super(owner, title);
        this._application = appl;
        this.make(owner);
    }

    protected abstract short getDefaultFamilyFlag();

    public void defineExcludeFolders(Collection<DBFolder> excludes) {
        this._excludeFolders = excludes;
    }

    protected boolean excludeThisFolder(DBFolder dbFolder) {
        if (this._excludeFolders == null) {
            return false;
        }
        if (this._excludeFolders.isEmpty()) {
            return false;
        }
        return this._excludeFolders.contains(dbFolder);
    }

    private void make(Window owner) {
        this._ctrlSelect = new DBFolderPanelSelectFilterFlags(this._application, DBFolder.Family.PROJECT){

            @Override
            protected DBFolderTreeModel createTreeModel(PlugableAppl appl, DBFolder.Family dbFamily) {
                DAOFactory daoFactory = appl.getDAOFactory();
                return new DBFolderVirtualTreeModel(daoFactory.createFolderDAO(), daoFactory.createUserDAO(), appl.getDBUser(), DBFolder.Family.PROJECT, "Select-Virtual-Filter-Project"){

                    @Override
                    public boolean acceptFolder(DBFolder dbFolder) {
                        return this.selectFolder(dbFolder);
                    }
                };
            }

            @Override
            protected void make() {
                super.make();
                this.getCtrlTree().setCellRenderer(new DBFolderVirtualTreeRenderer());
            }

            @Override
            protected boolean selectThisFolder(DBFolder dbFolder) {
                if (DBObjectProjectDlgChooser.this.excludeThisFolder(dbFolder)) {
                    return false;
                }
                return super.selectThisFolder(dbFolder);
            }
        };
        this._ctrlSelect.addFlag(this.getDefaultFamilyFlag());
        this._ctrlSelect.getCtrlTree().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                DBFolder dbFolder = DBObjectProjectDlgChooser.this._ctrlSelect.getSelectFolder(false);
                if (dbFolder == null) {
                    return;
                }
                if (!dbFolder.isVersion()) {
                    return;
                }
                DBObjectProjectDlgChooser.this.validDialog();
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this._ctrlSelect, "Center");
        this.getContentPane().add((Component)this.createButPanel(), "South");
        this.init();
        this.pack();
        this.setSize(350, 350);
        this.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(owner));
        this.setModal(true);
    }

    @Override
    protected boolean verifyParameters() {
        return this._multiSelection ? this.getSelectFolders() != null && !this.getSelectFolders().isEmpty() : this.getSelectFolder() != null;
    }

    public void setSelectFolder(DBFolder dbFolder) {
        this._ctrlSelect.setSelectFolder(dbFolder);
    }

    public DBFolder getSelectFolder() {
        DBFolder select = this._ctrlSelect.getSelectFolder(true);
        if (select == null) {
            return null;
        }
        if (this.excludeThisFolder(select)) {
            return null;
        }
        return select;
    }

    public List<DBFolder> getSelectFolders() {
        ArrayList<DBFolder> folders = new ArrayList<DBFolder>();
        DBFolder[] selectedFolders = this._ctrlSelect.getSelectFolders();
        if (selectedFolders == null || selectedFolders.length == 0) {
            return folders;
        }
        for (DBFolder folder : selectedFolders) {
            if (this.excludeThisFolder(folder)) continue;
            folders.add(folder);
        }
        return folders;
    }

    public DBFolderPanelSelect getCtrlSelect() {
        return this._ctrlSelect;
    }

    @Override
    public void dispose() {
        this._ctrlSelect.dispose();
        super.dispose();
    }

    public void setMultiSelectionTree(boolean multiSelection) {
        if (this._multiSelection != multiSelection) {
            this._ctrlSelect.getCtrlTree().getSelectionModel().setSelectionMode(multiSelection ? 4 : 1);
            this._multiSelection = multiSelection;
        }
    }
}

