/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.wrap.io;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.db.DBFactory;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.general.log.io.SAXLogHandler;
import java.util.Map;
import java.util.logging.Logger;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class SAXWrapHandler
extends SAXLogHandler {
    private static Logger _LOG = Logger.getLogger(SAXWrapHandler.class.getPackage().getName());

    public SAXWrapHandler(DBLogs.DBLogsManager manager, Locator locator) {
        super(manager);
        if (locator != null) {
            this.setLocator(locator);
        }
    }

    public long readID(String eltName, String attrName, Map<String, String> attrs) throws SAXException {
        long paramID = -2L;
        String refID = attrs.get(attrName);
        if (refID == null || refID.isEmpty()) {
            this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_NO", eltName, attrName), this.getLocator()));
        }
        try {
            paramID = Long.parseLong(refID);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (paramID == -1L) {
            _LOG.fine(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_ID", eltName, attrName, paramID));
        } else if (paramID < 0L) {
            this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_ID", eltName, attrName, paramID), this.getLocator()));
        }
        return paramID;
    }

    public String readName(String eltName, String attrName, Map<String, String> attrs) throws SAXException {
        String name = attrs.get(attrName);
        if (name == null || name.isEmpty()) {
            this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_NO", eltName, attrName), this.getLocator()));
        }
        return name;
    }

    public DBFolder readDBFolder(String eltName, Map<String, String> attrs, DAOFolder daoFolder, String rootName, boolean optional) throws SAXException {
        DBFolder dbFolder;
        long refID = this.readID(eltName, "refID", attrs);
        String refPath = attrs.get("refPath");
        if (refPath == null || refPath.isEmpty()) {
            this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_NO", eltName, "refPath"), this.getLocator()));
        }
        if ((dbFolder = daoFolder.findFolder(refID, refPath, rootName)) == null) {
            if (optional) {
                this.warning(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_FOLDER", refPath), this.getLocator()));
            } else {
                this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_FOLDER", refPath), this.getLocator()));
            }
        }
        return dbFolder;
    }

    public String readAttrNullable(String eltName, String attrName, Map<String, String> attrs, String defaultVal) throws SAXException {
        String attrValue = attrs.get(attrName);
        if (attrValue == null) {
            return defaultVal;
        }
        return attrValue;
    }

    public String readAttr(String eltName, String attrName, Map<String, String> attrs) throws SAXException {
        String attrValue = attrs.get(attrName);
        if (attrValue == null || attrValue.isEmpty()) {
            this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_NO", eltName, attrName), this.getLocator()));
        }
        return attrValue;
    }

    public boolean readBoolean(String eltName, String attrName, Map<String, String> attrs, boolean opt, boolean defValue) throws SAXException {
        String attrValue = attrs.get(attrName);
        if (attrValue == null || attrValue.isEmpty()) {
            if (opt) {
                return defValue;
            }
            this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_NO", eltName, attrName), this.getLocator()));
        }
        if (attrValue.equals("true")) {
            return true;
        }
        if (attrValue.equals("false")) {
            return false;
        }
        this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", eltName, attrName, attrValue), this.getLocator()));
        return false;
    }

    public double readDouble(String eltName, String attrName, Map<String, String> attrs, boolean opt, double defValue) throws SAXException {
        String attrValue = attrs.get(attrName);
        if (attrValue == null || attrValue.isEmpty()) {
            if (opt) {
                return defValue;
            }
            this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_NO", eltName, attrName), this.getLocator()));
        }
        if (attrValue.equals("NaN")) {
            return Double.NaN;
        }
        if (attrValue.equals("Infinity")) {
            return Double.POSITIVE_INFINITY;
        }
        if (attrValue.equals("-Infinity")) {
            return Double.NEGATIVE_INFINITY;
        }
        if (DBFactory.verifyDouble(attrValue)) {
            return Double.parseDouble(attrValue);
        }
        this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", eltName, attrName, attrValue), this.getLocator()));
        return Double.NaN;
    }

    public int readPositiveInteger(String eltName, String attrName, Map<String, String> attrs, boolean opt, int defValue) throws SAXException {
        String attrValue = attrs.get(attrName);
        if (attrValue == null || attrValue.isEmpty()) {
            if (opt) {
                return defValue;
            }
            this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_NO", eltName, attrName), this.getLocator()));
        }
        int number = -1;
        try {
            number = Integer.parseInt(attrValue);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (number < 0) {
            this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", eltName, attrName, attrValue), this.getLocator()));
        }
        return number;
    }
}

