/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.plugin.PlugPanel;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PlugableUtility;
import com.dassault.cecilia.core.plugin.PluginWithOptions;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.faulttree.DAGImportChoice;
import com.dassault.cecilia.dbobj.general.conflict.DBConflict;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class GeneralIOPreferencies
implements PluginWithOptions,
PlugPanel {
    private static Logger _LOG = Logger.getLogger(GeneralIOPreferencies.class.getPackage().getName());
    public static String PREF_KEY = GeneralIOPreferencies.class.getName();
    public static final String PREF_EXPORT_ACCESS = PREF_KEY + "#ExportAccess";
    public static final String PREF_EXPORT_DBLOGS = PREF_KEY + "#ExportLogs";
    public static final String PREF_EXPORT_LIMITZIP = PREF_KEY + "#ExportZipLimit";
    public static final String PREF_IMPORT_DAG_CONFLICT = PREF_KEY + "#ImportDagConflict";
    public static final String PREF_IMPORT_DAG_CHOICE = PREF_KEY + "#ImportDagChoice";
    JPanel _perfsPanel;
    boolean _bExportLogs = false;
    boolean _bExportAccess = false;
    long _lExportLimitZip = -1L;
    JCheckBox _ctrlExportLogs;
    JCheckBox _ctrlExportAccess;
    JTextField _ctrlExportLimitZip;
    DBConflict _valueIDagConflict = DBConflict.NOTIMPORT;
    DAGImportChoice _valueIDagChoice = DAGImportChoice.FT_OR_BF;
    JComboBox _ctrlIDagConflict;
    JComboBox _ctrlIDagChoice;

    @Override
    public void trash() {
    }

    @Override
    public boolean withOption(Plugable plugable) {
        return true;
    }

    @Override
    public PlugPanel displayOption(Plugable launcher) {
        this.load(launcher);
        return this;
    }

    @Override
    public void refreshOptions(Plugable launcher) {
        this.load(launcher);
    }

    @Override
    public boolean validOptions(Plugable launcher) {
        this.save(launcher);
        return true;
    }

    @Override
    public JPanel getPanel() {
        return this.makeContent();
    }

    @Override
    public String getInfo(String key) {
        if ("plugin.key".equals(key)) {
            return PREF_KEY;
        }
        if ("plugin.key.path".equals(key)) {
            return "GENERAL";
        }
        if ("plugin.name".equals(key)) {
            return ResMsgObj.getString("PREF_GENERAL_IO");
        }
        if ("plugin.title".equals(key)) {
            return ResMsgObj.getString("PREF_GENERAL_IO_TITLE");
        }
        if ("plugin.description".equals(key)) {
            return ResMsgObj.getString("PREF_GENERAL_IO_DESC");
        }
        return null;
    }

    @Override
    public Icon getIcon(String key) {
        return ResIcoCore.getImageIcon("IE_BOTH");
    }

    protected JPanel makeContent() {
        if (this._perfsPanel == null) {
            this._perfsPanel = new JPanel(new GridBagLayout());
            int posY = 0;
            this._perfsPanel.add(this.createExportPanel(), new GridBagConstraints(0, posY++, 1, 1, 0.0, 0.0, 18, 0, new Insets(20, 20, 10, 10), 0, 0));
            this._perfsPanel.add(this.createImportPanel(), new GridBagConstraints(0, posY++, 1, 1, 0.0, 0.0, 18, 0, new Insets(20, 20, 10, 10), 0, 0));
            this._perfsPanel.add((Component)new JLabel(), new GridBagConstraints(0, posY++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        return this._perfsPanel;
    }

    protected void load(Plugable launcher) {
        this.loadExportOptions(launcher);
        this.loadImportOptions(launcher);
    }

    protected void save(Plugable launcher) {
        this.saveExportOptions(launcher);
        this.saveImportOptions(launcher);
    }

    private Component createExportPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        this._ctrlExportLogs = new JCheckBox(ResMsgObj.getString("PREF_GENERAL_IO_DBLOGS"));
        this._ctrlExportLogs.setSelected(this._bExportLogs);
        this._ctrlExportLogs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneralIOPreferencies.this._bExportLogs = GeneralIOPreferencies.this._ctrlExportLogs.isSelected();
            }
        });
        this._ctrlExportAccess = new JCheckBox(ResMsgObj.getString("PREF_GENERAL_IO_ACCESS"));
        this._ctrlExportAccess.setSelected(this._bExportAccess);
        this._ctrlExportAccess.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneralIOPreferencies.this._bExportAccess = GeneralIOPreferencies.this._ctrlExportAccess.isSelected();
            }
        });
        this._ctrlExportLimitZip = new JTextField(10);
        this._ctrlExportLimitZip.setText(Long.toString(this._lExportLimitZip));
        this._ctrlExportLimitZip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneralIOPreferencies.this.validExportLimitZip();
            }
        });
        this._ctrlExportLimitZip.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                char c = evt.getKeyChar();
                if (c != '-' && (c < '0' || c > '9')) {
                    evt.consume();
                }
            }
        });
        this._ctrlExportLimitZip.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (e.isTemporary()) {
                    return;
                }
                GeneralIOPreferencies.this.validExportLimitZip();
            }
        });
        int idxY = 0;
        panel.add((Component)this._ctrlExportLogs, new GridBagConstraints(0, idxY++, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this._ctrlExportAccess, new GridBagConstraints(0, idxY++, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)new JLabel(ResMsgObj.getString("PREF_GENERAL_IO_LIMITZIP")), new GridBagConstraints(0, idxY, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this._ctrlExportLimitZip, new GridBagConstraints(1, idxY++, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)new JLabel(ResMsgObj.getString("PREF_GENERAL_IO_LIMITZIP_EXPLAIN")), new GridBagConstraints(0, idxY++, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.setBorder(BorderFactory.createTitledBorder(ResMsgVoc.getString("VOC_EXPORT")));
        return panel;
    }

    private void validExportLimitZip() {
        try {
            long size = Long.parseLong(this._ctrlExportLimitZip.getText());
            if (size < 0L) {
                size = -1L;
            }
            this._lExportLimitZip = size;
        }
        catch (NumberFormatException nfe) {
            _LOG.log(Level.INFO, "Erreur lors du controle de la valeur de la limite d'export des Zip", nfe);
        }
        this._ctrlExportLimitZip.setText(Long.toString(this._lExportLimitZip));
    }

    protected void loadExportOptions(Plugable launcher) {
        this._bExportLogs = PlugableUtility.getBoolOpt(launcher, PREF_EXPORT_DBLOGS, false);
        if (this._ctrlExportLogs != null) {
            this._ctrlExportLogs.setSelected(this._bExportLogs);
        }
        this._bExportAccess = PlugableUtility.getBoolOpt(launcher, PREF_EXPORT_ACCESS, false);
        if (this._ctrlExportAccess != null) {
            this._ctrlExportAccess.setSelected(this._bExportAccess);
        }
        this._lExportLimitZip = PlugableUtility.getLongOpt(launcher, PREF_EXPORT_LIMITZIP, -1L);
        if (this._ctrlExportLimitZip != null) {
            this._ctrlExportLimitZip.setText(Long.toString(this._lExportLimitZip));
        }
        if (_LOG.isLoggable(Level.FINEST)) {
            _LOG.finest("Load ExportOptions[Logs=" + this._bExportLogs + ", Access=" + this._bExportAccess + ", ZipLimit=" + this._lExportLimitZip + "]");
        }
    }

    protected void saveExportOptions(Plugable launcher) {
        if (_LOG.isLoggable(Level.FINEST)) {
            _LOG.finest("Save ExportOptions[Logs=" + this._bExportLogs + ", Access=" + this._bExportAccess + ", ZipLimit=" + this._lExportLimitZip + "]");
        }
        launcher.setOption(PREF_EXPORT_DBLOGS, Boolean.toString(this._bExportLogs));
        launcher.setOption(PREF_EXPORT_ACCESS, Boolean.toString(this._bExportAccess));
        launcher.setOption(PREF_EXPORT_LIMITZIP, Long.toString(this._lExportLimitZip));
    }

    public boolean getExportLogs() {
        return this._bExportLogs;
    }

    public boolean getExportAccess() {
        return this._bExportAccess;
    }

    public long getExportZipLimit() {
        return this._lExportLimitZip;
    }

    private Component createImportPanel() {
        this._ctrlIDagConflict = new JComboBox<DBConflict>(DBConflict.values());
        Dimension size = this._ctrlIDagConflict.getPreferredSize();
        size.width = size.width * 12 / 10;
        this._ctrlIDagConflict.setPreferredSize(size);
        this._ctrlIDagConflict.setSelectedItem((Object)this._valueIDagConflict);
        this._ctrlIDagConflict.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneralIOPreferencies.this._valueIDagConflict = (DBConflict)((Object)GeneralIOPreferencies.this._ctrlIDagConflict.getSelectedItem());
            }
        });
        this._ctrlIDagConflict.setRenderer(DBConflict.getListCellRenderer());
        this._ctrlIDagChoice = new JComboBox<DAGImportChoice>(DAGImportChoice.values());
        size = this._ctrlIDagChoice.getPreferredSize();
        size.width = size.width * 12 / 10;
        this._ctrlIDagChoice.setPreferredSize(size);
        this._ctrlIDagChoice.setSelectedItem((Object)this._valueIDagChoice);
        this._ctrlIDagChoice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneralIOPreferencies.this._valueIDagChoice = (DAGImportChoice)((Object)GeneralIOPreferencies.this._ctrlIDagChoice.getSelectedItem());
            }
        });
        this._ctrlIDagChoice.setRenderer(DAGImportChoice.getListCellRenderer());
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel lbl = new JLabel(ResMsgObj.getString("PREF_IMPORT_DAG_CONFLICT"));
        lbl.setToolTipText(ResMsgObj.getString("PREF_IMPORT_DAG_CONFLICT_TOOLTIP"));
        panel.add((Component)lbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this._ctrlIDagConflict, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        lbl = new JLabel(ResMsgObj.getString("PREF_IMPORT_DAG_CHOICE"));
        lbl.setToolTipText(ResMsgObj.getString("PREF_IMPORT_DAG_CHOICE_TOOLTIP"));
        panel.add((Component)lbl, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this._ctrlIDagChoice, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.setBorder(BorderFactory.createTitledBorder(ResMsgVoc.getString("VOC_IMPORT")));
        return panel;
    }

    protected void loadImportOptions(Plugable launcher) {
        String value = PlugableUtility.getStrOpt(launcher, PREF_IMPORT_DAG_CONFLICT, "");
        this._valueIDagConflict = DBConflict.readFrom(value, DBConflict.NOTIMPORT);
        if (this._ctrlIDagConflict != null) {
            this._ctrlIDagConflict.setSelectedItem((Object)this._valueIDagConflict);
        }
        value = PlugableUtility.getStrOpt(launcher, PREF_IMPORT_DAG_CHOICE, "");
        this._valueIDagChoice = DAGImportChoice.readFrom(value, DAGImportChoice.FT_OR_BF);
        if (this._ctrlIDagChoice != null) {
            this._ctrlIDagChoice.setSelectedItem((Object)this._valueIDagChoice);
        }
        if (_LOG.isLoggable(Level.FINEST)) {
            _LOG.finest("Load Import[DAGConflict=" + (Object)((Object)this._valueIDagConflict) + ", DAGChoice=" + (Object)((Object)this._valueIDagChoice) + "]");
        }
    }

    protected void saveImportOptions(Plugable launcher) {
        if (_LOG.isLoggable(Level.FINEST)) {
            _LOG.finest("Save Import[DAGConflict=" + (Object)((Object)this._valueIDagConflict) + ", DAGChoice=" + (Object)((Object)this._valueIDagChoice) + "]");
        }
        launcher.setOption(PREF_IMPORT_DAG_CONFLICT, this._valueIDagConflict.toString());
        launcher.setOption(PREF_IMPORT_DAG_CHOICE, this._valueIDagChoice.toString());
    }

    public DBConflict getImportDagConflict() {
        return this._valueIDagConflict;
    }

    public DAGImportChoice getImportDagChoice() {
        return this._valueIDagChoice;
    }
}

