/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.dependencies.Generate;
import com.dassault.cecilia.core.cecilia.dependencies.Recup;
import com.dassault.cecilia.core.cecilia.error.GeneralError;
import com.dassault.cecilia.db.DBAccess;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.db.DBSession;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.dbobj.ResMsgObj;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class GenerateExport
extends Generate<DBFolder> {
    DBUser _dbUser;
    Set<DBFolder> _parentsFolder = new HashSet<DBFolder>();

    public GenerateExport(DAOFactory daoFactory, DBUser dbUser) {
        super(daoFactory);
        this._dbUser = dbUser;
    }

    protected boolean validParents(DBFolder current, DBFolder origin) {
        DBFolder parent = current.getParent();
        if (parent.isSystem()) {
            return true;
        }
        if (this._parentsFolder.contains(parent)) {
            return true;
        }
        if (!this.validParents(parent, origin)) {
            return false;
        }
        DBAccess.Right right = this._daoFactory.createFolderDAO().getAccessRight(parent, this._dbUser);
        if (right == DBAccess.Right.NONE || right == DBAccess.Right.INTEGRATE) {
            this.getErrors().add(new GeneralError<DBFolder>(parent, ResMsgCore.msgFormat("MSG_ERR_ACCESS_FOLDER_PARENT_FRM", origin.getRefPath())));
        }
        this._parentsFolder.add(parent);
        return true;
    }

    @Override
    protected Recup<DBFolder> makeRecup(DBFolder.Family family) {
        return new Recup<DBFolder>(family, (Generate)this){

            @Override
            protected boolean isValid(DBFolder dbFolder, DBFolder t) {
                if (!GenerateExport.this.validParents(dbFolder, dbFolder)) {
                    return false;
                }
                if (dbFolder.getObject() != null) {
                    if (dbFolder.isLocked() && !dbFolder.isFreeze()) {
                        DBSession dbSession = dbFolder.getObject().getLockedSession();
                        GenerateExport.this.getErrors().add(new GeneralError<DBFolder>(dbFolder, ResMsgObj.msgFormat("MSG_OBJ_ERR_ISLOCKED", dbFolder.getRefPath(), dbSession.getUser().getLogin(), dbSession.isActive() ? "" : " ~")));
                    } else {
                        DBAccess.Right right = GenerateExport.this._daoFactory.createFolderDAO().getAccessRight(dbFolder, GenerateExport.this._dbUser);
                        if (right == DBAccess.Right.NONE || right == DBAccess.Right.INTEGRATE) {
                            GenerateExport.this.getErrors().add(new GeneralError<DBFolder>(dbFolder, ResMsgObj.msgFormat("MSG_OBJ_ERR_ACCESS_NO", dbFolder.getRefPath())));
                        }
                    }
                }
                return true;
            }
        };
    }

    @Override
    protected boolean addRelations(DBFolder dbFolder, Collection<DBRelation> relations) {
        if (!super.addRelations(dbFolder, relations)) {
            return false;
        }
        while (!dbFolder.getParent().isSystem()) {
            if ((dbFolder = dbFolder.getParent()).getObject() == null || super.addRelations(dbFolder, null)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean dontTreatThisFamily(DBFolder.Family family) {
        return false;
    }

    @Override
    protected DBFolder findOrCreate(DBFolder dbDest, DBFolder.Family family) {
        return dbDest;
    }

    public boolean withError() {
        return !this.getErrors().isEmpty();
    }

    public Set<DBFolder> getDepends() {
        LinkedHashSet<DBFolder> folders = new LinkedHashSet<DBFolder>();
        for (DBFolder.Family family : this.getKeys()) {
            Collection familyDepends = this.getValues(family);
            if (familyDepends == null) continue;
            folders.addAll(familyDepends);
        }
        return folders;
    }
}

