/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.arbor51;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObjModel;
import com.dassault.cecilia.db.DBObject;
import com.dassault.cecilia.db.dao.xml.DBObjModelBytes;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.faulttree.ccf.CCF;
import com.dassault.cecilia.dbobj.faulttree.config.FTConfig;
import com.dassault.cecilia.dbobj.faulttree.dsf.DSFEquation;
import com.dassault.cecilia.dbobj.faulttree.ft.FTEquation;
import com.dassault.cecilia.dbobj.faulttree.ft.FTVariable;
import com.dassault.cecilia.dbobj.faulttree.obj.FTEquationAbstract;
import com.dassault.cecilia.dbobj.faulttree.obj.FTEvent;
import com.dassault.cecilia.dbobj.faulttree.obj.FTLink;
import com.dassault.cecilia.dbobj.general.attrib.DBAttrib;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.modellaw.DBModelLaw;
import com.dassault.cecilia.dbobj.project.DBProject;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.io.arbor51.ResMsgSA51;
import com.dassault.cecilia.io.arbor51.SA51Constant;
import com.dassault.cecilia.io.arbor51.SA51Handler;
import com.dassault.cecilia.io.arbor51.SA51Utils;
import com.dassault.cecilia.io.imports.ParserTypeProject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.SAXException;

public class SA51Linker
implements SA51Constant {
    private final List<SA51Handler.IdentifiantObject> _listEvents;
    private final List<SA51Handler.IdentifiantObject> _listObjects;
    private final List<SA51Handler.IdentifiantObject> _listDSFEquation;
    private final List<DBFolder> _listCreatedFolder;
    private final CECFactory _cecFactoryLinker;
    private final Date _currentDateLinker;
    private final String _loginLinker;
    private final String _filePath;
    private DBFolder _root;
    private long _increment;

    public SA51Linker(String filePath, CECFactory cecFactory, Date currentDate, String login) {
        this._cecFactoryLinker = cecFactory;
        this._listEvents = new ArrayList<SA51Handler.IdentifiantObject>();
        this._listObjects = new ArrayList<SA51Handler.IdentifiantObject>();
        this._listDSFEquation = new ArrayList<SA51Handler.IdentifiantObject>();
        this._listCreatedFolder = new ArrayList<DBFolder>();
        this._currentDateLinker = currentDate;
        this._loginLinker = login;
        this._filePath = filePath;
    }

    public void setRoot(DBFolder root) {
        this._root = root;
    }

    public void setIncrement(long increment) {
        this._increment = increment;
    }

    public final void addNewLinkToDo(SA51Handler.IdentifiantObject idObj) {
        this._listEvents.add(idObj);
    }

    public final void addNewObject(String name, SA51Handler.TypeObject type, DBFolder folder) {
        SA51Handler.IdentifiantObject idObj = new SA51Handler.IdentifiantObject(type, name, folder);
        this._listObjects.add(idObj);
    }

    public final void addNewObject(String name, SA51Handler.TypeObject type, FTVariable ftVar) {
        SA51Handler.IdentifiantObject idObj = new SA51Handler.IdentifiantObject(type, name, ftVar);
        this._listObjects.add(idObj);
    }

    public final void addSubtreeDSF(SA51Handler.IdentifiantObject idObj) {
        this._listDSFEquation.add(idObj);
    }

    private final SA51Handler.IdentifiantObject getObj(SA51Handler.TypeObject type, String objName) {
        block3: for (SA51Handler.IdentifiantObject idObj : this._listObjects) {
            switch (type) {
                case BTP: {
                    if (idObj.getType() != type || !idObj.getName().equals(objName + "/1")) continue block3;
                    return idObj;
                }
            }
            if (idObj.getType() != type || !idObj.getName().equals(objName)) continue;
            return idObj;
        }
        return null;
    }

    public final void linkElements(SA51Handler.TypeObject ... types) throws SAXException {
        assert (types.length != 0);
        List<SA51Handler.TypeObject> listAllowedTypes = Arrays.asList(types);
        LinkedHashMap<FTEquationAbstract, DBLogs> setEquToRefresh = new LinkedHashMap<FTEquationAbstract, DBLogs>();
        SA51Utils._LOG.finest("Starting Linking");
        for (SA51Handler.IdentifiantObject identifiantObject : this._listEvents) {
            SA51Handler.TypeObject typeObj = identifiantObject.getType();
            if (!listAllowedTypes.contains((Object)typeObj)) continue;
            String objName = identifiantObject.getName();
            SA51Handler.IdentifiantObject idObjWanted = this.getObj(typeObj, objName);
            if (idObjWanted == null && typeObj != SA51Handler.TypeObject.SUBTREE) {
                StringBuilder sb = new StringBuilder();
                sb.append(this.getClass().getName()).append(": ").append(ResMsgSA51.msgFormat("MSG_ERR_FOLDER_UNKNOW", new Object[]{objName, typeObj}));
                SA51Utils._LOG.severe(sb.toString());
                FTEquationAbstract equa = identifiantObject.getTree();
                DBLogs logs = new DBLogs();
                logs.addLog(this._currentDateLinker, this._loginLinker, DBLogs.DBLevel.ERROR, ResMsgSA51.msgFormat("MSG_ERR_FOLDER_UNKNOW", new Object[]{objName, typeObj}));
                setEquToRefresh.put(equa, logs);
                continue;
            }
            DBLogs logs = new DBLogs();
            switch (typeObj) {
                case BTP: {
                    FTEvent event = identifiantObject.getEvent();
                    Object folder = idObjWanted.getFolder();
                    if (folder == null) {
                        throw new SAXException(ResMsgSA51.msgFormat("MSG_ERR_BTP_INEXISTANT", objName));
                    }
                    DBModelLaw dbLaw = (DBModelLaw)this._cecFactoryLinker.createObjectDAO().getWrap(((DBFolder)folder).getObject());
                    event.setModelLaw(dbLaw);
                    break;
                }
                case ATTRIBUTE: {
                    FTEvent event = identifiantObject.getEvent();
                    Object folder = idObjWanted.getFolder();
                    String value = identifiantObject.getValue();
                    assert (value != null);
                    ArrayList<DBAttrib.Value> values = new ArrayList<DBAttrib.Value>(event.getAttributes());
                    DBAttrib dbAttr = (DBAttrib)this._cecFactoryLinker.createObjectDAO().getWrap(((DBFolder)folder).getObject());
                    if (dbAttr == null) {
                        throw new SAXException(ResMsgSA51.msgFormat("MSG_ERR_ATTR_INEXISTANT", value));
                    }
                    String attrValue = SA51Utils.checkValue(value, dbAttr.getType());
                    DBAttrib.Value v = dbAttr.createInstance(attrValue);
                    if (v == null) {
                        throw new SAXException(ResMsgSA51.msgFormat("MSG_ERR_VAL_ATTR_INEXISTANT", value));
                    }
                    values.add(v);
                    event.setAttributes(values);
                    break;
                }
                case CCF: {
                    FTEvent event = identifiantObject.getEvent();
                    Object folder = idObjWanted.getFolder();
                    if (!((DBFolder)folder).isVersion()) {
                        folder = ((DBFolder)folder).findChild("1");
                    }
                    if (folder == null) {
                        throw new SAXException(ResMsgSA51.msgFormat("MSG_ERR_CCF_INEXISTANT", objName));
                    }
                    CCF ccf = (CCF)this._cecFactoryLinker.createObjectDAO().getWrap(((DBFolder)folder).getObject());
                    event.setCCF(ccf.getCopy());
                    break;
                }
                case DSF: {
                    Object link;
                    FTEquation equation = (FTEquation)identifiantObject.getTree();
                    FTConfig conf = identifiantObject.getConfig();
                    equation.getConfigs().remove(conf);
                    FTVariable ftVar = (FTVariable)idObjWanted.getVariable();
                    if (ftVar == null) {
                        DBFolder folder = idObjWanted.getFolder();
                        FTConfig.DSFConfigItem item = new FTConfig.DSFConfigItem(folder);
                        item.setVisible(true);
                        conf.addDSFItem(item);
                    } else {
                        link = ftVar.getLink();
                        if (link != null && ((FTLink)link).isDSF()) {
                            FTEquationAbstract ftEqu = ((FTLink)link).getSubTree();
                            assert (ftEqu != null);
                            FTConfig.DSFConfigItem item = new FTConfig.DSFConfigItem(ftEqu.getDBFolder());
                            item.setVisible(true);
                            conf.addDSFItem(item);
                        } else {
                            FTVariable curVar2 = (FTVariable)identifiantObject.getVariable();
                            logs.addLog(this._currentDateLinker, this._loginLinker, DBLogs.DBLevel.WARNING, ResMsgSA51.msgFormat("MSG_ERR_SUBTREE_INEXISTANT", objName, curVar2.getName()));
                            FTEvent event = new FTEvent();
                            event.setStyle(FTEvent.Style.UNLINK);
                            curVar2.setEvent(event);
                            break;
                        }
                    }
                    equation.getConfigs().add(conf);
                    break;
                }
                case SUBTREE: {
                    Object str;
                    FTVariable curVar = (FTVariable)identifiantObject.getVariable();
                    Object folder = this._cecFactoryLinker.createFolderDAO().getRootID("PROJECTS");
                    String[] strFolders = objName.substring(1, objName.length()).split("/");
                    Object link = strFolders;
                    int curVar2 = ((String[])link).length;
                    for (int event = 0; event < curVar2 && (folder = ((DBFolder)folder).findChild((String)(str = link[event]))) != null; ++event) {
                    }
                    if (folder == null) {
                        ParserTypeProject.TypeOfImport type = null;
                        type = this._root == null ? ParserTypeProject.TypeOfImport.PROJECT : (this._root.getParent().getName().equals("PROJECTS") ? ParserTypeProject.TypeOfImport.SYSTEM : ParserTypeProject.TypeOfImport.TREE);
                        assert (type != null);
                        if (type != ParserTypeProject.TypeOfImport.PROJECT) {
                            String treeID = strFolders[2];
                            String versID = strFolders[3];
                            str = this._listObjects.iterator();
                            while (str.hasNext()) {
                                SA51Handler.IdentifiantObject obj = (SA51Handler.IdentifiantObject)str.next();
                                DBFolder objFolder = obj.getFolder();
                                if (objFolder == null || !objFolder.getName().equals(versID) || !objFolder.getParent().getName().equals(treeID)) continue;
                                if (type == ParserTypeProject.TypeOfImport.SYSTEM) {
                                    String systemID = strFolders[1];
                                    if (!objFolder.getParent().getParent().getName().equals(systemID)) continue;
                                }
                                folder = obj.getFolder();
                                logs.addLog(this._currentDateLinker, this._loginLinker, DBLogs.DBLevel.INFO, ResMsgSA51.msgFormat("MSG_WARNING_ARRANGED_LINK", ((DBFolder)folder).getRefPath(), identifiantObject.getVariable()));
                                break;
                            }
                        }
                    }
                    if (folder == null || ((DBFolder)folder).getObject() == null) {
                        FTEvent event = new FTEvent();
                        curVar.setEvent(event);
                        DBFolder parentFolder = this._cecFactoryLinker.createFolderDAO().getRootID("PROJECTS");
                        DBFolder tmp = null;
                        str = strFolders;
                        int n = ((String[])str).length;
                        for (int i = 0; i < n; ++i) {
                            Object s = str[i];
                            tmp = parentFolder.findChild((String)s);
                            if (tmp == null) {
                                if (this._increment == -1L) {
                                    SA51Utils._LOG.severe("Increment not updated (-1)");
                                    return;
                                }
                                tmp = new DBFolder(this._increment++);
                                if (strFolders[0].equals(s)) {
                                    tmp.setFlags(DBFolder.createFlagsFolder(DBFolder.Family.PROJECT, (short)8, (short)0));
                                    DBProject project = new DBProject(tmp);
                                    DBObject object = new DBObject(tmp.getID());
                                    object.setFolder(tmp);
                                    tmp.setObject(object);
                                    DBObjModel dbObjModel = project.writeDBObjModel(false);
                                    object.addModel(new DBObjModelBytes(dbObjModel));
                                    this._cecFactoryLinker.createObjectDAO().putWrap(object, project);
                                } else if (strFolders[1].equals(s)) {
                                    tmp.setFlags(DBFolder.createFlagsFolder(DBFolder.Family.PROJECT, (short)0, (short)0));
                                } else if (strFolders[2].equals(s)) {
                                    tmp.setFlags(DBFolder.createFlagsModel(DBFolder.Family.PROJECT, identifiantObject.isDSF() ? (short)3 : 2, (short)0));
                                } else if (strFolders[3].equals(s)) {
                                    tmp.setFlags(DBFolder.createFlagsVersion(DBFolder.Family.PROJECT, identifiantObject.isDSF() ? (short)3 : 2, (short)0));
                                }
                                tmp.setName((String)s);
                                SA51Utils.linkDBFolder(parentFolder, tmp);
                            }
                            if (tmp.getDateCreate() == null) {
                                tmp.setDateCreate(this._currentDateLinker);
                            }
                            if (tmp.getDateModify() == null) {
                                tmp.setDateModify(this._currentDateLinker);
                            }
                            parentFolder = tmp;
                        }
                        this.generateDefaultTree(identifiantObject.getTree(), objName, tmp, identifiantObject.getEventName(), identifiantObject.isDSF());
                        folder = tmp;
                    }
                    DBObject obj = ((DBFolder)folder).getObject();
                    assert (obj != null);
                    FTEquationAbstract ftEqua = (FTEquationAbstract)this._cecFactoryLinker.createObjectDAO().getWrap(obj);
                    FTLink link2 = new FTLink();
                    String genericValue = identifiantObject.getGeneric();
                    if (genericValue != null && !genericValue.isEmpty()) {
                        link2.setGeneric(genericValue);
                    }
                    curVar.setLink(link2.setSubTree(ftEqua));
                    break;
                }
            }
            DBLogs oldLogs = (DBLogs)setEquToRefresh.get(identifiantObject.getTree());
            if (oldLogs == null) {
                setEquToRefresh.put(identifiantObject.getTree(), logs);
                continue;
            }
            for (DBLogs.Log log : logs.getLogs(DBLogs.DBLevel.FINE)) {
                oldLogs.addLog(log);
            }
        }
        for (Map.Entry entry : setEquToRefresh.entrySet()) {
            FTEquationAbstract equation = (FTEquationAbstract)entry.getKey();
            assert (equation != null);
            DBObjModel objModel = equation.writeDBObjModel(false);
            DBObject obj = equation.getDBFolder().getObject();
            DBObjModel modelToClear = null;
            if (equation instanceof FTEquation) {
                modelToClear = obj.getModel("tree.def");
            } else if (equation instanceof DSFEquation) {
                modelToClear = obj.getModel("dsf.def");
            }
            if (modelToClear != null) {
                obj.delModel(modelToClear);
            }
            obj.addModel(new DBObjModelBytes(objModel));
            for (DBLogs.Log log : ((DBLogs)entry.getValue()).getLogs(DBLogs.DBLevel.FINE)) {
                equation.getLogs().addLog(log);
            }
            DBObjModel objLogs = equation.writeDBObjLogs(false);
            modelToClear = obj.getModel("logs");
            obj.delModel(modelToClear);
            obj.addModel(new DBObjModelBytes(objLogs));
            this._cecFactoryLinker.createObjectDAO().putWrap(obj, equation);
        }
        SA51Utils._LOG.finest("End Linking");
    }

    public final void generateEmptyLinksDSF() {
        for (SA51Handler.IdentifiantObject idObj : this._listDSFEquation) {
            if (idObj.getFolder().getObject() == null) {
                this.generateDefaultTree(idObj.getTree(), idObj.getName(), idObj.getFolder(), idObj.getEventName(), idObj.isDSF());
                continue;
            }
            DBFolder folder = idObj.getFolder();
            if (!this._listCreatedFolder.contains(folder)) continue;
            Date date = Boolean.getBoolean("cecilia.junit.arbor51") ? new Date(1472594500000L) : this._currentDateLinker;
            String msg = idObj.isDSF() ? ResMsgSA51.msgFormat("MSG_ERR_DSF_INEXISTANT", idObj.getName(), idObj.getEventName()) : ResMsgSA51.msgFormat("MSG_ERR_SUBTREE_INEXISTANT", idObj.getName(), idObj.getEventName());
            SA51Utils._LOG.info(this.getClass().getName() + ": " + msg);
            idObj.getTree().getLogs().addLog(date, this._loginLinker, DBLogs.DBLevel.INFO, msg);
            this.refreshModel(idObj.getTree(), idObj.getTree().getDBFolder());
        }
    }

    private final void generateDefaultTree(FTEquationAbstract eqParent, String originalPath, DBFolder folder, String eventName, boolean isDSF) {
        Date date = Boolean.getBoolean("cecilia.junit.arbor51") ? new Date(1472594500000L) : this._currentDateLinker;
        FTEquationAbstract equation = null;
        equation = isDSF ? new DSFEquation(folder) : new FTEquation(folder);
        if (equation instanceof FTEquation) {
            FTVariable var = new FTVariable();
            var.setEvent(new FTEvent().setVariable(var));
            var.setName(folder.getParent().getName());
            var.setRoot(true);
            DBLogs.DefaultManager logMng = new DBLogs.DefaultManager(this._loginLinker, equation.getLogs());
            ((FTEquation)equation).setVariables(Collections.singleton(var), logMng, false);
        }
        equation.getLogs().addLog(date, this._loginLinker, DBLogs.DBLevel.INIT, ResMsgObj.getString("MSG_ERR_OBJ_NOT_INITIALIZED")).setPrivate(true);
        equation.getLogs().addLog(date, this._loginLinker, DBLogs.DBLevel.FINE, ResMsgSA51.msgFormat("MSG_LOG_CREATION_FROM_IMPORT", this._filePath));
        String msg = isDSF ? ResMsgSA51.msgFormat("MSG_ERR_DSF_INEXISTANT", originalPath, eventName) : ResMsgSA51.msgFormat("MSG_ERR_SUBTREE_INEXISTANT", originalPath, eventName);
        SA51Utils._LOG.info(this.getClass().getName() + ": " + msg);
        eqParent.getLogs().addLog(date, this._loginLinker, DBLogs.DBLevel.INFO, msg);
        this._listCreatedFolder.add(folder);
        this.refreshModel(equation, folder);
    }

    private final void refreshModel(DBWrap wrap, DBFolder folder) {
        DBObject obj = new DBObject(folder.getID()).setFolder(folder);
        folder.setObject(obj);
        SA51Utils.createProperty(obj, folder.getName().split("\\.")[1], "object.release");
        obj.addModel(new DBObjModelBytes(wrap.writeDBObjModel(false)));
        obj.addModel(new DBObjModelBytes(wrap.writeDBObjLogs(false)));
        folder.setRelations(wrap.getUseRelations());
        this._cecFactoryLinker.createObjectDAO().putWrap(folder.getObject(), wrap);
    }
}

