/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.arbor51;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObject;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.db.dao.xml.DBObjModelBytes;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.faulttree.ccf.CCF;
import com.dassault.cecilia.dbobj.faulttree.ft.BoolEquation;
import com.dassault.cecilia.dbobj.faulttree.ft.FTEquation;
import com.dassault.cecilia.dbobj.faulttree.ft.FTVariable;
import com.dassault.cecilia.dbobj.faulttree.ft.io.dagdef.EquBoolConvert;
import com.dassault.cecilia.dbobj.faulttree.obj.FTDefinition;
import com.dassault.cecilia.dbobj.faulttree.obj.FTEvent;
import com.dassault.cecilia.dbobj.faulttree.obj.FTLink;
import com.dassault.cecilia.dbobj.general.attrib.DBAttrib;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.modellaw.DBModelLaw;
import com.dassault.cecilia.io.arbor51.AbstractSA51Handler;
import com.dassault.cecilia.io.arbor51.ResMsgSA51;
import com.dassault.cecilia.io.arbor51.SA51Constant;
import com.dassault.cecilia.io.arbor51.SA51DSFHandler;
import com.dassault.cecilia.io.arbor51.SA51EventHandler;
import com.dassault.cecilia.io.arbor51.SA51Handler;
import com.dassault.cecilia.io.arbor51.SA51Utils;
import com.dassault.cecilia.lib.util.xmlparser.SAXActionHandler;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.zip.InflaterInputStream;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SA51TreeHandler
extends AbstractSA51Handler
implements SAXActionHandler,
SA51Constant {
    private Date _creationDate;
    private DAOFolder _daoFolder;
    private DBFolder _treeFolder;
    private DBFolder _treeFolderVers;
    private DBFolder _systemFolder;
    private boolean _autoGeneratedSystem = false;
    private boolean _root = false;
    private String _releaseNumber;
    private String _dagEqu;
    private final List<SA51Handler.IdentifiantObject> _objectLinkNeeded;
    private String _owner;
    SA51EventHandler _eventHandler;
    SA51DSFHandler _dsfConfigHandler;
    Map<String, FTVariable> _allVars = new HashMap<String, FTVariable>();
    List<FTVariable> _allLeaves = new ArrayList<FTVariable>();
    List<SA51Handler.IdentifiantObject> _dsfNotLinked;

    public SA51TreeHandler(DBFolder root, SA51Handler handler) {
        super(handler);
        this._daoFolder = this.getCeciFactory().createFolderDAO();
        this._objectLinkNeeded = new ArrayList<SA51Handler.IdentifiantObject>();
        this._systemFolder = root;
        assert (this._systemFolder != null && this._systemFolder.getParent() != null && this._systemFolder.getParent().getParent() != null && this._systemFolder.getParent().getParent().getName().equals("PROJECTS"));
    }

    public void startAction(String name, Map<String, String> attrs, boolean startAction) throws SAXException {
        if (this._eventHandler != null) {
            this._eventHandler.startAction(name, attrs, false);
        } else if (this._dsfConfigHandler != null) {
            this._dsfConfigHandler.startAction(name, attrs, false);
        } else if ("IDENTIFICATION".equals(name)) {
            String nameTree = this.getValidName(this.getAttribute(attrs, "NAME"), DBFolder.Family.PROJECT, name, "NAME");
            this._owner = this.getAttribute(attrs, "OWNER");
            Date dateCreation = SA51Utils.convertDate(this.getAttribute(attrs, "CREATION_DATE"));
            Date dateModify = SA51Utils.convertDate(this.getAttribute(attrs, "UPDATE_DATE"));
            String version = this.getAttribute(attrs, "VERSION");
            this._releaseNumber = this.getAttribute(attrs, "RELEASE_NUMBER");
            String release = this.getAttribute(attrs, "RELEASE");
            this._treeFolder = this._systemFolder.findChild(nameTree);
            String commentModel = this.getValidDesc(this.getAttribute(attrs, "COMMENT"));
            String commentVers = this.getValidDesc(this.getAttribute(attrs, "VERSION_COMMENT"));
            if (this._treeFolder == null) {
                this._treeFolder = this.createNewFolder(nameTree, DBFolder.createFlagsModel(DBFolder.Family.PROJECT, (short)2, (short)0), false, commentModel == null || commentModel.isEmpty() ? null : commentModel, this._systemFolder);
            }
            this._treeFolder.setDateCreate(this._creationDate);
            this._treeFolder.setDateModify(this._creationDate);
            this._treeFolderVers = this._treeFolder.findChild(version + '.' + release);
            if (this._treeFolderVers == null) {
                this._treeFolderVers = this.createNewFolder(version + '.' + release, DBFolder.createFlagsVersion(DBFolder.Family.PROJECT, (short)2, (short)0), false, commentVers == null || commentVers.isEmpty() ? null : commentVers, this._treeFolder);
            }
            this._treeFolderVers.setDateCreate(dateCreation);
            this._treeFolderVers.setDateModify(dateModify);
            if (this._autoGeneratedSystem) {
                this._systemFolder.setDateCreate(dateCreation);
                this._systemFolder.setDateModify(dateModify);
            }
        } else if ("CONFIG_DSF".equals(name)) {
            this._dsfConfigHandler = new SA51DSFHandler(this._systemFolder, this.getHandler());
            this._dsfConfigHandler.startAction(name, attrs, true);
        } else if ("EVENT".equals(name)) {
            this._eventHandler = new SA51EventHandler(this.getAttribute(attrs, "NAME"), this.getHandler());
            this._eventHandler.startAction(name, attrs, true);
        } else if ("TREE".equals(name)) {
            this._creationDate = SA51Utils.convertDate(this.getAttribute(attrs, "CREATION_DATE"));
        }
    }

    public boolean endAction(String name, Map<String, String> attrs, String txt) throws SAXException {
        if (this._dsfConfigHandler != null && this._dsfConfigHandler.endAction(name, attrs, txt)) {
            if (this._dsfNotLinked == null) {
                this._dsfNotLinked = new ArrayList<SA51Handler.IdentifiantObject>();
            }
            this._dsfNotLinked.addAll(this._dsfConfigHandler.getDSFNotLinked());
            this._dsfConfigHandler = null;
        } else {
            if (this._eventHandler != null && this._eventHandler.endAction(name, attrs, txt)) {
                String linkSubtree;
                String comment;
                String varString = this._eventHandler.getName();
                FTVariable curVar = this._allVars.get(varString);
                if (curVar == null) {
                    curVar = new FTVariable().setName(varString);
                    this._allVars.put(varString, curVar);
                }
                if ((comment = this._eventHandler.getLabel()) != null) {
                    if (comment.length() > 1023) {
                        this.warning(new SAXParseException(ResMsgSA51.msgFormat("MSG_WARNING_COMMENT_TOO_LONG", comment), this.getLocator()));
                        comment = comment.substring(0, 1023);
                    }
                    curVar.setLabel(comment);
                }
                if (this._eventHandler.getGenericity()) {
                    curVar.setGeneric(true);
                }
                if ((linkSubtree = this._eventHandler.getSubtreeLink()) != null && !linkSubtree.isEmpty()) {
                    DBFolder parentFolder = this.getCeciFactory().createFolderDAO().getRootID("PROJECTS");
                    String[] strFolders = this.createFoldersSubtree(linkSubtree);
                    if (strFolders == null) {
                        SA51Utils._LOG.log(Level.SEVERE, ResMsgSA51.msgFormat("MSG_ERR_SYNTAX_LINK", linkSubtree, this.getHandler().getLocator().getLineNumber(), this.getHandler().getLocator().getColumnNumber(), name));
                        curVar.setEvent(new FTEvent().setStyle(FTEvent.Style.UNLINK));
                    } else {
                        boolean folderNotExists = false;
                        for (String s : strFolders) {
                            DBFolder tmp = parentFolder.findChild(s);
                            if (tmp == null) {
                                String[] pathFolders = this.createFoldersSubtree(linkSubtree);
                                StringBuilder sb = new StringBuilder();
                                for (String pathFolder : pathFolders) {
                                    sb.append('/').append(pathFolder);
                                }
                                SA51Handler.IdentifiantObject idObj = new SA51Handler.IdentifiantObject(SA51Handler.TypeObject.SUBTREE, sb.toString(), curVar);
                                idObj.setIsDSF(this._eventHandler.isDSF());
                                idObj.setEventName(varString);
                                if (this._eventHandler.getGenericExtention() != null && !this._eventHandler.getGenericExtention().isEmpty()) {
                                    idObj.setGeneric(this._eventHandler.getGenericExtention());
                                }
                                this._objectLinkNeeded.add(idObj);
                                folderNotExists = true;
                                break;
                            }
                            parentFolder = tmp;
                        }
                        if (!folderNotExists) {
                            DBObject obj = parentFolder.getObject();
                            FTEquation ftEqua = null;
                            if (obj != null) {
                                ftEqua = (FTEquation)this.getCeciFactory().createObjectDAO().getWrap(obj);
                            }
                            if (ftEqua == null) {
                                ftEqua = new FTEquation(parentFolder);
                            }
                            curVar.setLink(new FTLink().setSubTree(ftEqua).setGeneric(this._eventHandler.getGenericExtention()));
                        }
                        if (this._eventHandler.isDSF()) {
                            this.getLinker().addNewObject(varString, SA51Handler.TypeObject.DSF, curVar);
                        }
                    }
                } else if (this._eventHandler.isLeaf()) {
                    String ccfName;
                    String btpRef;
                    FTEvent event = new FTEvent();
                    if (this._eventHandler.getIsUnlink() != null) {
                        event.setStyle(FTEvent.Style.UNLINK);
                    }
                    if ((btpRef = this._eventHandler.getBTPRef()) != null && !btpRef.isEmpty()) {
                        DBFolder foldBTP = this.getFolderBTP(this._daoFolder.getRootID("LAW_MODELS"), btpRef);
                        if (foldBTP == null) {
                            this._objectLinkNeeded.add(new SA51Handler.IdentifiantObject(SA51Handler.TypeObject.BTP, this.getValidBTPPath(btpRef), event));
                        } else {
                            if (foldBTP.isModel()) {
                                foldBTP = foldBTP.findChild("1");
                            }
                            if (foldBTP == null || !foldBTP.isVersion() || foldBTP.getObject() == null) {
                                this.warning(new SAXParseException(ResMsgSA51.msgFormat("MSG_ERR_FOLDER_UNKNOW", btpRef, "LAW_MODELS".toLowerCase()), this.getLocator()));
                            } else {
                                DBModelLaw dbLaw = (DBModelLaw)this.getCeciFactory().createObjectDAO().getWrap(foldBTP.getObject());
                                event.setModelLaw(dbLaw);
                            }
                        }
                    } else {
                        event.setOccurrence(this._eventHandler.getLaw());
                    }
                    List<SA51EventHandler.Attribute> attributes = this._eventHandler.getAttrs();
                    ArrayList<DBAttrib.Value> values = new ArrayList<DBAttrib.Value>();
                    for (SA51EventHandler.Attribute attr : attributes) {
                        SA51Utils.Pair p = SA51Utils.createVarWithVer(attr.getName());
                        if (p == null) {
                            this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", "ATTRIBUTE_INSTANCE", "NAME", attr.getName()), this.getLocator()));
                            continue;
                        }
                        DBFolder attrVers = SA51Utils.goToChild(this._daoFolder.getRootID("ATTRIBUTES"), "Default", p.getName(), p.getVersion());
                        if (attrVers == null || attrVers.getObject() == null) {
                            this._objectLinkNeeded.add(new SA51Handler.IdentifiantObject(SA51Handler.TypeObject.ATTRIBUTE, p.getName() + p.getVersion(), event, attr.getValue()));
                            continue;
                        }
                        DBAttrib dbAttr = (DBAttrib)this.getCeciFactory().createObjectDAO().getWrap(attrVers.getObject());
                        if (dbAttr == null) {
                            this.warning(new SAXParseException(ResMsgObj.msgFormat("MSG_ERR_DBMOD_ATTRIBS_XML_READ", attrVers.getRefPath(), curVar.getName()), this.getLocator()));
                            continue;
                        }
                        String attrValue = SA51Utils.checkValue(attr.getValue(), dbAttr.getType());
                        DBAttrib.Value v = dbAttr.createInstance(attrValue);
                        if (v == null) {
                            String definition = new StringBuilder(128).append("'").append(attrVers.getRefPath()).append("' = ").append(attr.getValue()).toString();
                            this.warning(new SAXParseException(ResMsgObj.msgFormat("MSG_ERR_DBMOD_ATTRIBS_XML_VALUE", definition, curVar.getName()), this.getLocator()));
                            continue;
                        }
                        values.add(v);
                    }
                    event.setAttributes(values);
                    String state = this._eventHandler.getState();
                    if (state != null && !state.equals("normal")) {
                        event.setState("true".equals(state) ? FTEvent.State.TRUE : FTEvent.State.FALSE);
                    }
                    if ((ccfName = this._eventHandler.getCCFEvent()) != null && !ccfName.isEmpty()) {
                        DBFolder dbFold = SA51Utils.goToChild(this._daoFolder.getRootID("CCF_MODELS"), ccfName, "1");
                        if (dbFold == null) {
                            this._objectLinkNeeded.add(new SA51Handler.IdentifiantObject(SA51Handler.TypeObject.CCF, ccfName, event));
                        } else {
                            CCF ccf = (CCF)this.getCeciFactory().createObjectDAO().getWrap(dbFold.getObject());
                            event.setCCF(ccf.getCopy());
                        }
                    }
                    if (this._eventHandler.getInFlightTest() != null) {
                        event.setInflightTested(this._eventHandler.getInFlightTest());
                    } else if (this._eventHandler.getInspected() != null) {
                        event.setInspected(this._eventHandler.getInspected());
                    }
                    curVar.setEvent(event);
                } else {
                    ArrayList<FTVariable> lstArgs = new ArrayList<FTVariable>();
                    for (String child : this._eventHandler.getChildren()) {
                        if (!this._allVars.containsKey(child)) {
                            FTVariable newChild = new FTVariable().setName(child);
                            this._allVars.put(child, newChild);
                        }
                        lstArgs.add(this._allVars.get(child));
                    }
                    FTDefinition ftDefinition = new FTDefinition(this._eventHandler.getType(), lstArgs);
                    if (this._eventHandler.getType().equals((Object)FTDefinition.Type.KOFN)) {
                        ftDefinition.setAtLeast(this._eventHandler.getAtLeast());
                    }
                    curVar.setDefinition(ftDefinition);
                }
                if (!this._root) {
                    curVar.setRoot(true);
                    this._root = true;
                }
                this._allLeaves.add(curVar);
                this._eventHandler = null;
                return false;
            }
            if ("BIGTREE_EQUATION".equals(name)) {
                this._dagEqu = txt;
            } else if ("BIGTREE_DEFINITION".equals(name)) {
                String defEqu = txt;
                FTEquation ftEqu = this.readBigTree(this._treeFolderVers, this._dagEqu, defEqu, this.getCeciFactory());
                this._treeFolder.setFlags(DBFolder.createFlagsModel(DBFolder.Family.PROJECT, (short)5, (short)0));
                if (ftEqu == null) {
                    this.error(new SAXParseException("Error while parsing bigtree '" + defEqu + "'", this.getLocator()));
                }
            }
        }
        if ("TREE".equals(name)) {
            DBObject object = this._treeFolderVers.getObject();
            if (object == null) {
                FTEquation ftEquation = new FTEquation(this._treeFolderVers);
                for (FTVariable var : this._allVars.values()) {
                    if (var.getDefinition() != null || var.getEvent() != null || var.getLink() != null) continue;
                    boolean isUnlinkDSF = false;
                    for (SA51Handler.IdentifiantObject idObj : this._objectLinkNeeded) {
                        if (!var.equals(idObj.getVariable())) continue;
                        isUnlinkDSF = true;
                        break;
                    }
                    if (isUnlinkDSF) continue;
                    FTEvent event = new FTEvent();
                    event.setLabel(var.getName());
                    event.setStyle(FTEvent.Style.UNDEVELOPED);
                    var.setEvent(event);
                    event.setVariable(var);
                    this._allLeaves.add(var);
                }
                for (DBLogs.Log log : this.getLogs().getLogs(DBLogs.DBLevel.FINEST)) {
                    ftEquation.getLogs().addLog(log);
                }
                this.addDefaultLog(ftEquation);
                DBLogs.DefaultManager logMng = new DBLogs.DefaultManager(this._owner, ftEquation.getLogs());
                ftEquation.setVariables(this._allLeaves, logMng, true);
                DBObject obj = new DBObject(this._treeFolderVers.getID()).setFolder(this._treeFolderVers);
                this._treeFolderVers.setObject(obj);
                SA51Utils.createProperty(obj, this._releaseNumber, "object.release");
                obj.addModel(new DBObjModelBytes(ftEquation.writeDBObjModel(false)));
                obj.addModel(new DBObjModelBytes(ftEquation.writeDBObjLogs(false)));
                this._treeFolderVers.setRelations(ftEquation.getUseRelations());
                this.getCeciFactory().createObjectDAO().putWrap(obj, ftEquation);
                List<SA51Handler.IdentifiantObject> listIdObjToLink = this._objectLinkNeeded;
                if (this._dsfNotLinked != null) {
                    listIdObjToLink.addAll(this._dsfNotLinked);
                }
                for (SA51Handler.IdentifiantObject idObj : listIdObjToLink) {
                    idObj.setTree(ftEquation);
                    this.getLinker().addNewLinkToDo(idObj);
                }
                if (ftEquation.withLoopDefinition()) {
                    this.error(new SAXParseException(ResMsgArbor.getString("MSG_ERR_DAG_FT_VERIFY"), this.getLocator()));
                }
                this.getLinker().addNewObject(SA51Utils.getFullPath(this._treeFolderVers, "PROJECTS"), SA51Handler.TypeObject.SUBTREE, this._treeFolderVers);
            }
            return true;
        }
        return false;
    }

    public FTEquation readBigTree(DBFolder curFolder, String dag, String def, CECFactory factory) {
        byte[] byteDag = SA51TreeHandler.convertToBytes(dag);
        byte[] byteDef = SA51TreeHandler.convertToBytes(def);
        BoolEquation ftEquation = new BoolEquation(curFolder);
        DBLogs.DefaultManager logMng = new DBLogs.DefaultManager(this._owner, ftEquation.getLogs());
        BufferedReader rDef = new BufferedReader(new InputStreamReader(new InflaterInputStream(new ByteArrayInputStream(byteDef))));
        EquBoolConvert ftConvert = new EquBoolConvert(factory, logMng, true);
        BufferedReader rDag = new BufferedReader(new InputStreamReader(new InflaterInputStream(new ByteArrayInputStream(byteDag))));
        if (!ftConvert.readDag(rDag) || !ftConvert.readDef(rDef)) {
            return null;
        }
        DBObject obj = new DBObject(curFolder.getID());
        DBObjModelBytes objModelDag = new DBObjModelBytes(byteDag);
        objModelDag.setID(curFolder.getID());
        objModelDag.setNature("tree.dag");
        objModelDag.setFormat("ARBOR");
        objModelDag.setEncoding("UTF-8");
        obj.addModel(objModelDag);
        ftConvert.prepareEquation(ftEquation);
        obj.addModel(new DBObjModelBytes(ftEquation.writeDBObjModel(false)));
        obj.addModel(new DBObjModelBytes(ftEquation.writeDBObjLogs(false)));
        curFolder.setObject(obj);
        curFolder.setFamilyFlag((short)5);
        factory.createObjectDAO().putWrap(obj, ftEquation);
        return ftEquation;
    }

    public static byte[] convertToBytes(String s) {
        char[] chars = s.toCharArray();
        int count = chars.length;
        byte[] bytes = new byte[count / 2];
        for (int i = 0; i < count; i += 2) {
            String hex = "" + chars[i] + chars[i + 1];
            bytes[i / 2] = (byte)Integer.parseInt(hex, 16);
        }
        return bytes;
    }
}

