/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.ftp10.util;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.DatabaseBuilder;
import com.healthmarketscience.jackcess.PropertyMap;
import com.healthmarketscience.jackcess.Row;
import com.healthmarketscience.jackcess.Table;
import java.io.File;
import java.util.List;
import javax.swing.JFileChooser;

public class TraceJackessFile {
    public static void traceJackcess(File file) throws Exception {
        String field;
        Object obj;
        Row row;
        List columns;
        Table table;
        Database base = DatabaseBuilder.open((File)file);
        System.out.println();
        System.out.println("================================================================================================");
        System.out.println("File: " + file.getAbsolutePath());
        System.out.println("================================================================================================");
        System.out.println();
        System.out.println("------------------------------------------------------------------------------------------------");
        System.out.println("Database Properties: ");
        PropertyMap map = base.getDatabaseProperties();
        for (PropertyMap.Property prop : map) {
            System.out.println(prop.getName() + "(" + prop.getType() + ") = " + prop.getValue());
        }
        System.out.println();
        System.out.println("------------------------------------------------------------------------------------------------");
        System.out.println("Summary Properties: ");
        map = base.getSummaryProperties();
        for (PropertyMap.Property prop : map) {
            System.out.println(prop.getName() + "(" + prop.getType() + ") = " + prop.getValue());
        }
        System.out.println();
        System.out.println("------------------------------------------------------------------------------------------------");
        System.out.println("User Define Properties: ");
        map = base.getUserDefinedProperties();
        for (PropertyMap.Property prop : map) {
            System.out.println(prop.getName() + "(" + prop.getType() + ") = " + prop.getValue());
        }
        for (String tableName : base.getSystemTableNames()) {
            System.out.println();
            System.out.println("------------------------------------------------------------------------------------------------");
            System.out.println("Explore SYSTEM table: " + tableName);
            table = base.getSystemTable(tableName);
            columns = table.getColumns();
            System.out.print("[");
            for (int i = 0; i < columns.size(); ++i) {
                if (i > 0) {
                    System.out.print(";");
                }
                Column col = (Column)columns.get(i);
                System.out.print(col.getName() + "(" + col.getType() + ")");
            }
            System.out.println("]");
            row = table.getNextRow();
            while (row != null) {
                System.out.print("{");
                for (int i = 0; i < columns.size(); ++i) {
                    if (i > 0) {
                        System.out.print(";");
                    }
                    if ((obj = row.get((Object)((Column)columns.get(i)).getName())) == null) continue;
                    field = obj.toString();
                    if (field.length() > 40) {
                        field = field.substring(0, 36) + "...";
                    }
                    System.out.print(field);
                }
                System.out.println("}");
                row = table.getNextRow();
            }
        }
        for (String tableName : base.getTableNames()) {
            System.out.println();
            System.out.println("#################################################################################################");
            System.out.println("Explore table: " + tableName);
            table = base.getTable(tableName);
            columns = table.getColumns();
            System.out.print("[");
            for (int i = 0; i < columns.size(); ++i) {
                if (i > 0) {
                    System.out.print(";");
                }
                Column col = (Column)columns.get(i);
                System.out.print(col.getName() + "(" + col.getType() + ")");
            }
            System.out.println("]");
            row = table.getNextRow();
            while (row != null) {
                System.out.print("{");
                for (int i = 0; i < columns.size(); ++i) {
                    if (i > 0) {
                        System.out.print(";");
                    }
                    if ((obj = row.get((Object)((Column)columns.get(i)).getName())) == null) continue;
                    field = obj.toString();
                    if (field.length() > 40) {
                        field = field.substring(0, 36) + "...";
                    }
                    System.out.print(field);
                }
                System.out.println("}");
                row = table.getNextRow();
            }
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length == 1) {
                TraceJackessFile.traceJackcess(new File(args[0]));
            } else {
                JFileChooser dlg = new JFileChooser();
                dlg.setCurrentDirectory(new File("."));
                if (dlg.showOpenDialog(null) == 1) {
                    return;
                }
                File file = dlg.getSelectedFile();
                if (file == null) {
                    return;
                }
                TraceJackessFile.traceJackcess(file);
            }
        }
        catch (Exception e) {
            System.err.print(e.getMessage());
        }
    }
}

