/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.ocas40;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.general.attrib.AttrType;
import com.dassault.cecilia.dbobj.general.attrib.DBAttrib;
import com.dassault.cecilia.dbobj.general.icon.DBIcon;
import com.dassault.cecilia.dbobj.general.law.Law;
import com.dassault.cecilia.dbobj.general.law.LawFormat;
import com.dassault.cecilia.dbobj.general.law.Param;
import com.dassault.cecilia.dbobj.mbsa.component.AltaComponent;
import com.dassault.cecilia.dbobj.mbsa.component.gui.NamePosition;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaEquipment;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaLink;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaSub;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaSynchro;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaContainer;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaDraw;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGraph;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGroup;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaLink;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaNode;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaPort;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaSheet;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaTransform;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.Pt;
import com.dassault.cecilia.dbobj.mbsa.node.AltaEvent;
import com.dassault.cecilia.dbobj.mbsa.node.AltaFlow;
import com.dassault.cecilia.dbobj.mbsa.node.AltaState;
import com.dassault.cecilia.dbobj.mbsa.operator.AltaOperator;
import com.dassault.cecilia.dbobj.mbsa.operator.AltaOperatorRef;
import com.dassault.cecilia.dbobj.mbsa.system.AltaColor;
import com.dassault.cecilia.dbobj.mbsa.system.AltaConfig;
import com.dassault.cecilia.dbobj.mbsa.system.AltaSystem;
import com.dassault.cecilia.dbobj.mbsa.type.AltaType;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeBool;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeFloat;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeInt;
import com.dassault.cecilia.dbobj.mbsa.type.DBEnum;
import com.dassault.cecilia.dbobj.mbsa.type.DBRecord;
import com.dassault.cecilia.dbobj.mbsa.type.DBRecordField;
import com.dassault.cecilia.dbobj.mbsa.type.DBType;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.lib.util.format.DoubleFormat;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class PerformExportOCAS4 {
    private static Logger _LOG = Logger.getLogger(PerformExportOCAS4.class.getPackage().getName());
    CECFactory _cecFactory = null;
    Set<DBFolder> _foldersSorted;
    DBUser _dbUser;
    ZipOutputStream _zipStream = null;
    DBFolder _dbFolderPrevious = null;
    private static final LawFormat OCAS_LAW_FORMAT = new LawFormat.DefaultLawFormat(){

        @Override
        public String format(String id) {
            return id.replace("-", "_");
        }

        @Override
        public String getSeparatorBegin() {
            return "(";
        }

        @Override
        public String getSeparator() {
            return ", ";
        }

        @Override
        public String getSeparatorEnd() {
            return ")";
        }
    };
    Map<DBFolder, DBFolder> _mapIconModelToVersion = new HashMap<DBFolder, DBFolder>();
    Set<String> _setIcon = new HashSet<String>();

    public PerformExportOCAS4(CECFactory cecFactory, Set<DBFolder> foldersToExport) {
        this._cecFactory = cecFactory;
        this._foldersSorted = new TreeSet<DBFolder>(DBFolder.getComparatorWithFamily());
        this._foldersSorted.addAll(foldersToExport);
    }

    public PerformExportOCAS4 setDBUser(DBUser dbUser) {
        this._dbUser = dbUser;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportTo(File file) throws IOException {
        try {
            this._zipStream = new ZipOutputStream(new FileOutputStream(file));
            File xmlFile = new File(file.getParentFile(), file.getName() + ".xml");
            Writer out = null;
            try {
                out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(xmlFile), StandardCharsets.ISO_8859_1));
                this.exportToXML(out);
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            ZipEntry zipEntry = new ZipEntry("export.xml");
            this._zipStream.putNextEntry(zipEntry);
            FileInputStream input = null;
            try {
                int len;
                input = new FileInputStream(xmlFile);
                byte[] buffer = new byte[4096];
                while ((len = ((InputStream)input).read(buffer)) != -1) {
                    this._zipStream.write(buffer, 0, len);
                }
            }
            finally {
                if (input != null) {
                    try {
                        ((InputStream)input).close();
                    }
                    catch (IOException iOException) {}
                }
            }
            this._zipStream.closeEntry();
            zipEntry = new ZipEntry("export-id");
            this._zipStream.putNextEntry(zipEntry);
            OutputStreamWriter out2 = new OutputStreamWriter(this._zipStream);
            out2.write("<ocasVersion value=\"4.0.4\">\n");
            out2.write("<creationDate value=\"" + new SimpleDateFormat("dd/MM/yy HH:mm").format(new Date()) + "\">\n");
            out2.write("<creationOwner value=\"" + this._dbUser.getLogin() + "\">\n");
            out2.write("<comment>\n\n</comment>\n");
            ((Writer)out2).flush();
            this._zipStream.closeEntry();
        }
        finally {
            if (this._zipStream != null) {
                this._zipStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyDTD(Writer out) {
        InputStream dtdInput = PerformExportOCAS4.class.getResourceAsStream("OCAS4.dtd");
        if (dtdInput == null) {
            _LOG.warning("Non OCAS4.0 DTD.");
            return;
        }
        BufferedReader dtdReader = null;
        try {
            String line;
            dtdReader = new BufferedReader(new InputStreamReader(dtdInput));
            while ((line = dtdReader.readLine()) != null) {
                out.write(line);
                out.write("\n");
            }
            out.flush();
        }
        catch (IOException e) {
            _LOG.warning("IOException during copy DTD");
            _LOG.log(Level.FINER, "", e);
        }
        finally {
            if (dtdReader != null) {
                try {
                    dtdReader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void exportToXML(Writer out) throws IOException {
        out.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
        this.copyDTD(out);
        out.append("<EXPORT>\n");
        for (DBFolder dbFolder : this._foldersSorted) {
            this.exportTo(out, dbFolder);
        }
        if (this._dbFolderPrevious != null) {
            this.exportFamilyClose(out);
        }
        out.append("</EXPORT>\n");
    }

    private void exportTo(Writer out, DBFolder dbFolder) throws IOException {
        if (dbFolder.isSystem()) {
            return;
        }
        if (!dbFolder.isVersion()) {
            return;
        }
        if (this._dbFolderPrevious != null && this._dbFolderPrevious.getFamily() != dbFolder.getFamily()) {
            this.exportFamilyClose(out);
        }
        switch (dbFolder.getFamily()) {
            case TYPE: {
                this.exportTypeTo(out, dbFolder);
                break;
            }
            case OPERATOR: {
                this.exportOperatorTo(out, dbFolder);
                break;
            }
            case COMPONENT: {
                this.exportComponentTo(out, dbFolder);
                break;
            }
            case EQUIPMENT: {
                this.exportEquipmentTo(out, dbFolder);
                break;
            }
            case PROJECT: {
                if (dbFolder.getFamilyFlag() == 1) {
                    this.exportModelTo(out, dbFolder);
                    break;
                }
                return;
            }
            default: {
                return;
            }
        }
        this._dbFolderPrevious = dbFolder;
    }

    private void exportFamilyClose(Writer out) throws IOException {
        switch (this._dbFolderPrevious.getFamily()) {
            case TYPE: {
                out.write("  </TYPE_FAMILY>\n");
                break;
            }
            case OPERATOR: {
                out.write("  </OPERATOR_FAMILY>\n");
                break;
            }
            case COMPONENT: {
                out.write("  </COMPONENT_FAMILY>\n");
                break;
            }
            case EQUIPMENT: {
                out.write("  </EQUIPMENT_FAMILY>\n");
                break;
            }
            case PROJECT: {
                out.write("  </PROJECT>\n");
            }
        }
        this._dbFolderPrevious = null;
    }

    private boolean withSamePath(DBFolder dbPreviousFolder, DBFolder dbCurrentFolder) {
        if (dbPreviousFolder == null) {
            return false;
        }
        if ((dbPreviousFolder = dbPreviousFolder.getParent()) == null) {
            return false;
        }
        if ((dbPreviousFolder = dbPreviousFolder.getParent()) == null) {
            return false;
        }
        if (dbCurrentFolder == null) {
            return false;
        }
        if ((dbCurrentFolder = dbCurrentFolder.getParent()) == null) {
            return false;
        }
        if ((dbCurrentFolder = dbCurrentFolder.getParent()) == null) {
            return false;
        }
        return dbPreviousFolder.equals(dbCurrentFolder);
    }

    private DBWrap exportTypeTo(Writer out, DBFolder dbFolder) throws IOException {
        DBWrap dbWrap = this._cecFactory.findOrCreateWrap(dbFolder);
        if (dbWrap == null) {
            return null;
        }
        if (!(dbWrap instanceof DBType)) {
            return null;
        }
        out.write(this.printFamilyIfNecessary(dbFolder, "TYPE_FAMILY"));
        DBType dbType = (DBType)dbWrap;
        StringBuilder buffer = new StringBuilder();
        buffer.append("    <TYPE");
        if (dbType instanceof DBRecord) {
            buffer.append(" LINK=\"").append(((DBRecord)dbType).getTypeLink().getID()).append("\"");
        }
        buffer.append(">\n");
        out.write(buffer.toString());
        out.write(this.printIdentification(dbFolder));
        if (dbType instanceof DBRecord) {
            buffer = new StringBuilder();
            for (DBRecordField field : ((DBRecord)dbType).getFields()) {
                buffer.append("      <FIELD");
                buffer.append(" NAME=\"").append(field.getName()).append("\"");
                buffer.append(" TYPE=\"").append(this.convertType(field.getType())).append("\"");
                buffer.append(" DIRECTION=\"").append(field.getDirection().toString().toLowerCase()).append("\"");
                buffer.append(" CROSS=\"").append(field.getCrossField()).append("\"");
                buffer.append("/>\n");
            }
            out.write(buffer.toString());
        } else {
            buffer = new StringBuilder();
            for (int i = 0; i < ((DBEnum)dbType).getValueCount(); ++i) {
                buffer.append("      <FIELD");
                buffer.append(" NAME=\"").append(((DBEnum)dbType).getValueAt(i)).append("\"");
                buffer.append("/>\n");
            }
            out.write(buffer.toString());
        }
        out.write("    </TYPE>\n");
        return dbWrap;
    }

    private DBWrap exportOperatorTo(Writer out, DBFolder dbFolder) throws IOException {
        DBWrap dbWrap = this._cecFactory.findOrCreateWrap(dbFolder);
        if (dbWrap == null) {
            return null;
        }
        if (!(dbWrap instanceof AltaOperator)) {
            return null;
        }
        out.write(this.printFamilyIfNecessary(dbFolder, "OPERATOR_FAMILY"));
        AltaOperator dbOperator = (AltaOperator)dbWrap;
        StringBuilder buffer = new StringBuilder();
        buffer.append("    <OPERATOR");
        buffer.append(" LAW=\"");
        this.convertCode(buffer, dbOperator.getCode());
        buffer.append("\">\n");
        out.write(buffer.toString());
        buffer = new StringBuilder();
        buffer.append("      <OPERANDE");
        buffer.append(" NAME=\"").append(dbFolder.getParent().getName()).append("\"");
        buffer.append(" TYPE=\"").append(this.convertType(dbOperator.getType())).append("\"");
        buffer.append("/>\n");
        for (AltaFlow flow : dbOperator.getFlows()) {
            buffer.append("      <OPERANDE");
            buffer.append(" NAME=\"").append(flow.getName()).append("\"");
            buffer.append(" TYPE=\"").append(this.convertType(flow.getType())).append("\"");
            buffer.append("/>\n");
        }
        out.write(buffer.toString());
        out.write(this.printIdentification(dbFolder));
        out.write("    </OPERATOR>\n");
        return dbWrap;
    }

    private DBWrap exportComponentTo(Writer out, DBFolder dbFolder) throws IOException {
        DBWrap dbWrap = this._cecFactory.findOrCreateWrap(dbFolder);
        if (dbWrap == null) {
            return null;
        }
        if (!(dbWrap instanceof AltaComponent)) {
            return null;
        }
        AltaComponent dbComponent = (AltaComponent)dbWrap;
        out.write(this.printFamilyIfNecessary(dbFolder, "COMPONENT_FAMILY"));
        out.write(this.printComponentHeader(dbComponent, "COMPONENT_MODEL"));
        out.write(this.printComponentFlows(dbComponent));
        out.write(this.printComponentStates(dbComponent));
        out.write(this.printComponentEvents(dbComponent));
        out.write(this.printComponentIcons(dbComponent));
        StringBuilder buffer = new StringBuilder();
        for (AltaOperatorRef oper : dbComponent.getUsedOperator()) {
            buffer.append("      <OPERATOR_ID");
            buffer.append(" NAME=\"").append(oper.getName()).append("\"");
            DBFolder dbFamily = oper.getDBFolder().getParent().getParent();
            buffer.append(" FAMILY=\"").append(dbFamily.getParent().getName()).append("_").append(dbFamily.getName()).append("\"");
            buffer.append(" VERSION=\"").append(oper.getDBFolder().getName()).append("\"");
            buffer.append("/>\n");
        }
        out.write(buffer.toString());
        out.write(this.printIdentification(dbFolder));
        out.write("    </COMPONENT_MODEL>\n");
        return dbWrap;
    }

    private DBWrap exportEquipmentTo(Writer out, DBFolder dbFolder) throws IOException {
        DBWrap dbWrap = this._cecFactory.findOrCreateWrap(dbFolder);
        if (dbWrap == null) {
            return null;
        }
        if (!(dbWrap instanceof AltaEquipment)) {
            return null;
        }
        AltaEquipment dbEquipment = (AltaEquipment)dbWrap;
        out.write(this.printFamilyIfNecessary(dbFolder, "EQUIPMENT_FAMILY"));
        out.write(this.printComponentHeader(dbEquipment, "EQUIPMENT_MODEL"));
        out.write(this.printComponentFlows(dbEquipment));
        out.write(this.printComponentSyncs(dbEquipment));
        out.write(this.printComponentIcons(dbEquipment));
        out.write(this.printEquipmentSheets(dbEquipment));
        StringBuilder buffer = new StringBuilder();
        DBFolder dbFamily = dbFolder.getParent().getParent();
        buffer.append("      <CONTENT");
        buffer.append(" FAMILY=\"").append(dbFamily.getParent().getName()).append("_").append(dbFamily.getName()).append("\"");
        buffer.append(" NAME=\"").append(dbFolder.getParent().getName()).append("\"");
        buffer.append(" VERSION=\"").append(dbFolder.getName()).append("\"");
        buffer.append(">\n");
        out.write(buffer.toString());
        out.write(this.printEquipmentContent(dbEquipment));
        out.write("      </CONTENT>\n");
        out.write(this.printIdentification(dbFolder));
        out.write("    </EQUIPMENT_MODEL>\n");
        return dbWrap;
    }

    private DBWrap exportModelTo(Writer out, DBFolder dbFolder) throws IOException {
        DBWrap dbWrap = this._cecFactory.findOrCreateWrap(dbFolder);
        if (dbWrap == null) {
            return null;
        }
        if (!(dbWrap instanceof AltaSystem)) {
            return null;
        }
        AltaSystem dbEquipment = (AltaSystem)dbWrap;
        out.write(this.printFamilyIfNecessary(dbFolder, "PROJECT"));
        out.write("    <SYSTEM>\n");
        out.write(this.printModelColors(dbEquipment));
        out.write(this.printModelConfigs(dbEquipment));
        out.write(this.printComponentEvents(dbEquipment));
        out.write(this.printEquipmentSheets(dbEquipment));
        StringBuilder buffer = new StringBuilder();
        buffer.append("      <ARCHITECTURE");
        buffer.append(" ASSERTION=\"");
        this.convertCode(buffer, dbEquipment.getCode());
        buffer.append("\">\n");
        out.write(buffer.toString());
        out.write(this.printComponentSyncs(dbEquipment));
        out.write(this.printEquipmentContent(dbEquipment));
        out.write("      </ARCHITECTURE>\n");
        out.write(this.printIdentification(dbFolder));
        out.write("    </SYSTEM>\n");
        return dbWrap;
    }

    private String printIdentification(DBFolder dbFolder) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("      <IDENTIFICATION");
        buffer.append(" NAME=\"").append(dbFolder.getParent().getName()).append("\"");
        buffer.append(" VERSION=\"").append(dbFolder.getName()).append("\"");
        buffer.append(" RELEASE=\"").append(1).append("\"");
        buffer.append(" CREATION_DATE=\"").append("\"");
        buffer.append(" UPDATE_DATE=\"").append("\"");
        buffer.append(" GROUP_ACCESS=\"").append(1).append("\"");
        buffer.append(" OTHER_ACCESS=\"").append(1).append("\"");
        buffer.append(" GROUP=\"").append("admin").append("\"");
        buffer.append(" OWNER=\"").append("admin").append("\"");
        buffer.append(" COMMENT=\"").append(this.convertComment(dbFolder.getDescription())).append("\"");
        buffer.append(" FREEZE=\"").append(dbFolder.getObject().isFreeze()).append("\"");
        buffer.append("/>\n");
        return buffer.toString();
    }

    private String printFamilyIfNecessary(DBFolder dbFolder, String xmlEntity) {
        if (!this.withSamePath(this._dbFolderPrevious, dbFolder)) {
            StringBuilder buffer = new StringBuilder();
            if (this._dbFolderPrevious != null) {
                buffer.append("  </").append(xmlEntity).append(">\n");
            }
            DBFolder dbFamily = dbFolder.getParent().getParent();
            buffer.append("  <").append(xmlEntity).append(">\n");
            buffer.append("    <IDENTIFICATION");
            buffer.append(" NAME=\"").append(dbFamily.getParent().getName()).append("_").append(dbFamily.getName()).append("\"");
            buffer.append(" GROUP_ACCESS=\"").append(1).append("\"");
            buffer.append(" OTHER_ACCESS=\"").append(1).append("\"");
            buffer.append(" GROUP=\"").append("admin").append("\"");
            buffer.append(" OWNER=\"").append("admin").append("\"");
            buffer.append("/>\n");
            return buffer.toString();
        }
        return "";
    }

    private String printComponentHeader(AltaComponent dbComponent, String xmlEntity) throws IOException {
        StringBuilder buffer = new StringBuilder();
        int h = dbComponent.getHeight();
        int w = dbComponent.getWidth();
        buffer.append("    <").append(xmlEntity);
        buffer.append(" BORDER=\"").append(dbComponent.isBorderDrawing()).append("\"");
        buffer.append(" HEIGHT=\"").append(h + 6).append("\"");
        buffer.append(" WIDTH=\"").append(w + 6).append("\"");
        if (dbComponent.getIconEdit() != null) {
            DBIcon dbIcon = dbComponent.getIconEdit();
            DBFolder dbPath = dbIcon.getDBFolder().getParent();
            buffer.append(" ICON=\"").append(this.appendIcon(dbPath, dbIcon, h, w)).append("\"");
        }
        buffer.append(" LAW=\"");
        this.convertCode(buffer, dbComponent.getCode());
        buffer.append("\">\n");
        return buffer.toString();
    }

    private String printComponentFlows(AltaComponent dbComponent) {
        StringBuilder buffer = new StringBuilder();
        for (AltaFlow flow : dbComponent.getFlows()) {
            if (flow.getOrientation() == AltaFlow.Orientation.LOCAL && !dbComponent.getCode().contains(flow.getName())) continue;
            buffer.append("      <IO");
            buffer.append(" NAME=\"").append(flow.getName()).append("\"");
            buffer.append(" TYPE=\"").append(this.convertType(flow.getType())).append("\"");
            buffer.append(" DIRECTION=\"").append(flow.getOrientation().toString().toLowerCase()).append("\"");
            buffer.append(" X=\"").append(flow.getX()).append("\"");
            buffer.append(" Y=\"").append(flow.getY()).append("\"");
            buffer.append("/>\n");
        }
        return buffer.toString();
    }

    private String printComponentStates(AltaComponent dbComponent) {
        StringBuilder buffer = new StringBuilder();
        for (AltaState state : dbComponent.getStates()) {
            buffer.append("      <STATE");
            buffer.append(" NAME=\"").append(state.getName()).append("\"");
            buffer.append(" TYPE=\"").append(this.convertType(state.getType())).append("\"");
            buffer.append(" DEFAULT=\"").append(state.getDefaultValue()).append("\"");
            buffer.append("/>\n");
        }
        return buffer.toString();
    }

    private String printComponentEvents(AltaComponent dbComponent) {
        StringBuilder buffer = new StringBuilder();
        for (AltaEvent event : dbComponent.getEvents()) {
            double value;
            Param param;
            buffer.append("      <EVENT");
            buffer.append(" NAME=\"").append(event.getName()).append("\"");
            buffer.append(" COMMENT=\"").append(this.convertComment(event.getLabel())).append("\"");
            buffer.append(" LAW=\"").append(this.convertLaw(event.getLaw())).append("\"");
            if (event.getInspected() != null) {
                param = event.getInspected();
                value = this._cecFactory.getLawManager().evaluate(param);
                if (!Double.isNaN(value)) {
                    buffer.append(" INSPECTED=\"").append(Double.toString(value)).append("\"");
                } else {
                    _LOG.warning("Inspected: No evaluation for " + param + " [Event:" + event.getName() + ",Component:" + dbComponent.getDBFolder().getRefPath() + "]");
                }
            } else if (event.getInflightTested() != null) {
                param = event.getInflightTested();
                value = this._cecFactory.getLawManager().evaluate(param);
                if (!Double.isNaN(value)) {
                    buffer.append(" INFLIGHTTESTED=\"").append(Double.toString(value)).append("\"");
                } else {
                    _LOG.warning("InflightTested: No evaluation for " + param + " [Event:" + event.getName() + ",Component:" + dbComponent.getDBFolder().getRefPath() + "]");
                }
            }
            buffer.append(">\n");
            for (DBAttrib.Value dbAttrib : event.getAttributes()) {
                buffer.append("        <ATTRIBUTE");
                DBFolder folAttrib = dbAttrib.getKey().getDBFolder();
                if (dbAttrib.getKey().getType() == AttrType.ALIAS) {
                    buffer.append(" NAME=\"").append(folAttrib.getParent().getName()).append("_").append(folAttrib.getName()).append("\"");
                } else {
                    buffer.append(" NAME=\"").append(folAttrib.getParent().getName()).append("_").append(folAttrib.getName()).append("=").append(dbAttrib.getValue().toString()).append("\"");
                }
                buffer.append(" INHERIT=\"").append(false).append("\"");
                buffer.append("/>\n");
            }
            buffer.append("      </EVENT>\n");
        }
        return buffer.toString();
    }

    private String printComponentIcons(AltaComponent dbComponent) throws IOException {
        List<DBIcon> icons = dbComponent.getSimuls();
        if (icons.size() == 0) {
            return "";
        }
        if (!dbComponent.getCode().contains("icone")) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        int h = dbComponent.getHeight();
        int w = dbComponent.getWidth();
        for (DBIcon icon : icons) {
            DBFolder dbPath = icon.getDBFolder().getParent();
            buffer.append("      <ICON");
            buffer.append(" NAME=\"").append(this.appendIcon(dbPath, icon, h, w)).append("\"");
            buffer.append("/>\n");
        }
        return buffer.toString();
    }

    private String printComponentSyncs(AltaEquipment dbEquipment) {
        StringBuilder buffer = new StringBuilder();
        for (AltaSynchro sync : dbEquipment.getSynchros()) {
            buffer.append("      <SYNCHRO");
            buffer.append(" NAME=\"").append(sync.getName()).append("\"");
            buffer.append(" LAW=\"").append(this.convertLaw(sync.getLaw())).append("\"");
            buffer.append(" TYPE=\"").append(sync.getType().ordinal()).append("\"");
            buffer.append(">\n");
            for (String event : sync.getEvents()) {
                buffer.append("        <TRANSITION NAME=\"").append(event).append("\"/>\n");
            }
            buffer.append("      </SYNCHRO>\n");
        }
        return buffer.toString();
    }

    private String printEquipmentSheets(AltaEquipment dbEquipment) {
        StringBuilder buffer = new StringBuilder();
        for (AlgaSheet sheet : dbEquipment.getContent().getSheets()) {
            buffer.append("      <SHEET");
            buffer.append(" NAME=\"").append(sheet.getName()).append("\"");
            buffer.append(" NUMBER=\"").append(sheet.getNumber()).append("\"");
            buffer.append(" SELECTED=\"").append(sheet.isSelected()).append("\"");
            buffer.append(" VISIBLE=\"").append(sheet.isVisible()).append("\"");
            buffer.append(" ORDER=\"").append(sheet.getNumber()).append("\"");
            buffer.append("/>\n");
        }
        int nbr = dbEquipment.getContent().getSheets().size();
        while (nbr < 5) {
            buffer.append("      <SHEET");
            buffer.append(" NAME=\"Claque ").append(++nbr).append("\"");
            buffer.append(" NUMBER=\"").append(nbr).append("\"");
            buffer.append(" SELECTED=\"").append(false).append("\"");
            buffer.append(" VISIBLE=\"").append(false).append("\"");
            buffer.append(" ORDER=\"").append(nbr).append("\"");
            buffer.append("/>\n");
        }
        return buffer.toString();
    }

    private String printEquipmentContent(AltaEquipment dbEquipment) {
        StringBuilder buffer = new StringBuilder();
        for (AltaFlow flow : dbEquipment.getFlows()) {
            AlgaPort port = dbEquipment.getGraphic(flow);
            if (port == null) continue;
            buffer.append("        <PORT");
            buffer.append(" NAME=\"#").append(flow.getName()).append("\"");
            buffer.append(" X=\"").append(port.getX() - 3).append("\"");
            buffer.append(" Y=\"").append(port.getY() - 3).append("\"");
            buffer.append(" TEXT_LOC=\"").append(this.convertTextLoc(port.getNamePosition())).append("\"");
            buffer.append(" SHEET=\"").append(this.convertSheetID(port.getParent())).append("\"");
            buffer.append(" LOCKED=\"").append(port.isLocked()).append("\"");
            buffer.append(">\n");
            this.appendTransform(buffer, port);
            buffer.append("        </PORT>\n");
        }
        for (AltaSub sub : dbEquipment.getSubs()) {
            AlgaNode node = sub.getGraphic();
            DBFolder dbVersion = sub.getNode().getDBFolder();
            DBFolder dbFamily = dbVersion.getParent().getParent();
            if (sub.getNode() instanceof AltaEquipment) {
                buffer.append("        <EQUIPMENT");
            } else {
                buffer.append("        <COMPONENT");
            }
            buffer.append(" NAME=\"").append(sub.getName()).append("\"");
            buffer.append(" FAMILY=\"").append(dbFamily.getParent().getName()).append("_").append(dbFamily.getName()).append("\"");
            buffer.append(" MODEL=\"").append(dbVersion.getParent().getName()).append("\"");
            buffer.append(" VERSION=\"").append(dbVersion.getName()).append("\"");
            buffer.append(" X=\"").append(node.getX() - 3).append("\"");
            buffer.append(" Y=\"").append(node.getY() - 3).append("\"");
            buffer.append(" TEXT_LOC=\"").append(this.convertTextLoc(node.getNamePosition())).append("\"");
            buffer.append(" SHEET=\"").append(this.convertSheetID(node.getParent())).append("\"");
            buffer.append(" LOCKED=\"").append(node.isLocked()).append("\"");
            buffer.append(">\n");
            this.appendTransform(buffer, node);
            if (sub.getNode() instanceof AltaEquipment) {
                buffer.append("        </EQUIPMENT>\n");
                continue;
            }
            buffer.append("        </COMPONENT>\n");
        }
        for (AlgaSheet sheet : dbEquipment.getContent().getSheets()) {
            for (AlgaGraph graph : sheet.getGraphs()) {
                if (!(graph instanceof AlgaLink)) continue;
                AlgaLink gLink = (AlgaLink)graph;
                AltaLink lLink = gLink.getLogical();
                buffer.append("        <LINK");
                buffer.append(" FROM=\"").append(this.convertLink(lLink.getFromSub(), lLink.getFromFlow(), lLink.getFromField())).append("\"");
                buffer.append(" TO=\"").append(this.convertLink(lLink.getToSub(), lLink.getToFlow(), lLink.getToField())).append("\"");
                buffer.append(" SHEET=\"").append(sheet.getNumber()).append("\"");
                buffer.append(" LOCKED=\"").append(gLink.isLocked()).append("\"");
                buffer.append(" ARROW=\"").append(gLink.isDrawArrow()).append("\"");
                buffer.append(" PIPE=\"").append(gLink.isPipeStyle()).append("\"");
                buffer.append(">\n");
                if (gLink.getNbrPoints() > 0) {
                    for (Pt pt : gLink.getPoints()) {
                        buffer.append("          <BREAK");
                        buffer.append(" X=\"").append(pt.getX()).append("\"");
                        buffer.append(" Y=\"").append(pt.getY()).append("\"");
                        buffer.append(" POINT=\"").append(pt.getStyle() != Pt.Style.NONE).append("\"");
                        buffer.append("/>\n");
                    }
                }
                buffer.append("        </LINK>\n");
            }
        }
        return buffer.toString();
    }

    private String printModelColors(AltaSystem dbSystem) {
        StringBuilder buffer = new StringBuilder();
        AltaColor altaColor = dbSystem.getColors();
        for (AltaType type : altaColor.getTypes()) {
            buffer.append("      <COLOR");
            buffer.append(" NAME=\"").append(this.convertType(type)).append("\"");
            buffer.append(">\n");
            AltaColor.ColorMap map = altaColor.getColorMap(type);
            for (AltaColor.ColorMap.Item item : map.getItems()) {
                buffer.append("        <COLOR_VALUE");
                buffer.append(" NAME=\"").append(item.getValue()).append("\"");
                Color color = item.getColor();
                buffer.append(" RED=\"").append(color.getRed()).append("\"");
                buffer.append(" GREEN=\"").append(color.getGreen()).append("\"");
                buffer.append(" BLUE=\"").append(color.getBlue()).append("\"");
                buffer.append("/>\n");
            }
            buffer.append("      </COLOR>\n");
        }
        return buffer.toString();
    }

    private String printModelConfigs(AltaSystem dbSystem) {
        StringBuilder buffer = new StringBuilder();
        for (AltaConfig config : dbSystem.getConfigs()) {
            buffer.append("      <INIT_FILE");
            buffer.append(" NAME=\"").append(config.getName()).append("\"");
            buffer.append(">\n");
            for (Map.Entry<String, String> states : config.getStates().entrySet()) {
                buffer.append("        <INIT_STATE");
                buffer.append(" NAME=\"").append(states.getKey()).append(" = ").append(states.getValue()).append("\"");
                buffer.append("/>\n");
            }
            buffer.append("      </INIT_FILE>\n");
        }
        return buffer.toString();
    }

    private String convertLaw(Law law) {
        if (law == null) {
            return "";
        }
        return OCAS_LAW_FORMAT.format(law, DoubleFormat.getJavaInstance());
    }

    private String convertLink(AltaSub sub, AltaFlow flow, DBRecordField field) {
        StringBuilder buffer = new StringBuilder();
        if (sub == null) {
            buffer.append("#").append(flow.getName());
        } else {
            buffer.append(sub.getName());
        }
        buffer.append(".").append(flow.getName());
        if (field != null) {
            buffer.append(".").append(field.getName());
        }
        return buffer.toString();
    }

    private void appendTransform(StringBuilder buffer, AlgaDraw draw) {
        AlgaTransform transform = draw.getTransform();
        if (transform != null && transform.withTransform()) {
            if (transform.isRotate()) {
                buffer.append("          <TRANSFORM VALUE=\"3\" />\n");
            }
            if (transform.isMirrorV()) {
                buffer.append("          <TRANSFORM VALUE=\"1\" />\n");
            }
            if (transform.isMirrorH()) {
                buffer.append("          <TRANSFORM VALUE=\"2\" />\n");
            }
        }
    }

    private int convertSheetID(AlgaContainer parent) {
        if (parent instanceof AlgaSheet) {
            return ((AlgaSheet)parent).getNumber();
        }
        if (parent instanceof AlgaGroup) {
            return this.convertSheetID(parent.getParent());
        }
        return -1;
    }

    private Object convertTextLoc(NamePosition namePosition) {
        switch (namePosition) {
            case TOP: {
                return 0;
            }
            case BOTTOM: {
                return 1;
            }
            case LEFT: {
                return 2;
            }
            case RIGHT: {
                return 3;
            }
            case CENTER: {
                return 4;
            }
        }
        return 0;
    }

    private void convertCode(StringBuilder xmlString, String code) {
        char curCar = ' ';
        block10: for (int i = 0; i < code.length(); ++i) {
            curCar = code.charAt(i);
            switch (curCar) {
                case '&': {
                    xmlString.append("&amp;");
                    continue block10;
                }
                case '<': {
                    xmlString.append("&lt;");
                    continue block10;
                }
                case '>': {
                    xmlString.append("&gt;");
                    continue block10;
                }
                case '\'': {
                    xmlString.append("&apos;");
                    continue block10;
                }
                case '\"': {
                    xmlString.append("&quot;");
                    continue block10;
                }
                case '\t': {
                    xmlString.append("&#9;");
                    continue block10;
                }
                case '\n': {
                    xmlString.append("&#10;");
                    continue block10;
                }
                case '\r': {
                    xmlString.append("&#13;");
                    continue block10;
                }
                default: {
                    xmlString.append(curCar);
                }
            }
        }
    }

    private String convertComment(String txt) {
        if (txt == null) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(txt.length() * 3 / 2);
        this.convertCode(buffer, txt);
        return buffer.toString();
    }

    private String convertType(AltaType type) {
        if (type instanceof AltaTypeBool) {
            return "bool";
        }
        if (type instanceof AltaTypeFloat) {
            return "float";
        }
        if (type instanceof AltaTypeInt) {
            return "int";
        }
        if (type instanceof DBType) {
            DBType dbType = (DBType)type;
            StringBuilder buffer = new StringBuilder();
            DBFolder dbFolder = dbType.getDBFolder();
            dbFolder = dbFolder.getParent().getParent();
            buffer.append(dbFolder.getParent().getName()).append("_");
            buffer.append(dbFolder.getName()).append("/");
            buffer.append(dbType.getDBFolder().getParent().getName()).append(";");
            buffer.append(dbType.getDBFolder().getName());
            return buffer.toString();
        }
        return type.toString();
    }

    private String appendIcon(DBFolder dbPath, DBIcon dbIcon, int h, int w) throws IOException {
        DBFolder dbVersion;
        String result = dbPath.getRefPath();
        boolean resize = false;
        ImageIcon icon = dbIcon.getImage();
        resize = resize || icon.getIconHeight() < h - 6;
        resize = resize || icon.getIconHeight() > h + 6;
        resize = resize || icon.getIconWidth() < w - 6;
        boolean bl = resize = resize || icon.getIconWidth() > w + 6;
        if (resize) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(dbPath.getParent().getName()).append("/");
            String filename = dbPath.getName();
            int pos = filename.lastIndexOf(".");
            if (pos != -1) {
                buffer.append(filename.substring(0, pos));
                buffer.append("_").append(w).append("x").append(h);
                buffer.append(".png");
            } else {
                buffer.append(filename);
                buffer.append("_").append(w).append("x").append(h);
            }
            result = buffer.toString();
        }
        if ((dbVersion = this._mapIconModelToVersion.get(dbPath)) == null) {
            dbVersion = dbIcon.getDBFolder();
            this._mapIconModelToVersion.put(dbPath, dbVersion);
        } else if (!dbVersion.equals(dbIcon.getDBFolder())) {
            _LOG.warning("Conflit sur les version d'icone pour : " + dbPath.getRefPath());
        }
        if (!this._setIcon.contains(result)) {
            this._setIcon.add(result);
            ZipEntry zipEntry = new ZipEntry("icones/" + result);
            this._zipStream.putNextEntry(zipEntry);
            if (!resize) {
                byte[] buffer = DBIcon.readImageBytes(dbVersion, this._cecFactory);
                this._zipStream.write(buffer);
            } else {
                this.exportIcon(dbIcon, result, h, w);
            }
            this._zipStream.closeEntry();
        } else if (!dbVersion.equals(dbIcon.getDBFolder())) {
            _LOG.warning("Conflit sur les version d'icone pour : " + dbPath.getRefPath());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportIcon(DBIcon dbIcon, String format, int h, int w) {
        ImageIcon icon = dbIcon.getImage();
        BufferedImage image = new BufferedImage(w, h, 2);
        Graphics2D g2D = null;
        try {
            g2D = image.createGraphics();
            g2D.drawImage(icon.getImage(), 0, 0, w, h, null);
        }
        finally {
            if (g2D != null) {
                g2D.dispose();
            }
        }
        try {
            ImageIO.write((RenderedImage)image, "png", this._zipStream);
        }
        catch (Throwable th) {
            _LOG.severe("Exception during write image : " + th.getMessage() + "\n   " + dbIcon.getDBFolder().getRefPath() + "\t" + format.toLowerCase() + "\t" + w + ";" + h + "\tpng");
        }
    }
}

