/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.trees;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.error.MsgType;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PluginMAction;
import com.dassault.cecilia.core.plugin.PluginModel;
import com.dassault.cecilia.db.DBAccess;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObjModel;
import com.dassault.cecilia.db.DBObject;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.faulttree.DAGImportChoice;
import com.dassault.cecilia.dbobj.faulttree.ft.BoolEquation;
import com.dassault.cecilia.dbobj.faulttree.ft.FTEquation;
import com.dassault.cecilia.dbobj.faulttree.ft.io.dagdef.EquBoolConvert;
import com.dassault.cecilia.dbobj.general.conflict.DBConflict;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.io.trees.UtilityImportTreeAbstract;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.DeflaterInputStream;

public abstract class UtilityImportTreeDag
extends UtilityImportTreeAbstract {
    private static Logger _LOG = Logger.getLogger(UtilityImportTreeDag.class.getPackage().getName());
    public static final String DEFAULT_BIGTREE_MINSIZE = "10ko";
    public static final String PROP_BIGTREE_MINSIZE = "cecilia.ft.import.EquBoolMinSize";
    public static final String PROP_BIGTREE_CHECK = "cecilia.ft.import.EquBoolCheck";
    Plugable _plugable;
    DAGImportChoice _choiceType;

    public UtilityImportTreeDag(Plugable plugable, DAGImportChoice choiceType) {
        super(plugable.getAppl().getDAOFactory(), plugable.getAppl().getDBUser());
        this._choiceType = choiceType;
        this._plugable = plugable;
    }

    public UtilityImportTreeDag(DAOFactory daoFactory, DBUser dbUser, DAGImportChoice choiceType) {
        super(daoFactory, dbUser);
        this._choiceType = choiceType;
        this._plugable = null;
    }

    protected long parseMinSize(String input) {
        try {
            long value;
            int uniteValue;
            long maxValue;
            if (input.toUpperCase().endsWith("MO")) {
                maxValue = (long)Math.pow(2.0, 11.0);
                uniteValue = (int)Math.pow(2.0, 20.0);
                value = Long.parseLong(input.substring(0, input.length() - 2));
            } else if (input.toUpperCase().endsWith("KO")) {
                uniteValue = (int)Math.pow(2.0, 10.0);
                maxValue = (long)Math.pow(2.0, 21.0);
                value = Long.parseLong(input.substring(0, input.length() - 2));
            } else if (input.toUpperCase().endsWith("O")) {
                uniteValue = (int)Math.pow(2.0, 0.0);
                maxValue = (long)Math.pow(2.0, 31.0);
                value = Long.parseLong(input.substring(0, input.length() - 1));
            } else {
                uniteValue = (int)Math.pow(2.0, 0.0);
                maxValue = (long)Math.pow(2.0, 31.0);
                value = Long.parseLong(input);
            }
            if (value >= maxValue) {
                _LOG.warning("Value of 'cecilia.ft.import.EquBoolMinSize' property is too large, set to (2Go - 1) octets : " + input);
            }
            value = Math.min(value, maxValue);
            value = Math.max(0L, value);
            return (long)uniteValue * value;
        }
        catch (Exception e) {
            _LOG.log(Level.WARNING, "Exception during evaluation of 'cecilia.ft.import.EquBoolMinSize' property [" + input + "]", e);
            return -1L;
        }
    }

    public DBFolder doImportFile(File importFile, String dstPath, String strName, DBConflict dbConflict) {
        DAOFolder daoFolder = this.getDAOFactory().createFolderDAO();
        DBFolder dstFolder = daoFolder.findFolder(daoFolder.getRootID("PROJECTS"), dstPath, false);
        if (dstFolder == null) {
            this.addError(importFile, ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_FOLDER", dstPath));
            return null;
        }
        if (dstFolder.getChildren() == null) {
            daoFolder.findChildren(dstFolder);
        }
        return this.doImportFile(importFile, dstFolder, strName, dbConflict);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBFolder doImportFile(File importFile, DBFolder dstFolder, String strName, DBConflict dbConflict) {
        String target;
        String dateGeneration;
        String modelRefPath;
        String userGeneration;
        String initialConf;
        FTEquation ftEquation;
        String ext;
        if (dstFolder == null) {
            throw new NullPointerException();
        }
        _LOG.fine("doImportFile(" + importFile + ", " + dstFolder.getRefPath() + ", " + strName + ", " + dbConflict.getLabel() + ")");
        boolean bBigTree = false;
        DBFolder dbFTVersion = null;
        DBFolder dbFTModel = dstFolder.findChild(strName);
        if (dbFTModel != null) {
            dbFTVersion = this.verifyVersionTargetWhenConflict(importFile, dbFTModel, dbConflict, this._choiceType);
            if (dbFTVersion == null) {
                return null;
            }
            bBigTree = dbFTModel.getFamilyFlag() == 5;
        } else {
            if (this._daoFactory.createFolderDAO().getAccessRight(dstFolder, this.getDBUser()) != DBAccess.Right.WRITE) {
                this.addError(importFile, ResMsgCore.msgFormat("MSG_ERR_ACCESS_WRITE", dstFolder.getRefPath()));
                return null;
            }
            dbConflict = null;
            switch (this._choiceType) {
                case BOOL_FORMULA: {
                    bBigTree = true;
                    break;
                }
                case FAULT_TREE: {
                    bBigTree = false;
                    break;
                }
                case FT_OR_BF: {
                    long limitBigSize;
                    String defineBigSize = System.getProperty(PROP_BIGTREE_MINSIZE, DEFAULT_BIGTREE_MINSIZE);
                    if (defineBigSize == null || (limitBigSize = this.parseMinSize(defineBigSize)) < 0L || importFile.length() <= limitBigSize) break;
                    bBigTree = true;
                }
            }
        }
        if (bBigTree && Boolean.getBoolean(PROP_BIGTREE_CHECK)) {
            PluginModel plugin = this._plugable.getPlugin("com.dassault.cecilia.plugin.faulttree.compute.PluginCmdEngine");
            if (plugin == null || !(plugin instanceof PluginMAction)) {
                _LOG.warning("Don't find plugin 'com.dassault.cecilia.plugin.faulttree.compute.PluginCmdEngine'\nBigTree file doesn't check !");
            } else {
                try {
                    ((PluginMAction)plugin).createSession(this._plugable, importFile);
                }
                catch (Throwable t) {
                    this.addError(importFile, t.getMessage());
                    return null;
                }
            }
        }
        File defFile = null;
        String defName = importFile.getName();
        int defLen = defName.length();
        if (defLen > 4 && ((ext = defName.substring(defLen - 4)).equalsIgnoreCase(".DAG") || ext.equalsIgnoreCase(".ARA"))) {
            defName = defName.substring(0, defLen - 4) + ".def";
            defFile = new File(importFile.getParentFile(), defName);
            if (!defFile.exists()) {
                defFile = null;
            }
        }
        DBFolder dbVersion = null;
        dbVersion = dbConflict == null ? this.createWithoutConflict(dstFolder, strName, bBigTree) : this.createWithConflict(dbConflict, dbFTModel, dbFTVersion, bBigTree);
        if (dbVersion == null) {
            return null;
        }
        FTEquation fTEquation = ftEquation = bBigTree ? new BoolEquation(dbVersion) : new FTEquation(dbVersion);
        if (dbVersion.getID() >= 0L) {
            ftEquation.readLogs(this.getDAOFactory());
        }
        DBLogs.DefaultManager logMng = new DBLogs.DefaultManager(this.getDBUser().getLogin(), ftEquation.getLogs());
        logMng.addLog(DBLogs.DBLevel.FINE, "Import from '" + importFile.getAbsolutePath() + "'");
        Date currentDate = new Date();
        EquBoolConvert ftConvert = new EquBoolConvert((CECFactory)this.getDAOFactory(), logMng, bBigTree);
        if (defFile != null) {
            ftConvert.setProcessLeaves(false);
        }
        boolean error = false;
        try {
            FileInputStream input = new FileInputStream(importFile);
            ftConvert.readDag(new InputStreamReader(input));
            for (DBLogs.Log log : ftEquation.getLogs().getLogs(DBLogs.DBLevel.WARNING)) {
                if (log.getCreate() == null || currentDate.compareTo(log.getCreate()) > 0) continue;
                if (log.getLevel() == DBLogs.DBLevel.ERROR) {
                    this.addError(importFile, MsgType.ERROR, log.getMessage());
                    error = true;
                    continue;
                }
                this.addError(importFile, MsgType.WARNING, log.getMessage());
            }
            if (!error && defFile != null) {
                input = new FileInputStream(defFile);
                ftConvert.readDef(new InputStreamReader(input));
                for (DBLogs.Log log : ftEquation.getLogs().getLogs(DBLogs.DBLevel.WARNING)) {
                    if (log.getCreate() == null || currentDate.compareTo(log.getCreate()) > 0) continue;
                    if (log.getLevel() == DBLogs.DBLevel.ERROR) {
                        this.addError(importFile, MsgType.ERROR, log.getMessage());
                        error = true;
                        continue;
                    }
                    this.addError(importFile, MsgType.WARNING, log.getMessage());
                }
            }
        }
        catch (FileNotFoundException e) {
            _LOG.log(Level.FINE, "Probleme lors de l'import d'un arbre au format dag/def", e);
            this.addError(importFile, MsgType.FATAL, ResMsgCore.getString("FILE_ERROR_READ_ACCESS"));
            error = true;
        }
        if (error) {
            return null;
        }
        FileInputStream inputStream = null;
        if (bBigTree) {
            try {
                inputStream = new FileInputStream(importFile);
            }
            catch (FileNotFoundException e) {
                _LOG.log(Level.WARNING, "Le fichier d'equation est devenu tout a coup inaccessible !!", e);
            }
            if (inputStream != null) {
                DBObject dbObject = dbVersion.getObject();
                DBObjModel model = null;
                if (dbFTModel != null && dbConflict == DBConflict.UPDATE) {
                    model = dbObject.getModel("tree.dag");
                }
                if (model == null) {
                    model = new DBObjModel();
                    model.setNature("tree.dag");
                    dbObject.addModel(model);
                }
                model.setFormat("ARBOR");
                model.setSize(importFile.length());
                model.setStreamToSave(new DeflaterInputStream(inputStream));
            } else {
                this.addError(importFile, MsgType.FATAL, "Y a eu un probl\u00e9me lors de la lecture !!");
                return null;
            }
        }
        ftConvert.prepareEquation(ftEquation);
        String criticity = ftConvert.getReadingCriticity();
        if (criticity != null) {
            ftEquation.setCriticityLevel(criticity);
        }
        if ((initialConf = ftConvert.getReadingInitialConf()) != null) {
            ftEquation.setInitialConfMBSA(initialConf);
        }
        if ((userGeneration = ftConvert.getReadingUserGeneration()) != null) {
            ftEquation.setUserGenerationMBSA(userGeneration);
        }
        if ((modelRefPath = ftConvert.getReadingModelRefPath()) != null) {
            ftEquation.setModelePathMBSA(modelRefPath);
        }
        if ((dateGeneration = ftConvert.getReadingDateGeneration()) != null) {
            ftEquation.setLastModifDataMBSA(dateGeneration);
        }
        if ((target = ftConvert.getReadingTarget()) != null) {
            ftEquation.setTargetMBSA(target);
        }
        try {
            DBFolder dbResult = this.finalizeImportFile(importFile, dbVersion, dbConflict, ftEquation);
            if (dbResult != null) {
                dstFolder.setMustBeUpdated(true);
            }
            DBFolder dBFolder = dbResult;
            return dBFolder;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    _LOG.log(Level.INFO, "Le fichier d'equation ne peut pas se fermer !!", e);
                }
            }
        }
    }
}

