/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.trees.cafta;

import com.dassault.cecilia.io.trees.cafta.ResMsgCafta;

public class CaftaException
extends Exception {
    private final int _line;
    private final Exception _error;
    private final OriginTypeFile _origin;

    public CaftaException(OriginTypeFile origin, String msg, Exception error, int line) {
        super(msg);
        this._origin = origin;
        this._error = error;
        this._line = line;
    }

    public CaftaException(OriginTypeFile origin, Exception err, int line) {
        this(origin, null, err, line);
    }

    public CaftaException(OriginTypeFile origin, String msg, int line) {
        this(origin, msg, null, line);
    }

    public final String displayMessage() {
        StringBuilder sb = new StringBuilder();
        if (this._origin != null) {
            sb.append(CaftaException.getRessourceFromOrigin(this._origin)).append(' ');
        }
        if (this._line != -1) {
            sb.append(this._error == null ? ResMsgCafta.msgFormat("CAFTA_IMPORT_ERROR_AT_LINE", this._line) : ResMsgCafta.msgFormat("CAFTA_IMPORT_EXCEPTION_AT_LINE", this._line));
        }
        sb.append(this._error == null || this.getMessage() != null && this._error != null ? this.getMessage() : (this._error.getMessage() == null ? this._error.toString() : this._error.getMessage()));
        if (this._error != null && this._error instanceof NullPointerException) {
            this._error.printStackTrace();
        }
        return sb.toString();
    }

    public final String displayUserFriendlyMsg() {
        StringBuilder sb = new StringBuilder();
        if (this._line != -1) {
            sb.append(this._error == null ? ResMsgCafta.msgFormat("CAFTA_IMPORT_ERROR_AT_LINE", this._line) : ResMsgCafta.msgFormat("CAFTA_IMPORT_EXCEPTION_AT_LINE", this._line));
        }
        sb.append(this._error == null || this.getMessage() != null && this._error != null ? this.getMessage() : (this._error.getMessage() == null ? this._error.toString() : this._error.getMessage()));
        return sb.toString();
    }

    public static final String getRessourceFromOrigin(OriginTypeFile originException) {
        switch (originException) {
            case BASIC_EVNTS: {
                return ResMsgCafta.getString("CAFTA_IMPORT_FROM_BE_FILE");
            }
            case GATE_DESCRS: {
                return ResMsgCafta.getString("CAFTA_IMPORT_FROM_GATES_DESC_FILE");
            }
            case GATE_INPUTS: {
                return ResMsgCafta.getString("CAFTA_IMPORT_FROM_GATES_INPUT_FILE");
            }
        }
        return null;
    }

    public final OriginTypeFile getOriginException() {
        if (this._error instanceof CaftaException) {
            return ((CaftaException)this._error).getOriginException();
        }
        return this._origin;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CaftaException)) {
            return false;
        }
        CaftaException exception = (CaftaException)obj;
        if (exception.getOriginException() != this.getOriginException()) {
            return false;
        }
        if (exception._line != this._line) {
            return false;
        }
        return exception.displayMessage().equals(this.displayMessage());
    }

    public int hashCode() {
        int hashCode = super.hashCode();
        hashCode += this._line;
        if (this._error != null) {
            hashCode += 2 * this._error.hashCode();
        }
        return hashCode += 3 * this._origin.hashCode();
    }

    public static enum OriginTypeFile {
        GATE_INPUTS,
        GATE_DESCRS,
        BASIC_EVNTS;

    }
}

