/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.xml6;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.wrap.io.SAXWrapHandler;
import com.dassault.cecilia.io.xml6.DBFolderHandlerXml;
import com.dassault.cecilia.io.xml6.DBFolderXmlConstant;
import java.util.Map;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DBRootHandlerXml
extends SAXWrapHandler
implements DBFolderXmlConstant {
    protected DAOFactory _daoFactory;
    DBFolderHandlerXml _childHandler = null;

    public DBRootHandlerXml(DBLogs.DBLogsManager logMng, DAOFactory daoFactory) {
        super(logMng, null);
        this._daoFactory = daoFactory;
    }

    public void startAction(String key, Map<String, String> attrs, boolean startAction) throws SAXException {
        if (this._childHandler != null) {
            this._childHandler.startAction(key, attrs, startAction);
        } else if (startAction) {
            if (!"cec.export".equals(key)) {
                this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_START", "cec.export"), this.getLocator()));
            }
        } else if ("cec.folder".equals(key)) {
            this._childHandler = new DBFolderHandlerXml(this.getLogManager(), this.getLocator(), this._daoFactory);
            this._childHandler.startAction(key, attrs, true);
        } else {
            this.errorElementUnknown(key);
        }
    }

    public boolean endAction(String key, Map<String, String> attrs, String txt) throws SAXException {
        boolean result;
        if (this._childHandler != null && (result = this._childHandler.endAction(key, attrs, txt))) {
            DBFolder dbFolder = this._childHandler.getDBFolder();
            if (dbFolder != null) {
                DAOFolder daoFolder = this._daoFactory.createFolderDAO();
                DBFolder dbRoot = daoFolder.getRootID(dbFolder.getFamily().getRootName());
                dbRoot.getChildren().add(dbFolder);
                dbFolder.setParent(dbRoot);
            }
            this._childHandler = null;
        }
        return "cec.export".equals(key);
    }
}

