/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.cecilia;

import com.dassault.cecilia.core.cecilia.CeciliaRuntimeException;
import com.dassault.cecilia.core.cecilia.export.DBKOutput;
import com.dassault.cecilia.core.cecilia.export.ExpBook;
import com.dassault.cecilia.core.plugin.InfoDatum;
import com.dassault.cecilia.core.plugin.PluginMAction;
import com.dassault.cecilia.core.plugin.PluginModel;
import com.dassault.cecilia.db.DBAccess;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.faulttree.TreeInfoCompute;
import com.dassault.cecilia.dbobj.faulttree.config.FTConfig;
import com.dassault.cecilia.dbobj.faulttree.ft.FTEquation;
import com.dassault.cecilia.dbobj.faulttree.ft.export.XPortCfgTree;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.FTEquationDatumUtility;
import com.dassault.cecilia.dbobj.faulttree.obj.FTVariableAbstract;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import com.dassault.cecilia.main.cecilia.ProcessWordPlugable;
import com.dassault.cecilia.main.cecilia.ResMsgCecilia;
import java.awt.print.PageFormat;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CeciliaBatchTreeCtrl {
    private static Logger _LOG = Logger.getLogger(CeciliaBatchTreeCtrl.class.getPackage().getName());
    CeciliaAppl _appl;

    public CeciliaBatchTreeCtrl(CeciliaAppl appl) {
        this._appl = appl;
    }

    XMLDatumHandler getXMLDatumHandler(String key) {
        XMLDatumHandler handler = null;
        try {
            SAXParserFactory fabrique = SAXParserFactory.newInstance();
            handler = new XMLDatumHandler();
            SAXParser parseur = fabrique.newSAXParser();
            parseur.parse((InputStream)new ByteArrayInputStream(key.getBytes(Charset.forName("UTF-8"))), (DefaultHandler)handler);
        }
        catch (Exception e) {
            _LOG.log(Level.WARNING, "Error during read getDatum for key = " + key, e);
            return null;
        }
        return handler;
    }

    private FTEquation createErrorEquation(StringBuilder buffer, String msg) {
        _LOG.info(msg);
        throw new CeciliaRuntimeException(msg);
    }

    private FTEquation readFTEquation(String treePath, StringBuilder msgError, boolean testIsLocked) {
        CECFactory cecFactory = this._appl.getDAOFactory();
        DAOFolder daoFolder = cecFactory.createFolderDAO();
        DBFolder dbFolder = daoFolder.findFolder("PROJECTS", treePath);
        if (dbFolder == null) {
            return this.createErrorEquation(msgError, ResMsgCecilia.msgFormat("ERR_FTBATCH_FOLDER_UNKNOWN", treePath));
        }
        if (dbFolder.getFamily() != DBFolder.Family.PROJECT) {
            return this.createErrorEquation(msgError, ResMsgCecilia.msgFormat("ERR_FTBATCH_FOLDER_ISNOT_FT", treePath));
        }
        if (dbFolder.getFamilyFlag() != 2 && dbFolder.getFamilyFlag() != 5) {
            return this.createErrorEquation(msgError, ResMsgCecilia.msgFormat("ERR_FTBATCH_FOLDER_ISNOT_FT", treePath));
        }
        if (daoFolder.getAccessRight(dbFolder, this._appl.getDBUser()) == DBAccess.Right.NONE) {
            return this.createErrorEquation(msgError, ResMsgCecilia.msgFormat("ERR_FTBATCH_FOLDER_ACCESS", treePath));
        }
        if (dbFolder.isEdited()) {
            return this.createErrorEquation(msgError, ResMsgCecilia.msgFormat("ERR_FTBATCH_FOLDER_EDITED", treePath));
        }
        if (testIsLocked && dbFolder.isLocked() && !this._appl.getDAOFactory().createObjectDAO().isLockBy(dbFolder.getObject(), this._appl.getDBSession())) {
            return this.createErrorEquation(msgError, ResMsgCecilia.msgFormat("ERR_FTBATCH_FOLDER_LOCKED", treePath));
        }
        DBWrap dbWrap = cecFactory.findOrCreateWrap(dbFolder);
        if (dbWrap == null || !(dbWrap instanceof FTEquation)) {
            return this.createErrorEquation(msgError, ResMsgCecilia.msgFormat("ERR_FTBATCH_FOLDER_UNREAD", treePath));
        }
        return (FTEquation)dbWrap;
    }

    private InfoDatum createErrorDatum(String msg) {
        _LOG.info(msg);
        throw new CeciliaRuntimeException(msg);
    }

    public InfoDatum getDatum(String key) {
        FTConfig ftConfig;
        String strConfig;
        if (!key.startsWith("<?xml")) {
            return null;
        }
        XMLDatumHandler handler = this.getXMLDatumHandler(key);
        if (handler == null) {
            return null;
        }
        StringBuilder bufErr = new StringBuilder();
        FTEquation ftEqu = this.readFTEquation(handler._treePath, bufErr, true);
        if (ftEqu == null) {
            return null;
        }
        if (!ftEqu.instanciate(false, this._appl.getDBUser())) {
            return this.createErrorDatum(ResMsgCecilia.msgFormat("ERR_FTBATCH_EQUATION_UNINSTANCE", handler._treePath));
        }
        String strRoot = handler._treeRoot;
        if (strRoot != null && !strRoot.isEmpty()) {
            FTVariableAbstract ftRoot = ftEqu.getVariable(strRoot);
            if (ftRoot == null) {
                return this.createErrorDatum(ResMsgCecilia.msgFormat("ERR_FTBATCH_VAR_UNKNOWN", strRoot, handler._treePath));
            }
            if (ftRoot.isLeaf()) {
                return this.createErrorDatum(ResMsgCecilia.msgFormat("ERR_FTBATCH_VAR_LEAF", strRoot));
            }
            if (!ftRoot.isIntern()) {
                return this.createErrorDatum(ResMsgCecilia.msgFormat("ERR_FTBATCH_VAR_EXTERNAL", strRoot));
            }
        }
        if (!((strConfig = handler._treeConfig) == null || strConfig.isEmpty() || (ftConfig = ftEqu.getConfig(strConfig)) != null || ftEqu.getConfigs().isEmpty() && strConfig.equalsIgnoreCase("Default"))) {
            return this.createErrorDatum(ResMsgCecilia.msgFormat("ERR_FTBATCH_CONFIG_UNKNOWN", strConfig, handler._treePath));
        }
        if (!this._appl.getDAOFactory().createObjectDAO().isLockBy(ftEqu.getDBFolder().getObject(), this._appl.getDBSession())) {
            if (!this._appl.getDAOFactory().createObjectDAO().lock(ftEqu.getDBFolder().getObject(), this._appl.getDBSession())) {
                return this.createErrorDatum(ResMsgObj.msgFormat("MSG_OBJ_ERR_LOCK", handler._treePath));
            }
            this._appl.refreshDAOFolder(true);
        }
        FTEquationDatumUtility datumUtility = new FTEquationDatumUtility(ftEqu, this._appl.getTopWindow(), this._appl);
        StringBuilder keyDatum = new StringBuilder().append("Tree.Compute.").append(handler._computeType);
        if (handler._treeConfig != null) {
            keyDatum.append("@").append(handler._treeConfig);
            if (handler._treeRoot != null) {
                keyDatum.append("@").append(handler._treeRoot);
            }
        }
        TreeInfoCompute result = null;
        try {
            result = datumUtility.getDatum(keyDatum.toString());
        }
        catch (Throwable th) {
            if (!this._appl.getDAOFactory().createObjectDAO().unlock(ftEqu.getDBFolder().getObject(), this._appl.getDBSession())) {
                _LOG.info(ResMsgObj.msgFormat("MSG_OBJ_ERR_UNLOCK", handler._treePath));
            } else {
                this._appl.refreshDAOFolder(true);
            }
            throw new RuntimeException(th);
        }
        if (result != null) {
            result.getParameters().put("tree.lock", "true");
            result.getParameters().put("tree.open", "false");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setDatum(InfoDatum idatum) {
        PluginModel plugin;
        if (!idatum.getKey().startsWith("<?xml")) {
            return false;
        }
        XMLDatumHandler handler = this.getXMLDatumHandler(idatum.getKey());
        if (handler == null) {
            return false;
        }
        StringBuilder bufErr = new StringBuilder();
        FTEquation ftEqu = this.readFTEquation(handler._treePath, bufErr, false);
        if (ftEqu == null) {
            return true;
        }
        if (!this._appl.getDBSession().equals(ftEqu.getDBFolder().getObject().getLockedSession())) {
            _LOG.info("FT-Equation '" + handler._treePath + "' is locked by another session.");
            return true;
        }
        if (handler._treeUnlock.booleanValue()) {
            if (handler._treeSave.booleanValue()) {
                if (this._appl.getDAOFactory().createFolderDAO().getAccessRight(ftEqu.getDBFolder(), this._appl.getDBUser()) != DBAccess.Right.WRITE) {
                    _LOG.info("Don't access write right for FT-Equation '" + handler._treePath + "'");
                } else if (ftEqu.getDBFolder().getObject().isFreeze()) {
                    _LOG.info("Freeze FT-Equation '" + handler._treePath + "'");
                } else if (!ftEqu.writeToDAO(this._appl.getDAOFactory(), this._appl.getDBUser())) {
                    _LOG.info("Error during save FT-Equation '" + handler._treePath + "'");
                }
            }
            if (!this._appl.getDAOFactory().createObjectDAO().unlock(ftEqu.getDBFolder().getObject(), this._appl.getDBSession())) {
                _LOG.info(ResMsgObj.msgFormat("MSG_OBJ_ERR_UNLOCK", handler._treePath));
            } else {
                this._appl.refreshDAOFolder(true);
            }
            return true;
        }
        FTEquationDatumUtility datumUtility = new FTEquationDatumUtility(ftEqu, this._appl.getTopWindow(), this._appl);
        String oldKey = idatum.getKey();
        try {
            StringBuilder keyDatum = new StringBuilder().append("Tree.Compute.").append(handler._computeType);
            idatum.setKey(keyDatum.toString());
            datumUtility.setDatum(idatum);
        }
        finally {
            idatum.setKey(oldKey);
        }
        if (handler != null && handler._exportFile != null && handler._exportFile.length() > 0 && (plugin = this._appl.getPlugable().getPlugin("com.dassault.cecilia.plugin.export.wordxml.PluginWordXml")) != null && plugin instanceof PluginMAction) {
            try {
                PageFormat pf = new PageFormat();
                pf.setOrientation(Integer.parseInt(handler._exportPageOrientation));
                pf.getPaper().setSize(Integer.parseInt(handler._exportPageWidth), Integer.parseInt(handler._exportPageHeight));
                ExpBook expBook = new ExpBook(this._appl.getDAOFactory());
                expBook.setPageFormat(pf);
                expBook.setPreferencies(this._appl.getPreferencies());
                XPortCfgTree xport = new XPortCfgTree();
                xport.configBook(expBook, ftEqu);
                xport.setTypeExport(XPortCfgTree.TypeExport.ONLY_TREE_VIEW);
                DBKOutput xmlWriter = new DBKOutput(new File(handler._exportFile));
                if (xmlWriter.getXmlOutputFile() != null) {
                    expBook.writeDocbook(xmlWriter);
                    ProcessWordPlugable processPlugable = new ProcessWordPlugable(new File(handler._exportFile), pf, ftEqu.getRefID());
                    ((PluginMAction)plugin).createSession(processPlugable, false);
                }
            }
            catch (Throwable th) {
                _LOG.log(Level.SEVERE, "Probl\u00e8me lors de l'export de l'arbre", th);
            }
        }
        return true;
    }

    static class XMLDatumHandler
    extends DefaultHandler {
        String _treePath = null;
        String _computeType = null;
        String _treeConfig = null;
        String _treeRoot = null;
        Boolean _treeClose = false;
        Boolean _treeUnlock = false;
        Boolean _treeSave = false;
        String _exportFile = null;
        String _exportForOneHour = null;
        String _exportPageOrientation = null;
        String _exportPageWidth = null;
        String _exportPageHeight = null;
        String _exportGSRAuto = null;
        String _exportGSRLevel = null;

        XMLDatumHandler() {
        }

        private String getAttribute(Attributes attrs, String name, boolean opt) throws SAXException {
            int idx = attrs.getIndex(name);
            if (idx != -1) {
                return attrs.getValue(idx);
            }
            if (opt) {
                return null;
            }
            throw new SAXException("No attribute '" + name + "'");
        }

        @Override
        public void startElement(String uri, String sName, String qName, Attributes attrs) throws SAXException {
            String eltName;
            String string = eltName = "".equals(sName) ? qName : sName;
            if (eltName.equals("compute")) {
                this._computeType = this.getAttribute(attrs, "type", false);
            }
            if (eltName.equals("export")) {
                this._exportFile = this.getAttribute(attrs, "file", false);
                this._exportForOneHour = this.getAttribute(attrs, "forOneHour", false);
                this._exportPageOrientation = this.getAttribute(attrs, "pageOrientation", false);
                this._exportPageWidth = this.getAttribute(attrs, "pageWidth", false);
                this._exportPageHeight = this.getAttribute(attrs, "pageHeight", false);
                this._exportGSRAuto = this.getAttribute(attrs, "gsrAuto", false);
                this._exportGSRLevel = this.getAttribute(attrs, "gsrLevel", false);
            }
            if (eltName.equals("tree")) {
                this._treePath = this.getAttribute(attrs, "path", false);
                this._treeConfig = this.getAttribute(attrs, "config", false);
                this._treeRoot = this.getAttribute(attrs, "root", true);
                int idx = attrs.getIndex("closeIfOpen");
                if (idx != -1) {
                    this._treeClose = attrs.getValue(idx).equals("true");
                }
                if ((idx = attrs.getIndex("unlock")) != -1) {
                    this._treeUnlock = attrs.getValue(idx).equals("true");
                }
                if ((idx = attrs.getIndex("save")) != -1) {
                    this._treeSave = attrs.getValue(idx).equals("true");
                }
            }
        }
    }
}

