/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.cecilia.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.plugin.IModel;
import com.dassault.cecilia.core.plugin.PlugModel;
import com.dassault.cecilia.core.plugin.PlugPanel;
import com.dassault.cecilia.core.plugin.PlugPanelExtend;
import com.dassault.cecilia.core.pluginmanager.ExtendedPlugable;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.taskmanager.ResTask;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.main.cecilia.CeciliaGUI;
import com.dassault.cecilia.main.cecilia.gui.CInternalFrame;
import java.awt.BorderLayout;
import java.awt.Window;
import javax.swing.Icon;
import javax.swing.JOptionPane;

public class CPlugPanel
extends CInternalFrame
implements PlugModel {
    PlugPanel _panel;
    boolean _persist;
    ExtendedPlugable _plugable;
    DBFolder _dbFolder;

    public CPlugPanel(PlugPanel panel, ExtendedPlugable plugable) {
        this(panel, plugable, false);
    }

    public CPlugPanel(PlugPanel panel, ExtendedPlugable plugable, boolean persist) {
        super(panel.getInfo("plugin.name"));
        Icon icon;
        this._panel = panel;
        this._plugable = plugable;
        this._persist = persist;
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(panel.getPanel(), "Center");
        this.getContentPane().add(this.createClosePanel(), "South");
        if (this._panel instanceof PlugPanelExtend) {
            ((PlugPanelExtend)this._panel).configCloseable(new PlugPanelExtend.HelperClose(){

                @Override
                public void close(PlugPanelExtend plug) {
                    if (CPlugPanel.this.isClosed()) {
                        return;
                    }
                    CPlugPanel.this.doDefaultCloseAction();
                }
            });
        }
        int width = 300;
        String size = panel.getInfo("ppanel.default.width");
        if (size != null) {
            try {
                width = Integer.parseInt(size);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        int height = 300;
        String size2 = panel.getInfo("ppanel.default.height");
        if (size2 != null) {
            try {
                height = Integer.parseInt(size2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.pack();
        this.setSize(width, height);
        String panelTitle = panel.getInfo("ppanel.title");
        if (panelTitle == null) {
            panelTitle = "External frame";
        }
        this.setTitle(panelTitle);
        String panelButton = panel.getInfo("ppanel.button");
        if (panelButton != null) {
            this.setIconText(panelButton);
        }
        if ((icon = panel.getIcon("ppanel.icon")) != null) {
            this.setFrameIcon(icon);
            this.setButtonIcon(icon);
        }
    }

    public void setDBFolder(DBFolder dbFolder) {
        this._dbFolder = dbFolder;
    }

    @Override
    public DBFolder getDBFolder() {
        return this._dbFolder;
    }

    @Override
    public boolean print() {
        PlugPanelExtend xPanel;
        if (this._panel instanceof PlugPanelExtend && (xPanel = (PlugPanelExtend)this._panel).isPrinting()) {
            xPanel.print();
            return true;
        }
        return super.print();
    }

    @Override
    public boolean preview() {
        PlugPanelExtend xPanel;
        if (this._panel instanceof PlugPanelExtend && (xPanel = (PlugPanelExtend)this._panel).isPreviewing()) {
            xPanel.preview();
            return true;
        }
        return super.print();
    }

    @Override
    public Object export(String format) {
        if (this._panel instanceof PlugPanelExtend && format != null) {
            PlugPanelExtend xPanel = (PlugPanelExtend)this._panel;
            if (format.equalsIgnoreCase("DOCBOOK") && this._plugable.getPageFormat("docbook.file") != null) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._plugable.getWindow()), ResMsgCore.getString("KEY_1173"), ResMsgVoc.getString("VOC_WARNING"), 2);
                return null;
            }
            if (xPanel.isExporting(format)) {
                return xPanel.export(format);
            }
        }
        return null;
    }

    @Override
    public void toDoWhenActivated() {
        Window win;
        super.toDoWhenActivated();
        if (this._panel instanceof PlugPanelExtend && (win = this._plugable.getWindow()) != null && win instanceof CeciliaGUI) {
            ((CeciliaGUI)win).getAction("PRINT").setEnabled(((PlugPanelExtend)this._panel).isPrinting());
            ((CeciliaGUI)win).getAction("PRINT_PREVIEW").setEnabled(((PlugPanelExtend)this._panel).isPreviewing());
        }
    }

    @Override
    public void toDoWhenDeActivated() {
        Window win;
        super.toDoWhenDeActivated();
        if (this._panel instanceof PlugPanelExtend && (win = this._plugable.getWindow()) != null && win instanceof CeciliaGUI) {
            ((CeciliaGUI)win).getAction("PRINT").setEnabled(false);
            ((CeciliaGUI)win).getAction("PRINT_PREVIEW").setEnabled(false);
        }
    }

    @Override
    public void toDoWhenBeClosed() {
        if (!this._persist) {
            this._panel.trash();
            this._panel = null;
        }
        super.toDoWhenBeClosed();
    }

    @Override
    public String getInfo(String key) {
        if (this._panel instanceof PlugModel) {
            return ((PlugModel)((Object)this._panel)).getInfo(key);
        }
        return null;
    }

    @Override
    public IModel getModel(String key) {
        if (this._panel instanceof PlugModel) {
            return ((PlugModel)((Object)this._panel)).getModel(key);
        }
        return null;
    }

    @Override
    public boolean isCachedDesktopManager() {
        String info = this.getInfo("ppanel.title");
        return info == null || !info.equals(ResTask.getString("PAN_TASK_TITLE"));
    }
}

