/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.general.treatment;

import com.dassault.cecilia.core.plugin.IOParameters;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PluginManager;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.other.JCRLabel;
import com.dassault.cecilia.plugin.general.treatment.ExecParametersIO;
import com.dassault.cecilia.plugin.general.treatment.ResTreatment;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class ExecParameters {
    String _exec;
    String _args;
    String _dir;
    boolean _shellExec;
    protected static IOParameters _instance = new ExecParametersIO();

    public String getExec() {
        if (this._exec == null) {
            return "";
        }
        return this._exec;
    }

    public String getArgs() {
        return this._args;
    }

    public String getDir() {
        return this._dir;
    }

    public boolean isShellExec() {
        return this._shellExec;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(128);
        sb.append(ResTreatment.getString("DLG_PARAMS_SHELL_EXE_BIN"));
        sb.append(" : ").append(this._exec).append("\n");
        sb.append(ResTreatment.getString("DLG_PARAMS_SHELL_EXE_ARGS"));
        sb.append(" : ").append(this._args).append("\n");
        if (this._dir.length() > 0) {
            sb.append(ResTreatment.getString("DLG_PARAMS_SHELL_EXE_PATH"));
            sb.append(" : ").append(this._dir).append("\n");
        }
        return sb.toString();
    }

    public ExecParameters() {
        this._exec = null;
        this._args = "%{file}";
        this._dir = ".";
        this._shellExec = false;
    }

    public ExecParameters(String exec) {
        this._exec = exec;
        this._args = "%{file}";
        this._dir = ".";
        this._shellExec = false;
    }

    public ExecParameters(ExecParameters src) {
        this._exec = src._exec;
        this._args = src._args;
        this._dir = src._dir;
        this._shellExec = src._shellExec;
    }

    public boolean VerifyData(Plugable launcher) {
        if (this._exec.length() == 0) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)launcher.getWindow()), ResTreatment.msgFormat("PRV_SHELL_ERR_BIN", this._exec));
            return false;
        }
        if (!this._args.contains("%{file}")) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)launcher.getWindow()), ResTreatment.msgFormat("PRV_SHELL_ERR_ARGS", this._args));
            return false;
        }
        if (!new File(this._dir).isDirectory()) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)launcher.getWindow()), ResTreatment.msgFormat("PRV_SHELL_ERR_DIR", this._dir));
            return false;
        }
        return true;
    }

    public boolean change(PluginManager launcher) {
        Window win = launcher.getWindow();
        if (win != null) {
            win = SwingUtilities.getWindowAncestor(launcher.getWindow());
        }
        if (win == null) {
            win = launcher.getWindow();
        }
        DlgChange dlg = new DlgChange(win);
        dlg._ctrlBin.setText(this._exec);
        dlg._ctrlArgs.setText(this._args);
        dlg._ctrlPath.setText(this._dir);
        dlg._ctrlIsShell.setSelected(this._shellExec);
        dlg.setVisible(true);
        if (dlg.getResult()) {
            this._exec = dlg._ctrlBin.getText().trim();
            this._args = dlg._ctrlArgs.getText();
            this._dir = dlg._ctrlPath.getText();
            this._shellExec = dlg._ctrlIsShell.isSelected();
            return true;
        }
        return false;
    }

    public static IOParameters getIOParameters() {
        return _instance;
    }

    class DlgChange
    extends JDialogCecilia {
        JTextField _ctrlBin;
        JTextField _ctrlPath;
        JTextField _ctrlArgs;
        JCheckBox _ctrlIsShell;

        public DlgChange(Window owner) {
            super(owner, true);
            this.init();
        }

        protected JPanel createExePanel() {
            JPanel root = new JPanel(new GridBagLayout());
            root.setBorder(BorderFactory.createTitledBorder(ResTreatment.getString("DLG_PARAMS_SHELL_EXE_TITLE")));
            int line = 0;
            root.add((Component)new JCRLabel(ResTreatment.getString("DLG_PARAMS_SHELL_EXE_BIN")), new GridBagConstraints(0, line, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this._ctrlBin = new JTextField(20);
            root.add((Component)this._ctrlBin, new GridBagConstraints(1, line++, 1, 1, 100.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
            root.add((Component)new JCRLabel(ResTreatment.getString("DLG_PARAMS_SHELL_EXE_PATH")), new GridBagConstraints(0, line, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this._ctrlPath = new JTextField(20);
            root.add((Component)this._ctrlPath, new GridBagConstraints(1, line++, 1, 1, 100.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
            root.add((Component)new JCRLabel(ResTreatment.getString("DLG_PARAMS_SHELL_EXE_ARGS")), new GridBagConstraints(0, line, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this._ctrlArgs = new JTextField(20);
            root.add((Component)this._ctrlArgs, new GridBagConstraints(1, line++, 1, 1, 100.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
            this._ctrlIsShell = new JCheckBox(ResTreatment.getString("DLG_PARAMS_SHELL_EXE_JNI"));
            root.add((Component)this._ctrlIsShell, new GridBagConstraints(0, line++, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this._ctrlIsShell.setVisible(false);
            JButton defVal = new JButton(ResTreatment.getString("DLG_DEFVALUE"));
            defVal.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DlgChange.this._ctrlBin.setText("");
                    DlgChange.this._ctrlPath.setText(".");
                    DlgChange.this._ctrlArgs.setText("%{file}");
                    DlgChange.this._ctrlIsShell.setSelected(false);
                }
            });
            root.add((Component)defVal, new GridBagConstraints(0, line++, 2, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            return root;
        }

        protected void init() {
            super.init();
            JPanel rPanel = new JPanel(new GridBagLayout());
            rPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            rPanel.add((Component)this.createExePanel(), new GridBagConstraints(0, 0, 1, 1, 100.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            rPanel.add((Component)this.createButPanel(), new GridBagConstraints(0, 1, 1, 1, 100.0, 100.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)rPanel, "Center");
            this.pack();
            Dimension tSize = this.getSize();
            Dimension pSize = this.getOwner().getSize();
            Point pLoc = this.getOwner().getLocation();
            this.setLocation(pLoc.x + pSize.width / 2 - tSize.width / 2, pLoc.y + pSize.height / 2 - tSize.height / 2);
            this.setTitle(ResTreatment.getString("DLG_PARAMS_SHELL_TITLE"));
        }

        protected boolean verifyParameters() {
            if (this._ctrlBin.getText().trim().length() == 0) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)((Object)this)), ResTreatment.msgFormat("PRV_SHELL_ERR_BIN", this._ctrlBin.getText()));
                return false;
            }
            if (!new File(this._ctrlPath.getText()).isDirectory()) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)((Object)this)), ResTreatment.msgFormat("PRV_SHELL_ERR_DIR", this._ctrlPath.getText()));
                return false;
            }
            return true;
        }
    }
}

