/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.general.treatment;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.plugin.DefaultIOParameters;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.lib.util.format.StringCodec;
import com.dassault.cecilia.plugin.general.treatment.MapStringToStringPanel;
import com.dassault.cecilia.plugin.general.treatment.ResTreatment;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XsltFactory {
    private static final Logger __logger = Logger.getLogger(XsltFactory.class.getPackage().getName());
    String _name = null;
    Map<String, String> _attributes = new LinkedHashMap<String, String>();

    public String getName() {
        return this._name;
    }

    public Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this._attributes);
    }

    String save() {
        StringBuffer out = new StringBuffer(256);
        this.saveXML(out);
        return out.toString();
    }

    void save(StringBuffer out) {
        out.append("(");
        if (this._name != null) {
            out.append("\"");
            StringCodec.encodeTxt((String)this._name, (StringBuffer)out);
            out.append("\", {");
            Iterator<Map.Entry<String, String>> iter = this._attributes.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, String> attr = iter.next();
                out.append("(\"");
                StringCodec.encodeTxt((String)attr.getKey(), (StringBuffer)out);
                out.append("\", \"");
                StringCodec.encodeTxt((String)attr.getValue(), (StringBuffer)out);
                out.append("\")");
                if (!iter.hasNext()) continue;
                out.append(", ");
            }
        }
        out.append(")");
    }

    void saveXML(StringBuffer out) {
        if (this._name != null) {
            out.append("<factory name=\"");
            out.append(DefaultIOParameters.toXML((String)this._name));
            out.append("\"");
            if (this._attributes.size() > 0) {
                out.append(">");
                for (Map.Entry<String, String> attr : this._attributes.entrySet()) {
                    out.append("<attribute name=\"");
                    out.append(DefaultIOParameters.toXML((String)attr.getKey()));
                    out.append("\" value=\"");
                    out.append(DefaultIOParameters.toXML((String)attr.getValue()));
                    out.append("\"/>");
                }
                out.append("</factory>");
            } else {
                out.append("/>");
            }
        }
    }

    boolean load(String factory) {
        if (factory.trim().length() == 0) {
            this._name = null;
            this._attributes.clear();
            return true;
        }
        return this.loadXML(factory);
    }

    boolean loadXML(String factory) {
        if (!factory.startsWith("<?xml ")) {
            factory = "<?xml version=\"1.0\"?>\n" + factory;
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        dbf.setIgnoringComments(true);
        dbf.setIgnoringElementContentWhitespace(true);
        dbf.setCoalescing(false);
        dbf.setExpandEntityReferences(true);
        DocumentBuilder db = null;
        Document doc = null;
        try {
            db = dbf.newDocumentBuilder();
            db.setErrorHandler(new ErrorHandler(){

                @Override
                public void error(SAXParseException exception) throws SAXException {
                    __logger.log(Level.WARNING, "Exception during load factory configuration", exception);
                }

                @Override
                public void fatalError(SAXParseException exception) throws SAXException {
                    __logger.log(Level.WARNING, "Exception during load factory configuration", exception);
                }

                @Override
                public void warning(SAXParseException exception) throws SAXException {
                    __logger.log(Level.INFO, "Exception during load factory configuration", exception);
                }
            });
            doc = db.parse(new ByteArrayInputStream(factory.getBytes()));
        }
        catch (ParserConfigurationException pce) {
            __logger.log(Level.WARNING, "Exception during load factory configuration", pce);
            return false;
        }
        catch (SAXException se) {
            __logger.log(Level.WARNING, "Exception during load factory configuration", se);
            return false;
        }
        catch (IOException ioe) {
            __logger.log(Level.WARNING, "Exception during load factory configuration", ioe);
            return false;
        }
        return this.loadXML(doc.getFirstChild());
    }

    private static String getAttribut(Node n, String key) {
        if (!n.hasAttributes()) {
            return null;
        }
        NamedNodeMap atts = n.getAttributes();
        for (int i = 0; i < atts.getLength(); ++i) {
            Node att = atts.item(i);
            if (att.getNodeType() != 2 || !key.equals(att.getNodeName())) continue;
            return att.getNodeValue();
        }
        return null;
    }

    boolean loadXML(Node data) {
        if (data.getNodeType() != 1) {
            __logger.warning("Parsing error : current node is not an element");
            return false;
        }
        if (!data.getNodeName().equals("factory")) {
            __logger.warning("Parsing error : current node is not a 'factory' element : " + data.getNodeName());
            return false;
        }
        String name = XsltFactory.getAttribut(data, "name");
        if (name == null || name.trim().length() == 0) {
            __logger.warning("Parsing error : 'factory' without 'name' attribute");
            return false;
        }
        LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
        for (Node child = data.getFirstChild(); child != null; child = child.getNextSibling()) {
            String childName;
            if (child.getNodeType() != 1 || !(childName = child.getNodeName()).equals("attribute")) continue;
            String attrName = XsltFactory.getAttribut(child, "name");
            if (attrName == null || attrName.trim().length() == 0) {
                __logger.warning("Parsing error : 'attribute' without 'name' attribute");
                return false;
            }
            String attrValue = XsltFactory.getAttribut(child, "value");
            if (attrValue == null || attrValue.trim().length() == 0) {
                __logger.warning("Parsing error : 'attribute' without 'value' attribute");
                return false;
            }
            if ((attrValue = attrs.put(attrName, attrValue)) == null) continue;
            __logger.info("Attribute of factory already exist : name='" + attrName + "', oldvalue='" + attrValue + "'");
        }
        this._name = name;
        this._attributes = attrs;
        return true;
    }

    String resume() {
        if (this._name == null) {
            return ResTreatment.getString("XSLT_FACTORY_DEFAULT");
        }
        StringBuffer sb = new StringBuffer(256);
        sb.append(ResTreatment.getString("XSLT_FACTORY_EXPLAIN"));
        sb.append("\n\n");
        sb.append(ResMsgVoc.getString((String)"VOC_NAME"));
        sb.append(" : ").append(this._name).append("\n");
        if (this._attributes.size() > 0) {
            sb.append(ResTreatment.getString("XSLT_ATTRIBUTES"));
            sb.append(" : \n");
            for (Map.Entry<String, String> attr : this._attributes.entrySet()) {
                sb.append("\t").append(attr.getKey());
                sb.append(" = ").append(attr.getValue()).append("\n");
            }
        }
        return sb.toString();
    }

    boolean modify(JComponent owner) {
        Window win = SwingUtilities.getWindowAncestor(owner);
        DlgChangeFactory dlg = new DlgChangeFactory(win);
        if (this._name == null) {
            dlg._ctrlName.setText("");
        } else {
            dlg._ctrlName.setText(this._name);
        }
        dlg._panelAttributs.setData(this._attributes);
        dlg.setVisible(true);
        boolean result = dlg.getResult();
        if (result) {
            this._name = dlg._ctrlName.getText();
            this._attributes = dlg._panelAttributs.getData();
        } else {
            this._name = null;
            this._attributes = new LinkedHashMap<String, String>();
        }
        return result;
    }

    class DlgChangeFactory
    extends JDialogCecilia {
        JCheckBox _ctrlSpecific;
        JLabel _lblName;
        JTextField _ctrlName;
        JButton _butDefName;
        MapStringToStringPanel _panelAttributs;

        public DlgChangeFactory(Window win) {
            super(win, true);
            this.init();
        }

        protected JComponent createInfoPanel() {
            JTextArea txtArea = new JTextArea(ResTreatment.getString("XSLT_FACTORY_EXPLAIN"));
            txtArea.setEditable(false);
            txtArea.setBackground(new JLabel().getBackground());
            txtArea.setSelectedTextColor(txtArea.getForeground());
            return txtArea;
        }

        protected JComponent createDataPanel() {
            JPanel xOptPanel = new JPanel(new GridBagLayout());
            this._lblName = new JLabel(ResTreatment.getString("XSLT_FACTORY"));
            xOptPanel.add((Component)this._lblName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            this._ctrlName = new JTextField(20);
            xOptPanel.add((Component)this._ctrlName, new GridBagConstraints(1, 0, 1, 1, 10.0, 0.0, 13, 2, new Insets(5, 5, 5, 0), 0, 0));
            this._butDefName = new JButton("<=");
            this._butDefName.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TransformerFactory tf = TransformerFactory.newInstance();
                    DlgChangeFactory.this._ctrlName.setText(tf.getClass().getName());
                }
            });
            xOptPanel.add((Component)this._butDefName, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 5, 5), 0, 0));
            this._panelAttributs = new MapStringToStringPanel(ResTreatment.getString("XSLT_ATTRIBUTES"));
            xOptPanel.add((Component)this._panelAttributs, new GridBagConstraints(0, 1, 3, 1, 10.0, 10.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            return xOptPanel;
        }

        protected void init() {
            super.init();
            JPanel rPanel = new JPanel(new GridBagLayout());
            rPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            rPanel.add((Component)this.createInfoPanel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 15, 5), 0, 0));
            rPanel.add((Component)this.createDataPanel(), new GridBagConstraints(0, 1, 1, 1, 10.0, 10.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            rPanel.add((Component)this.createButPanel(), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)rPanel, "Center");
            this.pack();
            Dimension tSize = this.getSize();
            Dimension pSize = this.getOwner().getSize();
            Point pLoc = this.getOwner().getLocation();
            this.setLocation(pLoc.x + pSize.width / 2 - tSize.width / 2, pLoc.y + pSize.height / 2 - tSize.height / 2);
            this.setTitle(ResTreatment.getString("XSLT_FACTORY"));
        }

        protected boolean verifyParameters() {
            String factoryName = this._ctrlName.getText().trim();
            if (factoryName.length() > 0) {
                block3: {
                    try {
                        Class<?> clazz = Class.forName(factoryName);
                        TransformerFactory tf = (TransformerFactory)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        tf.toString();
                    }
                    catch (Exception e) {
                        if (JOptionPane.showConfirmDialog(JOptionCecilia.getTopContainerOf((Component)this._ctrlName), ResTreatment.msgFormat("XSLT_FACTORY_NAME_ERROR", e.getClass().getSimpleName(), e.getMessage()), ResMsgVoc.getString((String)"VOC_ERROR"), 0) != 1) break block3;
                        this._ctrlName.requestFocus();
                        return false;
                    }
                }
                return this._panelAttributs.verifyData(true);
            }
            return true;
        }
    }
}

