/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.loader;

import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.impl.peergroup.CompatibilityEquater;
import net.jxta.logging.Logging;
import net.jxta.platform.JxtaLoader;
import net.jxta.platform.Module;
import net.jxta.platform.ModuleSpecID;
import net.jxta.protocol.ModuleImplAdvertisement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefJxtaLoader
extends JxtaLoader {
    private static final transient Logger LOG = Logger.getLogger(RefJxtaLoader.class.getName());
    private final CompatibilityEquater equator;
    private final Map<ModuleSpecID, Map<String, Class<? extends Module>>> classes = new HashMap<ModuleSpecID, Map<String, Class<? extends Module>>>();
    private final Map<Class<? extends Module>, ModuleImplAdvertisement> implAdvs = new WeakHashMap<Class<? extends Module>, ModuleImplAdvertisement>();

    public RefJxtaLoader(URL[] urls, CompatibilityEquater equator) {
        this(urls, RefJxtaLoader.class.getClassLoader(), equator);
    }

    public RefJxtaLoader(URL[] urls, ClassLoader parent, CompatibilityEquater equator) {
        super(urls, parent);
        this.equator = equator;
    }

    protected Class<? extends Module> loadClass(String name, URL url, boolean resolve) throws ClassNotFoundException {
        try {
            return this.loadClass(name, resolve);
        }
        catch (ClassNotFoundException e) {
            if (url != null) {
                this.addURL(url);
                return this.loadClass(name, resolve);
            }
            throw e;
        }
    }

    public Class<? extends Module> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> newClass = this.findLoadedClass(name);
        if (newClass == null) {
            try {
                newClass = super.loadClass(name, false);
            }
            catch (ClassNotFoundException ignored) {
                // empty catch block
            }
        }
        if (newClass == null) {
            try {
                newClass = this.findSystemClass(name);
                if (newClass != null) {
                    return newClass;
                }
            }
            catch (ClassNotFoundException ignored) {
                // empty catch block
            }
            if (newClass == null) {
                try {
                    newClass = Thread.currentThread().getContextClassLoader().loadClass(name);
                    if (newClass != null) {
                        return newClass;
                    }
                }
                catch (ClassNotFoundException ignored) {
                    // empty catch block
                }
            }
        }
        if (resolve) {
            this.resolveClass(newClass);
        }
        return newClass;
    }

    @Override
    public synchronized Class<? extends Module> findClass(ModuleSpecID spec) throws ClassNotFoundException {
        Map<String, Class<? extends Module>> compats = this.classes.get(spec);
        if (null == compats) {
            throw new ClassNotFoundException("No matching class for : " + spec);
        }
        for (Map.Entry<String, Class<? extends Module>> anEntry : compats.entrySet()) {
            StructuredDocument asDoc;
            String aCompat = anEntry.getKey();
            try {
                asDoc = StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, new StringReader(aCompat));
            }
            catch (IOException ignored) {
                continue;
            }
            if (!this.equator.compatible(asDoc)) continue;
            return anEntry.getValue();
        }
        throw new ClassNotFoundException(spec.toString());
    }

    @Override
    public Class<? extends Module> loadClass(ModuleSpecID spec) throws ClassNotFoundException {
        Class<? extends Module> found = this.findClass(spec);
        this.resolveClass(found);
        return found;
    }

    public Class<? extends Module> loadClass(String name, URL url) throws ClassNotFoundException {
        return this.loadClass(name, url, true);
    }

    @Override
    public synchronized Class<? extends Module> defineClass(ModuleImplAdvertisement impl) throws ClassFormatError {
        Class<? extends Module> loaded;
        String asString = impl.getCompat().toString();
        Map<String, Class<? extends Module>> compats = this.classes.get(impl.getModuleSpecID());
        if (null == compats) {
            compats = new HashMap<String, Class<? extends Module>>();
            this.classes.put(impl.getModuleSpecID(), compats);
        }
        if (null == (loaded = compats.get(asString))) {
            try {
                loaded = this.loadClass(impl.getCode(), new URL(impl.getUri()), false);
            }
            catch (ClassNotFoundException failed) {
                throw new ClassFormatError("Class '" + impl.getCode() + "' could not be loaded from : " + impl.getUri());
            }
            catch (MalformedURLException failed) {
                throw new ClassFormatError("Cannot load class '" + impl.getCode() + "' from : " + impl.getUri());
            }
            compats.put(asString, loaded);
        }
        this.implAdvs.put(loaded, impl);
        return loaded;
    }

    public ModuleImplAdvertisement findModuleImplAdvertisement(Class clazz) {
        ModuleImplAdvertisement result = this.implAdvs.get(clazz);
        if (null == result) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "No module imp adv for " + clazz);
            }
            return null;
        }
        return result.clone();
    }

    @Override
    public ModuleImplAdvertisement findModuleImplAdvertisement(ModuleSpecID msid) {
        Class<? extends Module> moduleClass;
        try {
            moduleClass = this.findClass(msid);
        }
        catch (ClassNotFoundException failed) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "Failed to find class for " + msid, failed);
            }
            return null;
        }
        if (null == moduleClass) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "No class for " + msid);
            }
            return null;
        }
        return this.findModuleImplAdvertisement((Class)moduleClass);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Classes : ");
        for (Map.Entry<ModuleSpecID, Map<String, Class<? extends Module>>> eachMCID : this.classes.entrySet()) {
            ModuleSpecID mcid = eachMCID.getKey();
            result.append("\n\t" + mcid + " :");
            for (Map.Entry<String, Class<? extends Module>> eachClass : eachMCID.getValue().entrySet()) {
                result.append("\n\t\t" + eachClass.getValue().toString());
            }
        }
        return result.toString();
    }
}

