/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.membership.pse;

import java.net.URI;
import java.security.KeyStoreException;
import java.security.NoSuchProviderException;
import net.jxta.exception.PeerGroupException;
import net.jxta.impl.membership.pse.CMKeyStoreManager;
import net.jxta.impl.membership.pse.KeyStoreManager;
import net.jxta.impl.membership.pse.PSEMembershipService;
import net.jxta.impl.membership.pse.URIKeyStoreManager;
import net.jxta.impl.protocol.PSEConfigAdv;

public abstract class PSEKeyStoreManagerFactory {
    private static PSEKeyStoreManagerFactory defaultGenerator = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefault(PSEKeyStoreManagerFactory newDefault) {
        Class<PSEKeyStoreManagerFactory> clazz = PSEKeyStoreManagerFactory.class;
        synchronized (PSEKeyStoreManagerFactory.class) {
            defaultGenerator = newDefault;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PSEKeyStoreManagerFactory getDefault() {
        Class<PSEKeyStoreManagerFactory> clazz = PSEKeyStoreManagerFactory.class;
        synchronized (PSEKeyStoreManagerFactory.class) {
            if (defaultGenerator == null) {
                defaultGenerator = new PSEKeyStoreManagerFactoryDefault();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultGenerator;
        }
    }

    public abstract KeyStoreManager getInstance(PSEMembershipService var1, PSEConfigAdv var2) throws PeerGroupException;

    private static class PSEKeyStoreManagerFactoryDefault
    extends PSEKeyStoreManagerFactory {
        private PSEKeyStoreManagerFactoryDefault() {
        }

        public KeyStoreManager getInstance(PSEMembershipService service, PSEConfigAdv config) throws PeerGroupException {
            URI location = config.getKeyStoreLocation();
            try {
                KeyStoreManager store_manager;
                if (null == location) {
                    store_manager = new CMKeyStoreManager(config.getKeyStoreType(), config.getKeyStoreProvider(), service.getGroup(), service.getAssignedID());
                } else {
                    if (!location.isAbsolute()) {
                        location = service.group.getStoreHome().resolve(location);
                    }
                    store_manager = new URIKeyStoreManager(config.getKeyStoreType(), config.getKeyStoreProvider(), location);
                }
                return store_manager;
            }
            catch (NoSuchProviderException not_available) {
                throw new PeerGroupException("Requested KeyStore provider not available", not_available);
            }
            catch (KeyStoreException bad) {
                throw new PeerGroupException("KeyStore failure initializing KeyStoreManager", bad);
            }
        }
    }
}

