/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.cstepper;

import com.dassault.cecilia.core.cecilia.stepper.ViewStepper;
import com.dassault.cecilia.core.plugin.AbstractPlugTaskBanWithLog;
import com.dassault.cecilia.core.plugin.IModel;
import com.dassault.cecilia.core.plugin.PlugPanel;
import com.dassault.cecilia.core.plugin.PlugTask;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PlugableProxyModel;
import com.dassault.cecilia.core.plugin.PlugableUtility;
import com.dassault.cecilia.core.plugin.PluginMAction;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.lib.ban.BanEntry;
import com.dassault.cecilia.lib.ban.BanInputStream;
import com.dassault.cecilia.lib.mbsa.Stepper;
import com.dassault.cecilia.lib.mbsa.StepperException;
import com.dassault.cecilia.lib.mbsa.stepper.BanStepper;
import com.dassault.cecilia.lib.util.ResIcoAbstract;
import com.dassault.cecilia.lib.util.io.FileUtility;
import com.dassault.cecilia.plugin.mbsa.cstepper.BanInferencePlugin;
import com.dassault.cecilia.plugin.mbsa.cstepper.DlgTargetsITree;
import com.dassault.cecilia.plugin.mbsa.cstepper.PluginInference;
import com.dassault.cecilia.plugin.mbsa.cstepper.ResCStep;
import com.dassault.cecilia.plugin.mbsa.cstepper.UtilityPluginTargetsXTree;
import com.dassault.cecilia.plugin.mbsa.viewer.DefaultFileFilter;
import com.dassault.cecilia.plugin.mbsa.viewer.DlgTargetsSelection;
import com.dassault.cecilia.plugin.mbsa.viewer.TargetModel;
import com.dassault.cecilia.plugin.mbsa.viewer.ban.BatchTreeImport;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PluginCmdXTree
extends PluginInference
implements PluginMAction {
    private static Logger _LOG = Logger.getLogger(PluginCmdXTree.class.getPackage().getName());
    public static final String OPT_EXEC = PluginCmdXTree.class.getName() + "#Execute";
    public static final String OPT_SIMPLIFY_NOT_DOUBLE = PluginCmdXTree.class.getName() + "#SimplifyDoubleNot";
    public static final String OPT_SIMPLIFY_NOT_UNLESS = PluginCmdXTree.class.getName() + "#SimplifyUnlessNot";
    public static final String OPT_SIMPLIFY_COMBINAISON = PluginCmdXTree.class.getName() + "#SimplifyCombinaison";
    public static final String OPT_UNLOOP_CTRL = PluginCmdXTree.class.getName() + "#UnloopCtrl";
    public static final String OPT_FLATNESS = PluginCmdXTree.class.getName() + "#Flatness";
    XTreeOptsPanel _optsITree = null;

    public String getInfo(String key) {
        if (key.equals("plugin.name")) {
            return ResCStep.getString("PLUG_CMD_I2TREE_NAME");
        }
        if (key.equals("plugin.description") || key.equals("plugin.tooltip")) {
            return ResCStep.getString("PLUG_CMD_I2TREE_DESC");
        }
        if (key.equals("type")) {
            return "PluginAction";
        }
        return super.getInfo(key);
    }

    public Icon getIcon(String key) {
        if (key.equals("plugin.default")) {
            return ResIcoAbstract.getIconRes((URL)((Object)((Object)this)).getClass().getResource("A2-03.svg"));
        }
        return super.getIcon(key);
    }

    public boolean withOption(Plugable plugable) {
        return true;
    }

    public PlugPanel displayOption(Plugable launcher) {
        if (this._optsITree == null) {
            this._optsITree = new XTreeOptsPanel();
        }
        this._optsITree.prepareWith(launcher);
        return this._optsITree;
    }

    public void refreshOptions(Plugable launcher) {
        if (this._optsITree != null) {
            this._optsITree.prepareWith(launcher);
        }
    }

    public void createSession(Plugable launch, Object parameters) {
        PlugableProxyModel launcher = new PlugableProxyModel(launch);
        if (!this.specificPreVerify((Plugable)launcher)) {
            return;
        }
        IModel model = launcher.getModel("altarica.file");
        if (model == null) {
            return;
        }
        Stepper stepper = this.createBanIStepper((Plugable)launcher);
        if (stepper == null) {
            return;
        }
        DlgTargetsSelection dlg = this.createComputeOpts((Plugable)launcher, stepper);
        if (dlg == null) {
            return;
        }
        this.createTask((Plugable)launcher, model, dlg, stepper);
    }

    protected boolean specificPreVerify(Plugable launch) {
        File file = this.getFileExecutable(launch);
        if (file == null) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)launch.getWindow()), ResCStep.getString("ERR_XTREE_LAUNCH"), ResCStep.getString("DEF_TITLE"), 0);
            return false;
        }
        return true;
    }

    protected File getFileExecutable(Plugable launch) {
        return FileUtility.findExecute((String)PlugableUtility.getStrOpt((Plugable)launch, (String)OPT_EXEC, null), (boolean)true, (String)"CStepper", ((Object)((Object)this)).getClass());
    }

    protected Stepper createBanIStepper(Plugable launcher) {
        if (this.verifyPluginTranslator(launcher) == null) {
            return null;
        }
        IModel model = launcher.getModel("altarica.file");
        if (model == null) {
            return null;
        }
        final File output = this.createFile(launcher, "OTools", ".alt");
        if (output == null) {
            return null;
        }
        output.deleteOnExit();
        BanInferencePlugin plugInf = new BanInferencePlugin(model){

            @Override
            protected void prepareBanEntry(Plugable launch, Object ... objects) {
                super.prepareBanEntry(launch, objects);
                BanEntry ban = this.getBanEntry();
                ban.setUserProperty("altr.input", this.getModel().getFile().getAbsolutePath());
                ban.setUserProperty("altr.main", this.getModel().getName());
                ban.setUserProperty("action.extern", "true");
                ban.setUserProperty("altr.otools.output", output.getAbsolutePath());
            }
        };
        BanEntry ban = plugInf.banExecute(launcher, null, new Object[0]);
        if (ban != null) {
            return (Stepper)ban.getIdObject("stepper-id");
        }
        return null;
    }

    protected DlgTargetsSelection createComputeOpts(Plugable launcher, Stepper stepper) {
        ViewStepper viewStepper = new ViewStepper();
        try {
            viewStepper.open(stepper);
        }
        catch (StepperException e) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)launcher.getWindow()), ResCStep.getString("ERR_STEPPER_EXC") + "\n" + e.getMessage(), this.getInfo("plugin.name"), 0);
            return null;
        }
        viewStepper.getRoot().setWithDomain(true);
        TargetModel defTgt = new TargetModel();
        defTgt.defineDefault(launcher, viewStepper, new DefaultFileFilter(){

            @Override
            public boolean accept(File f) {
                String fname = f.getName().toLowerCase();
                return fname.endsWith(".dag") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return "Aralia File(*.dag)";
            }

            @Override
            public String getDefaultExtension() {
                return ".dag";
            }
        });
        DlgTargetsITree dlg = new DlgTargetsITree(launcher, launcher.getWindow());
        dlg.create(defTgt);
        if (!dlg.doModal(launcher)) {
            dlg = null;
        }
        viewStepper.close();
        return dlg;
    }

    protected AbstractPlugTaskBanWithLog createTask(final Plugable launcher, IModel model, DlgTargetsSelection dlg, Stepper stepper) {
        File iLogFile = this.createFile(launcher, "ITree", ".log");
        if (iLogFile == null) {
            return null;
        }
        File xLogFile = this.createFile(launcher, "XTree", ".log");
        if (xLogFile == null) {
            return null;
        }
        InputStream baseScript = ((Object)((Object)this)).getClass().getResourceAsStream("BanScriptXTree.xml");
        if (baseScript == null) {
            _LOG.severe("Resource script not found : BanScriptXTree.xml");
            return null;
        }
        if (!(stepper instanceof BanStepper)) {
            _LOG.warning("Stepper is not BanStepper");
            return null;
        }
        Object otoolsFile = ((BanStepper)stepper).getBanEntry().getIdObject("file-otools");
        if (otoolsFile == null) {
            _LOG.warning("Stepper without 'file-otools' object");
            return null;
        }
        if (!(otoolsFile instanceof File)) {
            _LOG.warning("'file-otools' object is not instance of File");
            return null;
        }
        UtilityPluginTargetsXTree util = new UtilityPluginTargetsXTree(this, dlg.getTargets(), dlg.getDbOutputSelection());
        BanInputStream script = util.createBanScript(launcher, "XTree", baseScript, xLogFile);
        if (script == null) {
            return null;
        }
        BanEntry entry = util.createBanEntry(launcher, null);
        if (entry == null) {
            return null;
        }
        entry.addUnit(BatchTreeImport.class);
        entry.setIdObject("itree.input", otoolsFile);
        entry.setUserProperty("itree.log.path", iLogFile.getAbsolutePath());
        entry.setUserProperty("xtree.log.path", xLogFile.getAbsolutePath());
        File file = this.getFileExecutable(launcher);
        if (file == null) {
            entry.setUserProperty("cstepper.exec", FileUtility.getBasePath(((Object)((Object)this)).getClass()) + File.separator + "cstepper");
        } else {
            entry.setUserProperty("cstepper.exec", file.getAbsolutePath());
        }
        AbstractPlugTaskBanWithLog task = new AbstractPlugTaskBanWithLog(model.getUID(), launcher, entry, script, xLogFile){

            protected String getDesc() {
                return this.getInfo("plugin.name");
            }

            protected String getName() {
                return "XTree";
            }

            public Icon getIcon(String key) {
                if (key.equals("ptask.icon")) {
                    return ResIcoAbstract.getIconRes((URL)((Object)((Object)this)).getClass().getResource("A2-03.svg"));
                }
                return super.getIcon(key);
            }

            protected void displayResult(File pathInfo, boolean endTrace) {
                super.displayResult(pathInfo, endTrace);
                launcher.getAppl().refreshDAOFolder();
                launcher.getAppl().refreshFolders(true);
            }
        };
        launcher.addTask((PlugTask)task, model.getUID());
        return task;
    }

    class XTreeOptsPanel
    extends JPanel
    implements PlugPanel {
        Plugable _launcher;
        JCheckBox _ctrlSNotDouble;
        JCheckBox _ctrlSNotUnless;
        JCheckBox _ctrlSComb;
        JCheckBox _ctrlLoopCtrl;
        JLabel _lblExec;
        JTextField _ctrlExec;

        public void prepareWith(Plugable launcher) {
            this._launcher = launcher;
            this._ctrlSNotDouble.setSelected(PlugableUtility.getBoolOpt((Plugable)this._launcher, (String)OPT_SIMPLIFY_NOT_DOUBLE, (boolean)false));
            this._ctrlSComb.setSelected(PlugableUtility.getBoolOpt((Plugable)this._launcher, (String)OPT_SIMPLIFY_COMBINAISON, (boolean)true));
            this._ctrlSNotUnless.setSelected(PlugableUtility.getBoolOpt((Plugable)this._launcher, (String)OPT_SIMPLIFY_NOT_UNLESS, (boolean)false));
            this._ctrlLoopCtrl.setSelected(PlugableUtility.getBoolOpt((Plugable)this._launcher, (String)OPT_UNLOOP_CTRL, (boolean)false));
            this._ctrlExec.setText(PlugableUtility.getStrOpt((Plugable)this._launcher, (String)OPT_EXEC, (String)""));
        }

        public XTreeOptsPanel() {
            super(new GridBagLayout());
            this._launcher = null;
            boolean debug = Boolean.getBoolean("cecilia.core.debug");
            Box simplify = Box.createVerticalBox();
            simplify.setBorder(BorderFactory.createTitledBorder(ResCStep.getString("DLG_OPT_ITREE_SIMPLIFY")));
            this._ctrlSNotDouble = new JCheckBox(ResCStep.getString("DLG_OPT_ITREE_SIMPLIFY_NOT_DOUBLE"));
            this._ctrlSNotDouble.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    XTreeOptsPanel.this._launcher.setOption(OPT_SIMPLIFY_NOT_DOUBLE, XTreeOptsPanel.this._ctrlSNotDouble.isSelected() ? "true" : "false");
                }
            });
            this._ctrlSNotDouble.setEnabled(debug);
            simplify.add(this._ctrlSNotDouble);
            this._ctrlSComb = new JCheckBox(ResCStep.getString("DLG_OPT_ITREE_SIMPLIFY_COMBINAISON"));
            this._ctrlSComb.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    XTreeOptsPanel.this._launcher.setOption(OPT_SIMPLIFY_COMBINAISON, XTreeOptsPanel.this._ctrlSComb.isSelected() ? "true" : "false");
                }
            });
            simplify.add(this._ctrlSComb);
            this._ctrlSNotUnless = new JCheckBox(ResCStep.getString("DLG_OPT_ITREE_SIMPLIFY_NOT_UNLESS"));
            this._ctrlSNotUnless.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    XTreeOptsPanel.this._launcher.setOption(OPT_SIMPLIFY_NOT_UNLESS, XTreeOptsPanel.this._ctrlSNotUnless.isSelected() ? "true" : "false");
                }
            });
            this._ctrlSNotUnless.setEnabled(debug);
            simplify.add(this._ctrlSNotUnless);
            this._ctrlLoopCtrl = new JCheckBox(ResCStep.getString("DLG_OPT_ITREE_LOOP_CTRL"));
            this._ctrlLoopCtrl.setEnabled(debug);
            this._ctrlLoopCtrl.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    XTreeOptsPanel.this._launcher.setOption(OPT_UNLOOP_CTRL, XTreeOptsPanel.this._ctrlLoopCtrl.isSelected() ? "true" : "false");
                }
            });
            this.add((Component)simplify, new GridBagConstraints(0, 0, 1, 1, 100.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this._ctrlLoopCtrl, new GridBagConstraints(0, 1, 1, 1, 100.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this._lblExec = new JLabel(ResCStep.getString("DLG_OPT_I2TREE_EXEC"));
            this._ctrlExec = new JTextField(40);
            this._ctrlExec.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    XTreeOptsPanel.this._launcher.setOption(OPT_EXEC, XTreeOptsPanel.this._ctrlExec.getText());
                }

                @Override
                public void focusGained(FocusEvent e) {
                }
            });
            this.add((Component)this._lblExec, new GridBagConstraints(0, 2, 1, 1, 100.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this._ctrlExec, new GridBagConstraints(0, 3, 1, 1, 100.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        }

        public Component getPanel() {
            return this;
        }

        public void trash() {
        }

        public String getInfo(String key) {
            return PluginCmdXTree.this.getInfo(key);
        }

        public Icon getIcon(String key) {
            return null;
        }
    }
}

