/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.ban.unitdefs.optionnal;

import com.dassault.cecilia.lib.ban.BanProcessException;
import com.dassault.cecilia.lib.ban.Unit;
import com.dassault.cecilia.lib.ban.UnitContainer;
import com.dassault.cecilia.lib.ban.UnitValued;
import com.dassault.cecilia.lib.ban.unitdefs.Eval;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;

public class JUnit
extends Unit
implements UnitContainer {
    Action _method = Action.fail;
    String _msg = "Fail action";
    protected List<Unit> _args = new ArrayList<Unit>(3);

    public void setMethod(String value) {
        this._method = null;
        try {
            this._method = Action.valueOf(value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (this._method == null) {
            throw new BanProcessException("JUnit | attribute 'method' must be equal :\n" + Action.values());
        }
    }

    public void setMessage(String value) {
        this._msg = value;
    }

    @Override
    public void addUnit(Unit unit) {
        if (!(unit instanceof UnitValued)) {
            throw new BanProcessException("Child of element 'junit' Must be valued unit");
        }
        this._args.add(unit);
        unit.setOwnerUnit(this);
    }

    public void endValid() {
        if (this._method == null) {
            throw new BanProcessException("No attribut 'method' for element 'junit'");
        }
        if (this._method.getNbr() != this._args.size()) {
            throw new BanProcessException("Number argument for element 'junit' (with method='" + this._method.toString() + "') must be equal " + this._method.getNbr());
        }
    }

    @Override
    public void execute() {
        switch (this._method) {
            case fail: {
                Assert.fail((String)this._msg);
                break;
            }
            case assertTrue: {
                Assert.assertTrue((String)this._msg, (boolean)Eval.Bool(this.string(this._args.get(0).perform())));
                break;
            }
            case assertFalse: {
                Assert.assertFalse((String)this._msg, (boolean)Eval.Bool(this.string(this._args.get(0).perform())));
                break;
            }
            case assertEquals: {
                Assert.assertTrue((String)this._msg, (boolean)Eval.EQ(this.string(this._args.get(0).perform()), this.string(this._args.get(1).perform())));
                break;
            }
            case assertNotEquals: {
                Assert.assertFalse((String)this._msg, (boolean)Eval.EQ(this.string(this._args.get(0).perform()), this.string(this._args.get(1).perform())));
            }
        }
    }

    protected static enum Action {
        fail(0),
        assertTrue(1),
        assertFalse(1),
        assertEquals(2),
        assertNotEquals(2);

        protected int _nbr;

        private Action(int arg) {
            this._nbr = arg;
        }

        public int getNbr() {
            return this._nbr;
        }
    }
}

