/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.cstepper.opt;

import com.dassault.cecilia.core.cecilia.export.DBKWriter;
import com.dassault.cecilia.core.cecilia.stepper.ViewStepper;
import com.dassault.cecilia.core.plugin.AbstractPlugTaskBanWithLog;
import com.dassault.cecilia.core.plugin.IModel;
import com.dassault.cecilia.core.plugin.PlugPanel;
import com.dassault.cecilia.core.plugin.PlugTask;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PlugableProxyModel;
import com.dassault.cecilia.core.plugin.PlugableUtility;
import com.dassault.cecilia.core.plugin.PluginMAction;
import com.dassault.cecilia.core.plugin.PluginModel;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.other.FileFilterExtention;
import com.dassault.cecilia.core.swing.other.JCRLabel;
import com.dassault.cecilia.core.swing.other.ToggleBorderLayout;
import com.dassault.cecilia.lib.ban.BanEntry;
import com.dassault.cecilia.lib.ban.BanInputStream;
import com.dassault.cecilia.lib.mbsa.Stepper;
import com.dassault.cecilia.lib.mbsa.StepperException;
import com.dassault.cecilia.lib.util.ResIcoAbstract;
import com.dassault.cecilia.plugin.mbsa.cstepper.PluginInference;
import com.dassault.cecilia.plugin.mbsa.cstepper.ResCStep;
import com.dassault.cecilia.plugin.mbsa.cstepper.TargetModelSeq;
import com.dassault.cecilia.plugin.mbsa.cstepper.opt.DlgTargetsISeq;
import com.dassault.cecilia.plugin.mbsa.viewer.DefaultFileFilter;
import com.dassault.cecilia.plugin.mbsa.viewer.TargetModel;
import com.dassault.cecilia.plugin.mbsa.viewer.UtilityPluginTargets;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.NumberFormat;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.DefaultFormatter;

public class PluginCmdISeq
extends PluginInference
implements PluginMAction {
    public static final String OPT_TRACE_SELECT = PluginCmdISeq.class.getName() + "#TraceSelect";
    public static final String OPT_TRACE_PATH = PluginCmdISeq.class.getName() + "#TracePath";
    public static final String OPT_ERROR_SELECT = PluginCmdISeq.class.getName() + "#ErrorSelect";
    public static final String OPT_ERROR_NBR = PluginCmdISeq.class.getName() + "#ErrorNbr";
    public static final String OPT_DISPLAY_PROGRESS_SELECT = PluginCmdISeq.class.getName() + "#DisplayProgressSelect";
    public static final String OPT_DISPLAY_PROGRESS_NBR = PluginCmdISeq.class.getName() + "#DisplayProgressNbr";
    public static final String OPT_EVT_LOCKER = PluginCmdISeq.class.getName() + "#EvtLooker";
    public static final String OPT_DISPLAY_CUTS = PluginCmdISeq.class.getName() + "#DisplayCuts";
    public static final String OPT_FAST_GENERATOR = PluginCmdISeq.class.getName() + "#FastGenerator";
    public static final String OPT_TYPE = PluginCmdISeq.class.getName() + "#TypeGenerator";
    public static final String OPT_TYPE_COMB = "Comb";
    public static final String OPT_TYPE_PERMUT = "Permut";
    public static final String OPT_TYPE_REPEAT = "Repeat";
    public static final String OPT_ORDER = PluginCmdISeq.class.getName() + "#Order";
    ISeqOptsPanel _opts = null;
    private static final String DEPEND_CMD = "com.dassault.cecilia.plugin.mbsa.viewer.PluginCmdViewStepper";

    public String getInfo(String key) {
        if (key.equals("plugin.name")) {
            return ResCStep.getString("PLUG_CMD_ISEQ_NAME");
        }
        if (key.equals("plugin.description") || key.equals("plugin.tooltip")) {
            return ResCStep.getString("PLUG_CMD_ISEQ_DESC");
        }
        if (key.equals("type")) {
            return "PluginAction";
        }
        return super.getInfo(key);
    }

    public Icon getIcon(String key) {
        if (key.equals("plugin.default")) {
            return ResIcoAbstract.getIconRes((URL)((Object)((Object)this)).getClass().getResource("A2-07.svg"));
        }
        return super.getIcon(key);
    }

    public boolean withOption(Plugable plugable) {
        return true;
    }

    public PlugPanel displayOption(Plugable launcher) {
        if (this._opts == null) {
            this._opts = new ISeqOptsPanel();
        }
        this._opts.prepareWith(launcher);
        return this._opts;
    }

    public void refreshOptions(Plugable launcher) {
        if (this._opts != null) {
            this._opts.prepareWith(launcher);
        }
    }

    public void createSession(Plugable launch, Object parameters) {
        PlugableProxyModel launcher = new PlugableProxyModel(launch);
        IModel model = launcher.getModel("altarica.file");
        if (model == null) {
            return;
        }
        PluginModel plugin = launcher.getPlugin(DEPEND_CMD);
        if (plugin == null) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)launcher.getWindow()), ResCStep.getString("ERR_DEPEND_PLUGIN") + "\n   [" + DEPEND_CMD + "]");
            return;
        }
        Stepper stepper = this.createBanStepper((Plugable)launcher);
        if (stepper == null) {
            return;
        }
        DlgTargetsISeq dlg = this.createComputeOpts((Plugable)launcher, stepper);
        if (dlg == null) {
            return;
        }
        this.createTask((Plugable)launcher, model, dlg.getTargets(), stepper);
    }

    private DlgTargetsISeq createComputeOpts(Plugable launcher, Stepper stepper) {
        ViewStepper viewStepper = new ViewStepper();
        try {
            viewStepper.open(stepper);
        }
        catch (StepperException e) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)launcher.getWindow()), ResCStep.getString("ERR_STEPPER_EXC") + "\n" + e.getMessage(), this.getInfo("plugin.name"), 0);
            return null;
        }
        viewStepper.getRoot().setWithDomain(true);
        int order = PlugableUtility.getIntOpt((Plugable)launcher, (String)OPT_ORDER, (int)3);
        TargetModelSeq defTgt = new TargetModelSeq(order);
        defTgt.defineDefault(launcher, viewStepper, new DefaultFileFilter(){

            public boolean accept(File f) {
                String fname = f.getName().toLowerCase();
                return fname.endsWith(".seq") || f.isDirectory();
            }

            public String getDescription() {
                return "Sequences File(*.seq)";
            }

            public String getDefaultExtension() {
                return ".seq";
            }
        });
        DlgTargetsISeq dlg = new DlgTargetsISeq(launcher.getWindow());
        dlg.create(defTgt);
        if (!dlg.doModal(launcher)) {
            dlg = null;
        }
        viewStepper.close();
        return dlg;
    }

    private void createTask(Plugable launcher, IModel model, List<TargetModel> tgts, Stepper stepper) {
        File logFile = this.createFile(launcher, "ISeq", ".log");
        if (logFile == null) {
            return;
        }
        InputStream baseScript = ((Object)((Object)this)).getClass().getResourceAsStream("BanScriptISeq.txt");
        if (baseScript == null) {
            Logger.getLogger(PluginCmdISeq.class.getPackage().getName()).severe("Resource script not found : BanScriptISeq.txt");
            return;
        }
        UtilityPluginTargetsISeq util = new UtilityPluginTargetsISeq();
        BanInputStream script = util.createBanScript(launcher, tgts, "ISeq", baseScript, logFile);
        if (script == null) {
            return;
        }
        BanEntry entry = util.createBanEntry(launcher, null);
        if (entry == null) {
            return;
        }
        entry.setIdObject("stepper-id", (Object)stepper);
        entry.setUserProperty("iseq.log.path", logFile.getAbsolutePath());
        AbstractPlugTaskBanWithLog task = new AbstractPlugTaskBanWithLog(model.getUID(), launcher, entry, script, logFile){

            protected String getDesc() {
                return ResCStep.getString("PLUG_CMD_ISEQ_NAME");
            }

            protected String getName() {
                return "ISeq";
            }

            public Icon getIcon(String key) {
                if (key.equals("ptask.icon")) {
                    return ResIcoAbstract.getIconRes((URL)((Object)((Object)this)).getClass().getResource("A2-07.svg"));
                }
                return super.getIcon(key);
            }
        };
        launcher.addTask((PlugTask)task, model.getUID());
    }

    class UtilityPluginTargetsISeq
    extends UtilityPluginTargets {
        UtilityPluginTargetsISeq() {
        }

        protected String getTitle() {
            return PluginCmdISeq.this.getInfo("plugin.name");
        }

        protected File createFile(Plugable launch, String base, String ext) {
            return PluginCmdISeq.this.createFile(launch, base, ext);
        }

        protected void defineUserProperties(Plugable launch, BanEntry entry) {
            entry.setUserProperty("iseq.resultset", PlugableUtility.getBoolOpt((Plugable)launch, (String)OPT_DISPLAY_CUTS, (boolean)false) ? "mincuts" : "minseqs");
            String typeFind = PlugableUtility.getStrOpt((Plugable)launch, (String)OPT_TYPE, (String)PluginCmdISeq.OPT_TYPE_PERMUT);
            if (typeFind.equals(PluginCmdISeq.OPT_TYPE_COMB)) {
                entry.setUserProperty("iseq.finder", "combinaison");
            } else if (typeFind.equals(PluginCmdISeq.OPT_TYPE_REPEAT)) {
                entry.setUserProperty("iseq.finder", "repetition");
            } else {
                entry.setUserProperty("iseq.finder", "permutation");
            }
            entry.setUserProperty("iseq.locker", Boolean.toString(PlugableUtility.getBoolOpt((Plugable)launch, (String)OPT_EVT_LOCKER, (boolean)true)));
            if (PlugableUtility.getBoolOpt((Plugable)launch, (String)OPT_ERROR_SELECT, (boolean)true)) {
                entry.setUserProperty("iseq.maxerror", Integer.toString(PlugableUtility.getIntOpt((Plugable)launch, (String)OPT_ERROR_NBR, (int)10)));
            } else {
                entry.setUserProperty("iseq.maxerror", "1");
            }
            if (PlugableUtility.getBoolOpt((Plugable)launch, (String)OPT_DISPLAY_PROGRESS_SELECT, (boolean)true)) {
                entry.setUserProperty("iseq.display.sequence", Integer.toString(PlugableUtility.getIntOpt((Plugable)launch, (String)OPT_DISPLAY_PROGRESS_NBR, (int)10000)));
            }
            if (PlugableUtility.getBoolOpt((Plugable)launch, (String)OPT_TRACE_SELECT, (boolean)true)) {
                entry.setUserProperty("iseq.display.trace", launch.getOption(OPT_TRACE_PATH));
            }
            entry.setUserProperty("iseq.fast.generator", Boolean.toString(PlugableUtility.getBoolOpt((Plugable)launch, (String)OPT_FAST_GENERATOR, (boolean)true)));
        }

        protected void writeTargetToBanScript(DBKWriter writer, TargetModel Tgt, int cpt, int nbr) throws IOException {
            TargetModelSeq tgt = (TargetModelSeq)Tgt;
            this.writeProgressToBanScript(writer, tgt, cpt, nbr);
            writer.write("<callfunct ref=\"iseq-launch\">\n", false);
            writer.addIndent(1);
            writer.write("<value valuable=\"false\" value=\"", false);
            writer.write(tgt.getVarTarget(), true);
            writer.write("\"/>\n", false);
            writer.write("<value valuable=\"false\" value=\"", false);
            writer.write(tgt.getValTarget(), true);
            writer.write("\"/>\n", false);
            writer.write("<value valuable=\"false\" value=\"", false);
            writer.write(tgt.getFilePath(), true);
            writer.write("\"/>\n", false);
            writer.write("<value valuable=\"false\" value=\"", false);
            writer.write(Integer.toString(tgt.getOrder()), true);
            writer.write("\"/>\n", false);
            writer.write("<value valuable=\"false\" value=\"", false);
            writer.write(Boolean.toString(cpt > 1), true);
            writer.write("\"/>\n", false);
            writer.addIndent(-1);
            writer.write("</callfunct>\n", false);
        }
    }

    class ISeqOptsPanel
    extends JPanel
    implements PlugPanel {
        Plugable _launcher = null;
        JCheckBox _ctrlTrace;
        JCheckBox _ctrlError;
        JCheckBox _ctrlProgress;
        JCRLabel _lblTrace;
        JCRLabel _lblError;
        JCRLabel _lblProgress;
        JFormattedTextField _ctrlErrorNbr;
        JFormattedTextField _ctrlProgressNbr;
        JTextField _ctrlTracePath;
        JButton _ctrlTracePathFind;

        public void prepareWith(Plugable launcher) {
            this._launcher = launcher;
            this._ctrlTrace.setSelected(PlugableUtility.getBoolOpt((Plugable)this._launcher, (String)OPT_TRACE_SELECT, (boolean)false));
            this._ctrlTracePath.setText(this._launcher.getOption(OPT_TRACE_PATH));
            this._ctrlError.setSelected(PlugableUtility.getBoolOpt((Plugable)this._launcher, (String)OPT_ERROR_SELECT, (boolean)true));
            this._ctrlErrorNbr.setText(Integer.toString(PlugableUtility.getIntOpt((Plugable)this._launcher, (String)OPT_ERROR_NBR, (int)10)));
            this._ctrlProgress.setSelected(PlugableUtility.getBoolOpt((Plugable)this._launcher, (String)OPT_DISPLAY_PROGRESS_SELECT, (boolean)true));
            this._ctrlProgressNbr.setText(Integer.toString(PlugableUtility.getIntOpt((Plugable)this._launcher, (String)OPT_DISPLAY_PROGRESS_NBR, (int)10000)));
            this.refreshCtrl();
        }

        public ISeqOptsPanel() {
            JPanel trace = new JPanel((LayoutManager)new ToggleBorderLayout());
            this._ctrlTrace = new JCheckBox(ResCStep.getString("DLG_OPT_ISEQ_PATH"));
            this._ctrlTrace.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ISeqOptsPanel.this.refreshCtrl();
                    ISeqOptsPanel.this._launcher.setOption(OPT_TRACE_SELECT, ISeqOptsPanel.this._ctrlTrace.isSelected() ? "true" : "false");
                }
            });
            this._lblTrace = new JCRLabel(ResCStep.getString("DLG_OPT_ISEQ_PATH_LBL"));
            this._ctrlTracePath = new JTextField();
            this._ctrlTracePath.addFocusListener(new FocusListener(){
                String _save;

                @Override
                public void focusLost(FocusEvent e) {
                    String txt = ISeqOptsPanel.this._ctrlTracePath.getText();
                    boolean err = false;
                    if (txt.equalsIgnoreCase("stdout")) {
                        txt = txt.toLowerCase();
                    } else if (txt.equalsIgnoreCase("stderr")) {
                        txt = txt.toLowerCase();
                    } else {
                        File tstFile = new File(txt);
                        if (tstFile.isFile()) {
                            if (!tstFile.canWrite()) {
                                err = true;
                            }
                        } else if (!tstFile.getParentFile().isDirectory()) {
                            err = true;
                        }
                    }
                    if (err) {
                        JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)ISeqOptsPanel.this._ctrlTracePath), ResCStep.getString("DLG_OPT_ISEQ_PATH_ERR"));
                        ISeqOptsPanel.this._ctrlTracePath.setText(this._save);
                    } else {
                        ISeqOptsPanel.this._launcher.setOption(OPT_TRACE_PATH, txt);
                    }
                }

                @Override
                public void focusGained(FocusEvent e) {
                    this._save = ISeqOptsPanel.this._ctrlTracePath.getText();
                }
            });
            this._ctrlTracePathFind = new JButton("...");
            this._ctrlTracePathFind.addActionListener(new ActionListener(){
                JFileChooser _fileChooser;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (this._fileChooser == null) {
                        this._fileChooser = new JFileChooser();
                        FileFilterExtention logFilter = new FileFilterExtention("Log file (*.log)", ".log").verifyWrite(true);
                        this._fileChooser.addChoosableFileFilter((FileFilter)logFilter);
                        this._fileChooser.setFileFilter((FileFilter)logFilter);
                    }
                    this._fileChooser.setCurrentDirectory(new File(PlugableUtility.getStrOpt((Plugable)ISeqOptsPanel.this._launcher, (String)"plugable.option.path", (String)".")));
                    if (this._fileChooser.showSaveDialog(ISeqOptsPanel.this._ctrlTracePath) == 0) {
                        ISeqOptsPanel.this._launcher.setOption("plugable.option.path", this._fileChooser.getSelectedFile().getParent());
                        String path = FileFilterExtention.addDefaultExtention((JFileChooser)this._fileChooser).getPath();
                        ISeqOptsPanel.this._ctrlTracePath.setText(path);
                        ISeqOptsPanel.this._launcher.setOption(OPT_TRACE_PATH, path);
                    }
                }
            });
            JPanel intern = new JPanel(new GridBagLayout());
            intern.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(10, 5, 5, 5)));
            intern.add((Component)this._lblTrace, new GridBagConstraints(0, 0, 2, 1, 100.0, 100.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            intern.add((Component)this._ctrlTracePath, new GridBagConstraints(0, 1, 1, 1, 100.0, 100.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            intern.add((Component)this._ctrlTracePathFind, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            trace.add(this._ctrlTrace);
            trace.add(intern);
            NumberFormat nf = NumberFormat.getNumberInstance();
            nf.setParseIntegerOnly(true);
            nf.setGroupingUsed(false);
            JPanel error = new JPanel((LayoutManager)new ToggleBorderLayout());
            this._ctrlError = new JCheckBox(ResCStep.getString("DLG_OPT_ISEQ_ERROR"));
            this._ctrlError.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ISeqOptsPanel.this.refreshCtrl();
                    ISeqOptsPanel.this._launcher.setOption(OPT_ERROR_SELECT, ISeqOptsPanel.this._ctrlError.isSelected() ? "true" : "false");
                }
            });
            this._lblError = new JCRLabel(ResCStep.getString("DLG_OPT_ISEQ_ERROR_LBL"));
            this._ctrlErrorNbr = new JFormattedTextField(nf);
            ((DefaultFormatter)this._ctrlErrorNbr.getFormatter()).setAllowsInvalid(false);
            this._ctrlErrorNbr.setColumns(6);
            this._ctrlErrorNbr.setText("10");
            this._ctrlErrorNbr.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    try {
                        String value = ISeqOptsPanel.this._ctrlErrorNbr.getText();
                        Integer.parseInt(value);
                        ISeqOptsPanel.this._launcher.setOption(OPT_ERROR_NBR, value);
                    }
                    catch (NumberFormatException exc) {
                        ISeqOptsPanel.this._ctrlErrorNbr.setText(Integer.toString(PlugableUtility.getIntOpt((Plugable)ISeqOptsPanel.this._launcher, (String)OPT_ERROR_NBR, (int)10)));
                        ISeqOptsPanel.this._ctrlErrorNbr.requestFocus();
                    }
                }
            });
            JPanel intern2 = new JPanel(new GridBagLayout());
            intern2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(10, 5, 5, 5)));
            intern2.add((Component)this._lblError, new GridBagConstraints(0, 0, 1, 1, 100.0, 100.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            intern2.add((Component)this._ctrlErrorNbr, new GridBagConstraints(1, 0, 1, 1, 100.0, 100.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            error.add(this._ctrlError);
            error.add(intern2);
            JPanel progress = new JPanel((LayoutManager)new ToggleBorderLayout());
            this._ctrlProgress = new JCheckBox(ResCStep.getString("DLG_OPT_ISEQ_PROGRESS"));
            this._ctrlProgress.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ISeqOptsPanel.this.refreshCtrl();
                    ISeqOptsPanel.this._launcher.setOption(OPT_DISPLAY_PROGRESS_SELECT, ISeqOptsPanel.this._ctrlProgress.isSelected() ? "true" : "false");
                }
            });
            this._lblProgress = new JCRLabel(ResCStep.getString("DLG_OPT_ISEQ_PROGRESS_LBL"));
            this._ctrlProgressNbr = new JFormattedTextField(nf);
            ((DefaultFormatter)this._ctrlProgressNbr.getFormatter()).setAllowsInvalid(false);
            this._ctrlProgressNbr.setColumns(10);
            this._ctrlProgressNbr.setText("1000");
            this._ctrlProgressNbr.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    try {
                        String value = ISeqOptsPanel.this._ctrlProgressNbr.getText();
                        Integer.parseInt(value);
                        ISeqOptsPanel.this._launcher.setOption(OPT_DISPLAY_PROGRESS_NBR, value);
                    }
                    catch (NumberFormatException exc) {
                        ISeqOptsPanel.this._ctrlProgressNbr.setText(Integer.toString(PlugableUtility.getIntOpt((Plugable)ISeqOptsPanel.this._launcher, (String)OPT_DISPLAY_PROGRESS_NBR, (int)10000)));
                        ISeqOptsPanel.this._ctrlProgressNbr.requestFocus();
                    }
                }
            });
            JPanel intern3 = new JPanel(new GridBagLayout());
            intern3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(10, 5, 5, 5)));
            intern3.add((Component)this._lblProgress, new GridBagConstraints(0, 0, 1, 1, 100.0, 100.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            intern3.add((Component)this._ctrlProgressNbr, new GridBagConstraints(1, 0, 1, 1, 100.0, 100.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            progress.add(this._ctrlProgress);
            progress.add(intern3);
            JPanel root = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.fill = 2;
            gbc.weighty = 100.0;
            gbc.weightx = 100.0;
            gbc.gridx = 0;
            gbc.gridy = -1;
            gbc.insets = new Insets(5, 0, 5, 0);
            ++gbc.gridy;
            root.add((Component)trace, gbc);
            ++gbc.gridy;
            root.add((Component)error, gbc);
            ++gbc.gridy;
            root.add((Component)progress, gbc);
            this.add(root);
        }

        protected void refreshCtrl() {
            this._lblTrace.setEnabled(this._ctrlTrace.isSelected());
            this._ctrlTracePath.setEnabled(this._ctrlTrace.isSelected());
            this._ctrlTracePathFind.setEnabled(this._ctrlTrace.isSelected());
            this._lblError.setEnabled(this._ctrlError.isSelected());
            this._ctrlErrorNbr.setEnabled(this._ctrlError.isSelected());
            this._lblProgress.setEnabled(this._ctrlProgress.isSelected());
            this._ctrlProgressNbr.setEnabled(this._ctrlProgress.isSelected());
        }

        public Component getPanel() {
            return this;
        }

        public void trash() {
        }

        public String getInfo(String key) {
            return PluginCmdISeq.this.getInfo(key);
        }

        public Icon getIcon(String key) {
            return null;
        }
    }
}

