/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.jstepper;

import com.dassault.cecilia.core.plugin.AbstractPluginWithStepper;
import com.dassault.cecilia.core.plugin.PlugPanel;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PlugableUtility;
import com.dassault.cecilia.core.plugin.PluginMStepper;
import com.dassault.cecilia.core.plugin.PluginMTranslate;
import com.dassault.cecilia.core.plugin.PluginModel;
import com.dassault.cecilia.core.plugin.Translator;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.other.JCRLabel;
import com.dassault.cecilia.lib.ban.BanConnected;
import com.dassault.cecilia.lib.ban.BanEntry;
import com.dassault.cecilia.lib.mbsa.Stepper;
import com.dassault.cecilia.lib.util.ResIcoAbstract;
import com.dassault.cecilia.plugin.mbsa.jstepper.PluginJava1;
import com.dassault.cecilia.plugin.mbsa.jstepper.ResJStep;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class PluginStepperJava1
extends PluginJava1
implements PluginMStepper {
    Java1OptsPanel _opts = null;

    public String getInfo(String key) {
        if (key.equals("plugin.name")) {
            return ResJStep.getString("PLUG_STEPPER_J1_NAME");
        }
        if (key.equals("plugin.description") || key.equals("plugin.tooltip")) {
            return ResJStep.getString("PLUG_STEPPER_J1_DESC");
        }
        if (key.equals("type")) {
            return "PluginStepper";
        }
        if (key.equals("plugin.default")) {
            return "false";
        }
        return super.getInfo(key);
    }

    public Icon getIcon(String key) {
        if (key.equals("plugin.default")) {
            return ResIcoAbstract.getIconRes((URL)((Object)((Object)this)).getClass().getResource("A4-01.svg"));
        }
        return super.getIcon(key);
    }

    public boolean withOption(Plugable plugable) {
        return true;
    }

    public PlugPanel displayOption(Plugable launcher) {
        if (this._opts == null) {
            this._opts = new Java1OptsPanel();
        }
        this._opts.prepareWith(launcher);
        return this._opts;
    }

    public void refreshOptions(Plugable launcher) {
        if (this._opts != null) {
            this._opts.prepareWith(launcher);
        }
    }

    public Stepper createStepper(Plugable launcher, Object parameters) {
        BanEntry ban;
        File outFile;
        Translator trans;
        ResJStep.LOG.finer("[PluginStepperJava1.createStepper] Start " + Integer.toHexString(super.hashCode()));
        PluginModel plugTrans = launcher.getPlugin("com.dassault.cecilia.plugin.mbsa.translator.TranslatePluginJarByteCode");
        if (plugTrans == null || !(plugTrans instanceof PluginMTranslate)) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)launcher.getWindow()), ResJStep.getString("ERR_PLUG_TRANSLATE") + "\n   [" + "com.dassault.cecilia.plugin.mbsa.translator.TranslatePluginJarByteCode" + "]", ResJStep.getString("DEF_TITLE"), 0);
            return null;
        }
        if (parameters instanceof AbstractPluginWithStepper.InfoStepper) {
            parameters = ((AbstractPluginWithStepper.InfoStepper)parameters).getParameters();
        }
        if ((trans = ((PluginMTranslate)plugTrans).createTranslator(launcher, parameters)) == null) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)launcher.getWindow()), ResJStep.getString("ERR_TRANSLATOR"), ResJStep.getString("DEF_TITLE"), 0);
            return null;
        }
        try {
            outFile = File.createTempFile("J1Stepper", ".jar");
            outFile.deleteOnExit();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)launcher.getWindow()), ResJStep.getString("ERR_TMP_FILE"), ResJStep.getString("DEF_TITLE"), 0);
            return null;
        }
        ResJStep.LOG.finer("[PluginStepperJava1.createStepper][Translate] Start " + Integer.toHexString(super.hashCode()));
        if (!trans.translate(outFile, true)) {
            return null;
        }
        ResJStep.LOG.finer("[PluginStepperJava1.createStepper][Translate] End " + Integer.toHexString(super.hashCode()));
        BanEntry previous = null;
        if (trans instanceof BanConnected) {
            previous = ((BanConnected)trans).getBanEntry();
        }
        if ((ban = this.banExecute(launcher, previous, new Object[]{outFile})) != null) {
            ResJStep.LOG.finer("[PluginStepperJava1.createStepper] End " + Integer.toHexString(super.hashCode()));
            return (Stepper)ban.getIdObject("stepper-id");
        }
        return null;
    }

    class Java1OptsPanel
    extends JPanel
    implements PlugPanel {
        Plugable _launcher;
        JCheckBox _ctrlDeterminist;
        JCheckBox _ctrlConflict;
        JComboBox _ctrlChangeMax;

        public void prepareWith(Plugable launcher) {
            this._launcher = launcher;
            this._ctrlDeterminist.setSelected(PlugableUtility.getBoolOpt((Plugable)this._launcher, (String)PluginJava1.OPT_DETERMINIST, (boolean)false));
            this._ctrlConflict.setSelected(PlugableUtility.getBoolOpt((Plugable)this._launcher, (String)PluginJava1.OPT_EXC_CONFLICT, (boolean)false));
            this._ctrlChangeMax.setSelectedItem(PlugableUtility.getStrOpt((Plugable)this._launcher, (String)PluginJava1.OPT_CHANGE_MAX, (String)"5"));
        }

        public Java1OptsPanel() {
            super(new GridBagLayout());
            this._launcher = null;
            JPanel root = new JPanel(new GridBagLayout());
            root.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(ResJStep.getString("DLG_OPT_JAVA1")), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
            this._ctrlDeterminist = new JCheckBox(ResJStep.getString("DLG_OPT_JAVA1_DETERMINIST"));
            this._ctrlDeterminist.setHorizontalTextPosition(2);
            this._ctrlDeterminist.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Java1OptsPanel.this._launcher.setOption(PluginJava1.OPT_DETERMINIST, Java1OptsPanel.this._ctrlDeterminist.isSelected() ? "true" : "false");
                }
            });
            root.add((Component)this._ctrlDeterminist, new GridBagConstraints(0, 0, 2, 1, 100.0, 100.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this._ctrlConflict = new JCheckBox(ResJStep.getString("DLG_OPT_JAVA1_CONFLICT"));
            this._ctrlConflict.setHorizontalTextPosition(2);
            this._ctrlConflict.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Java1OptsPanel.this._launcher.setOption(PluginJava1.OPT_EXC_CONFLICT, Java1OptsPanel.this._ctrlConflict.isSelected() ? "true" : "false");
                }
            });
            root.add((Component)this._ctrlConflict, new GridBagConstraints(0, 1, 2, 1, 100.0, 100.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            JCRLabel lbl = new JCRLabel(ResJStep.getString("DLG_OPT_JAVA1_CHGMAX"));
            root.add((Component)lbl, new GridBagConstraints(0, 2, 1, 1, 100.0, 100.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this._ctrlChangeMax = new JComboBox<String>(new String[]{"3", "5", "10", "20"});
            this._ctrlChangeMax.setEditable(true);
            this._ctrlChangeMax.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String chgMax = Java1OptsPanel.this._ctrlChangeMax.getSelectedItem().toString();
                    try {
                        int val = Integer.parseInt(chgMax);
                        if (val > 0 && val < 1000) {
                            Java1OptsPanel.this._launcher.setOption(PluginJava1.OPT_CHANGE_MAX, chgMax);
                            return;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)Java1OptsPanel.this), ResJStep.getString("DLG_OPT_JAVA1_CHGMAX_ERR"), ResJStep.getString("DLG_OPT_JAVA1"), 0);
                    Java1OptsPanel.this._ctrlChangeMax.requestFocus();
                }
            });
            root.add((Component)this._ctrlChangeMax, new GridBagConstraints(1, 2, 1, 1, 100.0, 100.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            JButton defVal = new JButton(ResJStep.getString("DLG_DEFVALUE"));
            defVal.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Java1OptsPanel.this._ctrlDeterminist.setSelected(true);
                    Java1OptsPanel.this._launcher.setOption(PluginJava1.OPT_DETERMINIST, "true");
                    Java1OptsPanel.this._ctrlConflict.setSelected(true);
                    Java1OptsPanel.this._launcher.setOption(PluginJava1.OPT_EXC_CONFLICT, "true");
                    Java1OptsPanel.this._ctrlChangeMax.setSelectedItem("5");
                    Java1OptsPanel.this._launcher.setOption(PluginJava1.OPT_CHANGE_MAX, "5");
                }
            });
            root.add((Component)defVal, new GridBagConstraints(1, 3, 1, 1, 100.0, 100.0, 13, 0, new Insets(10, 5, 5, 5), 0, 0));
            this.add((Component)root, new GridBagConstraints(0, 0, 1, 1, 100.0, 100.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        }

        public Component getPanel() {
            return this;
        }

        public void trash() {
        }

        public String getInfo(String key) {
            return PluginStepperJava1.this.getInfo(key);
        }

        public Icon getIcon(String key) {
            return null;
        }
    }
}

