/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.seqgen;

import com.dassault.cecilia.core.cecilia.stepper.ViewStepper;
import com.dassault.cecilia.core.plugin.AbstractPlugTaskBanWithLog;
import com.dassault.cecilia.core.plugin.AbstractPluginWithStepper;
import com.dassault.cecilia.core.plugin.IModel;
import com.dassault.cecilia.core.plugin.PlugPanel;
import com.dassault.cecilia.core.plugin.PlugTask;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PlugableProxyModel;
import com.dassault.cecilia.core.plugin.PlugableUtility;
import com.dassault.cecilia.core.plugin.PluginMAction;
import com.dassault.cecilia.core.plugin.PluginModel;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.other.JCRLabel;
import com.dassault.cecilia.core.swing.other.ToggleBorderLayout;
import com.dassault.cecilia.lib.ban.BanConnected;
import com.dassault.cecilia.lib.ban.BanEntry;
import com.dassault.cecilia.lib.ban.BanInputStream;
import com.dassault.cecilia.lib.distrib.peers.CECILIAClient;
import com.dassault.cecilia.lib.mbsa.ModelReader;
import com.dassault.cecilia.lib.mbsa.NodeReader;
import com.dassault.cecilia.lib.mbsa.Stepper;
import com.dassault.cecilia.lib.mbsa.StepperException;
import com.dassault.cecilia.lib.util.ResIcoAbstract;
import com.dassault.cecilia.lib.util.io.XMLWriter;
import com.dassault.cecilia.plugin.mbsa.seqgen.DlgTargetsSeq;
import com.dassault.cecilia.plugin.mbsa.seqgen.PluginItemFilter;
import com.dassault.cecilia.plugin.mbsa.seqgen.PluginTargetModelSeq;
import com.dassault.cecilia.plugin.mbsa.seqgen.ResSeqGen;
import com.dassault.cecilia.plugin.mbsa.viewer.DefaultFileFilter;
import com.dassault.cecilia.plugin.mbsa.viewer.TargetModel;
import com.dassault.cecilia.plugin.mbsa.viewer.UtilityPluginTargetsDB;
import com.dassault.cecilia.plugin.mbsa.viewer.ban.BatchTreeImport;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.text.DefaultFormatter;

public class PluginCmdSeqGen
extends AbstractPluginWithStepper
implements PluginMAction,
CECILIAClient.DistribClientListener {
    public static final String OPT_ERROR_NBR = PluginCmdSeqGen.class.getName() + "#ErrorNbr";
    public static final String OPT_DISPLAY_PROGRESS_NBR = PluginCmdSeqGen.class.getName() + "#DisplayProgressNbr";
    public static final String OPT_SEQUENTIAL = PluginCmdSeqGen.class.getName() + "#Sequential";
    public static final String OPT_THREADED = PluginCmdSeqGen.class.getName() + "#Threaded";
    public static final String OPT_THREADED_MAX = PluginCmdSeqGen.class.getName() + "#ThreadedMax";
    public static final String OPT_DISTRIB = PluginCmdSeqGen.class.getName() + "#Distributed";
    public static final String OPT_EVT_LOCKER = PluginCmdSeqGen.class.getName() + "#EvtLooker";
    public static final String OPT_DISPLAY_CUTS = PluginCmdSeqGen.class.getName() + "#DisplayCuts";
    public static final String OPT_TYPE = PluginCmdSeqGen.class.getName() + "#TypeGenerator";
    public static final String OPT_TYPE_COMB = "Comb";
    public static final String OPT_TYPE_PERMUT = "Permut";
    public static final String OPT_TYPE_REPEAT = "Repeat";
    public static final String OPT_ORDER = PluginCmdSeqGen.class.getName() + "#Order";
    public static final String OPT_SET = PluginCmdSeqGen.class.getName() + "#TypeSet";
    public static final String OPT_SET_MINSEQ = "MINSEQ";
    public static final String OPT_SET_MINCUT = "MINCUT";
    public static final String OPT_FORMAT = PluginCmdSeqGen.class.getName() + "#TypeFormat";
    public static final String OPT_FRM_ARALIA = "ARALIA";
    public static final String OPT_FRM_MCS = "MCS";
    public static final String OPT_FRM_XML = "XML";
    public static final String OPT_POST_PROCESS = PluginCmdSeqGen.class.getName() + "#PostProcess";
    public static final String OPT_EVT_FILTER_DEPEND = PluginCmdSeqGen.class.getName() + "#FilterDepend";
    public static final String OPT_EVT_FILTER_EXCLUDE_NUMBER = PluginCmdSeqGen.class.getName() + "#FilterExcludeNumber";
    public static final String OPT_EVT_FILTER_EXCLUDE_ITEM = PluginCmdSeqGen.class.getName() + "#FilterExcludeItem";
    public static final String OPT_EVT_INVISIBLE_DEPEND = PluginCmdSeqGen.class.getName() + "#InvisibleDepend";
    public static final String OPT_EVT_INVISIBLE_EXCLUDE_NUMBER = PluginCmdSeqGen.class.getName() + "#InvisibleExcludeNumber";
    public static final String OPT_EVT_INVISIBLE_EXCLUDE_ITEM = PluginCmdSeqGen.class.getName() + "#InvisibleExcludeItem";
    SeqGenOptsPanel _opts = null;
    private static final String DEPEND_CMD = "com.dassault.cecilia.plugin.mbsa.viewer.PluginCmdViewStepper";
    protected static final String DEFINE_FILTER_EVENTS = "<!-- DEFINE FILTER EVENTS -->";
    protected static final String DEFINE_INVISIBLE_EVENTS = "<!-- DEFINE INVISIBLE EVENTS -->";

    public String getInfo(String key) {
        if (key.equals("plugin.name")) {
            return ResSeqGen.getString("PLUG_CMD_SEQ_NAME");
        }
        if (key.equals("plugin.description") || key.equals("plugin.tooltip")) {
            return ResSeqGen.getString("PLUG_CMD_SEQ_DESC");
        }
        if (key.equals("plugin.shortcut")) {
            return "alt G";
        }
        if (key.equals("type")) {
            return "PluginAction";
        }
        return super.getInfo(key);
    }

    public Icon getIcon(String key) {
        if (key.equals("plugin.default")) {
            return ResIcoAbstract.getIconRes((URL)((Object)((Object)this)).getClass().getResource("A3-04.svg"));
        }
        return super.getIcon(key);
    }

    public boolean withOption(Plugable plugable) {
        return true;
    }

    public PlugPanel displayOption(Plugable launcher) {
        if (this._opts == null) {
            this._opts = new SeqGenOptsPanel();
        }
        this._opts.prepareWith(launcher);
        if (this._opts._ctrlDistributed.isSelected()) {
            CECILIAClient.addDistribClientListener((CECILIAClient.DistribClientListener)this);
        }
        return this._opts;
    }

    public void refreshOptions(Plugable launcher) {
        if (this._opts != null) {
            this._opts.prepareWith(launcher);
        }
    }

    public void createSession(Plugable launch, Object parameters) {
        Object fmodel;
        Object step;
        BanEntry ban;
        PluginModel plugin = launch.getPlugin(DEPEND_CMD);
        if (plugin == null) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)launch.getWindow()), ResSeqGen.getString("ERR_DEPEND_PLUGIN") + "\n   [" + DEPEND_CMD + "]");
            return;
        }
        PlugableProxyModel launcher = new PlugableProxyModel(launch);
        IModel model = launcher.getModel("altarica.file");
        if (model == null) {
            return;
        }
        Stepper stepper = null;
        if (parameters instanceof String) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("create.fmodel", "true");
            stepper = this.createStepper((Plugable)launcher, new AbstractPluginWithStepper.InfoStepper((String)parameters, model, params));
        } else {
            stepper = this.createStepper((Plugable)launcher, parameters);
        }
        if (stepper == null) {
            return;
        }
        if (stepper instanceof BanConnected && (ban = ((BanConnected)stepper).getBanEntry()) != null && (step = ban.getIdObject("stepper-id")) != null && step instanceof Stepper && (fmodel = ban.getIdObject("altr-fmodel")) != null && fmodel instanceof ModelReader && ((ModelReader)fmodel).getNodeCount() == 1) {
            NodeReader flatNode = ((ModelReader)fmodel).getNode(0);
            DlgTargetsSeq dlg = this.createComputeOpts((Plugable)launcher, stepper, flatNode);
            if (dlg == null) {
                return;
            }
            this.createTask((Plugable)launcher, model, dlg, ban);
            dlg.dispose();
            return;
        }
        JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)launcher.getWindow()), ResSeqGen.getString("ERR_STEPPER"));
    }

    private DlgTargetsSeq createComputeOpts(Plugable launcher, Stepper stepper, NodeReader flatNode) {
        ViewStepper viewStepper = new ViewStepper();
        try {
            viewStepper.open(stepper);
        }
        catch (StepperException e) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)launcher.getWindow()), ResSeqGen.getString("ERR_STEPPER_EXC") + "\n" + e.getMessage(), this.getInfo("plugin.name"), 0);
            return null;
        }
        viewStepper.getRoot().setWithDomain(true);
        int order = PlugableUtility.getIntOpt((Plugable)launcher, (String)OPT_ORDER, (int)3);
        PluginTargetModelSeq defTgt = new PluginTargetModelSeq(order);
        defTgt.defineDefault(launcher, viewStepper, new DefaultFileFilter(){

            @Override
            public boolean accept(File f) {
                String fname = f.getName().toLowerCase();
                return fname.endsWith(".seq") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return "Sequences File(*.seq)";
            }

            @Override
            public String getDefaultExtension() {
                return ".seq";
            }
        });
        DlgTargetsSeq dlg = new DlgTargetsSeq(launcher);
        dlg.create(defTgt);
        dlg.setNode(flatNode);
        if (!dlg.doModal(launcher)) {
            dlg = null;
        }
        viewStepper.close();
        return dlg;
    }

    private AbstractPlugTaskBanWithLog createTask(final Plugable launcher, IModel model, DlgTargetsSeq dlg, BanEntry previous) {
        File logFile = this.createFile(launcher, "SeqGen", ".log");
        if (logFile == null) {
            return null;
        }
        boolean bSequential = PlugableUtility.getBoolOpt((Plugable)launcher, (String)OPT_SEQUENTIAL, (boolean)false);
        String nameScript = bSequential ? "BanScriptSeqGenSequential.xml" : "BanScriptSeqGen.xml";
        InputStream baseScript = ((Object)((Object)this)).getClass().getResourceAsStream(nameScript);
        if (baseScript == null) {
            Logger.getLogger(PluginCmdSeqGen.class.getPackage().getName()).severe("Resource script not found : " + nameScript);
            return null;
        }
        UtilityPluginTargetsSeqGen util = new UtilityPluginTargetsSeqGen(dlg.getTargets(), bSequential, dlg.getFilterItems(), dlg.getInvisibleItems(), dlg.getDbOutputSelection());
        BanInputStream script = util.createBanScript(launcher, "SeqGen", baseScript, logFile);
        if (script == null) {
            return null;
        }
        BanEntry entry = util.createBanEntry(launcher, previous);
        if (entry == null) {
            return null;
        }
        entry.addUnit(BatchTreeImport.class);
        entry.setUserProperty("seqgen.log.path", logFile.getAbsolutePath());
        AbstractPlugTaskBanWithLog task = new AbstractPlugTaskBanWithLog(model.getUID(), launcher, entry, script, logFile){

            protected String getDesc() {
                return ResSeqGen.getString("PLUG_CMD_SEQ_NAME");
            }

            protected String getName() {
                return "SeqGen";
            }

            public Icon getIcon(String key) {
                if (key.equals("ptask.icon")) {
                    return ResIcoAbstract.getIconRes((URL)((Object)((Object)this)).getClass().getResource("A3-04.svg"));
                }
                return super.getIcon(key);
            }

            protected void displayResult(File pathInfo, boolean endTrace) {
                super.displayResult(pathInfo, endTrace);
                launcher.getAppl().refreshDAOFolder();
                launcher.getAppl().refreshFolders(true);
            }
        };
        launcher.addTask((PlugTask)task, model.getUID());
        return task;
    }

    public void callbackSearchServer() {
    }

    class UtilityPluginTargetsSeqGen
    extends UtilityPluginTargetsDB {
        boolean _bSequential;
        List<PluginItemFilter.Filter> _filterItems;
        List<PluginItemFilter.Filter> _invisibleItems;
        String _dbConflictOption;

        public UtilityPluginTargetsSeqGen(List<TargetModel> targets, boolean sequential, List<PluginItemFilter.Filter> filterItems, List<PluginItemFilter.Filter> invisibleItems, String dbConflictOption) {
            super(targets);
            this.addKeyFragment(PluginCmdSeqGen.DEFINE_FILTER_EVENTS);
            this.addKeyFragment(PluginCmdSeqGen.DEFINE_INVISIBLE_EVENTS);
            this._filterItems = filterItems;
            this._invisibleItems = invisibleItems;
            this._bSequential = sequential;
            this._dbConflictOption = dbConflictOption;
        }

        protected String getTitle() {
            return PluginCmdSeqGen.this.getInfo("plugin.name");
        }

        protected File createFile(Plugable launch, String base, String ext) {
            return PluginCmdSeqGen.this.createFile(launch, base, ext);
        }

        protected String getPostProcessKey(Plugable launcher) {
            return launcher.getOption(OPT_POST_PROCESS);
        }

        @Override
        protected void defineUserProperties(Plugable launch, BanEntry entry) {
            String typeSet = PlugableUtility.getStrOpt((Plugable)launch, (String)OPT_SET, (String)PluginCmdSeqGen.OPT_SET_MINSEQ);
            if (typeSet.equals(PluginCmdSeqGen.OPT_SET_MINCUT)) {
                entry.setUserProperty("seqgen.resultset", "mincuts");
            } else if (typeSet.equals(PluginCmdSeqGen.OPT_SET_MINSEQ)) {
                entry.setUserProperty("seqgen.resultset", "minseqs");
            } else {
                entry.setUserProperty("seqgen.resultset", "basic");
            }
            String typeFind = PlugableUtility.getStrOpt((Plugable)launch, (String)OPT_TYPE, (String)PluginCmdSeqGen.OPT_TYPE_PERMUT);
            if (typeFind.equals(PluginCmdSeqGen.OPT_TYPE_COMB)) {
                entry.setUserProperty("seqgen.finder", "combinaison");
            } else if (typeFind.equals(PluginCmdSeqGen.OPT_TYPE_REPEAT)) {
                entry.setUserProperty("seqgen.finder", "repetition");
            } else if (typeFind.equals(PluginCmdSeqGen.OPT_TYPE_PERMUT)) {
                entry.setUserProperty("seqgen.finder", "permutation");
            } else {
                entry.setUserProperty("seqgen.finder", "basic");
            }
            if (!this._bSequential) {
                entry.setUserProperty("seqgen.finder.order", Integer.toString(PlugableUtility.getIntOpt((Plugable)launch, (String)OPT_ORDER, (int)3)));
                entry.setUserProperty("seqgen.target.number", Integer.toString(this._targets.size()));
            }
            entry.setUserProperty("seqgen.locker", Boolean.toString(PlugableUtility.getBoolOpt((Plugable)launch, (String)OPT_EVT_LOCKER, (boolean)true)));
            String typeFormat = PlugableUtility.getStrOpt((Plugable)launch, (String)OPT_FORMAT, (String)PluginCmdSeqGen.OPT_FRM_XML);
            if (typeFormat.equals(PluginCmdSeqGen.OPT_FRM_XML)) {
                entry.setUserProperty("seqgen.format", PluginCmdSeqGen.OPT_FRM_XML);
            } else if (typeFormat.equals(PluginCmdSeqGen.OPT_FRM_ARALIA)) {
                entry.setUserProperty("seqgen.format", "aralia");
            } else {
                entry.setUserProperty("seqgen.format", PluginCmdSeqGen.OPT_FRM_MCS);
            }
            entry.setUserProperty("seqgen.maxerror", Integer.toString(PlugableUtility.getIntOpt((Plugable)launch, (String)OPT_ERROR_NBR, (int)10)));
            entry.setUserProperty("seqgen.progress.step", Integer.toString(PlugableUtility.getIntOpt((Plugable)launch, (String)OPT_DISPLAY_PROGRESS_NBR, (int)100)));
            entry.setUserProperty("seqgen.distrib", Boolean.toString(PlugableUtility.getBoolOpt((Plugable)launch, (String)OPT_DISTRIB, (boolean)false)));
            entry.setUserProperty("seqgen.sequential", Boolean.toString(PlugableUtility.getBoolOpt((Plugable)launch, (String)OPT_SEQUENTIAL, (boolean)false)));
            entry.setUserProperty("seqgen.threaded", Boolean.toString(PlugableUtility.getBoolOpt((Plugable)launch, (String)OPT_THREADED, (boolean)false)));
            entry.setUserProperty("seqgen.threaded.max", Integer.toString(PlugableUtility.getIntOpt((Plugable)launch, (String)OPT_THREADED_MAX, (int)2)));
        }

        @Override
        protected void writeTargetToBanScript(Plugable plugable, Writer writer, TargetModel Tgt, int cpt, int nbr) throws IOException {
            PluginTargetModelSeq tgt = (PluginTargetModelSeq)Tgt;
            if (this._bSequential) {
                this.writeProgressToBanScript(writer, tgt, cpt, nbr);
                writer.write("<callfunct ref=\"seqgen-launch\">\n");
                writer.write("<value valuable=\"false\" value=\"");
                writer.write(XMLWriter.toXML((String)tgt.getVarTarget()));
                writer.write("\"/>\n");
                writer.write("<value valuable=\"false\" value=\"");
                writer.write(XMLWriter.toXML((String)tgt.getValTarget()));
                writer.write("\"/>\n");
                writer.write("<value valuable=\"false\" value=\"");
                writer.write(XMLWriter.toXML((String)tgt.getFilePath()));
                writer.write("\"/>\n");
                writer.write("<value valuable=\"false\" value=\"");
                writer.write(Integer.toString(tgt.getOrder()));
                writer.write("\"/>\n");
                writer.write("<value valuable=\"false\" value=\"");
                writer.write(Boolean.toString(cpt > 1));
                writer.write("\"/>\n");
                writer.write("</callfunct>\n");
            } else {
                writer.write("<target name=\"");
                writer.write(XMLWriter.toXML((String)tgt.getVarTarget()));
                writer.write("\" value=\"");
                writer.write(XMLWriter.toXML((String)tgt.getValTarget()));
                writer.write("\" file=\"");
                writer.write(XMLWriter.toXML((String)tgt.getFilePath()));
                writer.write("\"/>\n");
            }
        }

        @Override
        protected void writeFragment(Plugable launcher, Writer writer, String keyFragment, File logFile) throws IOException {
            if (PluginCmdSeqGen.DEFINE_FILTER_EVENTS.equals(keyFragment)) {
                boolean bDepend = PlugableUtility.getBoolOpt((Plugable)launcher, (String)OPT_EVT_FILTER_DEPEND, (boolean)false);
                if (this._filterItems.size() > 0 || bDepend) {
                    writer.write("  <filter>\n");
                    if (bDepend) {
                        writer.write("    <include depend=\"");
                        if (this._bSequential) {
                            writer.write("%{tgtname}");
                        } else {
                            Iterator iTgt = this._targets.iterator();
                            while (iTgt.hasNext()) {
                                writer.write("(");
                                writer.write(XMLWriter.toXML((String)((TargetModel)iTgt.next()).getVarTarget()));
                                writer.write(")");
                                if (!iTgt.hasNext()) continue;
                                writer.write("|");
                            }
                        }
                        writer.write("\"/>\n");
                    }
                    for (int i = 0; i < this._filterItems.size(); ++i) {
                        writer.write("    <exclude ");
                        PluginItemFilter.Filter item = this._filterItems.get(i);
                        switch (item._type) {
                            case NAME: {
                                writer.append("name=\"").append(XMLWriter.toXML((String)item._patternName)).append("\"");
                                break;
                            }
                            case ATTRIBUTE: {
                                writer.append("attribute=\"").append(XMLWriter.toXML((String)item._patternName)).append("\"");
                                if (item._expressionValue == null) break;
                                writer.append(" value=\"").append(XMLWriter.toXML((String)item._expressionValue)).append("\"");
                            }
                        }
                        writer.write("/>\n");
                    }
                    writer.write("  </filter>\n");
                }
            } else if (PluginCmdSeqGen.DEFINE_INVISIBLE_EVENTS.equals(keyFragment)) {
                boolean bDepend = PlugableUtility.getBoolOpt((Plugable)launcher, (String)OPT_EVT_INVISIBLE_DEPEND, (boolean)false);
                if (this._invisibleItems.size() > 0 || bDepend) {
                    writer.write("  <invisible>\n");
                    if (bDepend) {
                        writer.write("    <include instantaneous=\"true\"/>\n");
                    }
                    for (int i = 0; i < this._invisibleItems.size(); ++i) {
                        writer.write("    <exclude ");
                        PluginItemFilter.Filter item = this._invisibleItems.get(i);
                        switch (item._type) {
                            case NAME: {
                                writer.append("name=\"").append(XMLWriter.toXML((String)item._patternName)).append("\"");
                                break;
                            }
                            case ATTRIBUTE: {
                                writer.append("attribute=\"").append(XMLWriter.toXML((String)item._patternName)).append("\"");
                                if (item._expressionValue == null) break;
                                writer.append(" value=\"").append(XMLWriter.toXML((String)item._expressionValue)).append("\"");
                            }
                        }
                        writer.write("/>\n");
                    }
                    writer.write("  </invisible>\n");
                }
            } else {
                super.writeFragment(launcher, writer, keyFragment, logFile);
            }
        }

        @Override
        protected String getDBConflictOption() {
            return this._dbConflictOption;
        }

        @Override
        protected String withDestination() {
            return "  <destination file='${seqgen.log.path}'>\n    <param name='Append' value='true'/>\n    <layout name='%{seqgen.log.format}'>\n      <param name='Info' value='" + Boolean.getBoolean("cecilia.mbsa.plugin.abc.DBImportWithInfo") + "'/>\n      <param name='Output' value='true'/>\n    </layout>\n  </destination>\n";
        }
    }

    class SeqGenOptsPanel
    extends JPanel
    implements PlugPanel {
        Plugable _launcher;
        JCheckBox _ctrlSequential;
        JCheckBox _ctrlThreaded;
        JCheckBox _ctrlDistributed;
        JCRLabel _lblError;
        JCRLabel _lblProgress;
        JCRLabel _lblThreaded;
        JFormattedTextField _ctrlErrorNbr;
        JFormattedTextField _ctrlProgressNbr;
        JFormattedTextField _ctrlThreadedNbr;

        public void prepareWith(Plugable launcher) {
            this._launcher = launcher;
            this._ctrlSequential.setSelected(PlugableUtility.getBoolOpt((Plugable)this._launcher, (String)OPT_SEQUENTIAL, (boolean)false));
            this._ctrlThreaded.setSelected(PlugableUtility.getBoolOpt((Plugable)this._launcher, (String)OPT_THREADED, (boolean)false));
            this._ctrlThreadedNbr.setText(Integer.toString(PlugableUtility.getIntOpt((Plugable)this._launcher, (String)OPT_THREADED_MAX, (int)2)));
            this._ctrlDistributed.setSelected(PlugableUtility.getBoolOpt((Plugable)this._launcher, (String)OPT_DISTRIB, (boolean)false));
            this._ctrlErrorNbr.setText(Integer.toString(PlugableUtility.getIntOpt((Plugable)this._launcher, (String)OPT_ERROR_NBR, (int)10)));
            this._ctrlProgressNbr.setText(Integer.toString(PlugableUtility.getIntOpt((Plugable)this._launcher, (String)OPT_DISPLAY_PROGRESS_NBR, (int)100)));
            boolean bThreadSelect = this._ctrlThreaded.isSelected();
            this._lblThreaded.setEnabled(bThreadSelect);
            this._ctrlThreadedNbr.setEnabled(bThreadSelect);
        }

        public SeqGenOptsPanel() {
            super(new GridBagLayout());
            this._launcher = null;
            NumberFormat nf = NumberFormat.getNumberInstance();
            nf.setParseIntegerOnly(true);
            nf.setGroupingUsed(false);
            JPanel opts = new JPanel(new GridBagLayout());
            this._lblError = new JCRLabel(ResSeqGen.getString("DLG_OPT_SEQ_ERROR_LBL"));
            this._ctrlErrorNbr = new JFormattedTextField(nf);
            ((DefaultFormatter)this._ctrlErrorNbr.getFormatter()).setAllowsInvalid(false);
            this._ctrlErrorNbr.setColumns(6);
            this._ctrlErrorNbr.setText("10");
            this._ctrlErrorNbr.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    try {
                        String value = SeqGenOptsPanel.this._ctrlErrorNbr.getText();
                        if (Integer.parseInt(value) <= 0) {
                            throw new NumberFormatException();
                        }
                        SeqGenOptsPanel.this._launcher.setOption(OPT_ERROR_NBR, value);
                    }
                    catch (NumberFormatException exc) {
                        SeqGenOptsPanel.this._ctrlErrorNbr.setText(Integer.toString(PlugableUtility.getIntOpt((Plugable)SeqGenOptsPanel.this._launcher, (String)OPT_ERROR_NBR, (int)10)));
                        SeqGenOptsPanel.this._ctrlErrorNbr.requestFocus();
                    }
                }
            });
            opts.add((Component)this._lblError, new GridBagConstraints(0, 0, 1, 1, 100.0, 100.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            opts.add((Component)this._ctrlErrorNbr, new GridBagConstraints(1, 0, 1, 1, 100.0, 100.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            this._lblProgress = new JCRLabel(ResSeqGen.getString("DLG_OPT_SEQ_PROGRESS_LBL"));
            this._ctrlProgressNbr = new JFormattedTextField(nf);
            ((DefaultFormatter)this._ctrlProgressNbr.getFormatter()).setAllowsInvalid(false);
            this._ctrlProgressNbr.setColumns(6);
            this._ctrlProgressNbr.setText("1000");
            this._ctrlProgressNbr.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    try {
                        String value = SeqGenOptsPanel.this._ctrlProgressNbr.getText();
                        if (Integer.parseInt(value) <= 0) {
                            throw new NumberFormatException();
                        }
                        SeqGenOptsPanel.this._launcher.setOption(OPT_DISPLAY_PROGRESS_NBR, value);
                    }
                    catch (NumberFormatException exc) {
                        SeqGenOptsPanel.this._ctrlProgressNbr.setText(Integer.toString(PlugableUtility.getIntOpt((Plugable)SeqGenOptsPanel.this._launcher, (String)OPT_DISPLAY_PROGRESS_NBR, (int)100)));
                        SeqGenOptsPanel.this._ctrlErrorNbr.requestFocus();
                    }
                }
            });
            opts.add((Component)this._lblProgress, new GridBagConstraints(0, 1, 1, 1, 100.0, 100.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            opts.add((Component)this._ctrlProgressNbr, new GridBagConstraints(1, 1, 1, 1, 100.0, 100.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            int idxOpt = 2;
            this._ctrlSequential = new JCheckBox(ResSeqGen.getString("DLG_OPT_SEQ_SEQUENTIAL"));
            this._ctrlSequential.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SeqGenOptsPanel.this._launcher.setOption(OPT_SEQUENTIAL, SeqGenOptsPanel.this._ctrlSequential.isSelected() ? "true" : "false");
                }
            });
            opts.add((Component)this._ctrlSequential, new GridBagConstraints(0, idxOpt++, 2, 1, 100.0, 100.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            JPanel panelThreaded = new JPanel((LayoutManager)new ToggleBorderLayout());
            this._ctrlThreaded = new JCheckBox(ResSeqGen.getString("DLG_OPT_SEQ_THREADED"));
            this._ctrlThreaded.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean bThreadSelect = SeqGenOptsPanel.this._ctrlThreaded.isSelected();
                    SeqGenOptsPanel.this._lblThreaded.setEnabled(bThreadSelect);
                    SeqGenOptsPanel.this._ctrlThreadedNbr.setEnabled(bThreadSelect);
                    SeqGenOptsPanel.this._launcher.setOption(OPT_THREADED, bThreadSelect ? "true" : "false");
                }
            });
            this._lblThreaded = new JCRLabel(ResSeqGen.getString("DLG_OPT_SEQ_THREADED_LBL"));
            this._ctrlThreadedNbr = new JFormattedTextField(nf);
            ((DefaultFormatter)this._ctrlThreadedNbr.getFormatter()).setAllowsInvalid(false);
            this._ctrlThreadedNbr.setColumns(6);
            this._ctrlThreadedNbr.setText("2");
            this._ctrlThreadedNbr.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    try {
                        String value = SeqGenOptsPanel.this._ctrlThreadedNbr.getText();
                        Integer.parseInt(value);
                        SeqGenOptsPanel.this._launcher.setOption(OPT_THREADED_MAX, value);
                    }
                    catch (NumberFormatException exc) {
                        SeqGenOptsPanel.this._ctrlThreadedNbr.setText(Integer.toString(PlugableUtility.getIntOpt((Plugable)SeqGenOptsPanel.this._launcher, (String)OPT_THREADED_MAX, (int)2)));
                        SeqGenOptsPanel.this._ctrlThreadedNbr.requestFocus();
                    }
                }
            });
            JPanel intern = new JPanel(new GridBagLayout());
            intern.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(10, 5, 5, 5)));
            intern.add((Component)this._lblThreaded, new GridBagConstraints(0, 0, 1, 1, 100.0, 100.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            intern.add((Component)this._ctrlThreadedNbr, new GridBagConstraints(1, 0, 1, 1, 100.0, 100.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            panelThreaded.add(this._ctrlThreaded);
            panelThreaded.add(intern);
            opts.add((Component)panelThreaded, new GridBagConstraints(0, idxOpt++, 2, 1, 100.0, 100.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            this._ctrlDistributed = new JCheckBox(ResSeqGen.getString("DLG_OPT_SEQ_DISTRIB"));
            this._ctrlDistributed.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean oldValue = PlugableUtility.getBoolOpt((Plugable)SeqGenOptsPanel.this._launcher, (String)OPT_DISTRIB, (boolean)false);
                    if (oldValue == SeqGenOptsPanel.this._ctrlDistributed.isSelected()) {
                        return;
                    }
                    if (oldValue) {
                        CECILIAClient.removeDistribClientListener((CECILIAClient.DistribClientListener)PluginCmdSeqGen.this);
                    } else {
                        CECILIAClient.addDistribClientListener((CECILIAClient.DistribClientListener)PluginCmdSeqGen.this);
                    }
                    SeqGenOptsPanel.this._launcher.setOption(OPT_DISTRIB, SeqGenOptsPanel.this._ctrlDistributed.isSelected() ? "true" : "false");
                }
            });
            opts.add((Component)this._ctrlDistributed, new GridBagConstraints(0, idxOpt++, 2, 1, 100.0, 100.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            JButton defVal = new JButton(ResSeqGen.getString("DLG_DEFVALUE"));
            defVal.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SeqGenOptsPanel.this._ctrlErrorNbr.setText("10");
                    SeqGenOptsPanel.this._launcher.setOption(OPT_ERROR_NBR, "10");
                    SeqGenOptsPanel.this._ctrlProgressNbr.setText("100");
                    SeqGenOptsPanel.this._launcher.setOption(OPT_DISPLAY_PROGRESS_NBR, "100");
                    SeqGenOptsPanel.this._ctrlSequential.setSelected(false);
                    SeqGenOptsPanel.this._launcher.setOption(OPT_SEQUENTIAL, "false");
                    SeqGenOptsPanel.this._ctrlThreaded.setSelected(false);
                    SeqGenOptsPanel.this._lblThreaded.setEnabled(false);
                    SeqGenOptsPanel.this._ctrlThreadedNbr.setEnabled(false);
                    SeqGenOptsPanel.this._launcher.setOption(OPT_THREADED, "false");
                    SeqGenOptsPanel.this._ctrlThreadedNbr.setText("2");
                    SeqGenOptsPanel.this._launcher.setOption(OPT_THREADED_MAX, "2");
                    boolean oldValue = PlugableUtility.getBoolOpt((Plugable)SeqGenOptsPanel.this._launcher, (String)OPT_DISTRIB, (boolean)false);
                    if (oldValue) {
                        CECILIAClient.removeDistribClientListener((CECILIAClient.DistribClientListener)PluginCmdSeqGen.this);
                        SeqGenOptsPanel.this._launcher.setOption(OPT_DISTRIB, "false");
                    }
                }
            });
            opts.add((Component)defVal, new GridBagConstraints(0, idxOpt++, 2, 1, 100.0, 100.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)opts, new GridBagConstraints(0, 0, 1, 1, 100.0, 100.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        }

        public Component getPanel() {
            return this;
        }

        public void trash() {
        }

        public String getInfo(String key) {
            return PluginCmdSeqGen.this.getInfo(key);
        }

        public Icon getIcon(String key) {
            return null;
        }
    }
}

