/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.seqgen;

import com.dassault.cecilia.core.plugin.PanelSelectProcess;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PlugableUtility;
import com.dassault.cecilia.core.plugin.PluginMProcess;
import com.dassault.cecilia.core.plugin.PluginManager;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.table.TableDecoredItem;
import com.dassault.cecilia.core.swing.table.TableDecoredModel;
import com.dassault.cecilia.core.swing.table.TableDecoredPanel;
import com.dassault.cecilia.lib.mbsa.NodeReader;
import com.dassault.cecilia.lib.util.io.IndentWriter;
import com.dassault.cecilia.plugin.mbsa.seqgen.PluginCmdSeqGen;
import com.dassault.cecilia.plugin.mbsa.seqgen.PluginItemFilter;
import com.dassault.cecilia.plugin.mbsa.seqgen.PluginTargetModelSeq;
import com.dassault.cecilia.plugin.mbsa.seqgen.ResSeqGen;
import com.dassault.cecilia.plugin.mbsa.viewer.DefaultFileFilter;
import com.dassault.cecilia.plugin.mbsa.viewer.TargetModel;
import com.dassault.cecilia.plugin.mbsa.viewer.TargetsPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TargetsSeqPanel
extends TargetsPanel {
    private JCheckBox _ctrlEvtLooker;
    private JRadioButton _ctrlSeqComb;
    private JRadioButton _ctrlSeqPermut;
    private JRadioButton _ctrlSeqRepeat;
    private JComboBox<EnumResultSet> _ctrlSet;
    private JComboBox<EnumFormat> _ctrlFormat;
    private PanelSelectProcess _ctrlPostProcess;
    private JCheckBox _ctrlEvtFilterDepend;
    private PluginItemFilter _itemEvtFilter;
    private TableDecoredModel<PluginItemFilter> _tableEvtFilterExclude;
    private TableDecoredPanel<PluginItemFilter> _ctrlEvtFilterExclude;
    private JCheckBox _ctrlEvtInvisibleDepend;
    private PluginItemFilter _itemEvtInvisible;
    private TableDecoredModel<PluginItemFilter> _tableEvtInvisibleExclude;
    private TableDecoredPanel<PluginItemFilter> _ctrlEvtInvisibleExclude;
    private NodeReader _flatNode;
    private Plugable _launcher;
    private static final String XML_ELEM_SEQGEN = "seqgen";
    private static final String XML_ATTR_SEQGEN_GENERATION_TYPE = "generationType";
    private static final String XML_ATTR_SEQGEN_TARGET_ABSORB = "absorbentTarget";
    private static final String XML_ATTR_SEQGEN_RESULT_TYPE = "resultType";
    private static final String XML_ATTR_SEQGEN_DISPLAY_FORMAT = "displayFormat";
    private static final String XML_ELEM_EVENTS = "events";
    private static final String XML_ATTR_EVENTS_DEPENDS = "includeOnlyDepends";
    private static final String XML_ELEM_INVISIBLES = "invisibles";
    private static final String XML_ATTR_INVISIBLES_INSTANTANEOUS = "instantaneous";
    private static final String XML_ELEM_EXCLUDE = "exclude";
    private static final String XML_ATTR_FILTER_TYPE = "type";
    private static final String XML_ATTR_FILTER_NAME = "name";
    private static final String XML_ATTR_FILTER_EXPR = "expression";

    public TargetsSeqPanel(Plugable launcher, TargetModel def, String title) {
        super(def, title);
        this._launcher = launcher;
    }

    public void setNode(NodeReader flatNode) {
        this._flatNode = flatNode;
    }

    public void deleteNode() {
        this._flatNode = null;
    }

    @Override
    protected JPanel createOtherInfoPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        JTabbedPane result = new JTabbedPane();
        result.add(ResSeqGen.getString("PRV_CMD_SEQ_TAB_GENERAL"), this.createGeneralOptions());
        result.add(ResSeqGen.getString("PRV_CMD_SEQ_TAB_FILTER"), this.createFilterOptions());
        result.add(ResSeqGen.getString("PRV_CMD_SEQ_TAB_INVISIBLE"), this.createInvisibleOptions());
        result.removeTabAt(2);
        panel.add((Component)result, "Center");
        return panel;
    }

    @Override
    public void copyToCtrl(Plugable launcher) {
        PluginItemFilter item;
        String code;
        int i;
        super.copyToCtrl(launcher);
        this._ctrlPostProcess.setPlugable((PluginManager)launcher);
        this._itemEvtFilter.prepareEditor(SwingUtilities.getWindowAncestor(this), this._flatNode);
        this._itemEvtInvisible.prepareEditor(SwingUtilities.getWindowAncestor(this), this._flatNode);
        String value = launcher.getOption(PluginCmdSeqGen.OPT_TYPE);
        if (value == null) {
            this._ctrlSeqPermut.setSelected(true);
        } else if (value.equalsIgnoreCase("Comb")) {
            this._ctrlSeqComb.setSelected(true);
        } else if (value.equalsIgnoreCase("Repeat")) {
            this._ctrlSeqRepeat.setSelected(true);
        } else {
            this._ctrlSeqPermut.setSelected(true);
        }
        String set = launcher.getOption(PluginCmdSeqGen.OPT_SET);
        if (set != null) {
            for (int i2 = this._ctrlSet.getItemCount() - 1; i2 >= 0; --i2) {
                if (!set.equals(this._ctrlSet.getItemAt(i2).getCode())) continue;
                this._ctrlSet.setSelectedIndex(i2);
                break;
            }
        }
        int idxSelect = 0;
        set = launcher.getOption(PluginCmdSeqGen.OPT_FORMAT);
        if (set != null) {
            for (int i3 = this._ctrlFormat.getItemCount() - 1; i3 >= 0; --i3) {
                if (!set.equals(this._ctrlFormat.getItemAt(i3).getCode())) continue;
                idxSelect = i3;
                break;
            }
        }
        this._ctrlFormat.setSelectedIndex(idxSelect);
        this._ctrlEvtLooker.setSelected(PlugableUtility.getBoolOpt((Plugable)launcher, (String)PluginCmdSeqGen.OPT_EVT_LOCKER, (boolean)true));
        set = launcher.getOption(PluginCmdSeqGen.OPT_POST_PROCESS);
        if (set != null && set.length() > 0) {
            this._ctrlPostProcess.setSelectProcessFromKey(set);
        }
        this._ctrlEvtFilterDepend.setSelected(PlugableUtility.getBoolOpt((Plugable)launcher, (String)PluginCmdSeqGen.OPT_EVT_FILTER_DEPEND, (boolean)true));
        int nbr = PlugableUtility.getIntOpt((Plugable)launcher, (String)PluginCmdSeqGen.OPT_EVT_FILTER_EXCLUDE_NUMBER, (int)0);
        for (i = 0; i < nbr; ++i) {
            code = launcher.getOption(PluginCmdSeqGen.OPT_EVT_FILTER_EXCLUDE_ITEM + (i + 1));
            if (code == null || code.length() == 0 || (item = PluginItemFilter.createFromCode(code)) == null) continue;
            this._tableEvtFilterExclude.addData((TableDecoredItem)item);
        }
        this._ctrlEvtInvisibleDepend.setSelected(PlugableUtility.getBoolOpt((Plugable)launcher, (String)PluginCmdSeqGen.OPT_EVT_INVISIBLE_DEPEND, (boolean)true));
        nbr = PlugableUtility.getIntOpt((Plugable)launcher, (String)PluginCmdSeqGen.OPT_EVT_INVISIBLE_EXCLUDE_NUMBER, (int)0);
        for (i = 0; i < nbr; ++i) {
            code = launcher.getOption(PluginCmdSeqGen.OPT_EVT_INVISIBLE_EXCLUDE_ITEM + (i + 1));
            if (code == null || code.length() == 0 || (item = PluginItemFilter.createFromCode(code)) == null) continue;
            this._tableEvtInvisibleExclude.addData((TableDecoredItem)item);
        }
    }

    @Override
    public void copyFromCtrl(Plugable launcher) {
        PluginItemFilter item;
        int i;
        super.copyFromCtrl(launcher);
        String trueStr = "true";
        String falseStr = "false;";
        String value = "Permut";
        if (this._ctrlSeqComb.isSelected()) {
            value = "Comb";
        } else if (this._ctrlSeqRepeat.isSelected()) {
            value = "Repeat";
        }
        launcher.setOption(PluginCmdSeqGen.OPT_TYPE, value);
        launcher.setOption(PluginCmdSeqGen.OPT_SET, ((EnumResultSet)((Object)this._ctrlSet.getSelectedItem())).getCode());
        launcher.setOption(PluginCmdSeqGen.OPT_FORMAT, ((EnumFormat)((Object)this._ctrlFormat.getSelectedItem())).getCode());
        launcher.setOption(PluginCmdSeqGen.OPT_EVT_LOCKER, this._ctrlEvtLooker.isSelected() ? trueStr : falseStr);
        PluginTargetModelSeq firstTgt = (PluginTargetModelSeq)this.getTargets().get(0);
        launcher.setOption(PluginCmdSeqGen.OPT_ORDER, Integer.toString(firstTgt.getOrder()));
        PluginMProcess plugin = this._ctrlPostProcess.getSelectProcess();
        launcher.setOption(PluginCmdSeqGen.OPT_POST_PROCESS, plugin == null ? "" : plugin.getInfo("plugin.key"));
        launcher.setOption(PluginCmdSeqGen.OPT_EVT_FILTER_DEPEND, this._ctrlEvtFilterDepend.isSelected() ? trueStr : falseStr);
        int nbr = this._tableEvtFilterExclude.getRowCount();
        launcher.setOption(PluginCmdSeqGen.OPT_EVT_FILTER_EXCLUDE_NUMBER, Integer.toString(nbr));
        for (i = 0; i < nbr; ++i) {
            item = (PluginItemFilter)this._tableEvtFilterExclude.getData(i);
            launcher.setOption(PluginCmdSeqGen.OPT_EVT_FILTER_EXCLUDE_ITEM + (i + 1), item._data.getCode());
        }
        launcher.setOption(PluginCmdSeqGen.OPT_EVT_INVISIBLE_DEPEND, this._ctrlEvtInvisibleDepend.isSelected() ? trueStr : falseStr);
        nbr = this._tableEvtInvisibleExclude.getRowCount();
        launcher.setOption(PluginCmdSeqGen.OPT_EVT_INVISIBLE_EXCLUDE_NUMBER, Integer.toString(nbr));
        for (i = 0; i < nbr; ++i) {
            item = (PluginItemFilter)this._tableEvtInvisibleExclude.getData(i);
            launcher.setOption(PluginCmdSeqGen.OPT_EVT_INVISIBLE_EXCLUDE_ITEM + (i + 1), item._data.getCode());
        }
    }

    @Override
    public void processEraseFile(List<File> eraseFile, File file) {
        if (!this.overwriteFile()) {
            eraseFile.add(file);
        }
    }

    private JPanel createGeneralOptions() {
        this._ctrlPostProcess = new PanelSelectProcess(false);
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.weighty = 100.0;
        gbc.weightx = 100.0;
        Box seqType = Box.createVerticalBox();
        seqType.setBorder(BorderFactory.createTitledBorder(ResSeqGen.getString("PRV_CMD_SEQ_TYPE")));
        ButtonGroup grp = new ButtonGroup();
        this._ctrlSeqComb = new JRadioButton(ResSeqGen.getString("PRV_CMD_SEQ_TYPE_COMB"));
        this._ctrlSeqComb.setToolTipText(ResSeqGen.getString("PRV_CMD_SEQ_TYPE_COMB_TOOLTIP"));
        grp.add(this._ctrlSeqComb);
        seqType.add(this._ctrlSeqComb);
        this._ctrlSeqPermut = new JRadioButton(ResSeqGen.getString("PRV_CMD_SEQ_TYPE_PERMUT"));
        this._ctrlSeqPermut.setToolTipText(ResSeqGen.getString("PRV_CMD_SEQ_TYPE_PERMUT_TOOLTIP"));
        grp.add(this._ctrlSeqPermut);
        seqType.add(this._ctrlSeqPermut);
        this._ctrlSeqRepeat = new JRadioButton(ResSeqGen.getString("PRV_CMD_SEQ_TYPE_REPEAT"));
        this._ctrlSeqRepeat.setToolTipText(ResSeqGen.getString("PRV_CMD_SEQ_TYPE_REPEAT_TOOLTIP"));
        grp.add(this._ctrlSeqRepeat);
        seqType.add(this._ctrlSeqRepeat);
        gbc.gridwidth = 1;
        gbc.gridheight = 4;
        gbc.gridy = 1;
        gbc.gridx = 1;
        gbc.anchor = 13;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 10, 10, 10);
        result.add((Component)seqType, gbc);
        this._ctrlEvtLooker = new JCheckBox(ResSeqGen.getString("PRV_CMD_SEQ_EVT_LOOKER"));
        ++gbc.gridx;
        gbc.gridheight = 1;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        result.add((Component)this._ctrlEvtLooker, gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 0, 0, 0);
        result.add((Component)new JLabel(ResSeqGen.getString("PRV_CMD_SEQ_SET")), gbc);
        gbc.weighty = 100.0;
        gbc.weightx = 100.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 10, 0, 10);
        this._ctrlSet = new JComboBox();
        this._ctrlSet.addItem(EnumResultSet.MINCUT);
        this._ctrlSet.addItem(EnumResultSet.MINSEQ);
        this._ctrlSet.addItem(EnumResultSet.BASIC);
        ++gbc.gridx;
        result.add(this._ctrlSet, gbc);
        this._ctrlSet.setSelectedIndex(1);
        --gbc.gridx;
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 0, 0, 0);
        result.add((Component)new JLabel(ResSeqGen.getString("PRV_CMD_SEQ_FRM")), gbc);
        gbc.weighty = 100.0;
        gbc.weightx = 100.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 10, 0, 10);
        this._ctrlFormat = new JComboBox();
        this._ctrlFormat.addItem(EnumFormat.MCS);
        this._ctrlFormat.addItem(EnumFormat.ARALIA);
        this._ctrlFormat.addItem(EnumFormat.XML);
        ++gbc.gridx;
        result.add(this._ctrlFormat, gbc);
        this._ctrlFormat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EnumFormat frm = (EnumFormat)((Object)TargetsSeqPanel.this._ctrlFormat.getSelectedItem());
                TargetsSeqPanel.this.refreshFileFilter(frm.getFileFilter());
                TargetsSeqPanel.this.enableDbOutput(frm.equals((Object)EnumFormat.ARALIA) && TargetsSeqPanel.this._launcher.getAppl() != null);
                TargetsSeqPanel.this._ctrlPostProcess.setFilter("SeqGen/" + frm.getCode());
            }
        });
        --gbc.gridx;
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 0, 0, 0);
        result.add(this._ctrlPostProcess.getLabel(), gbc);
        gbc.weighty = 100.0;
        gbc.weightx = 100.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 10, 0, 10);
        ++gbc.gridx;
        result.add((Component)this._ctrlPostProcess, gbc);
        return result;
    }

    private JPanel createFilterOptions() {
        JPanel result = new JPanel(new BorderLayout());
        this._ctrlEvtFilterDepend = new JCheckBox(ResSeqGen.getString("PRV_CMD_SEQ_TAB_FILTER_DEPEND"));
        this._itemEvtFilter = new PluginItemFilter(PluginItemFilter.FilterType.NAME, ".*");
        this._tableEvtFilterExclude = new TableDecoredModel((TableDecoredItem)this._itemEvtFilter);
        this._ctrlEvtFilterExclude = new TableDecoredPanel<PluginItemFilter>(this._tableEvtFilterExclude){

            protected void createBoxActions(Container aPanel) {
                aPanel.add(TargetsSeqPanel.this._ctrlEvtFilterDepend);
                super.createBoxActions(aPanel);
            }

            protected Dimension getPreferredScrollableViewportSize() {
                return new Dimension(300, 50);
            }
        };
        result.add((Component)this._ctrlEvtFilterExclude, "Center");
        return result;
    }

    private JPanel createInvisibleOptions() {
        JPanel result = new JPanel(new BorderLayout());
        this._ctrlEvtInvisibleDepend = new JCheckBox(ResSeqGen.getString("PRV_CMD_SEQ_TAB_INVISIBLE_INSTANT"));
        this._itemEvtInvisible = new PluginItemFilter(PluginItemFilter.FilterType.NAME, ".*");
        this._tableEvtInvisibleExclude = new TableDecoredModel((TableDecoredItem)this._itemEvtInvisible);
        this._ctrlEvtInvisibleExclude = new TableDecoredPanel<PluginItemFilter>(this._tableEvtInvisibleExclude){

            protected void createBoxActions(Container aPanel) {
                aPanel.add(TargetsSeqPanel.this._ctrlEvtInvisibleDepend);
                super.createBoxActions(aPanel);
            }

            protected Dimension getPreferredScrollableViewportSize() {
                return new Dimension(300, 50);
            }
        };
        result.add((Component)this._ctrlEvtInvisibleExclude, "Center");
        return result;
    }

    @Override
    public boolean verifyParameters() {
        if (!super.verifyParameters()) {
            return false;
        }
        if (!PlugableUtility.getBoolOpt((Plugable)this._launcher, (String)PluginCmdSeqGen.OPT_SEQUENTIAL, (boolean)false)) {
            int order = 0;
            List<TargetModel> targets = this.getTargets();
            for (TargetModel tgt : targets) {
                if (order == 0) {
                    order = ((PluginTargetModelSeq)tgt).getOrder();
                    continue;
                }
                if (order == ((PluginTargetModelSeq)tgt).getOrder()) continue;
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)this), ResSeqGen.getString("DLG_CMD_SEQ_ERROR_DIFF_ORDER"));
                return false;
            }
        }
        return true;
    }

    public List<PluginItemFilter.Filter> getFilterItems() {
        ArrayList<PluginItemFilter.Filter> result = new ArrayList<PluginItemFilter.Filter>();
        int nbr = this._tableEvtFilterExclude.getRowCount();
        for (int i = 0; i < nbr; ++i) {
            result.add(((PluginItemFilter)this._tableEvtFilterExclude.getData((int)i))._data);
        }
        return result;
    }

    public List<PluginItemFilter.Filter> getInvisibleItems() {
        ArrayList<PluginItemFilter.Filter> result = new ArrayList<PluginItemFilter.Filter>();
        int nbr = this._tableEvtInvisibleExclude.getRowCount();
        for (int i = 0; i < nbr; ++i) {
            result.add(((PluginItemFilter)this._tableEvtInvisibleExclude.getData((int)i))._data);
        }
        return result;
    }

    @Override
    protected void doLoad(Element root) throws IOException {
        Element seqgenNode = this.loadGeneralInfos(root);
        if (seqgenNode != null) {
            Element invisibleNode;
            Element eventsNode = this.getElement(seqgenNode, XML_ELEM_EVENTS);
            if (eventsNode != null) {
                this.loadEventsFilter(eventsNode);
            }
            if ((invisibleNode = this.getElement(seqgenNode, XML_ELEM_INVISIBLES)) != null) {
                this.loadInvisibleEvents(invisibleNode);
            }
        }
        this._ctrlPostProcess.doLoad(root);
        super.doLoad(root);
    }

    private Element loadGeneralInfos(Element root) throws IOException {
        Element seqgenNode = this.getElement(root, XML_ELEM_SEQGEN);
        if (seqgenNode != null) {
            Enum opt;
            String value = this.getAttrValue(seqgenNode, XML_ATTR_SEQGEN_GENERATION_TYPE);
            if (value != null && !value.isEmpty()) {
                if (value.equalsIgnoreCase("Comb")) {
                    this._ctrlSeqComb.setSelected(true);
                } else if (value.equalsIgnoreCase("Permut")) {
                    this._ctrlSeqPermut.setSelected(true);
                } else if (value.equalsIgnoreCase("Repeat")) {
                    this._ctrlSeqRepeat.setSelected(true);
                } else {
                    throw new IOException("Bad value attribute seqgen@generationType: " + value);
                }
            }
            if ((value = this.getAttrValue(seqgenNode, XML_ATTR_SEQGEN_TARGET_ABSORB)) != null && !value.isEmpty()) {
                this._ctrlEvtLooker.setSelected(Boolean.valueOf(value));
            }
            if ((value = this.getAttrValue(seqgenNode, XML_ATTR_SEQGEN_RESULT_TYPE)) != null && !value.isEmpty()) {
                opt = null;
                try {
                    opt = EnumResultSet.valueOf(value.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    throw new IOException("Bad value attribute seqgen@resultType: " + value);
                }
                this._ctrlSet.setSelectedItem(opt);
            }
            if ((value = this.getAttrValue(seqgenNode, XML_ATTR_SEQGEN_DISPLAY_FORMAT)) != null && !value.isEmpty()) {
                opt = null;
                try {
                    opt = EnumFormat.valueOf(value.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    throw new IOException("Bad value attribute seqgen@displayFormat: " + value);
                }
                EnumFormat oldOpt = (EnumFormat)((Object)this._ctrlFormat.getSelectedItem());
                try {
                    this._ctrlFormat.setSelectedItem(opt);
                }
                catch (Throwable th) {
                    this._ctrlFormat.setSelectedItem((Object)oldOpt);
                }
            }
        }
        return seqgenNode;
    }

    private void loadEventsFilter(Node filtersNode) throws IOException {
        List<PluginItemFilter> filters;
        String value = this.getAttrValue(filtersNode, XML_ATTR_EVENTS_DEPENDS);
        if (value != null && !value.isEmpty()) {
            this._ctrlEvtFilterDepend.setSelected(Boolean.valueOf(value));
        }
        if ((filters = this.loadFilters(filtersNode)) != null) {
            this._tableEvtFilterExclude.setDatum(filters);
        }
    }

    private void loadInvisibleEvents(Node filtersNode) throws IOException {
        List<PluginItemFilter> filters;
        String value = this.getAttrValue(filtersNode, XML_ATTR_INVISIBLES_INSTANTANEOUS);
        if (value != null && !value.isEmpty()) {
            this._ctrlEvtInvisibleDepend.setSelected(Boolean.valueOf(value));
        }
        if ((filters = this.loadFilters(filtersNode)) != null) {
            this._tableEvtInvisibleExclude.setDatum(filters);
        }
    }

    private List<PluginItemFilter> loadFilters(Node filtersNode) throws IOException {
        NodeList childs = filtersNode.getChildNodes();
        ArrayList<PluginItemFilter> filters = new ArrayList<PluginItemFilter>();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node n = childs.item(i);
            if (!(n instanceof Element)) continue;
            Element filter = (Element)n;
            String type = this.getAttrValue(filter, XML_ATTR_FILTER_TYPE);
            PluginItemFilter.FilterType filterType = PluginItemFilter.FilterType.valueOf(type);
            String name = this.getAttrValue(filter, XML_ATTR_FILTER_NAME);
            String expr = this.getAttrValue(filter, XML_ATTR_FILTER_EXPR);
            PluginItemFilter itemFilter = new PluginItemFilter(filterType, name, expr);
            filters.add(itemFilter);
        }
        return filters;
    }

    @Override
    protected void doSave(IndentWriter writer) throws IOException {
        super.doSave(writer);
        this.saveSeqGen(writer);
        this._ctrlPostProcess.doSave(writer);
    }

    private void saveSeqGen(IndentWriter writer) throws IOException {
        writer.write("<");
        writer.write(XML_ELEM_SEQGEN);
        writer.write(" ");
        String val = null;
        val = this._ctrlSeqComb.isSelected() ? "Comb" : (this._ctrlSeqPermut.isSelected() ? "Permut" : "Repeat");
        writer.writeAttrWithValue(XML_ATTR_SEQGEN_GENERATION_TYPE, val.toLowerCase());
        writer.writeAttrWithValue(XML_ATTR_SEQGEN_TARGET_ABSORB, Boolean.toString(this._ctrlEvtLooker.isSelected()).toLowerCase());
        writer.writeAttrWithValue(XML_ATTR_SEQGEN_RESULT_TYPE, ((EnumResultSet)((Object)this._ctrlSet.getSelectedItem())).name().toLowerCase());
        writer.writeAttrWithValue(XML_ATTR_SEQGEN_DISPLAY_FORMAT, ((EnumFormat)((Object)this._ctrlFormat.getSelectedItem())).name().toLowerCase());
        writer.write(">\n");
        writer.addIndent(1);
        this.saveEventsFilter(writer);
        writer.addIndent(-1);
        writer.write("</");
        writer.write(XML_ELEM_SEQGEN);
        writer.write(">\n");
    }

    private void saveEventsFilter(IndentWriter writer) throws IOException {
        writer.write("<");
        writer.write(XML_ELEM_EVENTS);
        writer.write(" ");
        writer.writeAttrWithValue(XML_ATTR_EVENTS_DEPENDS, Boolean.toString(this._ctrlEvtFilterDepend.isSelected()).toLowerCase());
        if (this._tableEvtFilterExclude.getRowCount() == 0) {
            writer.write("/>\n");
        } else {
            writer.write(">\n");
            this.saveFilters(writer, this._tableEvtFilterExclude);
            writer.write("</");
            writer.write(XML_ELEM_EVENTS);
            writer.write(">\n");
        }
    }

    private void saveInvisibleEvents(IndentWriter writer) throws IOException {
        writer.write("<");
        writer.write(XML_ELEM_INVISIBLES);
        writer.write(" ");
        writer.writeAttrWithValue(XML_ATTR_INVISIBLES_INSTANTANEOUS, Boolean.toString(this._ctrlEvtInvisibleDepend.isSelected()).toLowerCase());
        if (this._tableEvtInvisibleExclude.getRowCount() == 0) {
            writer.write("/>\n");
        } else {
            writer.write(">\n");
            this.saveFilters(writer, this._tableEvtInvisibleExclude);
            writer.write("</");
            writer.write(XML_ELEM_INVISIBLES);
            writer.write(">\n");
        }
    }

    private void saveFilters(IndentWriter writer, TableDecoredModel<PluginItemFilter> model) throws IOException {
        writer.addIndent(1);
        for (int i = 0; i < model.getRowCount(); ++i) {
            PluginItemFilter filter = (PluginItemFilter)model.getData(i);
            PluginItemFilter.Filter f = filter.getData();
            writer.write("<");
            writer.write(XML_ELEM_EXCLUDE);
            writer.write(" ");
            writer.writeAttrWithValue(XML_ATTR_FILTER_TYPE, f.getType().name());
            writer.writeAttrWithValue(XML_ATTR_FILTER_NAME, f.getPatternName());
            if (f.getExpressionValue() != null) {
                writer.writeAttrWithValue(XML_ATTR_FILTER_EXPR, f.getExpressionValue());
            }
            writer.write("/>\n");
        }
        writer.addIndent(-1);
    }

    static enum EnumFormat {
        MCS("PRV_CMD_SEQ_FRM_MCS", "Sequences File (*.seq)", ".seq"),
        ARALIA("PRV_CMD_SEQ_FRM_ARALIA", "Aralia File (*.ara)", ".ara"),
        XML("PRV_CMD_SEQ_FRM_XML", "XML Sequences File (*.xml)", ".xml");

        String _fileKey;
        String _fileDesc;
        String _fileExt;
        DefaultFileFilter _fileFilter;

        private EnumFormat(String key, String desc, String ext) {
            this._fileKey = key;
            this._fileDesc = desc;
            this._fileExt = ext;
        }

        public String toString() {
            return ResSeqGen.getString(this._fileKey);
        }

        public String getCode() {
            return super.toString();
        }

        public DefaultFileFilter getFileFilter() {
            if (this._fileFilter == null) {
                this._fileFilter = new DefaultFileFilter(){

                    @Override
                    public boolean accept(File f) {
                        String fname = f.getName().toLowerCase();
                        return fname.endsWith(_fileExt) || f.isDirectory();
                    }

                    @Override
                    public String getDescription() {
                        return _fileDesc;
                    }

                    @Override
                    public String getDefaultExtension() {
                        return _fileExt;
                    }
                };
            }
            return this._fileFilter;
        }
    }

    static enum EnumResultSet {
        MINCUT("PRV_CMD_SEQ_SET_MINCUT"),
        MINSEQ("PRV_CMD_SEQ_SET_MINSEQ"),
        BASIC("PRV_CMD_SEQ_SET_BASIC");

        String _key;

        private EnumResultSet(String key) {
            this._key = key;
        }

        public String toString() {
            return ResSeqGen.getString(this._key);
        }

        public String getCode() {
            return super.toString();
        }
    }
}

