/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.admin.others;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.dbgui.DBLicenseUtility;
import com.dassault.cecilia.core.swing.CeciliaAction;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.table.TablePanel;
import com.dassault.cecilia.db.DBLicense;
import com.dassault.cecilia.db.dao.DAOLicense;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.main.admin.ResIcoAdmin;
import com.dassault.cecilia.main.admin.ResMsgAdmin;
import com.dassault.cecilia.main.admin.others.LicensesTableModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class LicensesPanel
extends TablePanel {
    private static Logger _LOG = Logger.getLogger(LicensesPanel.class.getPackage().getName());
    CeciliaAction _ctrlAsk;
    CeciliaAction _ctrlRefresh;
    CAppl _application;
    DAOLicense _daoLicense;
    LicensesTableModel _tableModel;

    public LicensesPanel(CAppl application, DAOLicense daoLicense, LicensesTableModel model) {
        super(application.getTopWindow(), model, false);
        this._application = application;
        this._daoLicense = daoLicense;
        this._tableModel = model;
        this._tableModel.setDebugMode(application.isDebugMode());
        this.initialise();
    }

    @Override
    protected void createActions() {
        super.createActions();
        this._ctrlAdd.setName(ResMsgAdmin.getString("ACTION_LIC_INSTALL_MENU"));
        this._ctrlAdd.setDesc(ResMsgAdmin.getString("ACTION_LIC_INSTALL_TTIP"));
        this._ctrlAsk = new CeciliaAction(ResIcoAdmin.getImageIcon("BUT_LIC_ASK"), ResMsgAdmin.getString("ACTION_LIC_ASK_MENU"), ResMsgAdmin.getString("ACTION_LIC_ASK_TTIP")){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String host = LicensesPanel.this._daoLicense.getHostConnection();
                    DBLicenseUtility.askLicense(host, "Cecilia".toUpperCase(), LicensesPanel.this._ctrlTable, LicensesPanel.this._application.getTitle());
                }
                catch (IOException ioe) {
                    _LOG.log(Level.INFO, "Error during generate license file", ioe);
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(LicensesPanel.this._ctrlTable), ioe.getMessage(), LicensesPanel.this._application.getTitle(), 0);
                }
            }
        };
        this._ctrlRefresh = new CeciliaAction(ResIcoCore.getImageIcon("BUT_REFRESH"), ResMsgVoc.getString("VOC_REFRESH"), ResMsgObj.getString("ACTION_REFRESH_TTIP")){

            @Override
            public void actionPerformed(ActionEvent e) {
                LicensesPanel.this.refresh();
            }
        };
    }

    @Override
    protected void initialise() {
        super.initialise();
        TableColumn column = null;
        block9: for (int i = 0; i < this._tableModel.getColumnCount(); ++i) {
            column = this._ctrlTable.getColumnModel().getColumn(i);
            switch (i) {
                case 0: {
                    column.setPreferredWidth(50);
                    continue block9;
                }
                case 1: {
                    column.setPreferredWidth(25);
                    continue block9;
                }
                case 2: {
                    column.setPreferredWidth(200);
                    continue block9;
                }
                case 3: {
                    column.setPreferredWidth(20);
                    continue block9;
                }
                case 4: {
                    column.setPreferredWidth(20);
                    continue block9;
                }
                case 5: {
                    column.setPreferredWidth(40);
                    continue block9;
                }
                case 6: {
                    column.setPreferredWidth(20);
                }
            }
        }
        this._ctrlTable.setDefaultRenderer(Integer.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                this.setText(DBLicense.printToken((Integer)value));
                this.setHorizontalAlignment(0);
                return this;
            }
        });
        this._ctrlTable.setDefaultRenderer(Date.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                this.setText(DBLicense.printDate((Date)value));
                this.setHorizontalAlignment(0);
                return this;
            }
        });
        this._ctrlTable.setAutoCreateRowSorter(true);
    }

    @Override
    protected void createToolBarActions(Container toolbar) {
        toolbar.add(this._ctrlRefresh.createButton(CeciliaAction.BorderStyle.LIGHT));
        toolbar.add(Box.createGlue());
        toolbar.add(this._ctrlAsk.createButton(CeciliaAction.BorderStyle.LIGHT));
        toolbar.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        toolbar.add(this._ctrlAdd.createButton(CeciliaAction.BorderStyle.LIGHT));
        toolbar.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        toolbar.add(this._ctrlDel.createButton(CeciliaAction.BorderStyle.LIGHT));
    }

    @Override
    protected JPopupMenu createMenuActions(JPopupMenu popupList) {
        popupList.add(this._ctrlRefresh);
        popupList.addSeparator();
        popupList.add(this._ctrlAsk);
        popupList.addSeparator();
        return super.createMenuActions(popupList);
    }

    public void refresh() {
        this._tableModel.setItems(this._daoLicense.findAll());
    }

    @Override
    protected void addData(int viewRow) {
        int result;
        Calendar currentDate;
        DBLicense addLicense = null;
        try {
            addLicense = DBLicenseUtility.selectLicense(this._ctrlTable);
        }
        catch (IOException e) {
            _LOG.log(Level.INFO, "Error during load license file", e);
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlTable), ResMsgAdmin.getString("MSG_LIC_BAD_FILE"), this._application.getTitle(), 0);
        }
        if (addLicense == null) {
            return;
        }
        if (!addLicense.isCompatible(this._application.getVersion())) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlTable), ResMsgCore.getString("LICENSE_ERR_VERSION"), this._application.getTitle(), 0);
            return;
        }
        if (!addLicense.getExpire().equals(DBLicense.getAlwaysDate()) && (currentDate = Calendar.getInstance()).getTime().after(addLicense.getExpire())) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlTable), ResMsgCore.getString("LICENSE_ERR_CONNECT_DATE"), this._application.getTitle(), 0);
            return;
        }
        String localHost = this._daoLicense.getHostConnection();
        if (!this._daoLicense.verifyHost(addLicense.getHost(), localHost) && (result = JOptionPane.showConfirmDialog(JOptionCecilia.getTopContainerOf(this._ctrlTable), ResMsgAdmin.getString("MSG_LIC_BAD_HOST"), this._application.getTitle(), 0)) != 0) {
            return;
        }
        if (!this._daoLicense.insert(addLicense)) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlTable), ResMsgAdmin.getString("MSG_LIC_ERR_INSERT"), this._application.getTitle(), 0);
        } else {
            this.refresh();
        }
    }

    @Override
    protected void delData(int[] viewRows) {
        int nbrDel = 0;
        for (int i = 0; i < viewRows.length; ++i) {
            int modelRow = this._ctrlTable.convertRowIndexToModel(viewRows[i]);
            if (!this._daoLicense.delete((DBLicense)this._tableModel.getItem(modelRow))) continue;
            ++nbrDel;
        }
        if (nbrDel != viewRows.length) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlTable), ResMsgAdmin.getString("MSG_LIC_ERR_DELETE"), this._application.getTitle(), 0);
        }
        this.refresh();
        if (this._ctrlTable.getModel().getRowCount() > 0) {
            this._ctrlTable.setRowSelectionInterval(0, 0);
        }
    }
}

