/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.admin.patchs;

import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.main.admin.ResMsgAdmin;
import com.dassault.cecilia.main.admin.patchs.AbstractCorrectorWithSimpleMsg;
import com.dassault.cecilia.main.admin.patchs.CorrectionLocalFolder;
import java.awt.Component;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CorrectorLocalFolder
extends AbstractCorrectorWithSimpleMsg {
    CAppl _appl;

    public CorrectorLocalFolder(CAppl appl, Component c) {
        super(c);
        this._appl = appl;
    }

    @Override
    protected String getTitle() {
        return ResMsgAdmin.getString("PATCH_LOCAL_FOLDER_TITLE");
    }

    @Override
    protected void firstDo() {
        DAOFactory daoFactory = this._appl.getDAOFactory();
        LinkedHashMap<DBFolder, StringBuilder> errorFolders = new LinkedHashMap<DBFolder, StringBuilder>();
        this.findLocalFolder_rec(daoFactory.createFolderDAO().getRootID("ROOT"), null, daoFactory, errorFolders);
        this.treatError(errorFolders);
    }

    @Override
    protected void patch(List<DBFolder> dbFolders) {
        CorrectionLocalFolder cmd = new CorrectionLocalFolder(this._appl, this.getSource(), dbFolders);
        cmd.realiseDo();
    }

    static short verifyFlagFamily(DBFolder dbCurrent, DBFolder dbParent) {
        block23: {
            block24: {
                block22: {
                    if (dbCurrent.isSystem()) {
                        return -1;
                    }
                    if (dbCurrent.getFamily() != DBFolder.Family.PROJECT) break block22;
                    switch (dbCurrent.getFamilyFlag()) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: {
                            if (dbCurrent.isVersion()) {
                                if (dbParent.getFamilyFlag() != dbCurrent.getFamilyFlag()) {
                                    return dbParent.getFamilyFlag();
                                }
                            } else if (dbCurrent.isFolder()) {
                                return -2;
                            }
                            break block23;
                        }
                        case 8: {
                            if (!dbCurrent.isFolder()) {
                                return -2;
                            }
                            if (!dbParent.isSystem()) {
                                return 0;
                            }
                            break block23;
                        }
                        case 0: {
                            if (dbParent.isSystem()) {
                                return 8;
                            }
                            break block23;
                        }
                        default: {
                            return -2;
                        }
                    }
                }
                if (dbCurrent.getFamily() != DBFolder.Family.TYPE) break block24;
                switch (dbCurrent.getFamilyFlag()) {
                    case 1: 
                    case 2: {
                        if (dbCurrent.isVersion()) {
                            if (dbParent.getFamilyFlag() != dbCurrent.getFamilyFlag()) {
                                return dbParent.getFamilyFlag();
                            }
                        } else if (dbCurrent.isFolder()) {
                            return -2;
                        }
                        break block23;
                    }
                    case 0: {
                        break block23;
                    }
                    default: {
                        return -2;
                    }
                }
            }
            if (dbCurrent.getFamilyFlag() != 0) {
                return -2;
            }
        }
        return -1;
    }

    private void findLocalFolder_(DBFolder dbCurrent, DBFolder dbParent, Map<DBFolder, StringBuilder> errorFolders) {
        short ff;
        if (dbParent == null || dbParent.getFamily() != DBFolder.Family.APPLICATION) {
            // empty if block
        }
        if ((ff = CorrectorLocalFolder.verifyFlagFamily(dbCurrent, dbParent)) != -1) {
            this.appendError(dbCurrent, errorFolders, "La partie FlagFamily n'est pas correct : " + dbCurrent.getFamilyFlag() + " [" + ff + "]");
        }
    }

    private void findLocalFolder_rec(DBFolder dbCurrent, DBFolder dbParent, DAOFactory daoFactory, Map<DBFolder, StringBuilder> errorFolders) {
        this.findLocalFolder_(dbCurrent, dbParent, errorFolders);
        if (dbCurrent.isVersion()) {
            return;
        }
        List<DBFolder> dbChildren = dbCurrent.getChildren();
        if (dbChildren == null) {
            dbChildren = daoFactory.createFolderDAO().findChildren(dbCurrent);
        }
        if (dbChildren == null) {
            return;
        }
        for (DBFolder dbChild : dbChildren) {
            this.findLocalFolder_rec(dbChild, dbCurrent, daoFactory, errorFolders);
        }
    }
}

