/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.dbgui;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.dbgui.LicenseException;
import com.dassault.cecilia.core.cecilia.dbgui.LicenseManager;
import com.dassault.cecilia.core.plugin.Plug;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.dao.sql.SQLConnection;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public class LicenseMenuUtility {
    protected LicenseHelper _helper;
    protected JPopupMenu _menuUtility;
    protected Map<String, Action> _mapUtility;

    public LicenseMenuUtility(LicenseHelper helper) {
        this._helper = helper;
        this.create();
    }

    private void create() {
        this._menuUtility = new JPopupMenu();
        this._mapUtility = new HashMap<String, Action>();
        AbstractAction action = new AbstractAction(ResMsgCore.getString("DLG_DBCHANGE_LICENSETEST")){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                if (LicenseMenuUtility.this._helper.getModule() == null) {
                    return;
                }
                SQLConnection connect = LicenseMenuUtility.this._helper.getSQLConnection();
                if (connect == null) {
                    return;
                }
                try {
                    if (!LicenseMenuUtility.this._helper.verifyConnection(connect)) {
                        return;
                    }
                    if (LicenseMenuUtility.this.verifyLicense(connect)) {
                        JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(LicenseMenuUtility.this._helper.getComponentOwner()), ResMsgCore.getString("DLG_DBCHANGE_LICENSETEST_GOOD"), LicenseMenuUtility.this._helper.getTitle(), 1);
                    }
                }
                finally {
                    try {
                        connect.close();
                    }
                    catch (SQLException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        };
        this._menuUtility.add(action);
        this._mapUtility.put("DLG_DBCHANGE_LICENSETEST", action);
        action = new AbstractAction(ResMsgCore.getString("DLG_DBCHANGE_LICENSEASK")){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                if (LicenseMenuUtility.this._helper.getModule() == null) {
                    return;
                }
                SQLConnection connect = LicenseMenuUtility.this._helper.getSQLConnection();
                if (connect == null) {
                    return;
                }
                try {
                    if (!LicenseMenuUtility.this._helper.verifyConnection(connect)) {
                        return;
                    }
                    LicenseManager lic = new LicenseManager(connect);
                    try {
                        lic.askLicense(LicenseMenuUtility.this._helper.getModule(), LicenseMenuUtility.this._helper.getComponentOwner(), LicenseMenuUtility.this._helper.getTitle());
                    }
                    catch (LicenseException ex) {
                        JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(LicenseMenuUtility.this._helper.getComponentOwner()), ex.getMessage(), LicenseMenuUtility.this._helper.getTitle(), 0);
                    }
                }
                finally {
                    try {
                        connect.close();
                    }
                    catch (SQLException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        };
        this._menuUtility.add(action);
        this._mapUtility.put("DLG_DBCHANGE_LICENSEASK", action);
        action = new AbstractAction(ResMsgCore.getString("DLG_DBCHANGE_LICENSECHANGE")){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                if (LicenseMenuUtility.this._helper.getModule() == null) {
                    return;
                }
                SQLConnection connect = LicenseMenuUtility.this._helper.getSQLConnection();
                if (connect == null) {
                    return;
                }
                try {
                    if (!LicenseMenuUtility.this._helper.verifyConnection(connect)) {
                        return;
                    }
                    LicenseManager lic = new LicenseManager(connect);
                    try {
                        lic.changeLicense(LicenseMenuUtility.this._helper.getModule(), LicenseMenuUtility.this._helper.getComponentOwner());
                    }
                    catch (LicenseException ex) {
                        JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(LicenseMenuUtility.this._helper.getComponentOwner()), ex.getMessage(), LicenseMenuUtility.this._helper.getTitle(), 0);
                    }
                }
                finally {
                    try {
                        connect.close();
                    }
                    catch (SQLException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        };
        this._menuUtility.add(action);
        this._mapUtility.put("DLG_DBCHANGE_LICENSECHANGE", action);
        this._menuUtility.pack();
    }

    public boolean verifyLicense(SQLConnection connect) {
        LicenseManager lic = null;
        try {
            lic = new LicenseManager(connect);
            lic.login(this._helper.getModule());
            lic.logout();
            return true;
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._helper.getComponentOwner()), ex.getMessage(), this._helper.getTitle(), 0);
            return false;
        }
    }

    public JPopupMenu getMenu() {
        return this._menuUtility;
    }

    public static interface LicenseHelper {
        public SQLConnection getSQLConnection();

        public boolean verifyConnection(SQLConnection var1);

        public Component getComponentOwner();

        public String getTitle();

        public Plug getModule();
    }
}

