/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.export;

import com.dassault.cecilia.core.cecilia.export.DBKOutput;
import com.dassault.cecilia.core.cecilia.export.ExpComponent;
import com.dassault.cecilia.core.cecilia.print.SrbInputStream;
import java.io.IOException;
import java.util.Date;

public class ExpInfo
extends ExpComponent {
    String _title;
    String _subtitle;
    String _author;
    Date _date;

    public ExpInfo(String title) {
        this._title = title;
    }

    public ExpInfo setTitle(String value) {
        this._title = value;
        return this;
    }

    public ExpInfo setSubtitle(String value) {
        this._subtitle = value;
        return this;
    }

    public ExpInfo setAuthor(String value) {
        this._author = value;
        return this;
    }

    public ExpInfo setDate(Date value) {
        this._date = value;
        return this;
    }

    @Override
    public void writeDocbook(DBKOutput output) throws IOException {
        output.write("<info>\n", false);
        output.addIndent(1);
        output.write("<title>", false);
        output.write(this._title, true);
        output.write("</title>\n", false);
        if (this._subtitle != null && !this._subtitle.trim().isEmpty()) {
            output.write("<subtitle>", false);
            output.write(this._subtitle, true);
            output.write("</subtitle>\n", false);
        }
        if (this._author != null && !this._author.trim().isEmpty()) {
            output.write("<author><personname>", false);
            output.write(this._author, true);
            output.write("</personname></author>\n", false);
        }
        if (this._date != null) {
            output.write("<date>", false);
            output.write(this.dateToString(this._date), true);
            output.write("</date>\n", false);
        }
        this.writeAbstractDocbook(output);
        output.addIndent(-1);
        output.write("</info>\n", false);
    }

    protected void writeAbstractDocbook(DBKOutput output) throws IOException {
    }

    @Override
    public void writeScribe(SrbInputStream scribe) throws IOException {
        scribe.concat("<TITLE>" + this._title + "\n");
        scribe.concat("<DOCNUM>\n");
        if (this._date != null) {
            scribe.concat("<DATE>" + this.dateToString(this._date) + "\n");
        }
    }
}

