/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.export;

import com.dassault.cecilia.core.cecilia.export.DBKOutput;
import com.dassault.cecilia.core.cecilia.export.ExpContainer;
import com.dassault.cecilia.core.cecilia.print.SrbInputStream;
import java.io.IOException;
import java.util.logging.Level;

public abstract class ExpSection
extends ExpContainer {
    public abstract String getTitle();

    public String getSubTitle() {
        return null;
    }

    @Override
    public void writeDocbook(DBKOutput output) throws IOException {
        int current = this.getCurrentLevelSection();
        output.writeSection(current, this.getTitle());
        String subtitle = this.getSubTitle();
        if (subtitle != null && !subtitle.trim().isEmpty()) {
            output.write("<subtitle>", false);
            output.write(subtitle, true);
            output.write("</subtitle>\n", false);
        }
        this.writeContentDocbook(output);
        output.writeEndSection(current);
    }

    protected void writeContentDocbook(DBKOutput output) throws IOException {
        super.writeDocbook(output);
    }

    @Override
    public void writeScribe(SrbInputStream scribe) throws IOException {
        int current = this.getCurrentLevelSection();
        scribe.concat("<H" + current + ">" + this.getTitle() + "\n");
        String subtitle = this.getSubTitle();
        if (subtitle != null && !subtitle.trim().isEmpty()) {
            this.logMsg(Level.INFO, "writeScribe don't support subtitle");
        }
        this.writeContentScribe(scribe);
    }

    protected void writeContentScribe(SrbInputStream scribe) throws IOException {
        super.writeScribe(scribe);
    }
}

