/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.export;

import com.dassault.cecilia.core.cecilia.export.DBKOutput;
import com.dassault.cecilia.core.cecilia.export.ExpBook;
import com.dassault.cecilia.core.cecilia.export.ExpTableWithEntry;
import com.dassault.cecilia.core.cecilia.print.SrbInputStream;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;

public abstract class ExpTableWrap<T extends DBWrap>
extends ExpTableWithEntry<T> {
    private static Logger _LOG = Logger.getLogger(ExpTableWrap.class.getPackage().getName());
    Collection<DBFolder> _dbFolders;
    Class<T> _define;
    List<T> _wraps;

    public ExpTableWrap(Collection<DBFolder> dbFolders, Class<T> define) {
        this._dbFolders = dbFolders;
        this._define = define;
    }

    @Override
    public void writeDocbook(DBKOutput output) throws IOException {
        this.init();
        super.writeDocbook(output);
    }

    @Override
    public void writeScribe(SrbInputStream scribe) throws IOException {
        this.init();
        super.writeScribe(scribe);
    }

    private void init() {
        ExpBook book = this.getBook();
        if (book == null) {
            _LOG.info("Erreur de configuration - Pas de Expbook d'accessible");
            return;
        }
        this._wraps = new ArrayList<T>(this._dbFolders.size());
        for (DBFolder dbFolder : this._dbFolders) {
            DBWrap dbWrap = book.getDAOFactory().findOrCreateWrap(dbFolder);
            if (dbWrap == null) {
                _LOG.warning("Impossible de creer l'objet technique se referant au dossier : " + dbFolder.getRefPath());
                continue;
            }
            if (!this._define.isAssignableFrom(dbWrap.getClass())) {
                _LOG.warning("L'objet technique ne semble pas \u00eatre du bon type (" + this._define.getSimpleName() + ") : " + dbFolder.getRefPath());
                continue;
            }
            this._wraps.add(dbWrap);
        }
    }

    @Override
    protected int getRowCount() {
        return this._wraps.size();
    }

    @Override
    protected T getObject(int row) {
        return (T)((DBWrap)this._wraps.get(row));
    }
}

