/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.folder;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.IFolder;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class DBFolderResources {
    private static final Logger _LOG = Logger.getLogger(DBFolderResources.class.getPackage().getName());
    private static Map<IconEnum, ImageIcon> _mapIconFolders = null;
    private static Color COLOR_MODELS = new Color(4, 2, 131);
    private static Color COLOR_TREES = new Color(4, 83, 2);
    private static Color COLOR_BEQS = new Color(181, 0, 247);
    private static Color COLOR_DSFS = new Color(250, 4, 4);
    private static Color COLOR_FMEAS = new Color(130, 68, 4);
    private static Map<String, String> _mapSystemFolders = null;
    private static String[] _BTP_TYPE_FOLDER = new String[]{"VOC_FAMILY", "VOC_EQUIPMENT", "VOC_FUNCTION", "VOC_DEFECT"};

    private static synchronized void createMapIconFolders() {
        if (_mapIconFolders != null) {
            return;
        }
        _mapIconFolders = new HashMap<IconEnum, ImageIcon>();
        _mapIconFolders.put(IconEnum.FOLDER, ResIcoCore.getImageIcon("FOLDER_DEFAULT_C"));
        _mapIconFolders.put(IconEnum.FOLDER_O, ResIcoCore.getImageIcon("FOLDER_DEFAULT_O"));
        _mapIconFolders.put(IconEnum.IMAG, ResIcoCore.getImageIcon("FOLDER_IMAG"));
        _mapIconFolders.put(IconEnum.IMAG_V, ResIcoCore.getImageIcon("FOLDER_IMAG_V"));
        _mapIconFolders.put(IconEnum.IMAG_VF, ResIcoCore.getImageIcon("FOLDER_IMAG_VF"));
        _mapIconFolders.put(IconEnum.IMAG_VFL, ResIcoCore.getImageIcon("FOLDER_IMAG_VFL"));
        _mapIconFolders.put(IconEnum.IMAG_VL, ResIcoCore.getImageIcon("FOLDER_IMAG_VL"));
        _mapIconFolders.put(IconEnum.EQUIPMENT, ResIcoCore.getImageIcon("FOLDER_EQUIPMENT_"));
        _mapIconFolders.put(IconEnum.EQUIPMENT_I, ResIcoCore.getImageIcon("FOLDER_EQUIPMENT_I"));
        _mapIconFolders.put(IconEnum.EQUIPMENT_V, ResIcoCore.getImageIcon("FOLDER_EQUIPMENT_V"));
        _mapIconFolders.put(IconEnum.EQUIPMENT_VF, ResIcoCore.getImageIcon("FOLDER_EQUIPMENT_VF"));
        _mapIconFolders.put(IconEnum.EQUIPMENT_VFL, ResIcoCore.getImageIcon("FOLDER_EQUIPMENT_VFL"));
        _mapIconFolders.put(IconEnum.EQUIPMENT_VL, ResIcoCore.getImageIcon("FOLDER_EQUIPMENT_VL"));
        _mapIconFolders.put(IconEnum.COMPONENT, ResIcoCore.getImageIcon("FOLDER_COMPONENT_"));
        _mapIconFolders.put(IconEnum.COMPONENT_I, ResIcoCore.getImageIcon("FOLDER_COMPONENT_I"));
        _mapIconFolders.put(IconEnum.COMPONENT_V, ResIcoCore.getImageIcon("FOLDER_COMPONENT_V"));
        _mapIconFolders.put(IconEnum.COMPONENT_VF, ResIcoCore.getImageIcon("FOLDER_COMPONENT_VF"));
        _mapIconFolders.put(IconEnum.COMPONENT_VFL, ResIcoCore.getImageIcon("FOLDER_COMPONENT_VFL"));
        _mapIconFolders.put(IconEnum.COMPONENT_VL, ResIcoCore.getImageIcon("FOLDER_COMPONENT_VL"));
        _mapIconFolders.put(IconEnum.ENUM, ResIcoCore.getImageIcon("FOLDER_ENUM_"));
        _mapIconFolders.put(IconEnum.ENUM_I, ResIcoCore.getImageIcon("FOLDER_ENUM_I"));
        _mapIconFolders.put(IconEnum.ENUM_V, ResIcoCore.getImageIcon("FOLDER_ENUM_V"));
        _mapIconFolders.put(IconEnum.ENUM_VF, ResIcoCore.getImageIcon("FOLDER_ENUM_VF"));
        _mapIconFolders.put(IconEnum.ENUM_VFL, ResIcoCore.getImageIcon("FOLDER_ENUM_VFL"));
        _mapIconFolders.put(IconEnum.ENUM_VL, ResIcoCore.getImageIcon("FOLDER_ENUM_VL"));
        _mapIconFolders.put(IconEnum.LINK, ResIcoCore.getImageIcon("FOLDER_LINK_"));
        _mapIconFolders.put(IconEnum.LINK_I, ResIcoCore.getImageIcon("FOLDER_LINK_I"));
        _mapIconFolders.put(IconEnum.LINK_V, ResIcoCore.getImageIcon("FOLDER_LINK_V"));
        _mapIconFolders.put(IconEnum.LINK_VF, ResIcoCore.getImageIcon("FOLDER_LINK_VF"));
        _mapIconFolders.put(IconEnum.LINK_VFL, ResIcoCore.getImageIcon("FOLDER_LINK_VFL"));
        _mapIconFolders.put(IconEnum.LINK_VL, ResIcoCore.getImageIcon("FOLDER_LINK_VL"));
        _mapIconFolders.put(IconEnum.OPERATOR, ResIcoCore.getImageIcon("FOLDER_OPERATOR_"));
        _mapIconFolders.put(IconEnum.OPERATOR_I, ResIcoCore.getImageIcon("FOLDER_OPERATOR_I"));
        _mapIconFolders.put(IconEnum.OPERATOR_V, ResIcoCore.getImageIcon("FOLDER_OPERATOR_V"));
        _mapIconFolders.put(IconEnum.OPERATOR_VF, ResIcoCore.getImageIcon("FOLDER_OPERATOR_VF"));
        _mapIconFolders.put(IconEnum.OPERATOR_VFL, ResIcoCore.getImageIcon("FOLDER_OPERATOR_VFL"));
        _mapIconFolders.put(IconEnum.OPERATOR_VL, ResIcoCore.getImageIcon("FOLDER_OPERATOR_VL"));
        _mapIconFolders.put(IconEnum.MODEL, ResIcoCore.getImageIcon("FOLDER_MODEL_"));
        _mapIconFolders.put(IconEnum.MODEL_I, ResIcoCore.getImageIcon("FOLDER_MODEL_I"));
        _mapIconFolders.put(IconEnum.MODEL_V, ResIcoCore.getImageIcon("FOLDER_MODEL_V"));
        _mapIconFolders.put(IconEnum.MODEL_VF, ResIcoCore.getImageIcon("FOLDER_MODEL_VF"));
        _mapIconFolders.put(IconEnum.MODEL_VFL, ResIcoCore.getImageIcon("FOLDER_MODEL_VFL"));
        _mapIconFolders.put(IconEnum.MODEL_VL, ResIcoCore.getImageIcon("FOLDER_MODEL_VL"));
        _mapIconFolders.put(IconEnum.TREE, ResIcoCore.getImageIcon("FOLDER_TREE_"));
        _mapIconFolders.put(IconEnum.TREE_I, ResIcoCore.getImageIcon("FOLDER_TREE_I"));
        _mapIconFolders.put(IconEnum.TREE_V, ResIcoCore.getImageIcon("FOLDER_TREE_V"));
        _mapIconFolders.put(IconEnum.TREE_VF, ResIcoCore.getImageIcon("FOLDER_TREE_VF"));
        _mapIconFolders.put(IconEnum.TREE_VFL, ResIcoCore.getImageIcon("FOLDER_TREE_VFL"));
        _mapIconFolders.put(IconEnum.TREE_VL, ResIcoCore.getImageIcon("FOLDER_TREE_VL"));
        _mapIconFolders.put(IconEnum.BEQ, ResIcoCore.getImageIcon("FOLDER_BEQ_"));
        _mapIconFolders.put(IconEnum.BEQ_I, ResIcoCore.getImageIcon("FOLDER_BEQ_I"));
        _mapIconFolders.put(IconEnum.BEQ_V, ResIcoCore.getImageIcon("FOLDER_BEQ_V"));
        _mapIconFolders.put(IconEnum.BEQ_VF, ResIcoCore.getImageIcon("FOLDER_BEQ_VF"));
        _mapIconFolders.put(IconEnum.BEQ_VFL, ResIcoCore.getImageIcon("FOLDER_BEQ_VFL"));
        _mapIconFolders.put(IconEnum.BEQ_VL, ResIcoCore.getImageIcon("FOLDER_BEQ_VL"));
        _mapIconFolders.put(IconEnum.DSF, ResIcoCore.getImageIcon("FOLDER_DSF_"));
        _mapIconFolders.put(IconEnum.DSF_I, ResIcoCore.getImageIcon("FOLDER_DSF_I"));
        _mapIconFolders.put(IconEnum.DSF_V, ResIcoCore.getImageIcon("FOLDER_DSF_V"));
        _mapIconFolders.put(IconEnum.DSF_VF, ResIcoCore.getImageIcon("FOLDER_DSF_VF"));
        _mapIconFolders.put(IconEnum.DSF_VFL, ResIcoCore.getImageIcon("FOLDER_DSF_VFL"));
        _mapIconFolders.put(IconEnum.DSF_VL, ResIcoCore.getImageIcon("FOLDER_DSF_VL"));
        _mapIconFolders.put(IconEnum.FMEA, ResIcoCore.getImageIcon("FOLDER_FMEA_"));
        _mapIconFolders.put(IconEnum.FMEA_I, ResIcoCore.getImageIcon("FOLDER_FMEA_I"));
        _mapIconFolders.put(IconEnum.FMEA_V, ResIcoCore.getImageIcon("FOLDER_FMEA_V"));
        _mapIconFolders.put(IconEnum.FMEA_VF, ResIcoCore.getImageIcon("FOLDER_FMEA_VF"));
        _mapIconFolders.put(IconEnum.FMEA_VFL, ResIcoCore.getImageIcon("FOLDER_FMEA_VFL"));
        _mapIconFolders.put(IconEnum.FMEA_VL, ResIcoCore.getImageIcon("FOLDER_FMEA_VL"));
        _mapIconFolders.put(IconEnum.BTPEVENT, ResIcoCore.getImageIcon("FOLDER_EVENT_"));
        _mapIconFolders.put(IconEnum.BTPEVENT_I, ResIcoCore.getImageIcon("FOLDER_EVENT_I"));
        _mapIconFolders.put(IconEnum.BTPEVENT_V, ResIcoCore.getImageIcon("FOLDER_EVENT_V"));
        _mapIconFolders.put(IconEnum.BTPEVENT_VF, ResIcoCore.getImageIcon("FOLDER_EVENT_VF"));
        _mapIconFolders.put(IconEnum.BTPEVENT_VFL, ResIcoCore.getImageIcon("FOLDER_EVENT_VFL"));
        _mapIconFolders.put(IconEnum.BTPEVENT_VL, ResIcoCore.getImageIcon("FOLDER_EVENT_VL"));
        _mapIconFolders.put(IconEnum.ATTRIBUTE, ResIcoCore.getImageIcon("FOLDER_ATTRIBUTE_"));
        _mapIconFolders.put(IconEnum.ATTRIBUTE_I, ResIcoCore.getImageIcon("FOLDER_ATTRIBUTE_I"));
        _mapIconFolders.put(IconEnum.ATTRIBUTE_V, ResIcoCore.getImageIcon("FOLDER_ATTRIBUTE_V"));
        _mapIconFolders.put(IconEnum.ATTRIBUTE_VF, ResIcoCore.getImageIcon("FOLDER_ATTRIBUTE_VF"));
        _mapIconFolders.put(IconEnum.ATTRIBUTE_VFL, ResIcoCore.getImageIcon("FOLDER_ATTRIBUTE_VFL"));
        _mapIconFolders.put(IconEnum.ATTRIBUTE_VL, ResIcoCore.getImageIcon("FOLDER_ATTRIBUTE_VL"));
        _mapIconFolders.put(IconEnum.PARAMETER, ResIcoCore.getImageIcon("FOLDER_PARAMETER_"));
        _mapIconFolders.put(IconEnum.PARAMETER_I, ResIcoCore.getImageIcon("FOLDER_PARAMETER_I"));
        _mapIconFolders.put(IconEnum.PARAMETER_V, ResIcoCore.getImageIcon("FOLDER_PARAMETER_V"));
        _mapIconFolders.put(IconEnum.PARAMETER_VF, ResIcoCore.getImageIcon("FOLDER_PARAMETER_VF"));
        _mapIconFolders.put(IconEnum.PARAMETER_VFL, ResIcoCore.getImageIcon("FOLDER_PARAMETER_VFL"));
        _mapIconFolders.put(IconEnum.PARAMETER_VL, ResIcoCore.getImageIcon("FOLDER_PARAMETER_VL"));
        _mapIconFolders.put(IconEnum.BTPAUTHOR, ResIcoCore.getImageIcon("FOLDER_AUTHOR_"));
        _mapIconFolders.put(IconEnum.BTPAPPLI, ResIcoCore.getImageIcon("FOLDER_APPLICATION_"));
        _mapIconFolders.put(IconEnum.BTPJUSTIF, ResIcoCore.getImageIcon("FOLDER_JUSTIFICATION_"));
        _mapIconFolders.put(IconEnum.CCF, ResIcoCore.getImageIcon("FOLDER_CCF_"));
        _mapIconFolders.put(IconEnum.CCF_I, ResIcoCore.getImageIcon("FOLDER_CCF_I"));
        _mapIconFolders.put(IconEnum.CCF_V, ResIcoCore.getImageIcon("FOLDER_CCF_V"));
        _mapIconFolders.put(IconEnum.CCF_VF, ResIcoCore.getImageIcon("FOLDER_CCF_VF"));
        _mapIconFolders.put(IconEnum.CCF_VFL, ResIcoCore.getImageIcon("FOLDER_CCF_VFL"));
        _mapIconFolders.put(IconEnum.CCF_VL, ResIcoCore.getImageIcon("FOLDER_CCF_VL"));
        _mapIconFolders.put(IconEnum.MODELS, ResIcoCore.getImageIcon("FOLDER_MODELS"));
        _mapIconFolders.put(IconEnum.TREES, ResIcoCore.getImageIcon("FOLDER_TREES"));
        _mapIconFolders.put(IconEnum.BEQS, ResIcoCore.getImageIcon("FOLDER_BEQS"));
        _mapIconFolders.put(IconEnum.DSFS, ResIcoCore.getImageIcon("FOLDER_DSFS"));
        _mapIconFolders.put(IconEnum.FMEAS, ResIcoCore.getImageIcon("FOLDER_FMEAS"));
    }

    public static ImageIcon getFrameIcon(IFolder folder) {
        if (_mapIconFolders == null) {
            DBFolderResources.createMapIconFolders();
        }
        DBFolder dbFolder = folder.getSource();
        IconEnum icon = IconEnum.FOLDER;
        block0 : switch (dbFolder.getFamily()) {
            case ATTRIBUTE: {
                icon = IconEnum.ATTRIBUTE_I;
                break;
            }
            case PARAMETER: {
                icon = IconEnum.PARAMETER_I;
                break;
            }
            case BTP_MODEL: {
                icon = IconEnum.BTPEVENT_I;
                break;
            }
            case BTP_APPLICATION: {
                icon = IconEnum.BTPAPPLI;
                break;
            }
            case BTP_AUTHOR: {
                icon = IconEnum.BTPAUTHOR;
                break;
            }
            case BTP_SUBSTANTIATION: {
                icon = IconEnum.BTPJUSTIF;
                break;
            }
            case CCF_MODEL: {
                icon = IconEnum.CCF_I;
                break;
            }
            case FMEA_MODEL: {
                icon = IconEnum.FMEA_I;
                break;
            }
            case COMPONENT: {
                icon = IconEnum.COMPONENT_I;
                break;
            }
            case EQUIPMENT: {
                icon = IconEnum.EQUIPMENT_I;
                break;
            }
            case TYPE: {
                if (dbFolder.getFamilyFlag() == 1) {
                    icon = IconEnum.ENUM_I;
                    break;
                }
                icon = IconEnum.LINK_I;
                break;
            }
            case OPERATOR: {
                icon = IconEnum.OPERATOR_I;
                break;
            }
            case IMAG: {
                icon = IconEnum.IMAG;
                break;
            }
            case PROJECT: {
                switch (dbFolder.getFamilyFlag()) {
                    case 3: {
                        icon = IconEnum.DSF_I;
                        break block0;
                    }
                    case 4: {
                        icon = IconEnum.FMEA_I;
                        break block0;
                    }
                    case 1: {
                        icon = IconEnum.MODEL_I;
                        break block0;
                    }
                    case 2: {
                        icon = IconEnum.TREE_I;
                        break block0;
                    }
                    case 5: {
                        icon = IconEnum.BEQ_I;
                    }
                }
            }
        }
        ImageIcon result = _mapIconFolders.get((Object)icon);
        if (result == null) {
            _LOG.warning("Pas d'icone dans la table de hashage pour : " + (Object)((Object)icon));
        }
        return result;
    }

    public static ImageIcon getIcon(IFolder folder, boolean expanded, boolean leaf, boolean withoutLock, boolean withoutFreeze) {
        if (_mapIconFolders == null) {
            DBFolderResources.createMapIconFolders();
        }
        boolean lock = !withoutLock && folder.isLocked();
        boolean freeze = !withoutFreeze && folder.isFreeze();
        IconEnum icon = IconEnum.FOLDER;
        DBFolder dbFolder = folder.getSource();
        if (dbFolder.isModel()) {
            block0 : switch (dbFolder.getFamily()) {
                case ATTRIBUTE: {
                    icon = IconEnum.ATTRIBUTE;
                    break;
                }
                case PARAMETER: {
                    icon = IconEnum.PARAMETER;
                    break;
                }
                case BTP_MODEL: {
                    icon = IconEnum.BTPEVENT;
                    break;
                }
                case BTP_APPLICATION: {
                    icon = IconEnum.BTPAPPLI;
                    break;
                }
                case BTP_AUTHOR: {
                    icon = IconEnum.BTPAUTHOR;
                    break;
                }
                case BTP_SUBSTANTIATION: {
                    icon = IconEnum.BTPJUSTIF;
                    break;
                }
                case CCF_MODEL: {
                    icon = IconEnum.CCF;
                    break;
                }
                case FMEA_MODEL: {
                    icon = IconEnum.FMEA;
                    break;
                }
                case COMPONENT: {
                    icon = IconEnum.COMPONENT;
                    break;
                }
                case EQUIPMENT: {
                    icon = IconEnum.EQUIPMENT;
                    break;
                }
                case TYPE: {
                    if (dbFolder.getFamilyFlag() == 1) {
                        icon = IconEnum.ENUM;
                        break;
                    }
                    icon = IconEnum.LINK;
                    break;
                }
                case OPERATOR: {
                    icon = IconEnum.OPERATOR;
                    break;
                }
                case IMAG: {
                    icon = IconEnum.IMAG;
                    break;
                }
                case PROJECT: {
                    switch (dbFolder.getFamilyFlag()) {
                        case 3: {
                            icon = IconEnum.DSF;
                            break block0;
                        }
                        case 4: {
                            icon = IconEnum.FMEA;
                            break block0;
                        }
                        case 1: {
                            icon = IconEnum.MODEL;
                            break block0;
                        }
                        case 2: {
                            icon = IconEnum.TREE;
                            break block0;
                        }
                        case 5: {
                            icon = IconEnum.BEQ;
                        }
                    }
                }
            }
        } else if (dbFolder.isVersion()) {
            block23 : switch (dbFolder.getFamily()) {
                case ATTRIBUTE: {
                    if (freeze && lock) {
                        icon = IconEnum.ATTRIBUTE_VFL;
                        break;
                    }
                    if (freeze) {
                        icon = IconEnum.ATTRIBUTE_VF;
                        break;
                    }
                    if (lock) {
                        icon = IconEnum.ATTRIBUTE_VL;
                        break;
                    }
                    if (leaf) {
                        icon = IconEnum.ATTRIBUTE_V;
                        break;
                    }
                    icon = IconEnum.ATTRIBUTE;
                    break;
                }
                case PARAMETER: {
                    if (freeze && lock) {
                        icon = IconEnum.PARAMETER_VFL;
                        break;
                    }
                    if (freeze) {
                        icon = IconEnum.PARAMETER_VF;
                        break;
                    }
                    if (lock) {
                        icon = IconEnum.PARAMETER_VL;
                        break;
                    }
                    if (leaf) {
                        icon = IconEnum.PARAMETER_V;
                        break;
                    }
                    icon = IconEnum.PARAMETER;
                    break;
                }
                case BTP_MODEL: {
                    if (freeze && lock) {
                        icon = IconEnum.BTPEVENT_VFL;
                        break;
                    }
                    if (freeze) {
                        icon = IconEnum.BTPEVENT_VF;
                        break;
                    }
                    if (lock) {
                        icon = IconEnum.BTPEVENT_VL;
                        break;
                    }
                    if (leaf) {
                        icon = IconEnum.BTPEVENT_V;
                        break;
                    }
                    icon = IconEnum.BTPEVENT;
                    break;
                }
                case BTP_APPLICATION: {
                    icon = IconEnum.BTPAPPLI;
                    break;
                }
                case BTP_AUTHOR: {
                    icon = IconEnum.BTPAUTHOR;
                    break;
                }
                case BTP_SUBSTANTIATION: {
                    icon = IconEnum.BTPJUSTIF;
                    break;
                }
                case CCF_MODEL: {
                    if (freeze && lock) {
                        icon = IconEnum.CCF_VFL;
                        break;
                    }
                    if (freeze) {
                        icon = IconEnum.CCF_VF;
                        break;
                    }
                    if (lock) {
                        icon = IconEnum.CCF_VL;
                        break;
                    }
                    if (leaf) {
                        icon = IconEnum.CCF_V;
                        break;
                    }
                    icon = IconEnum.CCF;
                    break;
                }
                case FMEA_MODEL: {
                    if (freeze && lock) {
                        icon = IconEnum.FMEA_VFL;
                        break;
                    }
                    if (freeze) {
                        icon = IconEnum.FMEA_VF;
                        break;
                    }
                    if (lock) {
                        icon = IconEnum.FMEA_VL;
                        break;
                    }
                    if (leaf) {
                        icon = IconEnum.FMEA_V;
                        break;
                    }
                    icon = IconEnum.FMEA;
                    break;
                }
                case COMPONENT: {
                    if (freeze && lock) {
                        icon = IconEnum.COMPONENT_VFL;
                        break;
                    }
                    if (freeze) {
                        icon = IconEnum.COMPONENT_VF;
                        break;
                    }
                    if (lock) {
                        icon = IconEnum.COMPONENT_VL;
                        break;
                    }
                    if (leaf) {
                        icon = IconEnum.COMPONENT_V;
                        break;
                    }
                    icon = IconEnum.COMPONENT;
                    break;
                }
                case EQUIPMENT: {
                    if (freeze && lock) {
                        icon = IconEnum.EQUIPMENT_VFL;
                        break;
                    }
                    if (freeze) {
                        icon = IconEnum.EQUIPMENT_VF;
                        break;
                    }
                    if (lock) {
                        icon = IconEnum.EQUIPMENT_VL;
                        break;
                    }
                    if (leaf) {
                        icon = IconEnum.EQUIPMENT_V;
                        break;
                    }
                    icon = IconEnum.EQUIPMENT;
                    break;
                }
                case TYPE: {
                    if (dbFolder.getFamilyFlag() == 1) {
                        if (freeze && lock) {
                            icon = IconEnum.ENUM_VFL;
                            break;
                        }
                        if (freeze) {
                            icon = IconEnum.ENUM_VF;
                            break;
                        }
                        if (lock) {
                            icon = IconEnum.ENUM_VL;
                            break;
                        }
                        if (leaf) {
                            icon = IconEnum.ENUM_V;
                            break;
                        }
                        icon = IconEnum.ENUM;
                        break;
                    }
                    if (freeze && lock) {
                        icon = IconEnum.LINK_VFL;
                        break;
                    }
                    if (freeze) {
                        icon = IconEnum.LINK_VF;
                        break;
                    }
                    if (lock) {
                        icon = IconEnum.LINK_VL;
                        break;
                    }
                    if (leaf) {
                        icon = IconEnum.LINK_V;
                        break;
                    }
                    icon = IconEnum.LINK;
                    break;
                }
                case OPERATOR: {
                    if (freeze && lock) {
                        icon = IconEnum.OPERATOR_VFL;
                        break;
                    }
                    if (freeze) {
                        icon = IconEnum.OPERATOR_VF;
                        break;
                    }
                    if (lock) {
                        icon = IconEnum.OPERATOR_VL;
                        break;
                    }
                    if (leaf) {
                        icon = IconEnum.OPERATOR_V;
                        break;
                    }
                    icon = IconEnum.OPERATOR;
                    break;
                }
                case IMAG: {
                    if (freeze && lock) {
                        icon = IconEnum.IMAG_VFL;
                        break;
                    }
                    if (freeze) {
                        icon = IconEnum.IMAG_VF;
                        break;
                    }
                    if (lock) {
                        icon = IconEnum.IMAG_VF;
                        break;
                    }
                    if (leaf) {
                        icon = IconEnum.IMAG_V;
                        break;
                    }
                    icon = IconEnum.IMAG;
                    break;
                }
                case PROJECT: {
                    switch (dbFolder.getFamilyFlag()) {
                        case 3: {
                            if (freeze && lock) {
                                icon = IconEnum.DSF_VFL;
                                break block23;
                            }
                            if (freeze) {
                                icon = IconEnum.DSF_VF;
                                break block23;
                            }
                            if (lock) {
                                icon = IconEnum.DSF_VL;
                                break block23;
                            }
                            if (leaf) {
                                icon = IconEnum.DSF_V;
                                break block23;
                            }
                            icon = IconEnum.DSF;
                            break block23;
                        }
                        case 4: {
                            if (freeze && lock) {
                                icon = IconEnum.FMEA_VFL;
                                break block23;
                            }
                            if (freeze) {
                                icon = IconEnum.FMEA_VF;
                                break block23;
                            }
                            if (lock) {
                                icon = IconEnum.FMEA_VL;
                                break block23;
                            }
                            if (leaf) {
                                icon = IconEnum.FMEA_V;
                                break block23;
                            }
                            icon = IconEnum.FMEA;
                            break block23;
                        }
                        case 1: {
                            if (freeze && lock) {
                                icon = IconEnum.MODEL_VFL;
                                break block23;
                            }
                            if (freeze) {
                                icon = IconEnum.MODEL_VF;
                                break block23;
                            }
                            if (lock) {
                                icon = IconEnum.MODEL_VL;
                                break block23;
                            }
                            if (leaf) {
                                icon = IconEnum.MODEL_V;
                                break block23;
                            }
                            icon = IconEnum.MODEL;
                            break block23;
                        }
                        case 2: {
                            if (freeze && lock) {
                                icon = IconEnum.TREE_VFL;
                                break block23;
                            }
                            if (freeze) {
                                icon = IconEnum.TREE_VF;
                                break block23;
                            }
                            if (lock) {
                                icon = IconEnum.TREE_VL;
                                break block23;
                            }
                            if (leaf) {
                                icon = IconEnum.TREE_V;
                                break block23;
                            }
                            icon = IconEnum.TREE;
                            break block23;
                        }
                        case 5: {
                            icon = freeze && lock ? IconEnum.BEQ_VFL : (freeze ? IconEnum.BEQ_VF : (lock ? IconEnum.BEQ_VL : (leaf ? IconEnum.BEQ_V : IconEnum.BEQ)));
                        }
                    }
                }
            }
        } else if (expanded) {
            icon = IconEnum.FOLDER_O;
        }
        ImageIcon result = _mapIconFolders.get((Object)icon);
        if (result == null) {
            _LOG.warning("Pas d'icone dans la table de hashage pour : " + (Object)((Object)icon));
        }
        return result;
    }

    public static Icon getVirtualIcon(short familyFlag, boolean expanded, boolean leaf) {
        if (_mapIconFolders == null) {
            DBFolderResources.createMapIconFolders();
        }
        IconEnum icon = IconEnum.FOLDER;
        switch (familyFlag) {
            case 1: {
                icon = IconEnum.MODELS;
                break;
            }
            case 2: {
                icon = IconEnum.TREES;
                break;
            }
            case 5: {
                icon = IconEnum.BEQS;
                break;
            }
            case 3: {
                icon = IconEnum.DSFS;
                break;
            }
            case 4: {
                icon = IconEnum.FMEAS;
            }
        }
        Icon result = _mapIconFolders.get((Object)icon);
        if (result == null) {
            _LOG.warning("Pas d'icone dans la table de hashage pour : " + (Object)((Object)icon));
        }
        return result;
    }

    public static Color getVirtualColor(short familyFlag) {
        switch (familyFlag) {
            case 1: {
                return COLOR_MODELS;
            }
            case 2: {
                return COLOR_TREES;
            }
            case 3: {
                return COLOR_DSFS;
            }
            case 4: {
                return COLOR_FMEAS;
            }
            case 5: {
                return COLOR_BEQS;
            }
        }
        return Color.BLACK;
    }

    private static synchronized void createMapSystemFolders() {
        if (_mapSystemFolders != null) {
            return;
        }
        _mapSystemFolders = new HashMap<String, String>();
        _mapSystemFolders.put("ROOT", "/");
        _mapSystemFolders.put("BTP", ResMsgCore.getString("MSG_FOL_SYST_OTHER"));
        _mapSystemFolders.put("ATTRIBUTES", ResMsgVoc.getString("VOC_ATTRIBUTES"));
        _mapSystemFolders.put("LAW_PARAMETERS", ResMsgVoc.getString("VOC_PARAMETERS"));
        _mapSystemFolders.put("LAW_MODELS", ResMsgCore.getString("MSG_FOL_SYST_FRB"));
        _mapSystemFolders.put("BTP_APPLICATIONS", ResMsgVoc.getString("VOC_APPLICATIONS"));
        _mapSystemFolders.put("BTP_AUTHORS", ResMsgVoc.getString("VOC_AUTHORS"));
        _mapSystemFolders.put("BTP_SUBSTANTIATIONS", ResMsgVoc.getString("VOC_SUBSTANTIATIONS"));
        _mapSystemFolders.put("FMEA_MODELS", ResMsgVoc.getString("VOC_FMEA_MODELS"));
        _mapSystemFolders.put("CCF_MODELS", ResMsgVoc.getString("VOC_CCF_MODELS"));
        _mapSystemFolders.put("PROJECTS", ResMsgVoc.getString("VOC_PROJECTS"));
        _mapSystemFolders.put("EQUIPMENT_FAMILIES", ResMsgVoc.getString("VOC_EQUIPMENTS"));
        _mapSystemFolders.put("COMPONENT_FAMILIES", ResMsgVoc.getString("VOC_COMPONENTS"));
        _mapSystemFolders.put("OPERATOR_FAMILIES", ResMsgVoc.getString("VOC_OPERATORS"));
        _mapSystemFolders.put("TYPE_FAMILIES", ResMsgVoc.getString("VOC_TYPES"));
        _mapSystemFolders.put("IMAGE_FAMILIES", ResMsgVoc.getString("VOC_IMAGES"));
    }

    public static String getName(IFolder folder) {
        if (_mapSystemFolders == null) {
            DBFolderResources.createMapSystemFolders();
        }
        if (folder.isSystem()) {
            return _mapSystemFolders.get(folder.getName());
        }
        return folder.getName();
    }

    public static String getVirtualName(short familyFlag) {
        switch (familyFlag) {
            case 1: {
                return ResMsgVoc.getString("VOC_MODELS");
            }
            case 2: {
                return ResMsgVoc.getString("VOC_TREES");
            }
            case 5: {
                return ResMsgVoc.getString("VOC_BEQS");
            }
            case 3: {
                return ResMsgVoc.getString("VOC_DSFS");
            }
            case 4: {
                return ResMsgVoc.getString("VOC_FMEAS");
            }
        }
        return null;
    }

    public static String getTypeName(DBFolder folder) {
        short flagFamily;
        DBFolder.Family family;
        String result;
        if (_mapSystemFolders == null) {
            DBFolderResources.createMapSystemFolders();
        }
        if (folder.isSystem()) {
            return _mapSystemFolders.get(folder.getName());
        }
        if (folder.isVersion()) {
            DBFolder.Family family2 = folder.getFamily();
            return DBFolderResources.getTypeVersion(family2);
        }
        if (folder.isModel() && (result = DBFolderResources.getTypeModel(family = folder.getFamily(), flagFamily = folder.getFamilyFlag())) != null) {
            return result;
        }
        if (folder.isFolder()) {
            int depth = folder.getDepthUntilSystem();
            DBFolder.Family family3 = folder.getFamily();
            result = DBFolderResources.getTypeFolder(family3, depth - 1);
            if (result != null) {
                return result;
            }
        }
        _LOG.info("Type de dossier non repertorie : " + folder);
        return folder.getName();
    }

    public static String getTypeVersion(DBFolder.Family family) {
        switch (family) {
            case BTP_APPLICATION: {
                return ResMsgVoc.getString("VOC_APPLICATION");
            }
            case BTP_AUTHOR: {
                return ResMsgVoc.getString("VOC_AUTHOR");
            }
            case BTP_SUBSTANTIATION: {
                return ResMsgVoc.getString("VOC_SUBSTANTIATION");
            }
        }
        return ResMsgVoc.getString("VOC_VERSION");
    }

    public static String getTypeModel(DBFolder.Family family, short flagFamily) {
        switch (family) {
            case BTP_APPLICATION: {
                return ResMsgVoc.getString("VOC_APPLICATION");
            }
            case BTP_AUTHOR: {
                return ResMsgVoc.getString("VOC_AUTHOR");
            }
            case BTP_SUBSTANTIATION: {
                return ResMsgVoc.getString("VOC_SUBSTANTIATION");
            }
            case BTP_MODEL: {
                return ResMsgVoc.getString("VOC_EVENTS_MODEL");
            }
            case ATTRIBUTE: {
                return ResMsgVoc.getString("VOC_ATTRIBUTE");
            }
            case PARAMETER: {
                return ResMsgVoc.getString("VOC_PARAMETER");
            }
            case CCF_MODEL: {
                return ResMsgVoc.getString("VOC_CCF_MODELS");
            }
            case FMEA_MODEL: {
                return ResMsgVoc.getString("VOC_FMEA");
            }
            case IMAG: {
                return ResMsgVoc.getString("VOC_ICON");
            }
            case COMPONENT: {
                return ResMsgVoc.getString("VOC_COMPONENT");
            }
            case EQUIPMENT: {
                return ResMsgVoc.getString("VOC_EQUIPMENT");
            }
            case OPERATOR: {
                return ResMsgVoc.getString("VOC_OPERATOR");
            }
            case TYPE: {
                switch (flagFamily) {
                    case 1: {
                        return ResMsgVoc.getString("VOC_ENUM");
                    }
                    case 2: {
                        return ResMsgVoc.getString("VOC_RECORD");
                    }
                }
                return ResMsgVoc.getString("VOC_TYPE");
            }
            case PROJECT: {
                switch (flagFamily) {
                    case 1: {
                        return ResMsgVoc.getString("VOC_MODEL");
                    }
                    case 2: {
                        return ResMsgVoc.getString("VOC_TREE");
                    }
                    case 5: {
                        return ResMsgVoc.getString("VOC_BEQ");
                    }
                    case 3: {
                        return ResMsgVoc.getString("VOC_DSF");
                    }
                    case 4: {
                        return ResMsgVoc.getString("VOC_FMEA");
                    }
                }
                return ResMsgVoc.getString("VOC_MODEL");
            }
        }
        return null;
    }

    public static String getTypeFolder(DBFolder.Family family, int depth) {
        switch (family) {
            case ATTRIBUTE: 
            case PARAMETER: 
            case IMAG: {
                if (depth != 0) break;
                return ResMsgVoc.getString("VOC_FAMILY");
            }
            case COMPONENT: 
            case EQUIPMENT: 
            case TYPE: 
            case OPERATOR: {
                if (depth == 0) {
                    return ResMsgVoc.getString("VOC_FAMILY");
                }
                if (depth != 1) break;
                return ResMsgVoc.getString("VOC_FAMILY_SUB");
            }
            case PROJECT: {
                if (depth == 0) {
                    return ResMsgVoc.getString("VOC_PROJECT");
                }
                if (depth != 1) break;
                return ResMsgVoc.getString("VOC_SYSTEM");
            }
            case BTP_MODEL: {
                if (depth < 0 || depth > 3) break;
                return ResMsgVoc.getString(_BTP_TYPE_FOLDER[depth]);
            }
        }
        return null;
    }

    static enum IconEnum {
        FOLDER,
        FOLDER_O,
        FAMILY,
        COMPONENT,
        COMPONENT_I,
        COMPONENT_V,
        COMPONENT_VF,
        COMPONENT_VFL,
        COMPONENT_VL,
        EQUIPMENT,
        EQUIPMENT_I,
        EQUIPMENT_V,
        EQUIPMENT_VF,
        EQUIPMENT_VFL,
        EQUIPMENT_VL,
        ENUM,
        ENUM_I,
        ENUM_V,
        ENUM_VF,
        ENUM_VFL,
        ENUM_VL,
        LINK,
        LINK_I,
        LINK_V,
        LINK_VF,
        LINK_VFL,
        LINK_VL,
        OPERATOR,
        OPERATOR_I,
        OPERATOR_V,
        OPERATOR_VF,
        OPERATOR_VFL,
        OPERATOR_VL,
        MODEL,
        MODEL_I,
        MODEL_V,
        MODEL_VF,
        MODEL_VFL,
        MODEL_VL,
        TREE,
        TREE_I,
        TREE_V,
        TREE_VF,
        TREE_VFL,
        TREE_VL,
        BEQ,
        BEQ_I,
        BEQ_V,
        BEQ_VF,
        BEQ_VFL,
        BEQ_VL,
        DSF,
        DSF_I,
        DSF_V,
        DSF_VF,
        DSF_VFL,
        DSF_VL,
        FMEA,
        FMEA_I,
        FMEA_V,
        FMEA_VF,
        FMEA_VFL,
        FMEA_VL,
        BTPEVENT,
        BTPEVENT_I,
        BTPEVENT_V,
        BTPEVENT_VF,
        BTPEVENT_VFL,
        BTPEVENT_VL,
        ATTRIBUTE,
        ATTRIBUTE_I,
        ATTRIBUTE_V,
        ATTRIBUTE_VF,
        ATTRIBUTE_VFL,
        ATTRIBUTE_VL,
        PARAMETER,
        PARAMETER_I,
        PARAMETER_V,
        PARAMETER_VF,
        PARAMETER_VFL,
        PARAMETER_VL,
        CCF,
        CCF_I,
        CCF_V,
        CCF_VF,
        CCF_VFL,
        CCF_VL,
        BTPAUTHOR,
        BTPAPPLI,
        BTPJUSTIF,
        IMAG,
        IMAG_V,
        IMAG_VF,
        IMAG_VFL,
        IMAG_VL,
        MODELS,
        TREES,
        DSFS,
        FMEAS,
        BEQS;

    }
}

