/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.folder;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTreeModelInterface;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTreeNode;
import com.dassault.cecilia.core.swing.table.JTableTransfertHandler;
import com.dassault.cecilia.core.swing.tree.TreeTable;
import com.dassault.cecilia.db.DBAccess;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.IGroup;
import com.dassault.cecilia.db.IUser;
import com.dassault.cecilia.db.dao.DAOFolder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class FolderTreeTableModel
implements TreeTable.TreeTableModel<DBFolderTreeNode>,
DBFolderTreeModelInterface,
DAOFolder.UpdateListener,
JTableTransfertHandler.HelperConvert {
    private static Logger _LOG = Logger.getLogger(FolderTreeTableModel.class.getPackage().getName());
    protected DAOFolder _daoFolder;
    DBFolderTreeNode _root;
    boolean _isDebugMode = false;
    Map<DBFolder, DBFolderTreeNode> _nodes = new HashMap<DBFolder, DBFolderTreeNode>();
    List<TreeModelListener> _listener = new ArrayList<TreeModelListener>();

    public FolderTreeTableModel(DAOFolder daoFolder, DBFolder root) {
        this._daoFolder = daoFolder;
        this.setFolderRoot(root);
    }

    public void setFolderRoot(DBFolder root) {
        _LOG.finer("Define folder root: " + root + " [oldRoot: " + this._root + "]");
        this._nodes.clear();
        this._root = new DBFolderTreeNode(this, root);
        this.putTreeNode(root, this._root);
        this.fireTreeStructureChanged(this, this.getPathToRoot(this._root));
    }

    public boolean isDebugMode() {
        return this._isDebugMode;
    }

    public void setDebugMode(boolean debug) {
        this._isDebugMode = debug;
    }

    @Override
    public DBFolderTreeNode getRoot() {
        return this._root;
    }

    @Override
    public DBFolderTreeNode getTreeNode(DBFolder dbFolder) {
        return this._nodes.get(dbFolder);
    }

    @Override
    public void putTreeNode(DBFolder dbFolder, DBFolderTreeNode trNode) {
        this._nodes.put(dbFolder, trNode);
    }

    void removeTreeNode(DBFolder dbFolder, DBFolderTreeNode trNode) {
        this._nodes.remove(dbFolder);
    }

    @Override
    public boolean withNodeFiles() {
        return false;
    }

    @Override
    public List<DBFolder> findChildren(DBFolder dbFolder) {
        return this._daoFolder.findChildren(dbFolder);
    }

    @Override
    public boolean acceptFolder(DBFolder dbFolder) {
        return true;
    }

    private DBFolderTreeNode[] getPathToRoot_rec(DBFolderTreeNode dbFolder, int depth) {
        DBFolderTreeNode[] result;
        if (dbFolder == null) {
            if (depth == 0) {
                return null;
            }
            result = new DBFolderTreeNode[depth];
        } else {
            result = dbFolder == this._root ? new DBFolderTreeNode[depth] : this.getPathToRoot_rec(this.getTreeNode(dbFolder.getDBFolder().getParent()), ++depth);
            result[result.length - depth] = dbFolder;
        }
        return result;
    }

    @Override
    public TreeNode[] getPathToRoot(TreeNode aNode) {
        return this.getPathToRoot_rec((DBFolderTreeNode)aNode, 0);
    }

    @Override
    public Object getChild(Object parent, int index) {
        return ((TreeNode)parent).getChildAt(index);
    }

    @Override
    public int getChildCount(Object parent) {
        return ((TreeNode)parent).getChildCount();
    }

    @Override
    public boolean isLeaf(Object node) {
        return ((TreeNode)node).isLeaf();
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public int getIndexOfChild(Object obj, Object child) {
        if (obj == null || child == null) {
            return -1;
        }
        return ((TreeNode)obj).getIndex((TreeNode)child);
    }

    @Override
    public int getColumnCount() {
        return this._isDebugMode ? 12 : 9;
    }

    protected IDCol convertColIndexToColID(int column) {
        switch (column) {
            case 0: {
                return IDCol.NAME;
            }
            case 1: {
                return IDCol.DESC;
            }
            case 2: {
                return IDCol.CREATE;
            }
            case 3: {
                return IDCol.MODIF;
            }
            case 4: {
                return IDCol.LAST_USER;
            }
            case 5: {
                return IDCol.OWNER;
            }
            case 6: {
                return IDCol.GROUP;
            }
            case 7: {
                return IDCol.ACCESS_GROUP;
            }
            case 8: {
                return IDCol.ACCESS_OTHER;
            }
            case 9: {
                return IDCol.FLAGS;
            }
            case 10: {
                return IDCol.ID;
            }
            case 11: {
                return IDCol.TIME_UPT;
            }
        }
        return IDCol.ERROR;
    }

    protected String getColumnName(IDCol colID) {
        switch (colID) {
            case NAME: {
                return ResMsgVoc.getString("VOC_NAME");
            }
            case DESC: {
                return ResMsgVoc.getString("VOC_DESCRIPTION");
            }
            case CREATE: {
                return ResMsgVoc.getString("VOC_DATE_CREATE");
            }
            case MODIF: {
                return ResMsgVoc.getString("VOC_DATE_MODIF");
            }
            case LAST_USER: {
                return ResMsgVoc.getString("VOC_USER_LAST");
            }
            case OWNER: {
                return ResMsgVoc.getString("VOC_OWNER");
            }
            case GROUP: {
                return ResMsgCore.getString("LBL_GROUP_OWNER_I");
            }
            case ACCESS_GROUP: {
                return ResMsgCore.getString("LBL_ACCESS_OWNER_I");
            }
            case ACCESS_OTHER: {
                return ResMsgCore.getString("LBL_ACCESS_OTHER_I");
            }
            case FLAGS: {
                return "Flags";
            }
            case ID: {
                return "ID";
            }
            case TIME_UPT: {
                return "TimeUpt";
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int column) {
        return this.getColumnName(this.convertColIndexToColID(column));
    }

    protected Class getColumnClass(IDCol colID) {
        switch (colID) {
            case NAME: {
                return TreeTable.TreeTableModel.class;
            }
            case DESC: {
                return String.class;
            }
            case CREATE: {
                return Date.class;
            }
            case MODIF: {
                return Date.class;
            }
            case LAST_USER: {
                return IUser.class;
            }
            case OWNER: {
                return IUser.class;
            }
            case GROUP: {
                return IGroup.class;
            }
            case ACCESS_GROUP: {
                return DBAccess.Right.class;
            }
            case ACCESS_OTHER: {
                return DBAccess.Right.class;
            }
            case FLAGS: {
                return Integer.class;
            }
            case ID: {
                return Long.class;
            }
            case TIME_UPT: {
                return Long.class;
            }
        }
        return null;
    }

    @Override
    public Class getColumnClass(int column) {
        return this.getColumnClass(this.convertColIndexToColID(column));
    }

    protected Object getValueAt(DBFolderTreeNode node, IDCol colID) {
        switch (colID) {
            case NAME: {
                return node.getDBFolder().getName();
            }
            case DESC: {
                return node.getDBFolder().getDescription();
            }
            case CREATE: {
                return node.getDBFolder().getDateCreate();
            }
            case MODIF: {
                return node.getDBFolder().getDateModify();
            }
            case LAST_USER: {
                return node.getDBFolder().getUserModify();
            }
            case OWNER: {
                return node.getDBFolder().getUserOwner();
            }
            case GROUP: {
                return node.getDBFolder().getGroupOwner();
            }
            case ACCESS_GROUP: {
                return node.getDBFolder().getRightGroup();
            }
            case ACCESS_OTHER: {
                return node.getDBFolder().getRightOther();
            }
            case FLAGS: {
                return node.getDBFolder().getFlags();
            }
            case ID: {
                return node.getDBFolder().getID();
            }
            case TIME_UPT: {
                return node.getDBFolder().getTimeUpdate();
            }
        }
        return null;
    }

    @Override
    public Object getValueAt(DBFolderTreeNode node, int row, int column) {
        return this.getValueAt(node, this.convertColIndexToColID(column));
    }

    @Override
    public boolean isCellEditable(DBFolderTreeNode node, int row, int column) {
        return false;
    }

    @Override
    public void setValueAt(Object aValue, DBFolderTreeNode node, int row, int column) {
    }

    @Override
    public String convertToString(Object obj, int row, int col) {
        if (col == 0) {
            DBFolder dbFolder = ((DBFolderTreeNode)obj).getDBFolder();
            StringBuilder buffer = new StringBuilder();
            if (dbFolder.isSystem()) {
                buffer.append("cec://").append(dbFolder.getName());
            } else {
                dbFolder.getPathUntilSystem(buffer);
            }
            return buffer.toString();
        }
        return obj == null ? "" : obj.toString();
    }

    @Override
    public void changeBegin() {
    }

    @Override
    public boolean changeState(DBFolder dbFolder) {
        DBFolderTreeNode trNode = this.getTreeNode(dbFolder);
        if (trNode != null) {
            int idx;
            DBFolderTreeNode parent = trNode.getParent();
            if (parent != null && parent instanceof DBFolderTreeNode && (idx = parent.getIndex(trNode)) >= 0) {
                this.fireTreeNodesChanged(this, this.getPathToRoot(parent), new int[]{idx}, new Object[]{trNode});
            }
            return true;
        }
        DBFolder dbParent = dbFolder.getParent();
        if (dbParent == null) {
            return false;
        }
        DBFolderTreeNode trParent = this.getTreeNode(dbParent);
        if (trParent != null) {
            trNode = new DBFolderTreeNode(this, dbFolder);
            this.putTreeNode(dbFolder, trNode);
            trParent.insert(trNode);
            int idx = trParent.getIndex(trNode);
            this.fireTreeNodesInserted(this, this.getPathToRoot(trParent), new int[]{idx}, new Object[]{trNode});
            return true;
        }
        return false;
    }

    @Override
    public void changeStateAndChildren(DBFolder dbFolder, List<DBFolder> delChildren) {
        for (DBFolder dbDelFolder : delChildren) {
            DBFolderTreeNode trDelNode = this.getTreeNode(dbDelFolder);
            if (trDelNode == null) continue;
            DBFolderTreeNode trParent = trDelNode.getParent();
            if (trParent != null) {
                int idx = trParent.remove(trDelNode);
                if (idx < 0) continue;
                this.fireTreeNodesRemoved(this, this.getPathToRoot(trParent), new int[]{idx}, new Object[]{trDelNode});
                this.removeTreeNode(dbDelFolder, trDelNode);
                continue;
            }
            this.removeTreeNode(dbDelFolder, trDelNode);
        }
        this.changeState(dbFolder);
        for (DBFolder dbChild : dbFolder.getChildren()) {
            this.changeState(dbChild);
        }
    }

    @Override
    public void changeEnd() {
    }

    @Override
    public void refreshAll() {
        DBFolderTreeNode trRoot = this.getRoot();
        DBFolder dbRoot = trRoot.getDBFolder();
        this.setFolderRoot(dbRoot);
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this._listener.add(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this._listener.remove(l);
    }

    protected void fireTreeNodesChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        if (this._listener.size() == 0) {
            return;
        }
        TreeModelEvent e = new TreeModelEvent(source, path, childIndices, children);
        for (int i = this._listener.size() - 1; i >= 0; --i) {
            this._listener.get(i).treeNodesChanged(e);
        }
    }

    protected void fireTreeNodesInserted(Object source, Object[] path, int[] childIndices, Object[] children) {
        if (this._listener.size() == 0) {
            return;
        }
        TreeModelEvent e = new TreeModelEvent(source, path, childIndices, children);
        for (int i = this._listener.size() - 1; i >= 0; --i) {
            this._listener.get(i).treeNodesInserted(e);
        }
    }

    protected void fireTreeNodesRemoved(Object source, Object[] path, int[] childIndices, Object[] children) {
        if (this._listener.size() == 0) {
            return;
        }
        TreeModelEvent e = new TreeModelEvent(source, path, childIndices, children);
        for (int i = this._listener.size() - 1; i >= 0; --i) {
            this._listener.get(i).treeNodesRemoved(e);
        }
    }

    protected void fireTreeStructureChanged(Object source, Object[] path) {
        if (this._listener.size() == 0) {
            return;
        }
        TreeModelEvent e = new TreeModelEvent(source, path);
        for (int i = this._listener.size() - 1; i >= 0; --i) {
            this._listener.get(i).treeStructureChanged(e);
        }
    }

    public static enum IDCol {
        NAME,
        DESC,
        CREATE,
        MODIF,
        LAST_USER,
        OWNER,
        GROUP,
        ACCESS_GROUP,
        ACCESS_OTHER,
        FLAGS,
        ID,
        TIME_UPT,
        SPECIFIC1,
        SPECIFIC2,
        SPECIFIC3,
        SPECIFIC4,
        ERROR;

    }
}

